/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.BitSet;
import java.util.List;
import java.util.function.Supplier;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.model.controlcenter.UserView;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.binary.BinaryIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecordValue;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;

public class UdbUserView
extends AbstractUdbEntity<UserView>
implements UserView {
    protected static TableIndex table;
    protected static TextIndex firstName;
    protected static TextIndex firstNameTranslated;
    protected static TextIndex lastName;
    protected static TextIndex lastNameTranslated;
    protected static BinaryIndex profilePicture;
    protected static BinaryIndex profilePictureLarge;
    protected static TextIndex language;
    protected static SingleReferenceIndex organizationUnit;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        firstName = (TextIndex)tableIndex.getColumnIndex("firstName");
        firstNameTranslated = (TextIndex)tableIndex.getColumnIndex("firstNameTranslated");
        lastName = (TextIndex)tableIndex.getColumnIndex("lastName");
        lastNameTranslated = (TextIndex)tableIndex.getColumnIndex("lastNameTranslated");
        profilePicture = (BinaryIndex)tableIndex.getColumnIndex("profilePicture");
        profilePictureLarge = (BinaryIndex)tableIndex.getColumnIndex("profilePictureLarge");
        language = (TextIndex)tableIndex.getColumnIndex("language");
        organizationUnit = (SingleReferenceIndex)tableIndex.getColumnIndex("organizationUnit");
    }

    public static List<UserView> getAll() {
        return new EntityBitSetList(UserView.getBuilder(), table.getRecordBitSet());
    }

    public static List<UserView> sort(List<UserView> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbUserView.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static List<UserView> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbUserView.sort((TableIndex)table, UserView.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbUserView() {
        super(table);
    }

    public UdbUserView(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public UserView build() {
        return new UdbUserView();
    }

    public UserView build(int id) {
        return new UdbUserView(id, false);
    }

    @Override
    public String getFirstName() {
        return this.getTextValue(firstName);
    }

    @Override
    public String getFirstNameTranslated() {
        return this.getTextValue(firstNameTranslated);
    }

    @Override
    public String getLastName() {
        return this.getTextValue(lastName);
    }

    @Override
    public String getLastNameTranslated() {
        return this.getTextValue(lastNameTranslated);
    }

    @Override
    public byte[] getProfilePicture() {
        if (this.isChanged((ColumnIndex)profilePicture)) {
            return (byte[])this.getChangedValue((ColumnIndex)profilePicture);
        }
        return profilePicture.getValue(this.getId());
    }

    @Override
    public int getProfilePictureLength() {
        if (this.isChanged((ColumnIndex)profilePicture)) {
            byte[] bytes = (byte[])this.getChangedValue((ColumnIndex)profilePicture);
            return bytes != null ? bytes.length : 0;
        }
        return profilePicture.getLength(this.getId());
    }

    @Override
    public Supplier<InputStream> getProfilePictureInputStreamSupplier() {
        if (this.isChanged((ColumnIndex)profilePicture)) {
            byte[] bytes = (byte[])this.getChangedValue((ColumnIndex)profilePicture);
            if (bytes == null) {
                return null;
            }
            return () -> new ByteArrayInputStream(bytes);
        }
        return profilePicture.getInputStreamSupplier(this.getId());
    }

    @Override
    public byte[] getProfilePictureLarge() {
        if (this.isChanged((ColumnIndex)profilePictureLarge)) {
            return (byte[])this.getChangedValue((ColumnIndex)profilePictureLarge);
        }
        return profilePictureLarge.getValue(this.getId());
    }

    @Override
    public int getProfilePictureLargeLength() {
        if (this.isChanged((ColumnIndex)profilePictureLarge)) {
            byte[] bytes = (byte[])this.getChangedValue((ColumnIndex)profilePictureLarge);
            return bytes != null ? bytes.length : 0;
        }
        return profilePictureLarge.getLength(this.getId());
    }

    @Override
    public Supplier<InputStream> getProfilePictureLargeInputStreamSupplier() {
        if (this.isChanged((ColumnIndex)profilePictureLarge)) {
            byte[] bytes = (byte[])this.getChangedValue((ColumnIndex)profilePictureLarge);
            if (bytes == null) {
                return null;
            }
            return () -> new ByteArrayInputStream(bytes);
        }
        return profilePictureLarge.getInputStreamSupplier(this.getId());
    }

    @Override
    public String getLanguage() {
        return this.getTextValue(language);
    }

    @Override
    public OrganizationUnitView getOrganizationUnit() {
        if (this.isChanged((ColumnIndex)organizationUnit)) {
            return (OrganizationUnitView)this.getReferenceChangeValue((ColumnIndex)organizationUnit);
        }
        int id = organizationUnit.getValue(this.getId());
        if (id > 0) {
            return OrganizationUnitView.getById(id);
        }
        return null;
    }

    public UdbUserView save() {
        throw new UnsupportedOperationException();
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    public void restoreDeleted() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(table.getName()).append(": ").append(this.getId()).append("\n");
        for (ColumnIndex column : table.getColumnIndices()) {
            sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(this.getId()));
            if (this.isChanged(column)) {
                TransactionRequestRecordValue changeValue = this.getChangeValue(column);
                sb.append(" -> ").append(changeValue.getValue());
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

