/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.localization;

import com.ibm.icu.text.Transliterator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.WordUtils;
import org.teamapps.application.api.localization.Country;
import org.teamapps.application.api.localization.Language;

public class DictionaryBuilder {
    private static final String DICTIONARY_PREFIX = "org.teamapps.dictionary.";
    private static Transliterator TRANSLITERATOR = Transliterator.getInstance((String)"Any-Latin; nfd; [:nonspacing mark:] remove; nfc");
    private static final String HEADER = "/*-\n * ========================LICENSE_START=================================\n * TeamApps Application API\n * ---\n * Copyright (C) 2020 - 2021 TeamApps.org\n * ---\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n * \n *      http://www.apache.org/licenses/LICENSE-2.0\n * \n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * =========================LICENSE_END==================================\n */";
    private static final String RESOURCE_HEADER = "###\n# ========================LICENSE_START=================================\n# TeamApps Application API\n# ---\n# Copyright (C) 2020 - 2021 TeamApps.org\n# ---\n# Licensed under the Apache License, Version 2.0 (the \"License\");\n# you may not use this file except in compliance with the License.\n# You may obtain a copy of the License at\n# \n#      http://www.apache.org/licenses/LICENSE-2.0\n# \n# Unless required by applicable law or agreed to in writing, software\n# distributed under the License is distributed on an \"AS IS\" BASIS,\n# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n# See the License for the specific language governing permissions and\n# limitations under the License.\n# =========================LICENSE_END==================================\n###";
    private static final String DICTIONARY_HEADER = "package org.teamapps.application.api.localization;\n\npublic class Dictionary {";
    private static final String DICTIONARY_FOOTER = "\n\n}";

    public static void main(String[] args) throws IOException {
        if (args == null || args.length < 2) {
            System.err.println("Error missing paths!");
            return;
        }
        DictionaryBuilder.buildDictionaryData(args[0], args[1]);
    }

    private static void buildDictionaryData(String path, String resourcePath) throws IOException {
        List values = DictionaryBuilder.readData().stream().filter(s -> s != null && !s.isBlank()).collect(Collectors.toList());
        ArrayList<CallSite> resourceLines = new ArrayList<CallSite>();
        ArrayList<CallSite> codeLines = new ArrayList<CallSite>();
        for (String value : values) {
            if (value.startsWith("::")) {
                codeLines.add((CallSite)((Object)("//" + value.substring(2))));
                resourceLines.add((CallSite)((Object)("# " + value.substring(2))));
                continue;
            }
            if (value.contains("=")) {
                int pos = value.indexOf(61);
                String k = value.substring(0, pos);
                String string = value.substring(pos + 1);
                String key = DICTIONARY_PREFIX + k;
                resourceLines.add((CallSite)((Object)(key + "=" + string)));
                codeLines.add((CallSite)((Object)("public static final String " + k.toUpperCase().replaceAll("\\.", "_") + " = \"" + key + "\";")));
                continue;
            }
            resourceLines.add((CallSite)((Object)(DictionaryBuilder.createKey(value) + "=" + value)));
            codeLines.add((CallSite)((Object)("public static final String " + DictionaryBuilder.createConstant(value) + " = \"" + DictionaryBuilder.createKey(value) + "\";")));
        }
        File dictionary = new File(path, "Dictionary.java");
        File resource = new File(resourcePath, "dictionary_en.properties");
        if (!dictionary.exists() || !resource.exists()) {
            System.err.println("Error paths do not exist!");
            return;
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(dictionary, StandardCharsets.UTF_8));
        writer.write(HEADER);
        writer.newLine();
        writer.write(DICTIONARY_HEADER);
        writer.newLine();
        for (String string : codeLines) {
            writer.write("\t" + string);
            writer.newLine();
        }
        writer.write(DICTIONARY_FOOTER);
        writer.close();
        writer = new BufferedWriter(new FileWriter(resource, StandardCharsets.UTF_8));
        writer.write(RESOURCE_HEADER);
        writer.newLine();
        for (String string : resourceLines) {
            writer.write(string);
            writer.newLine();
        }
        writer.close();
        System.out.println("Done");
    }

    private static void createCountryAndLanguageLines() {
        for (Country country : Country.values()) {
            System.out.println("country." + country.name() + "=" + country.getValue());
        }
        for (Enum enum_ : Language.values()) {
            System.out.println("language." + enum_.name() + "=" + ((Language)enum_).getValue());
        }
    }

    private static String cleanValue(String value) {
        value = TRANSLITERATOR.transliterate((String)value);
        value = WordUtils.capitalize((String)value);
        value = ((String)value).replaceAll("\\.\\.\\.", "___");
        value = DictionaryBuilder.removeNonAnsi((String)value);
        value = ((String)value).replaceAll(" ", "");
        value = ((String)value).substring(0, 1).toLowerCase() + ((String)value).substring(1);
        return value;
    }

    private static String createKey(String value) {
        return DICTIONARY_PREFIX + DictionaryBuilder.cleanValue(value);
    }

    private static String createConstant(String value) {
        value = DictionaryBuilder.cleanValue((String)value);
        if (((String)(value = ((String)value).replaceAll("(.)(\\p{Upper})", "$1_$2").toUpperCase())).length() > 36) {
            value = "SENTENCE_" + ((String)value).substring(0, 35) + "__";
        }
        return value;
    }

    public static String removeNonAnsi(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c;
            char code = c = s.charAt(i);
            if (c == '_' || c == ' ') {
                sb.append(c);
                continue;
            }
            if (code > '@' && code < '[') {
                sb.append(c);
                continue;
            }
            if (code > '`' && code < '{') {
                sb.append(c);
                continue;
            }
            if (code <= '/' || code >= ':') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static List<String> readData() throws IOException {
        InputStream resource = DictionaryBuilder.class.getResourceAsStream("dictionary-data.txt");
        return IOUtils.readLines((InputStream)resource, (Charset)StandardCharsets.UTF_8);
    }
}

