/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.combo;

import java.text.Normalizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.model.ComboBoxModel;

public class ComboBoxUtils {
    public static <RECORD> ComboBox<RECORD> createComboBox(ComboBoxModel<RECORD> comboBoxModel, PropertyProvider<RECORD> propertyProvider, Template template) {
        ComboBox comboBox = new ComboBox(template);
        comboBox.setPropertyProvider(propertyProvider);
        Function<Object, String> recordToStringFunction = record -> {
            Map values = propertyProvider.getValues(record, Collections.singleton("caption"));
            Object result = values.get("caption");
            return (String)result;
        };
        comboBox.setRecordToStringFunction(recordToStringFunction);
        comboBox.setModel(comboBoxModel);
        return comboBox;
    }

    public static <RECORD> ComboBox<RECORD> createRecordComboBox(List<RECORD> records, PropertyProvider<RECORD> propertyProvider, Template template) {
        return ComboBoxUtils.createRecordComboBox(() -> records, propertyProvider, template);
    }

    public static <RECORD> ComboBox<RECORD> createRecordComboBox(Supplier<List<RECORD>> records, PropertyProvider<RECORD> propertyProvider, Template template) {
        return ComboBoxUtils.createRecordComboBox(records, 50, propertyProvider, template);
    }

    public static <RECORD> ComboBox<RECORD> createRecordComboBox(Supplier<List<RECORD>> records, int limit, PropertyProvider<RECORD> propertyProvider, Template template) {
        ComboBox comboBox = new ComboBox(template);
        comboBox.setPropertyProvider(propertyProvider);
        Function recordToStringFunction = ComboBoxUtils.createRecordToNormalizedStringFunction(propertyProvider);
        comboBox.setRecordToStringFunction(recordToStringFunction);
        comboBox.setModel(query -> {
            String normalizedQuery = ComboBoxUtils.getNormalized(query);
            return query == null || query.isBlank() ? ((List)records.get()).stream().limit(limit).collect(Collectors.toList()) : ((List)records.get()).stream().filter(record -> ((String)recordToStringFunction.apply(record)).toLowerCase().contains(normalizedQuery)).limit(limit).collect(Collectors.toList());
        });
        return comboBox;
    }

    public static <RECORD> ComboBoxModel<RECORD> createComboBoxModel(Supplier<List<RECORD>> recordSupplier, PropertyProvider<RECORD> propertyProvider, int limit, String ... properties) {
        BiFunction recordFilterFunction = UiUtils.createRecordFilterFunction(propertyProvider, properties);
        return query -> {
            List records = (List)recordSupplier.get();
            return records != null ? records.stream().filter(record -> (Boolean)recordFilterFunction.apply(record, query)).limit(limit).collect(Collectors.toList()) : Collections.emptyList();
        };
    }

    public static <RECORD> ComboBox<RECORD> createRecordComboBox(List<RECORD> records, Function<RECORD, String> toStringFunction, Function<RECORD, Icon> toIconFunction, Template template) {
        PropertyProvider propertyProvider = (record, collection) -> {
            HashMap map = new HashMap();
            map.put("icon", toIconFunction.apply(record));
            map.put("caption", toStringFunction.apply(record));
            return map;
        };
        return ComboBoxUtils.createRecordComboBox(() -> records, propertyProvider, template);
    }

    public static <RECORD> TagComboBox<RECORD> createTagComboBox(Supplier<List<RECORD>> records, PropertyProvider<RECORD> propertyProvider, Template template) {
        return ComboBoxUtils.createTagComboBox(records, 50, propertyProvider, template);
    }

    public static <RECORD> TagComboBox<RECORD> createTagComboBox(Supplier<List<RECORD>> records, int limit, PropertyProvider<RECORD> propertyProvider, Template template) {
        TagComboBox tagComboBox = new TagComboBox(template);
        tagComboBox.setPropertyProvider(propertyProvider);
        Function recordToStringFunction = ComboBoxUtils.createRecordToNormalizedStringFunction(propertyProvider);
        tagComboBox.setRecordToStringFunction(recordToStringFunction);
        tagComboBox.setModel(query -> {
            String normalizedQuery = ComboBoxUtils.getNormalized(query);
            return query == null || query.isBlank() ? ((List)records.get()).stream().limit(limit).collect(Collectors.toList()) : ((List)records.get()).stream().filter(record -> ((String)recordToStringFunction.apply(record)).toLowerCase().contains(normalizedQuery)).limit(limit).collect(Collectors.toList());
        });
        return tagComboBox;
    }

    public static <RECORD> Function<RECORD, String> createRecordToNormalizedStringFunction(PropertyProvider<RECORD> propertyProvider) {
        return record -> {
            Map map = propertyProvider.getValues(record, Collections.emptyList());
            String s1 = (String)map.get("caption");
            String s2 = (String)map.get("description");
            if (s1 != null) {
                String s = s2 == null ? s1 : s1 + " " + s2;
                return ComboBoxUtils.getNormalized(s);
            }
            StringBuilder sb = new StringBuilder();
            for (Object value : map.values()) {
                if (!(value instanceof String)) continue;
                String s = (String)value;
                sb.append(s).append(" ");
            }
            return ComboBoxUtils.getNormalized(sb.toString()).trim();
        };
    }

    public static String getNormalized(String s) {
        return s == null ? null : Normalizer.normalize(s, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").replace("\u00df", "ss").toLowerCase().replace("\u2014", "-").replace("\u0153", "oe").replace("\u00e6", "ae").replace('\u0111', 'd').replace('\u00f8', 'o');
    }
}

