/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.localization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.application.api.localization.LocalizationEntry;
import org.teamapps.application.api.localization.LocalizationEntrySet;
import org.teamapps.application.api.localization.LocalizationEntrySetImpl;
import org.teamapps.application.api.localization.LocalizationLanguages;
import org.teamapps.ux.i18n.TeamAppsResourceBundleControl;

public interface LocalizationData {
    public static final String DICTIONARY_PREFIX = "org.teamapps.dictionary.";

    public List<LocalizationEntrySet> getLocalizationEntrySets();

    default public Set<String> getAllKeys() {
        return this.getLocalizationEntrySets().stream().flatMap(entrySet -> entrySet.getEntries().stream()).map(LocalizationEntry::getKey).collect(Collectors.toSet());
    }

    default public Set<String> getLanguageSet() {
        return this.getLocalizationEntrySets().stream().map(LocalizationEntrySet::getLanguage).collect(Collectors.toSet());
    }

    default public Set<String> getMachineTranslatedLanguages() {
        return this.getLocalizationEntrySets().stream().filter(LocalizationEntrySet::isMachineTranslation).map(LocalizationEntrySet::getLanguage).collect(Collectors.toSet());
    }

    default public boolean containsAnyLanguage(List<String> languages) {
        Set<String> languageSet = this.getLanguageSet();
        for (String language : languages) {
            if (!languageSet.contains(language)) continue;
            return true;
        }
        return false;
    }

    default public Map<String, Map<String, String>> createLocalizationMapByKey() {
        HashMap<String, Map<String, String>> localizationMap = new HashMap<String, Map<String, String>>();
        for (LocalizationEntrySet entrySet : this.getLocalizationEntrySets()) {
            String language = entrySet.getLanguage();
            for (LocalizationEntry entry : entrySet.getEntries()) {
                String key = entry.getKey();
                String value = entry.getValue();
                localizationMap.computeIfAbsent(key, k -> new HashMap()).put(language, value);
            }
        }
        return localizationMap;
    }

    default public Map<String, Map<String, String>> createLocalizationMapByLanguage() {
        HashMap<String, Map<String, String>> localizationMap = new HashMap<String, Map<String, String>>();
        for (LocalizationEntrySet entrySet : this.getLocalizationEntrySets()) {
            Map map = localizationMap.computeIfAbsent(entrySet.getLanguage(), s -> new HashMap());
            entrySet.getEntries().forEach(entry -> map.put(entry.getKey(), entry.getValue()));
        }
        return localizationMap;
    }

    public static LocalizationData createFromResourceBundle(ResourceBundle resourceBundle, Locale language) {
        return LocalizationData.create(locale -> resourceBundle, new LocalizationLanguages(language));
    }

    public static LocalizationData createFromPropertyFiles(String baseName, ClassLoader classLoader, Locale ... translations) {
        return LocalizationData.createFromPropertyFiles(baseName, "properties", classLoader, new LocalizationLanguages(translations));
    }

    public static LocalizationData createFromPropertyFiles(String baseName, ClassLoader classLoader, LocalizationLanguages localizationLanguages) {
        return LocalizationData.createFromPropertyFiles(baseName, "properties", classLoader, localizationLanguages);
    }

    public static LocalizationData createFromPropertyFiles(String baseName, String resourceFileSuffix, ClassLoader classLoader, LocalizationLanguages localizationLanguages) {
        Function<Locale, ResourceBundle> resourceBundleByLocaleFunction = locale -> ResourceBundle.getBundle(baseName, locale, classLoader, (ResourceBundle.Control)new TeamAppsResourceBundleControl(resourceFileSuffix, Locale.ENGLISH));
        return LocalizationData.create(resourceBundleByLocaleFunction, localizationLanguages);
    }

    public static LocalizationData create(Function<Locale, ResourceBundle> resourceBundleByLocaleFunction, LocalizationLanguages localizationLanguages) {
        ResourceBundle resourceBundle;
        ArrayList<LocalizationEntrySet> entrySets = new ArrayList<LocalizationEntrySet>();
        for (Locale translation : localizationLanguages.getOriginalLanguages()) {
            resourceBundle = resourceBundleByLocaleFunction.apply(translation);
            entrySets.add(LocalizationData.createEntrySet(resourceBundle, translation, false));
        }
        for (Locale translation : localizationLanguages.getMachineTranslatedLanguages()) {
            resourceBundle = resourceBundleByLocaleFunction.apply(translation);
            entrySets.add(LocalizationData.createEntrySet(resourceBundle, translation, true));
        }
        return () -> entrySets;
    }

    public static LocalizationData createDictionaryData(ClassLoader classLoader) {
        return LocalizationData.createFromPropertyFiles("org.teamapps.application.api.localization.dictionary", classLoader, new LocalizationLanguages(Locale.forLanguageTag("en")).setMachineTranslatedLanguages(Locale.forLanguageTag("ar"), Locale.forLanguageTag("bg"), Locale.forLanguageTag("cs"), Locale.forLanguageTag("da"), Locale.forLanguageTag("de"), Locale.forLanguageTag("el"), Locale.forLanguageTag("es"), Locale.forLanguageTag("et"), Locale.forLanguageTag("fi"), Locale.forLanguageTag("fr"), Locale.forLanguageTag("hu"), Locale.forLanguageTag("in"), Locale.forLanguageTag("it"), Locale.forLanguageTag("ja"), Locale.forLanguageTag("ko"), Locale.forLanguageTag("lt"), Locale.forLanguageTag("lv"), Locale.forLanguageTag("no"), Locale.forLanguageTag("nl"), Locale.forLanguageTag("pl"), Locale.forLanguageTag("pt"), Locale.forLanguageTag("ro"), Locale.forLanguageTag("ru"), Locale.forLanguageTag("sk"), Locale.forLanguageTag("sl"), Locale.forLanguageTag("sv"), Locale.forLanguageTag("tr"), Locale.forLanguageTag("uk"), Locale.forLanguageTag("zh")));
    }

    public static LocalizationEntrySet createEntrySet(ResourceBundle bundle, Locale translation, boolean machineTranslation) {
        LocalizationEntrySetImpl entrySet = new LocalizationEntrySetImpl(translation.getLanguage(), machineTranslation);
        if (bundle instanceof PropertyResourceBundle) {
            PropertyResourceBundle propertyResourceBundle = (PropertyResourceBundle)bundle;
            for (String key : bundle.keySet()) {
                Object result = propertyResourceBundle.handleGetObject(key);
                if (result == null) continue;
                String value = bundle.getString(key);
                if (!LocalizationData.checkNotEmpty(translation.getLanguage(), key, value)) continue;
                entrySet.addEntry(key, value);
            }
        } else {
            for (String key : bundle.keySet()) {
                String value = bundle.getString(key);
                if (!LocalizationData.checkNotEmpty(translation.getLanguage(), key, value)) continue;
                entrySet.addEntry(key, value);
            }
        }
        return entrySet;
    }

    public static boolean checkNotEmpty(String ... values) {
        for (String value : values) {
            boolean result = LocalizationData.checkNotEmpty(value);
            if (result) continue;
            return false;
        }
        return true;
    }

    public static boolean checkNotEmpty(String value) {
        return value != null && !value.isEmpty();
    }
}

