/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.password;

import de.mkammerer.argon2.Argon2;
import de.mkammerer.argon2.Argon2Factory;
import org.teamapps.application.api.password.SecurePasswordHash;

public class Argon2Hashing
implements SecurePasswordHash {
    private final Argon2 argon2;
    private final int iterations;
    private final int memory;
    private final int parallelism;

    public Argon2Hashing(int iterations, int memory, int parallelism) {
        this.iterations = iterations;
        this.memory = memory;
        this.parallelism = parallelism;
        this.argon2 = Argon2Factory.create();
    }

    @Override
    public String createSecureHash(String password) {
        if (password == null || password.isEmpty()) {
            return null;
        }
        return this.argon2.hash(this.iterations, this.memory, this.parallelism, password);
    }

    @Override
    public boolean verifyPassword(String password, String hash) {
        if (hash == null || hash.isEmpty() || password == null || password.isEmpty()) {
            return false;
        }
        return this.argon2.verify(hash, password);
    }
}

