/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.teamapps.application.api.application.BaseApplicationBuilder;
import org.teamapps.application.server.ApplicationLoader;
import org.teamapps.application.server.ApplicationServer;
import org.teamapps.application.server.SessionHandler;
import org.teamapps.config.TeamAppsConfiguration;

public class EmbeddedApplicationServer {
    private TeamAppsConfiguration teamAppsConfiguration = new TeamAppsConfiguration();
    private int port = 8080;
    private InputStream initialData;
    private BaseApplicationBuilder[] applicationBuilders;
    private String login = "admin";
    private String password = "admin";
    private String language = "en";
    private boolean darkTheme = false;
    private File basePath = new File("./server-data");
    private String proxyHost = null;
    private int proxyPort = 0;

    public static EmbeddedApplicationServer build() {
        return new EmbeddedApplicationServer();
    }

    public EmbeddedApplicationServer setTeamAppsConfiguration(TeamAppsConfiguration teamAppsConfiguration) {
        this.teamAppsConfiguration = teamAppsConfiguration;
        return this;
    }

    public EmbeddedApplicationServer setPort(int port) {
        this.port = port;
        return this;
    }

    public EmbeddedApplicationServer setInitialData(InputStream initialData) {
        this.initialData = initialData;
        return this;
    }

    public EmbeddedApplicationServer setApplicationBuilders(BaseApplicationBuilder ... applicationBuilders) {
        this.applicationBuilders = applicationBuilders;
        return this;
    }

    public EmbeddedApplicationServer setLogin(String login) {
        this.login = login;
        return this;
    }

    public EmbeddedApplicationServer setPassword(String password) {
        this.password = password;
        return this;
    }

    public EmbeddedApplicationServer setLanguage(String language) {
        this.language = language;
        return this;
    }

    public EmbeddedApplicationServer setDarkTheme(boolean darkTheme) {
        this.darkTheme = darkTheme;
        return this;
    }

    public EmbeddedApplicationServer setBasePath(File basePath) {
        this.basePath = basePath;
        return this;
    }

    public EmbeddedApplicationServer setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public EmbeddedApplicationServer setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public void startServer() {
        try {
            if (this.basePath.getParentFile().exists()) {
                this.basePath.mkdir();
            }
            System.out.println("Starting server with port:" + this.port + ", data path:" + this.basePath.getAbsolutePath());
            ApplicationServer applicationServer = new ApplicationServer(this.basePath, this.teamAppsConfiguration, this.port);
            InputStream inputStream = EmbeddedApplicationServer.class.getResourceAsStream("/org/teamapps/application/api/embedded/embedded-system.jar");
            Path tempFile = Files.createTempFile("temp", ".jar", new FileAttribute[0]);
            Files.copy(inputStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
            SessionHandler sessionHandler = applicationServer.updateSessionHandler(tempFile.toUri().toURL());
            applicationServer.start();
            ApplicationLoader applicationLoader = (ApplicationLoader)sessionHandler;
            if (this.initialData != null) {
                applicationLoader.createInitialData(this.initialData);
            }
            if (this.login != null) {
                applicationLoader.createInitialLogin(this.login, this.password, this.language, this.darkTheme);
            }
            if (this.proxyHost != null) {
                applicationLoader.setProxy(this.proxyHost, this.proxyPort);
            }
            if (this.applicationBuilders != null) {
                for (BaseApplicationBuilder builder : this.applicationBuilders) {
                    applicationLoader.installAndLoadApplication(builder);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

