/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.localize;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.Language;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.ux.form.FormWindow;
import org.teamapps.application.ux.localize.FlagMap;
import org.teamapps.application.ux.localize.TranslatableFieldBuilder;
import org.teamapps.application.ux.localize.TranslatableFieldType;
import org.teamapps.application.ux.window.DialogeUtils;
import org.teamapps.icon.flags.FlagIcon;
import org.teamapps.icons.Icon;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.absolutelayout.Length;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.field.MultiLineTextField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.richtext.RichTextEditor;
import org.teamapps.ux.component.field.richtext.ToolbarVisibilityMode;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.linkbutton.LinkButton;

public class TranslatableField2 {
    public static final List<String> ORDERED_LANGUAGE_LIST = Arrays.asList("en", "de", "fr", "es", "it", "nl", "pt", "pl", "tr", "bg", "cs", "da", "el", "et", "fi", "hu", "id", "lt", "lv", "no", "ro", "sk", "sl", "sv", "ru", "uk", "ja", "ko", "ar", "zh");
    private final ApplicationInstanceData applicationInstanceData;
    private TranslatableText value;
    private String sourceLanguage;
    private String localizedValue;
    private final boolean showFieldMessage;
    private final TranslatableFieldType fieldType;
    private final Function<TranslatableText, TranslatableText> translationFunction;
    private AbstractField<String> textField;

    public TranslatableField2(TranslatableFieldBuilder builder) {
        this.applicationInstanceData = builder.getApplicationInstanceData();
        this.sourceLanguage = this.applicationInstanceData.getUser().getLanguage();
        this.showFieldMessage = builder.isShowFieldMessage();
        this.translationFunction = builder.getTranslationFunction();
        this.fieldType = builder.getFieldType();
        int fieldHeight = builder.getFieldHeight();
        switch (this.fieldType) {
            case TEXT_FIELD: {
                this.textField = new TextField();
                break;
            }
            case MULTI_LINE_FIELD: {
                MultiLineTextField multiLineTextField = new MultiLineTextField();
                if (fieldHeight == 0) {
                    multiLineTextField.setAdjustHeightToContent(true);
                }
                this.textField = multiLineTextField;
                break;
            }
            case RICH_TEXT_FIELD: {
                this.textField = this.applicationInstanceData.getComponentFactory().createEmbeddedImagesEnabledRichTextEditor("translatable");
            }
        }
        this.setValue(null);
        if (this.fieldType != TranslatableFieldType.TEXT_FIELD && fieldHeight > 0) {
            this.textField.setCssStyle("height", Length.ofPixels((int)fieldHeight).toCssString());
        }
    }

    public void setValue(TranslatableText value) {
        this.value = value;
        if (value == null) {
            this.setTextFieldValue(null);
        } else {
            this.localizedValue = this.applicationInstanceData.getLocalized(value);
            this.setTextFieldValue(this.localizedValue);
        }
        this.updateFieldMessage();
    }

    public TranslatableText getValue() {
        if (this.value == null) {
            this.translatedIfNecessary();
        }
        return this.value;
    }

    public void translatedIfNecessary() {
        if (this.translationFunction != null && this.textField.isValueChangedByClient() && this.textField.getValue() != null && !((String)this.textField.getValue()).isBlank()) {
            if (this.value != null && !this.value.getOriginalLanguage().equals(this.sourceLanguage)) {
                DialogeUtils.showQuestion(ApplicationIcons.QUESTION, "Override existing translations?", "You have changed a value that was initially created in a different language. Dou you really want to override all translations?", ApplicationIcons.SIGN_WARNING, "Override", ApplicationIcons.WINDOW_CLOSE, "Do not override", this::performTranslation);
            } else if (this.value == null) {
                this.performTranslation();
            }
        }
    }

    private void performTranslation() {
        String text = (String)this.textField.getValue();
        if (text != null && !text.isBlank()) {
            this.value = this.translationFunction.apply(new TranslatableText(text, this.sourceLanguage));
            this.textField.setValueChangedByClient(false);
        }
    }

    private void updateFieldMessage() {
        StringBuilder msg;
        if (!this.showFieldMessage) {
            return;
        }
        if (this.value == null) {
            msg = new StringBuilder(this.applicationInstanceData.getLocalized("translatableTextField.emptyField.desc", FlagMap.getTranslatedLanguageWithFlag(this.sourceLanguage, true, this.applicationInstanceData)));
        } else {
            String originalLanguage = this.value.getOriginalLanguage();
            msg = new StringBuilder(this.applicationInstanceData.getLocalized("translatableTextField.originalLanguage", new Object[0]) + ": " + FlagMap.getTranslatedLanguageWithFlag(this.value.getOriginalLanguage(), true, this.applicationInstanceData) + "<br>");
            msg.append(this.applicationInstanceData.getLocalized("translatableTextField.originalText", new Object[0])).append(": ").append(this.value.getText()).append("<br>");
            msg.append(this.applicationInstanceData.getLocalized("translatableTextField.translations", new Object[0])).append(":<br>");
            for (Map.Entry entry2 : this.value.getTranslationMap().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(originalLanguage)).sorted(Map.Entry.comparingByKey()).toList()) {
                msg.append(FlagMap.getTranslatedLanguageWithFlag((String)entry2.getKey(), this.applicationInstanceData)).append(": ").append((String)entry2.getValue()).append("<br>");
            }
        }
        List<FieldMessage> fieldMessages = Collections.singletonList(new FieldMessage(FieldMessage.Position.POPOVER, FieldMessage.Visibility.ON_HOVER_OR_FOCUS, FieldMessage.Severity.INFO, msg.toString()));
        this.textField.setCustomFieldMessages(fieldMessages);
    }

    public AbstractField<String> getTextField() {
        return this.textField;
    }

    public void setTextFieldValue(String value) {
        this.textField.setValue((Object)value);
    }

    public boolean isChanged() {
        return !Objects.equals(this.textField.getValue(), this.localizedValue);
    }

    public LinkButton createTranslationWindowLinkButton() {
        String caption = this.applicationInstanceData.getLocalized("translatableTextField.editOrViewTranslations", new Object[0]);
        return this.createTranslationWindowLinkButton(caption);
    }

    public LinkButton createTranslationWindowLinkButton(String caption) {
        LinkButton linkButton = new LinkButton(caption);
        linkButton.onClicked.addListener(this::showTranslationWindow);
        return linkButton;
    }

    public LinkButton createChangeBaseLanguageLinkButton() {
        String caption = this.applicationInstanceData.getLocalized("translatableTextField.changeLanguage", new Object[0]) + " (" + FlagMap.getTranslatedLanguageWithFlag(this.sourceLanguage, this.applicationInstanceData) + ")";
        return this.createChangeBaseLanguageLinkButton(caption);
    }

    public LinkButton createChangeBaseLanguageLinkButton(String caption) {
        LinkButton linkButton = new LinkButton(caption);
        linkButton.onClicked.addListener(this::showChangeBaseLanguageWindow);
        return linkButton;
    }

    public void addToForm(String caption, boolean showChangeBaseLanguageLink, boolean showOpenTranslationWindowLink, ResponsiveFormLayout formLayout) {
        formLayout.addLabelAndField(null, caption, this.textField);
        if (showChangeBaseLanguageLink) {
            formLayout.addLabelAndComponent(null, null, (Component)this.createChangeBaseLanguageLinkButton());
        }
        if (showOpenTranslationWindowLink) {
            formLayout.addLabelAndComponent(null, null, (Component)this.createTranslationWindowLinkButton());
        }
    }

    public void showChangeBaseLanguageWindow() {
    }

    public void showTranslationWindow() {
        FormWindow formWindow = new FormWindow(ApplicationIcons.EARTH, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.translation", new Object[0]), true, this.applicationInstanceData);
        formWindow.addSection().setCollapsible(false).setDrawHeaderLine(false);
        LinkedHashMap<String, AbstractField<String>> fieldMap = new LinkedHashMap<String, AbstractField<String>>();
        TranslatableText translatableText = this.value != null ? this.value : new TranslatableText((String)this.textField.getValue(), this.sourceLanguage);
        translatableText.setTranslation((String)this.textField.getValue(), this.sourceLanguage);
        if (this.value != null) {
            this.createField(this.value.getOriginalLanguage(), fieldMap, translatableText, formWindow);
        } else {
            this.createField(this.sourceLanguage, fieldMap, translatableText, formWindow);
        }
        for (String rankedLanguage : this.applicationInstanceData.getUser().getRankedLanguages()) {
            this.createField(rankedLanguage, fieldMap, translatableText, formWindow);
        }
        for (String language : ORDERED_LANGUAGE_LIST) {
            this.createField(language, fieldMap, translatableText, formWindow);
        }
        formWindow.addOkButton().onClick.addListener(() -> {
            if (fieldMap.get(this.sourceLanguage) != null && ((AbstractField)fieldMap.get(this.sourceLanguage)).getValue() != null) {
                fieldMap.entrySet().stream().filter(e -> ((AbstractField)e.getValue()).getValue() != null && !((String)((AbstractField)e.getValue()).getValue()).isBlank()).forEach(e -> translatableText.setTranslation((String)((AbstractField)e.getValue()).getValue(), (String)e.getKey()));
                this.setValue(translatableText);
            }
            formWindow.close();
        });
        if (this.translationFunction != null && translatableText.getText() != null && !translatableText.getText().isBlank()) {
            formWindow.addButton((Icon)ApplicationIcons.GEARWHEEL, (String)this.applicationInstanceData.getLocalized((String)"apps.translate", (Object[])new Object[0])).onClick.addListener(() -> {
                TranslatableText inputText = new TranslatableText(translatableText.getText(), translatableText.getOriginalLanguage());
                fieldMap.entrySet().stream().filter(e -> ((AbstractField)e.getValue()).getValue() != null && !((String)((AbstractField)e.getValue()).getValue()).isBlank()).forEach(entry -> inputText.setTranslation((String)((AbstractField)entry.getValue()).getValue(), (String)entry.getKey()));
                TranslatableText text = this.translationFunction.apply(inputText);
                text.getTranslationMap().entrySet().stream().forEach(entry -> {
                    AbstractField field = (AbstractField)fieldMap.get(entry.getKey());
                    field.setValue((Object)((String)entry.getValue()));
                });
            });
        }
        formWindow.addButton((Icon)ApplicationIcons.DELETE, (String)this.applicationInstanceData.getLocalized((String)"org.teamapps.dictionary.remove", (Object[])new Object[0])).onClick.addListener(() -> fieldMap.values().forEach(f -> f.setValue(null)));
        formWindow.addCancelButton();
        formWindow.show();
    }

    private void createField(String languageIso, Map<String, AbstractField<String>> fieldMap, TranslatableText translatableText, FormWindow formWindow) {
        if (!fieldMap.containsKey(languageIso)) {
            TextField field = null;
            switch (this.fieldType) {
                case TEXT_FIELD: {
                    field = new TextField();
                    break;
                }
                case MULTI_LINE_FIELD: {
                    MultiLineTextField multiLineTextField = new MultiLineTextField();
                    multiLineTextField.setAdjustHeightToContent(true);
                    field = multiLineTextField;
                    break;
                }
                case RICH_TEXT_FIELD: {
                    RichTextEditor richTextEditor = new RichTextEditor();
                    richTextEditor.setToolbarVisibilityMode(ToolbarVisibilityMode.VISIBLE_IF_FOCUSED);
                    field = richTextEditor;
                }
            }
            Language language = Language.getLanguageByIsoCode(languageIso);
            FlagIcon icon = language != null ? language.getIcon() : null;
            String name = language != null ? language.getLanguageLocalized(this.applicationInstanceData) : languageIso;
            formWindow.addField((Icon)icon, name, (Component)field);
            fieldMap.put(languageIso, (AbstractField<String>)field);
            String value = translatableText.getTranslation(languageIso);
            if (value != null) {
                field.setValue((Object)value);
            }
        }
    }
}

