/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.AbstractApplicationView;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.event.Event;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.application.view.ViewSize;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.window.Window;

public abstract class AbstractLazyRenderingApplicationView
extends AbstractApplicationView {
    public final Event<Void> onViewRedrawRequired = new Event();
    private final TwoWayBindableValue<Boolean> visible = TwoWayBindableValue.create((Object)false);
    private View parentView;
    private Window parentWindow;
    private Panel parentPanel;
    private View targetView;
    private AbstractLazyRenderingApplicationView targetApplicationView;
    private Window targetWindow;
    protected boolean created;
    private List<AbstractLazyRenderingApplicationView> peerViewsToHideWhenVisible = Collections.emptyList();
    private List<AbstractLazyRenderingApplicationView> peerViewsToShowWhenVisible = Collections.emptyList();
    private List<AbstractLazyRenderingApplicationView> peerWithSameParent = Collections.emptyList();
    private ViewSize ensureViewSize;
    private List<ToolbarButtonGroup> buttonGroups = new ArrayList<ToolbarButtonGroup>();

    public AbstractLazyRenderingApplicationView(ApplicationInstanceData applicationInstanceData) {
        super(applicationInstanceData);
        this.visible.onChanged().addListener(isVisible -> {
            if (isVisible.booleanValue()) {
                this.onViewRedrawRequired.fire();
            }
        });
    }

    public AbstractLazyRenderingApplicationView setParentView(View parent) {
        this.parentView = parent;
        return this;
    }

    public AbstractLazyRenderingApplicationView setParentWindow(Window parent) {
        this.parentWindow = parent;
        this.parentPanel = parent;
        return this;
    }

    public AbstractLazyRenderingApplicationView setParentPanel(Panel parent) {
        this.parentPanel = parent;
        return this;
    }

    public AbstractLazyRenderingApplicationView setTargetView(View target) {
        this.targetView = target;
        return this;
    }

    public AbstractLazyRenderingApplicationView setTargetView(AbstractLazyRenderingApplicationView targetApplicationView) {
        this.targetApplicationView = targetApplicationView;
        return this;
    }

    public AbstractLazyRenderingApplicationView setTargetWindow(Window target) {
        this.targetWindow = target;
        return this;
    }

    public AbstractLazyRenderingApplicationView setPeerViews(List<AbstractLazyRenderingApplicationView> allViews, AbstractLazyRenderingApplicationView ... peerViews) {
        return this.setPeerViews(allViews, Collections.emptyList(), peerViews);
    }

    public AbstractLazyRenderingApplicationView setPeerViews(List<AbstractLazyRenderingApplicationView> allViews, List<AbstractLazyRenderingApplicationView> exclude, AbstractLazyRenderingApplicationView ... peerViews) {
        this.peerViewsToShowWhenVisible = Arrays.stream(peerViews).filter(v -> !v.equals(this)).collect(Collectors.toList());
        this.peerViewsToHideWhenVisible = allViews.stream().filter(v -> !exclude.contains(v) && !this.peerViewsToShowWhenVisible.contains(v) && !v.equals(this)).collect(Collectors.toList());
        return this;
    }

    public AbstractLazyRenderingApplicationView setPeerViewsToHideWhenVisible(AbstractLazyRenderingApplicationView ... views) {
        this.peerViewsToHideWhenVisible = Arrays.stream(views).filter(v -> !v.equals(this)).collect(Collectors.toList());
        return this;
    }

    public AbstractLazyRenderingApplicationView setPeerViewsToShowWhenVisible(AbstractLazyRenderingApplicationView ... views) {
        this.peerViewsToShowWhenVisible = Arrays.stream(views).filter(v -> !v.equals(this)).collect(Collectors.toList());
        return this;
    }

    public AbstractLazyRenderingApplicationView setPeersWithSameParent(AbstractLazyRenderingApplicationView ... views) {
        this.peerWithSameParent = Arrays.stream(views).filter(v -> !v.equals(this)).collect(Collectors.toList());
        return this;
    }

    public abstract void createUi();

    public abstract Component getViewComponent();

    protected void handleViewComponentChange() {
        if (this.parentView != null) {
            this.parentView.setComponent(this.getViewComponent());
        } else if (this.parentWindow != null) {
            this.parentWindow.setContent(this.getViewComponent());
        } else if (this.parentPanel != null) {
            this.parentPanel.setContent(this.getViewComponent());
        }
    }

    public void handleModelDataChanged() {
        if (this.isVisible()) {
            this.onViewRedrawRequired.fire();
        }
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean select) {
        this.buttonGroups.forEach(bg -> bg.setVisible(true));
        this.peerWithSameParent.forEach(AbstractLazyRenderingApplicationView::unsetView);
        if (this.parentView != null && this.ensureViewSize != null) {
            this.parentView.setSize(this.ensureViewSize);
        }
        if (!this.created) {
            this.createUi();
            this.created = true;
        }
        if (this.parentView != null) {
            if (this.parentView.getComponent() == null || !this.parentView.getComponent().equals((Object)this.getViewComponent())) {
                this.parentView.setComponent(this.getViewComponent());
            }
            this.parentView.setVisible(true);
            if (select) {
                this.parentView.focus();
            }
        } else if (this.parentPanel != null) {
            if (this.parentPanel.getContent() == null || !this.parentPanel.getContent().equals((Object)this.getViewComponent())) {
                this.parentPanel.setContent(this.getViewComponent());
            }
            if (this.parentWindow != null) {
                this.parentWindow.show();
            }
        } else if (this.parentWindow != null) {
            this.parentWindow.setContent(this.getViewComponent());
            this.parentWindow.show();
        }
        this.visible.set((Object)true);
        this.peerViewsToHideWhenVisible.forEach(v -> {
            if (v.isVisible()) {
                v.hide();
            }
        });
        this.peerViewsToShowWhenVisible.forEach(v -> {
            if (!v.isVisible()) {
                v.show(false);
            }
        });
    }

    public void unsetView() {
        this.buttonGroups.forEach(bg -> bg.setVisible(false));
    }

    public void hide() {
        this.visible.set((Object)false);
        if (this.parentView != null) {
            this.parentView.setVisible(false);
        } else if (this.parentWindow != null) {
            this.parentWindow.close();
        }
    }

    public void focusTargetView() {
        if (this.targetApplicationView != null) {
            this.targetApplicationView.show(true);
        }
        if (this.targetView != null) {
            this.targetView.focus();
        } else if (this.targetWindow != null) {
            this.targetWindow.show();
        }
    }

    public boolean isVisible() {
        return (Boolean)this.visible.get();
    }

    public Panel getParentPanel() {
        if (this.parentView != null) {
            return this.parentView.getPanel();
        }
        if (this.parentPanel != null) {
            return this.parentPanel;
        }
        if (this.parentWindow != null) {
            return this.parentWindow;
        }
        return null;
    }

    public ToolbarButtonGroup createToolbarButtonGroup() {
        return this.createToolbarButtonGroup(false, new ToolbarButtonGroup());
    }

    public ToolbarButtonGroup createToolbarButtonGroup(boolean local) {
        return this.createToolbarButtonGroup(local, new ToolbarButtonGroup());
    }

    public ToolbarButtonGroup createToolbarButtonGroup(boolean local, ToolbarButtonGroup buttonGroup) {
        ToolbarButtonGroup group = buttonGroup != null ? buttonGroup : new ToolbarButtonGroup();
        this.buttonGroups.add(group);
        if (this.parentView != null) {
            if (local) {
                return this.parentView.addLocalButtonGroup(group);
            }
            return this.parentView.addWorkspaceButtonGroup(group);
        }
        if (this.parentPanel != null) {
            if (this.parentPanel.getToolbar() == null) {
                this.parentPanel.setToolbar(new Toolbar());
            }
            return this.parentPanel.getToolbar().addButtonGroup(group);
        }
        if (this.parentWindow != null) {
            if (this.parentWindow.getToolbar() == null) {
                this.parentWindow.setToolbar(new Toolbar());
            }
            return this.parentWindow.getToolbar().addButtonGroup(group);
        }
        return null;
    }

    public View getTargetView() {
        return this.targetView;
    }

    public void setEnsureViewSize(ViewSize ensureViewSize) {
        this.ensureViewSize = ensureViewSize;
    }
}

