/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.application.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.teamapps.application.api.application.AbstractLazyRenderingApplicationView;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.form.FormEditState;
import org.teamapps.application.api.event.TwoWayBindableValueFireAlways;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.api.ui.FormMetaFields;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.form.FormButtonUtils;
import org.teamapps.application.ux.form.FormMetaFieldsImpl;
import org.teamapps.application.ux.view.RecordVersionsView;
import org.teamapps.databinding.ObservableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.dialogue.Dialogue;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.Fields;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.window.Window;

public abstract class AbstractLazyRenderingFormView<ENTITY extends Entity<?>>
extends AbstractLazyRenderingApplicationView {
    private ResponsiveForm<ENTITY> form;
    private ResponsiveFormLayout formLayout;
    public final Event<Void> onRevertRequested = new Event();
    public final Event<Void> onEntityChanged = new Event();
    private final TwoWayBindableValue<ENTITY> selectedEntity = TwoWayBindableValueFireAlways.create();
    private final TwoWayBindableValue<Boolean> dataModified = TwoWayBindableValue.create();
    private final TwoWayBindableValue<FormEditState> formEditState = TwoWayBindableValue.create();
    private ToolbarButton newButton;
    private ToolbarButton editButton;
    private ToolbarButton saveButton;
    private ToolbarButton revertButton;
    private ToolbarButton deleteButton;
    private ToolbarButton restoreButton;
    private ToolbarButton versionsButton;
    private Function<ENTITY, Boolean> saveHandler;
    private Supplier<Boolean> validationHandler;
    private BiConsumer<FormEditState, List<AbstractField<?>>> formEditStateHandler;
    private StandardPrivilegeGroup standardPrivilegeGroup;
    private OrganizationalPrivilegeGroup organizationalPrivilegeGroup;
    private Function<ENTITY, OrganizationUnitView> entityOrganizationUnitSelector;
    private List<AbstractField<?>> editableFields = new ArrayList();
    private FormMetaFieldsImpl metaFields;

    public AbstractLazyRenderingFormView(ApplicationInstanceData applicationInstanceData) {
        this(new ResponsiveForm(120, 200, 0), applicationInstanceData);
    }

    public AbstractLazyRenderingFormView(ResponsiveForm<ENTITY> form, ApplicationInstanceData applicationInstanceData) {
        super(applicationInstanceData);
        this.form = form;
    }

    @Override
    public AbstractLazyRenderingFormView<ENTITY> setParentView(View parent) {
        super.setParentView(parent);
        return this;
    }

    @Override
    public AbstractLazyRenderingFormView<ENTITY> setParentWindow(Window parent) {
        super.setParentWindow(parent);
        return this;
    }

    @Override
    public AbstractLazyRenderingFormView<ENTITY> setParentPanel(Panel parent) {
        super.setParentPanel(parent);
        return this;
    }

    @Override
    public void createUi() {
        this.metaFields = new FormMetaFieldsImpl(this.getApplicationInstanceData());
        this.formLayout = this.form.addResponsiveFormLayout(450);
        this.newButton = FormButtonUtils.createNewButton(this.getApplicationInstanceData());
        this.editButton = FormButtonUtils.createEditButton(this.getApplicationInstanceData());
        this.saveButton = FormButtonUtils.createSaveButton(this.getApplicationInstanceData());
        this.revertButton = FormButtonUtils.createRevertButton(this.getApplicationInstanceData());
        this.deleteButton = FormButtonUtils.createDeleteButton(this.getApplicationInstanceData());
        this.restoreButton = FormButtonUtils.createRestoreButton(this.getApplicationInstanceData());
        this.versionsButton = ToolbarButton.createSmall((Icon)ApplicationIcons.CLOCK_BACK, (String)this.getApplicationInstanceData().getLocalized("org.teamapps.dictionary.showModificationHistory", new Object[0]));
        this.newButton.setVisible(this.isEntityCreationAllowed());
        this.editButton.setVisible(false);
        this.saveButton.setVisible(false);
        this.revertButton.setVisible(false);
        this.deleteButton.setVisible(false);
        this.restoreButton.setVisible(false);
        this.versionsButton.setVisible(false);
        ToolbarButtonGroup buttonGroup = this.createToolbarButtonGroup(true);
        buttonGroup.addButton(this.newButton);
        buttonGroup.addButton(this.saveButton);
        buttonGroup = this.createToolbarButtonGroup(true);
        buttonGroup.addButton(this.editButton);
        buttonGroup = this.createToolbarButtonGroup(true);
        buttonGroup.addButton(this.revertButton);
        buttonGroup = this.createToolbarButtonGroup(true);
        buttonGroup.addButton(this.deleteButton);
        buttonGroup.addButton(this.restoreButton);
        buttonGroup = this.createToolbarButtonGroup(true);
        buttonGroup.addButton(this.versionsButton);
        this.newButton.onClick.addListener(() -> {
            if (this.isEntityCreationAllowed()) {
                this.dataModified.set((Object)false);
                ENTITY entity = this.createNewEntity();
                this.selectedEntity.set(entity);
                if (this.formEditState.get() == FormEditState.READ_STATE) {
                    this.formEditState.set((Object)FormEditState.EDIT_STATE);
                }
                this.newButton.setVisible(false);
            }
        });
        this.editButton.onClick.addListener(() -> {
            if (this.formEditState.get() == FormEditState.READ_STATE) {
                this.formEditState.set((Object)FormEditState.EDIT_STATE);
            }
        });
        this.saveButton.onClick.addListener(() -> {
            Entity entity = (Entity)this.selectedEntity.get();
            if (this.isEntityEditable(entity) && Fields.validateAll((List)this.form.getFields()) && this.validationHandler.get().booleanValue()) {
                if (this.saveHandler != null) {
                    if (!this.saveHandler.apply(entity).booleanValue()) {
                        return;
                    }
                    this.saveButton.setVisible(false);
                    this.restoreButton.setVisible(false);
                    this.newButton.setVisible(this.isEntityCreationAllowed());
                    this.markAllFieldsUnchanged();
                    UiUtils.showSaveNotification(true, this.getApplicationInstanceData());
                    this.onEntityChanged.fire();
                    if (this.formEditState.get() == FormEditState.EDIT_STATE) {
                        this.formEditState.set((Object)FormEditState.READ_STATE);
                    }
                }
            } else {
                UiUtils.showSaveNotification(false, this.getApplicationInstanceData());
            }
        });
        this.revertButton.onClick.addListener(() -> {
            this.selectedEntity.set((Object)((Entity)this.selectedEntity.get()));
            this.saveButton.setVisible(false);
            this.revertButton.setVisible(false);
            this.newButton.setVisible(this.isEntityCreationAllowed());
            this.deleteButton.setVisible(this.isEntityDeletionAllowed((Entity)this.selectedEntity.get()));
            this.markAllFieldsUnchanged();
            this.onRevertRequested.fire();
        });
        this.deleteButton.onClick.addListener(() -> {
            Entity entity = (Entity)this.selectedEntity.get();
            if (this.isEntityDeletionAllowed(entity)) {
                Dialogue.showOkCancel((Icon)ApplicationIcons.DELETE, (String)this.getApplicationInstanceData().getLocalized("org.teamapps.dictionary.deleteRecord", new Object[0]), (String)this.getApplicationInstanceData().getLocalized("org.teamapps.dictionary.doYouReallyWantToDeleteTheRecord", new Object[0])).addListener(result -> {
                    if (result.booleanValue()) {
                        entity.delete();
                        this.deleteButton.setVisible(false);
                        this.restoreButton.setVisible(this.isEntityRestoreAllowed(entity));
                        this.onEntityChanged.fire();
                    }
                });
            }
        });
        this.restoreButton.onClick.addListener(() -> {
            Entity entity = (Entity)this.selectedEntity.get();
            if (this.isEntityRestoreAllowed(entity)) {
                entity.restoreDeleted();
                this.restoreButton.setVisible(false);
                this.deleteButton.setVisible(this.isEntityDeletionAllowed((Entity)this.selectedEntity.get()));
                this.onEntityChanged.fire();
            }
        });
        this.versionsButton.onClick.addListener(() -> {
            Entity entity = (Entity)this.selectedEntity.get();
            RecordVersionsView<Entity> recordVersionsView = new RecordVersionsView<Entity>(entity, this.getApplicationInstanceData());
            AbstractUdbEntity udbEntity = (AbstractUdbEntity)entity;
            udbEntity.getTableIndex().getFieldIndices().forEach(col -> recordVersionsView.addField(col.getName(), null));
            recordVersionsView.showVersionsWindow();
        });
        this.formEditState.onChanged().addListener(state -> {
            if (this.formEditStateHandler != null) {
                Entity entity = (Entity)this.selectedEntity.get();
                List fields = !this.editableFields.isEmpty() ? this.editableFields : this.form.getFields();
                this.formEditStateHandler.accept((FormEditState)((Object)state), fields);
            }
        });
        this.selectedEntity.onChanged().addListener(entity -> {
            this.newButton.setVisible(this.isEntityCreationAllowed());
            this.deleteButton.setVisible(this.isEntityDeletionAllowed(entity));
            this.restoreButton.setVisible(this.isEntityRestoreAllowed(entity));
            this.editButton.setVisible(false);
            this.revertButton.setVisible(false);
            this.restoreButton.setVisible(false);
            this.versionsButton.setVisible(false);
            if (entity.isStored() && this.isEntityEditable(entity)) {
                this.editButton.setVisible(true);
                this.versionsButton.setVisible(true);
            }
            this.metaFields.updateEntity((Entity<?>)entity);
            this.clearMessages();
            this.markAllFieldsUnchanged();
        });
        this.createForm(this.formLayout);
        this.form.getFields().forEach(field -> {
            field.onValueChanged.addListener(() -> {
                this.dataModified.set((Object)true);
                this.revertButton.setVisible(true);
                this.markFieldChanged((AbstractField<?>)field);
                if (this.isEntityEditable((Entity)this.selectedEntity.get())) {
                    this.saveButton.setVisible(true);
                }
            });
            if (field instanceof TextField) {
                TextField textField = (TextField)field;
                textField.onTextInput.addListener(() -> this.dataModified.set((Object)true));
                this.revertButton.setVisible(true);
                if (!this.saveButton.isVisible() && this.isEntityEditable((Entity)this.selectedEntity.get())) {
                    this.saveButton.setVisible(true);
                }
            }
        });
    }

    public void addMetaFieldsSection() {
        this.metaFields.addMetaFields(this.formLayout, false);
    }

    public FormMetaFields getMetaFields() {
        return this.metaFields;
    }

    public void setSaveHandler(Function<ENTITY, Boolean> saveHandler) {
        this.saveHandler = saveHandler;
    }

    public void setSelectedEntity(ENTITY entity) {
        this.selectedEntity.set(entity);
    }

    public void setStandardPrivilegeGroup(StandardPrivilegeGroup standardPrivilegeGroup) {
        this.standardPrivilegeGroup = standardPrivilegeGroup;
    }

    public void setOrganizationalPrivilegeGroup(OrganizationalPrivilegeGroup organizationalPrivilegeGroup, Function<ENTITY, OrganizationUnitView> entityOrganizationUnitSelector) {
        this.organizationalPrivilegeGroup = organizationalPrivilegeGroup;
        this.entityOrganizationUnitSelector = entityOrganizationUnitSelector;
    }

    public void setValidationHandler(Supplier<Boolean> validationHandler) {
        this.validationHandler = validationHandler;
    }

    public void setFormEditStateHandler(BiConsumer<FormEditState, List<AbstractField<?>>> formEditStateHandler) {
        this.formEditStateHandler = formEditStateHandler;
    }

    public void setFormEditState(FormEditState formEditState) {
        this.formEditState.set((Object)formEditState);
    }

    public void setEditableFields(List<AbstractField<?>> fields) {
        this.editableFields = fields;
    }

    public void addEditableField(AbstractField<?> field) {
        this.editableFields.add(field);
    }

    public void addEditableFields(AbstractField<?> ... fields) {
        this.editableFields.addAll(Arrays.stream(fields).toList());
    }

    public ObservableValue<Boolean> getDataModifiedObservable() {
        return this.dataModified;
    }

    public Event<Void> getOnRevertRequested() {
        return this.onRevertRequested;
    }

    public void handleSelectedEntityChanged(ENTITY entity) {
        this.selectedEntity.set(entity);
    }

    public ObservableValue<FormEditState> getFormEditState() {
        return this.formEditState;
    }

    public abstract void createForm(ResponsiveFormLayout var1);

    public abstract ENTITY createNewEntity();

    @Override
    public Component getViewComponent() {
        return this.form;
    }

    protected void markAllFieldsUnchanged() {
        this.form.getFields().forEach(field -> {
            field.setCssStyle(".field-border", "border-color", null);
            field.setCssStyle(".field-border-glow", "box-shadow", null);
            field.setValueChangedByClient(false);
        });
    }

    protected void markFieldChanged(AbstractField<?> field) {
        field.setCssStyle(".field-border", "border-color", "#ec9a1a");
        field.setCssStyle(".field-border-glow", "box-shadow", "0 0 3px 0 #ec9a1a");
    }

    public void clearMessages() {
        this.form.getFields().forEach(AbstractField::clearValidatorMessages);
    }

    public boolean isEntityEditable(ENTITY entity) {
        Privilege privilege;
        if (entity == null) {
            return false;
        }
        Privilege privilege2 = privilege = entity.isStored() ? Privilege.UPDATE : Privilege.CREATE;
        if (this.standardPrivilegeGroup != null) {
            return this.getApplicationInstanceData().isAllowed(this.standardPrivilegeGroup, privilege);
        }
        OrganizationUnitView selectedOrganizationUnit = this.entityOrganizationUnitSelector.apply(entity);
        if (selectedOrganizationUnit != null) {
            return this.getApplicationInstanceData().isAllowed(this.organizationalPrivilegeGroup, privilege, selectedOrganizationUnit);
        }
        return !this.getApplicationInstanceData().getAllowedUnits(this.organizationalPrivilegeGroup, privilege).isEmpty();
    }

    public boolean isEntityDeletionAllowed(ENTITY entity) {
        if (entity == null || !entity.isStored() || entity.isDeleted()) {
            return false;
        }
        Privilege privilege = Privilege.DELETE;
        if (this.standardPrivilegeGroup != null) {
            return this.getApplicationInstanceData().isAllowed(this.standardPrivilegeGroup, privilege);
        }
        OrganizationUnitView selectedOrganizationUnit = this.entityOrganizationUnitSelector.apply(entity);
        if (selectedOrganizationUnit != null) {
            return this.getApplicationInstanceData().isAllowed(this.organizationalPrivilegeGroup, privilege, this.entityOrganizationUnitSelector.apply(entity));
        }
        return !this.getApplicationInstanceData().getAllowedUnits(this.organizationalPrivilegeGroup, privilege).isEmpty();
    }

    public boolean isEntityRestoreAllowed(ENTITY entity) {
        if (entity == null || !entity.isDeleted() || !entity.isRestorable()) {
            return false;
        }
        Privilege privilege = Privilege.RESTORE;
        if (this.standardPrivilegeGroup != null) {
            return this.getApplicationInstanceData().isAllowed(this.standardPrivilegeGroup, privilege);
        }
        return this.getApplicationInstanceData().isAllowed(this.organizationalPrivilegeGroup, privilege, this.entityOrganizationUnitSelector.apply(entity));
    }

    public boolean isEntityCreationAllowed() {
        return this.standardPrivilegeGroup != null ? this.getApplicationInstanceData().isAllowed(this.standardPrivilegeGroup, Privilege.CREATE) : !this.getApplicationInstanceData().getAllowedUnits(this.organizationalPrivilegeGroup, Privilege.CREATE).isEmpty();
    }
}

