/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.links;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.function.Supplier;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.file.value.MimeType;
import org.teamapps.ux.resource.FileResource;
import org.teamapps.ux.resource.InputStreamResource;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.session.SessionContext;

public class ResourceLinkUtil {
    public static String createFileResourceLink(FileValue value) {
        return ResourceLinkUtil.createFileResourceLink(value, null);
    }

    public static String createFileResourceLink(FileValue value, String overrideFileName) {
        if (value == null || value.getSize() == 0L) {
            return null;
        }
        Supplier<InputStream> inputStreamSupplier = () -> {
            InputStream inputStream;
            block8: {
                InputStream stream = value.getInputStream();
                try {
                    inputStream = stream;
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                stream.close();
            }
            return inputStream;
        };
        String name = overrideFileName != null ? overrideFileName + "." + value.getFileExtension() : value.getFileName();
        InputStreamResource inputStreamResource = null;
        MimeType mimeTypeData = value.getMimeTypeData();
        if (mimeTypeData != null) {
            final String mimeType = mimeTypeData.getMimeType();
            inputStreamResource = new InputStreamResource(inputStreamSupplier, value.getSize(), name){

                public String getMimeType() {
                    return mimeType;
                }

                public Date getLastModified() {
                    return new Date();
                }
            };
        } else {
            inputStreamResource = new InputStreamResource(inputStreamSupplier, value.getSize(), name);
        }
        return SessionContext.current().createResourceLink((Resource)inputStreamResource, value.getHash());
    }

    public static String createFileResourceLink(File file) {
        return ResourceLinkUtil.createFileResourceLink(file, file.getName());
    }

    public static String createFileResourceLink(File file, String name) {
        if (file == null || file.length() == 0L) {
            return null;
        }
        return SessionContext.current().createResourceLink((Resource)new FileResource(file, name));
    }
}

