/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.teamapps.data.value.Sorting;
import org.teamapps.event.Event;
import org.teamapps.ux.cache.record.ItemRange;
import org.teamapps.ux.component.infiniteitemview.RecordsAddedEvent;
import org.teamapps.ux.component.infiniteitemview.RecordsChangedEvent;
import org.teamapps.ux.component.infiniteitemview.RecordsRemovedEvent;
import org.teamapps.ux.component.table.AbstractTableModel;

public abstract class AbstractRecordTableModel<RECORD>
extends AbstractTableModel<RECORD> {
    private List<RECORD> records;
    private String fullTextFilter;
    private Sorting sorting;
    public final Event<String> onFullTextFilterChanged = new Event();
    public final Event<Sorting> onSortingChanged = new Event();

    public synchronized void handleRecordAdded(RECORD record) {
        if (this.sorting == null) {
            int recordPosition = this.records.size();
            this.records.add(record);
            this.onRecordAdded.fire((Object)new RecordsAddedEvent(recordPosition, Collections.singletonList(record)));
        } else {
            this.refresh();
        }
    }

    public synchronized void handleRecordChanged(RECORD record) {
        int recordPosition = this.findRecordPosition(record);
        if (recordPosition >= 0) {
            this.onRecordsChanged().fire((Object)new RecordsChangedEvent(recordPosition, Collections.singletonList(record)));
        }
    }

    public synchronized void handleRecordRemoved(RECORD record) {
        int recordPosition = this.findRecordPosition(record);
        if (recordPosition >= 0) {
            this.onRecordsRemoved().fire((Object)new RecordsRemovedEvent(ItemRange.startLength((int)recordPosition, (int)1)));
        }
    }

    private int findRecordPosition(RECORD record) {
        this.checkInitialized();
        for (int i = 0; i < this.records.size(); ++i) {
            if (!this.records.get(i).equals(record)) continue;
            return i;
        }
        return -1;
    }

    public synchronized RECORD getNextRecord(RECORD record) {
        int recordPosition = this.findRecordPosition(record);
        if (recordPosition >= 0 && recordPosition + 1 < this.records.size()) {
            return this.records.get(recordPosition + 1);
        }
        return null;
    }

    public synchronized RECORD getPreviousRecord(RECORD record) {
        int recordPosition = this.findRecordPosition(record);
        if (recordPosition > 0) {
            return this.records.get(recordPosition - 1);
        }
        return null;
    }

    public void setFullTextFilter(String fullTextFilter) {
        if (!Objects.equals(fullTextFilter, this.fullTextFilter)) {
            this.fullTextFilter = fullTextFilter;
            this.runQuery();
            this.onFullTextFilterChanged.fire((Object)fullTextFilter);
            this.onAllDataChanged().fire();
        }
    }

    public String getFullTextFilter() {
        return this.fullTextFilter;
    }

    public void setSorting(Sorting sorting) {
        if (!Objects.equals(this.sorting, sorting)) {
            this.sorting = sorting;
            this.runQuery();
            this.onSortingChanged.fire((Object)sorting);
            this.onAllDataChanged().fire();
        }
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public String getFulltextFilter() {
        return this.fullTextFilter;
    }

    public int getCount() {
        this.checkInitialized();
        return this.records.size();
    }

    public List<RECORD> getRecords(int startIndex, int length) {
        this.checkInitialized();
        if (startIndex >= this.records.size()) {
            return Collections.emptyList();
        }
        if (startIndex + length > this.records.size()) {
            length = this.records.size() - startIndex;
        }
        return this.records.subList(startIndex, startIndex + length);
    }

    private void checkInitialized() {
        if (this.records == null) {
            this.runQuery();
        }
    }

    public void refresh() {
        this.runQuery();
        this.onAllDataChanged().fire();
    }

    private synchronized void runQuery() {
        this.records = new ArrayList<RECORD>(this.executeQuery(this.fullTextFilter, this.sorting));
    }

    public abstract List<RECORD> executeQuery(String var1, Sorting var2);
}

