/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.window;

import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.window.Window;
import org.teamapps.ux.session.SessionContext;

public class WindowUtils {
    public static Window createWindow(Icon icon, String title) {
        int width = (int)Math.max(800.0f, Math.min(1600.0f, (float)SessionContext.current().getClientInfo().getViewPortWidth() * 0.8f));
        int height = (int)Math.max(600.0f, Math.min(1200.0f, (float)SessionContext.current().getClientInfo().getScreenHeight() * 0.8f));
        Window window = new Window(icon, title, width, height, null);
        window.setToolbar(new Toolbar());
        window.setCloseable(true);
        window.setCloseOnEscape(true);
        window.setMaximizable(true);
        return window;
    }

    public static void addCancelCloseButton(Window window, ApplicationLocalizationProvider localizationProvider) {
        Toolbar toolbar = window.getToolbar();
        if (toolbar == null) {
            toolbar = new Toolbar();
            window.setToolbar(toolbar);
        }
        ToolbarButtonGroup buttonGroup = toolbar.addButtonGroup(new ToolbarButtonGroup());
        ToolbarButton closeButton = ToolbarButton.create((Icon)ApplicationIcons.ERROR, (String)localizationProvider.getLocalized("org.teamapps.dictionary.cancel", new Object[0]), (String)localizationProvider.getLocalized("org.teamapps.dictionary.cancelAndCloseWindow", new Object[0]));
        closeButton.onClick.addListener(() -> ((Window)window).close());
        buttonGroup.addButton(closeButton);
    }

    public static void addOkButton(Window window, ApplicationLocalizationProvider localizationProvider) {
        Toolbar toolbar = window.getToolbar();
        if (toolbar == null) {
            toolbar = new Toolbar();
            window.setToolbar(toolbar);
        }
        ToolbarButtonGroup buttonGroup = toolbar.addButtonGroup(new ToolbarButtonGroup());
        ToolbarButton closeButton = ToolbarButton.create((Icon)ApplicationIcons.OK, (String)localizationProvider.getLocalized("org.teamapps.dictionary.oK", new Object[0]), (String)localizationProvider.getLocalized("org.teamapps.dictionary.oK", new Object[0]));
        closeButton.onClick.addListener(() -> ((Window)window).close());
        buttonGroup.addButton(closeButton);
    }
}

