/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.password;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import me.gosimple.nbvcxz.Nbvcxz;
import me.gosimple.nbvcxz.resources.Configuration;
import me.gosimple.nbvcxz.resources.ConfigurationBuilder;
import me.gosimple.nbvcxz.resources.Dictionary;
import me.gosimple.nbvcxz.resources.DictionaryBuilder;
import me.gosimple.nbvcxz.resources.Feedback;
import me.gosimple.nbvcxz.scoring.Result;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.user.SessionUser;

public class SecurePasswordChecker {
    public static List<String> checkPasswordWithLocalizedWarnings(String password, ApplicationInstanceData applicationInstanceData) {
        SessionUser user = applicationInstanceData.getUser();
        List<String> warnings = SecurePasswordChecker.checkPassword(password, user.getFirstName(), user.getLastName());
        if (warnings == null) {
            return null;
        }
        return warnings.stream().map(x$0 -> applicationInstanceData.getLocalized((String)x$0, new Object[0])).collect(Collectors.toList());
    }

    public static List<String> checkPassword(String password, String ... excluded) {
        DictionaryBuilder dictionaryBuilder = new DictionaryBuilder().setDictionaryName("exclude").setExclusion(true);
        Arrays.stream(excluded).forEach(ex -> dictionaryBuilder.addWord(ex, 0));
        Dictionary dictionary = dictionaryBuilder.createDictionary();
        List dictionaryList = ConfigurationBuilder.getDefaultDictionaries();
        dictionaryList.add(dictionary);
        Configuration configuration = new ConfigurationBuilder().setMinimumEntropy(Double.valueOf(40.0)).setLocale(Locale.ENGLISH).setDictionaries(dictionaryList).createConfiguration();
        Nbvcxz passwordChecker = new Nbvcxz(configuration);
        Result result = passwordChecker.estimate(password);
        if (result.isMinimumEntropyMet()) {
            return null;
        }
        ArrayList<String> warningKeys = new ArrayList<String>();
        Feedback feedback = result.getFeedback();
        if (feedback != null) {
            if (feedback.getWarningKey() != null) {
                warningKeys.add(feedback.getWarningKey());
            }
            if (feedback.getSuggestionKeys() != null) {
                warningKeys.addAll(feedback.getSuggestionKeys());
            }
        }
        if (warningKeys.isEmpty()) {
            warningKeys.add("feedback.extra.suggestions.addAnotherWord");
        }
        return warningKeys.stream().map(s -> s.replace("feedback.", "userSettings.passwordCheck.")).collect(Collectors.toList());
    }
}

