/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.search;

import org.apache.commons.text.similarity.LevenshteinDistance;
import org.teamapps.application.api.search.SearchType;

public class SearchEntry {
    private final String field;
    private final String value;
    private final SearchType searchType;
    private final int maxScore;

    public SearchEntry(String field, String value, SearchType searchType, int maxScore) {
        this.field = field;
        this.value = value;
        this.searchType = searchType;
        this.maxScore = maxScore;
    }

    public int getScore(String result) {
        int size;
        if (result == null || result.isEmpty()) {
            return 0;
        }
        int distance = LevenshteinDistance.getDefaultInstance().apply((CharSequence)result.trim().toLowerCase(), (CharSequence)this.value.trim().toLowerCase());
        if (distance >= (size = Math.max(result.length(), this.value.length())) / 2) {
            return 0;
        }
        float scoreValue = (float)(size - distance) / (float)size;
        return (int)(scoreValue * (float)this.maxScore);
    }

    public String getField() {
        return this.field;
    }

    public String getValue() {
        return this.value;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public int getMaxScore() {
        return this.maxScore;
    }
}

