/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.cluster.state.ReplicatedState;
import org.teamapps.cluster.state.ReplicatedStateTransactionRule;
import org.teamapps.cluster.state.StateUpdateMessage;
import org.teamapps.cluster.state.TransactionCompareRule;
import org.teamapps.event.Event;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.message.MessageRecord;
import org.teamapps.message.protocol.model.PojoObjectDecoder;

public class ReplicatedList<TYPE extends Message> {
    private final ReplicatedState replicatedState;
    private final String listName;
    private final Function<TYPE, String> typeToIdFunction;
    private final List<StateUpdateMessage> preparedUpdates;
    private final PojoObjectDecoder<TYPE> messageDecoder;
    private List<ReplicatedStateTransactionRule> transactionRules;
    public Event<TYPE> onEntryAdded = new Event();
    public Event<TYPE> onEntryRemoved = new Event();
    public Event<TYPE> onEntryUpdated = new Event();
    public Event<Void> onAllEntriesRemoved = new Event();
    public Event<Void> onListChanged = new Event();
    public Event<TYPE> onFireAndForget = new Event();

    protected ReplicatedList(ReplicatedState replicatedState, String listName, PojoObjectDecoder<TYPE> messageDecoder, Function<TYPE, String> typeToIdFunction, List<StateUpdateMessage> preparedUpdates, List<ReplicatedStateTransactionRule> transactionRules) {
        this.replicatedState = replicatedState;
        this.listName = listName;
        this.typeToIdFunction = typeToIdFunction;
        this.preparedUpdates = preparedUpdates;
        this.messageDecoder = messageDecoder;
        this.transactionRules = transactionRules;
    }

    public void addConditionContainsNot(TYPE entry) {
        this.transactionRules.add(new ReplicatedStateTransactionRule(this.listName, this.typeToIdFunction.apply(entry), TransactionCompareRule.CONTAINS_NOT, 0));
    }

    public void addConditionContainsNot(String identifier) {
        this.transactionRules.add(new ReplicatedStateTransactionRule(this.listName, identifier, TransactionCompareRule.CONTAINS_NOT, 0));
    }

    public void addConditionContains(TYPE entry) {
        this.transactionRules.add(new ReplicatedStateTransactionRule(this.listName, this.typeToIdFunction.apply(entry), TransactionCompareRule.CONTAINS, 0));
    }

    public void addConditionContains(String identifier) {
        this.transactionRules.add(new ReplicatedStateTransactionRule(this.listName, identifier, TransactionCompareRule.CONTAINS, 0));
    }

    public void addConditionSizeEquals(int size) {
        this.transactionRules.add(new ReplicatedStateTransactionRule(this.listName, null, TransactionCompareRule.LIST_SIZE_EQUALS, size));
    }

    public void addConditionSizeGreater(int size) {
        this.transactionRules.add(new ReplicatedStateTransactionRule(this.listName, null, TransactionCompareRule.LIST_SIZE_GREATER, size));
    }

    public void addConditionSizeSmaller(int size) {
        this.transactionRules.add(new ReplicatedStateTransactionRule(this.listName, null, TransactionCompareRule.LIST_SIZE_SMALLER, size));
    }

    public void prepareAddEntry(TYPE entry) {
        this.preparedUpdates.add(this.replicatedState.prepareAddEntry(this.listName, this.typeToIdFunction.apply(entry), entry));
    }

    public void prepareUpdateOrAddEntry(TYPE entry) {
        this.preparedUpdates.add(this.replicatedState.prepareUpdateEntry(this.listName, this.typeToIdFunction.apply(entry), entry));
    }

    public void prepareRemoveEntry(String identifier) {
        this.preparedUpdates.add(this.replicatedState.prepareRemoveEntry(this.listName, identifier));
    }

    public void prepareRemoveEntry(TYPE entry) {
        this.preparedUpdates.add(this.replicatedState.prepareRemoveEntry(this.listName, this.typeToIdFunction.apply(entry)));
    }

    public void prepareRemoveAllEntries() {
        this.preparedUpdates.add(this.replicatedState.prepareRemoveAllEntries(this.listName));
    }

    public void addEntry(TYPE entry) {
        this.replicatedState.addEntry(this.listName, this.typeToIdFunction.apply(entry), entry);
    }

    public void updateOrAddEntry(TYPE entry) {
        this.replicatedState.updateEntry(this.listName, this.typeToIdFunction.apply(entry), entry);
    }

    public void removeEntry(String identifier) {
        this.replicatedState.removeEntry(this.listName, identifier);
    }

    public void removeEntry(TYPE entry) {
        this.replicatedState.removeEntry(this.listName, this.typeToIdFunction.apply(entry));
    }

    public void removeAllEntries() {
        this.replicatedState.removeAllEntries(this.listName);
    }

    public void fireAndForget(TYPE entry) {
        this.replicatedState.fireAndForget(this.listName, entry);
    }

    public TYPE getEntry(String identifier) {
        Message entry = this.replicatedState.getEntry(this.listName, identifier);
        if (entry != null) {
            return this.remap(entry);
        }
        return null;
    }

    public boolean contains(TYPE entry) {
        if (entry == null) {
            return false;
        }
        String identifier = this.typeToIdFunction.apply(entry);
        return this.replicatedState.getEntry(this.listName, identifier) != null;
    }

    public boolean contains(String identifier) {
        return this.replicatedState.getEntry(this.listName, identifier) != null;
    }

    public List<TYPE> getEntries() {
        List entries = this.replicatedState.getEntries(this.listName);
        if (entries != null) {
            ArrayList list = new ArrayList();
            entries.forEach(e -> list.add(this.remap((Message)e)));
            return list;
        }
        return Collections.emptyList();
    }

    public List<TYPE> getEntries(int startIndex, int length) {
        List entries = this.replicatedState.getEntries(this.listName);
        if (entries != null) {
            return entries.stream().skip(startIndex).limit(length).map(this::remap).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public int getEntryCount() {
        return this.replicatedState.getEntryCount(this.listName);
    }

    protected void handleEntryAdded(Message message) {
        this.onEntryAdded.fire(this.remap(message));
        this.onListChanged.fire();
    }

    protected void handleEntryUpdated(Message message) {
        this.onEntryUpdated.fire(this.remap(message));
        this.onListChanged.fire();
    }

    protected void handleEntryRemoved(Message message) {
        this.onEntryRemoved.fire(this.remap(message));
        this.onListChanged.fire();
    }

    protected void handleAllEntriesRemoved() {
        this.onAllEntriesRemoved.fire();
        this.onListChanged.fire();
    }

    protected void handleFireAndForget(Message message) {
        this.onFireAndForget.fire(this.remap(message));
    }

    protected TYPE remap(Message message) {
        return (TYPE)(message != null ? (Message)this.messageDecoder.remap((MessageRecord)message) : null);
    }
}

