/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.tools;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyCompare<A, B> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Collection<A> aCollection;
    private final Collection<B> bCollection;
    private final Function<A, String> keyOfA;
    private final Function<B, String> keyOfB;
    private final List<A> notInB = new ArrayList<A>();
    private final List<A> inB = new ArrayList<A>();
    private final List<B> notInA = new ArrayList<B>();
    private final List<B> inA = new ArrayList<B>();
    private Map<String, A> aByKey;
    private Map<String, B> bByKey;
    private final boolean enforceUniqueKeys;

    public KeyCompare(Collection<A> aCollection, Collection<B> bCollection, Function<A, String> keyOfA, Function<B, String> keyOfB) {
        this(aCollection, bCollection, keyOfA, keyOfB, false);
    }

    public KeyCompare(Collection<A> aCollection, Collection<B> bCollection, Function<A, String> keyOfA, Function<B, String> keyOfB, boolean enforceUniqueKeys) {
        this.aCollection = aCollection;
        this.bCollection = bCollection;
        this.keyOfA = keyOfA;
        this.keyOfB = keyOfB;
        this.enforceUniqueKeys = enforceUniqueKeys;
        this.compare();
    }

    private void compare() {
        if (this.enforceUniqueKeys) {
            this.aByKey = this.aCollection.stream().collect(Collectors.toMap(this.keyOfA, a -> a));
            this.bByKey = this.bCollection.stream().collect(Collectors.toMap(this.keyOfB, b -> b));
        } else {
            this.aByKey = this.aCollection.stream().collect(Collectors.toMap(this.keyOfA, a -> a, this.getMergeFunctionA()));
            this.bByKey = this.bCollection.stream().collect(Collectors.toMap(this.keyOfB, b -> b, this.getMergeFunctionB()));
        }
        for (A a2 : this.aCollection) {
            if (this.bByKey.containsKey(this.keyOfA.apply(a2))) {
                this.inB.add(a2);
                continue;
            }
            this.notInB.add(a2);
        }
        for (Object b2 : this.bCollection) {
            if (this.aByKey.containsKey(this.keyOfB.apply(b2))) {
                this.inA.add(b2);
                continue;
            }
            this.notInA.add(b2);
        }
    }

    private BinaryOperator<A> getMergeFunctionA() {
        return (key1, key2) -> {
            LOGGER.warn("KeyCompare-A with non-unique keys:" + this.keyOfA.apply(key1) + " (" + String.valueOf(key1) + ", " + String.valueOf(key2) + ")");
            return key1;
        };
    }

    private BinaryOperator<B> getMergeFunctionB() {
        return (key1, key2) -> {
            LOGGER.warn("KeyCompare-B with non-unique keys:" + this.keyOfB.apply(key1) + " (" + String.valueOf(key1) + ", " + String.valueOf(key2) + ")");
            return key1;
        };
    }

    public A getA(B b) {
        return this.aByKey.get(this.keyOfB.apply(b));
    }

    public B getB(A a) {
        return this.bByKey.get(this.keyOfA.apply(a));
    }

    public List<A> getAEntriesNotInB() {
        return this.notInB;
    }

    public List<B> getBEntriesNotInA() {
        return this.notInA;
    }

    public List<A> getAEntriesInB() {
        return this.inB;
    }

    public List<B> getBEntriesInA() {
        return this.inA;
    }

    public void processExisting(BiConsumer<A, B> sameKeyConsumer) {
        for (A a : this.getAEntriesInB()) {
            B b = this.getB(a);
            sameKeyConsumer.accept(a, b);
        }
    }

    public void processNew(Consumer<B> newKeyConsumer) {
        for (B b : this.getBEntriesNotInA()) {
            newKeyConsumer.accept(b);
        }
    }

    public void processRemoved(Consumer<A> removedKeyConsumer) {
        for (A a : this.getAEntriesNotInB()) {
            removedKeyConsumer.accept(a);
        }
    }

    public boolean isDifferent() {
        return !this.notInA.isEmpty() || !this.notInB.isEmpty();
    }

    public String toString() {
        return "KeyCompare: existing:" + this.getAEntriesInB().size() + ", removed:" + String.valueOf(this.getAEntriesNotInB()) + ", added:" + this.getBEntriesNotInA().size();
    }
}

