/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.tools;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.pojo.AbstractUdbQuery;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.pojo.Query;
import org.teamapps.universaldb.query.IndexFilter;

public class PrivilegeUtils {
    public static <ENTITY extends Entity<ENTITY>> void createOrgUnitFilter(Query<ENTITY> query, String orgUnitFieldName, OrganizationalPrivilegeGroup privilegeGroup, Privilege privilege, ApplicationInstanceData applicationInstanceData) {
        AbstractUdbQuery abstractUdbQuery = (AbstractUdbQuery)query;
        SingleReferenceIndex singleReferenceIndex = (SingleReferenceIndex)abstractUdbQuery.getTableIndex().getFieldIndex(orgUnitFieldName);
        List<OrganizationUnitView> allowedUnits = applicationInstanceData.getAllowedUnits(privilegeGroup, privilege);
        List allowedUnitIds = allowedUnits.stream().map(unit -> unit.getId()).collect(Collectors.toList());
        IndexFilter filter = singleReferenceIndex.createFilter((Object)NumericFilter.containsFilter(allowedUnitIds));
        abstractUdbQuery.and(filter);
    }

    public static <ENTITY extends Entity<ENTITY>> Supplier<Query<ENTITY>> createQueryOrgUnitFilter(Supplier<Query<ENTITY>> querySupplier, String orgUnitFieldName, OrganizationalPrivilegeGroup privilegeGroup, Privilege privilege, ApplicationInstanceData applicationInstanceData) {
        return () -> {
            Query entityQuery = (Query)querySupplier.get();
            PrivilegeUtils.createOrgUnitFilter(entityQuery, orgUnitFieldName, privilegeGroup, privilege, applicationInstanceData);
            return entityQuery;
        };
    }
}

