/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.localize;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.Language;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.ux.localize.TranslatableField;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class TranslatableTextUtils {
    public static Function<TranslatableText, String> createTranslatableTextExtractor(ApplicationInstanceData applicationInstanceData) {
        List<String> rankedLanguages = applicationInstanceData.getUser().getRankedLanguages();
        return TranslatableTextUtils.createTranslatableTextExtractor(rankedLanguages);
    }

    public static Function<TranslatableText, String> createTranslatableTextExtractor(List<String> rankedLanguages) {
        return translatableText -> {
            if (translatableText == null) {
                return null;
            }
            Map translationMap = translatableText.getTranslationMap();
            for (String language : rankedLanguages) {
                String value = (String)translationMap.get(language);
                if (value == null) continue;
                return value;
            }
            return translatableText.getText();
        };
    }

    public static TranslatableField createTranslatableField(ApplicationInstanceData applicationInstanceData) {
        return new TranslatableField(applicationInstanceData);
    }

    public static TemplateField<TranslatableText> createTranslatableTemplateField(ApplicationInstanceData applicationInstanceData) {
        TemplateField templateField = new TemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        templateField.setPropertyProvider(TranslatableTextUtils.createPropertyProvider(applicationInstanceData));
        return templateField;
    }

    public static PropertyProvider<TranslatableText> createPropertyProvider(ApplicationInstanceData applicationInstanceData) {
        List<String> rankedLanguages = applicationInstanceData.getUser().getRankedLanguages();
        return (translatableText, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Map translationMap = translatableText.getTranslationMap();
            for (String languageIso : rankedLanguages) {
                Language language;
                String text = (String)translationMap.get(languageIso);
                if (text == null || (language = Language.getLanguageByIsoCode(languageIso)) == null) continue;
                map.put("icon", language.getIcon());
                map.put("caption", text);
                map.put("description", language.getIsoCode() + " (" + language.getLanguageLocalized(applicationInstanceData) + ")");
                return map;
            }
            if (translatableText.getText() != null) {
                Language language = Language.getLanguageByIsoCode(translatableText.getOriginalLanguage());
                if (language != null) {
                    map.put("icon", language.getIcon());
                    map.put("caption", translatableText.getText());
                    map.put("description", language.getIsoCode() + " (" + language.getLanguageLocalized(applicationInstanceData) + ")");
                    return map;
                }
                map.put("icon", ApplicationIcons.SYMBOL_QUESTIONMARK);
                map.put("caption", translatableText.getText());
                map.put("description", translatableText.getOriginalLanguage());
            }
            return map;
        };
    }
}

