/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.view;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.ux.UiUtils;
import org.teamapps.application.ux.view.RecordVersionViewFieldData;
import org.teamapps.application.ux.window.ApplicationWindow;
import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.data.extract.ValueExtractor;
import org.teamapps.icons.Icon;
import org.teamapps.icons.composite.CompositeIcon;
import org.teamapps.universaldb.index.FieldIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.reference.value.ResolvedMultiReferenceUpdate;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransactionRecordType;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransactionRecordValue;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.index.versioning.RecordUpdate;
import org.teamapps.universaldb.model.EnumFieldModel;
import org.teamapps.universaldb.model.FieldType;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.schema.Table;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.NumberField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagBoxWrappingMode;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.field.datetime.InstantDateTimeField;
import org.teamapps.ux.component.field.datetime.LocalDateField;
import org.teamapps.ux.component.field.datetime.LocalTimeField;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.format.Border;
import org.teamapps.ux.component.format.FontStyle;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.Line;
import org.teamapps.ux.component.format.LineType;
import org.teamapps.ux.component.format.Shadow;
import org.teamapps.ux.component.format.SizeType;
import org.teamapps.ux.component.format.SizingPolicy;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.format.VerticalElementAlignment;
import org.teamapps.ux.component.infiniteitemview.InfiniteListModel;
import org.teamapps.ux.component.table.ListTable;
import org.teamapps.ux.component.table.ListTableModel;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.template.gridtemplate.GridTemplate;
import org.teamapps.ux.component.template.gridtemplate.IconElement;
import org.teamapps.ux.component.template.gridtemplate.ImageElement;
import org.teamapps.ux.component.template.gridtemplate.TextElement;
import org.teamapps.ux.component.toolbar.ToolbarButton;

public class RecordVersionsView<ENTITY extends Entity<?>> {
    private final ENTITY entity;
    private final ApplicationInstanceData applicationInstanceData;
    private final AbstractUdbEntity<ENTITY> record;
    private final TableIndex tableIndex;
    private List<RecordUpdate> recordUpdates;
    private ResponsiveApplication responsiveApplication;
    private View leftView;
    private View centerView;
    private View rightView;
    private List<RecordVersionViewFieldData> viewFields = new ArrayList<RecordVersionViewFieldData>();

    public RecordVersionsView(ENTITY entity, ApplicationInstanceData applicationInstanceData) {
        this.entity = entity;
        this.applicationInstanceData = applicationInstanceData;
        this.record = (AbstractUdbEntity)entity;
        this.tableIndex = this.record.getTableIndex();
        this.recordUpdates = this.record.getRecordUpdates();
    }

    public static String getFirstUpper(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String createTitleFromCamelCase(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i < 3) {
                sb.append(c);
                continue;
            }
            if (Character.isUpperCase(c)) {
                sb.append(" ");
            }
            sb.append(c);
        }
        return RecordVersionsView.getFirstUpper(sb.toString());
    }

    public RecordVersionsView addField(String fieldName, String fieldTitle) {
        this.viewFields.add(new RecordVersionViewFieldData(this.getField(fieldName), fieldName, fieldTitle));
        return this;
    }

    public RecordVersionsView addReferenceField(String fieldName, String fieldTitle, Function<Integer, BaseTemplateRecord<Integer>> referencedRecordIdToTemplateRecord) {
        this.viewFields.add(new RecordVersionViewFieldData(this.getField(fieldName), fieldName, fieldTitle, referencedRecordIdToTemplateRecord));
        return this;
    }

    public RecordVersionsView addReferenceField(String fieldName, String fieldTitle, Function<Integer, BaseTemplateRecord<Integer>> referencedRecordIdToTemplateRecord, Template template) {
        this.viewFields.add(new RecordVersionViewFieldData(this.getField(fieldName), fieldName, fieldTitle, referencedRecordIdToTemplateRecord, template));
        return this;
    }

    public RecordVersionsView addCustomField(String fieldName, String fieldTitle, AbstractField<?> formField, Function<Object, Object> formFieldDataProvider, AbstractField<?> tableField, Function<Object, Object> tableFieldDataProvider) {
        this.viewFields.add(new RecordVersionViewFieldData(this.getField(fieldName), fieldName, fieldTitle, formField, formFieldDataProvider, tableField, tableFieldDataProvider));
        return this;
    }

    public RecordVersionsView addCustomField(String fieldName, String fieldTitle, AbstractField<?> formField, Function<Object, Object> fieldDataProvider, AbstractField<?> tableField) {
        this.viewFields.add(new RecordVersionViewFieldData(this.getField(fieldName), fieldName, fieldTitle, formField, fieldDataProvider, tableField, fieldDataProvider));
        return this;
    }

    private FieldIndex getField(String fieldName) {
        return this.tableIndex.getFieldIndex(fieldName);
    }

    private void createUi() {
        this.responsiveApplication = ResponsiveApplication.createApplication();
        Perspective perspective = Perspective.createPerspective();
        this.leftView = perspective.addView(View.createView((String)"left", (Icon)ApplicationIcons.CLOCK_BACK, (String)this.applicationInstanceData.getLocalized("org.teamapps.dictionary.modificationHistory", new Object[0]), null));
        this.centerView = perspective.addView(View.createView((String)"center", (Icon)ApplicationIcons.FORM, (String)this.applicationInstanceData.getLocalized("org.teamapps.dictionary.modificationHistory", new Object[0]), null));
        this.rightView = perspective.addView(View.createView((String)"right", (Icon)ApplicationIcons.TABLE, (String)this.applicationInstanceData.getLocalized("org.teamapps.dictionary.modificationHistory", new Object[0]), null));
        this.rightView.setVisible(false);
        this.responsiveApplication.showPerspective(perspective);
        this.leftView.getPanel().setBodyBackgroundColor((Color)(this.applicationInstanceData.getUser().isDarkTheme() ? Color.DARK_GRAY.withAlpha(0.05f) : Color.WHITE.withAlpha(0.94f)));
        this.centerView.getPanel().setBodyBackgroundColor((Color)(this.applicationInstanceData.getUser().isDarkTheme() ? Color.DARK_GRAY.withAlpha(0.05f) : Color.WHITE.withAlpha(0.94f)));
        Template template = this.createItemTemplate(24, 44, VerticalElementAlignment.CENTER, 48, 1, false);
        PropertyProvider propertyProvider = this.applicationInstanceData.getComponentFactory().createUserTemplateField().getPropertyProvider();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM).withLocale(this.applicationInstanceData.getUser().getLocale()).withZone(this.applicationInstanceData.getUser().getSessionContext().getTimeZone());
        PropertyProvider recordUpdatePropertyProvider = (recordUpdate, collection) -> {
            Map values = propertyProvider.getValues((Object)recordUpdate.getUserId(), null);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", this.getIcon((RecordUpdate)recordUpdate));
            map.put("image", values.get("image"));
            map.put("caption", values.get("caption"));
            map.put("description", values.get("description"));
            map.put("badge", dateTimeFormatter.format(Instant.ofEpochMilli(recordUpdate.getTimestamp())));
            return map;
        };
        Set viewFieldColumnIds = this.viewFields.stream().map(f -> f.getFieldIndex().getMappingId()).collect(Collectors.toSet());
        HashSet<ResolvedTransactionRecordType> fixedUpdateTypes = new HashSet<ResolvedTransactionRecordType>(Arrays.asList(ResolvedTransactionRecordType.DELETE, ResolvedTransactionRecordType.RESTORE, ResolvedTransactionRecordType.CREATE, ResolvedTransactionRecordType.CREATE_WITH_ID));
        ArrayList<RecordUpdate> filteredRecordUpdates = new ArrayList<RecordUpdate>();
        for (RecordUpdate recordUpdate2 : this.recordUpdates) {
            if (!fixedUpdateTypes.contains(recordUpdate2.getRecordType()) && !recordUpdate2.getRecordValues().stream().anyMatch(recordValue -> viewFieldColumnIds.contains(recordValue.getColumnId()))) continue;
            filteredRecordUpdates.add(recordUpdate2);
        }
        this.recordUpdates = filteredRecordUpdates;
        ListTable table = new ListTable();
        table.setModel((InfiniteListModel)new ListTableModel(this.recordUpdates));
        table.setDisplayAsList(true);
        table.setRowHeight(54);
        table.setForceFitWidth(true);
        TableColumn tableColumn = new TableColumn("col", "Versions", UiUtils.createTemplateField(template, recordUpdatePropertyProvider));
        table.setHideHeaders(true);
        tableColumn.setValueExtractor(object -> object);
        table.addColumn(tableColumn);
        this.leftView.setComponent((Component)table);
        ResponsiveForm form = new ResponsiveForm(120, 200, 0);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection(ApplicationIcons.EDIT, this.applicationInstanceData.getLocalized("Changed data", new Object[0])).setHideWhenNoVisibleFields(true);
        Set usedColumnIds = this.recordUpdates.stream().flatMap(rec -> rec.getRecordValues().stream()).map(ResolvedTransactionRecordValue::getColumnId).collect(Collectors.toSet());
        List<FieldIndex> metaFields = this.record.getTableIndex().getFieldIndices().stream().filter(c -> this.isMetaField(c.getName())).toList();
        List<FieldIndex> sortedColumns = Stream.concat(this.viewFields.stream().map(RecordVersionViewFieldData::getFieldIndex).filter(c -> usedColumnIds.contains(c.getMappingId())), metaFields.stream().filter(c -> usedColumnIds.contains(c.getMappingId()))).toList();
        List<FieldIndex> columns = Stream.concat(metaFields.stream().filter(c -> usedColumnIds.contains(c.getMappingId())), this.viewFields.stream().map(RecordVersionViewFieldData::getFieldIndex).filter(c -> usedColumnIds.contains(c.getMappingId()))).toList();
        Map<FieldIndex, RecordVersionViewFieldData> viewFieldByColumn = this.viewFields.stream().collect(Collectors.toMap(RecordVersionViewFieldData::getFieldIndex, c -> c));
        HashMap<Integer, AbstractField> fieldMap = new HashMap<Integer, AbstractField>();
        HashMap<Integer, Function<RecordUpdate, Object>> fieldFunctionMap = new HashMap<Integer, Function<RecordUpdate, Object>>();
        boolean metaSection = false;
        for (FieldIndex column : sortedColumns) {
            boolean metaField = this.isMetaField(column.getName());
            if (!metaSection && metaField) {
                metaSection = true;
                formLayout.addSection(ApplicationIcons.WINDOW_SIDEBAR, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.metaData", new Object[0])).setHideWhenNoVisibleFields(true);
            }
            Function<RecordUpdate, Object> fieldValueFunction = null;
            AbstractField formField = null;
            String title = null;
            if (metaField) {
                title = this.getMetaFieldTitle(column.getName());
                formField = this.createFormField(column);
                fieldValueFunction = this.createFieldValueFunction(column);
            } else {
                RecordVersionViewFieldData fieldData = viewFieldByColumn.get(column);
                title = fieldData.getFieldTitle();
                if (fieldData.isCustomField()) {
                    formField = fieldData.getFormField();
                    fieldValueFunction = recordUpdate -> {
                        ResolvedTransactionRecordValue updateValue = recordUpdate.getValue(column.getMappingId());
                        Object value = updateValue != null ? updateValue.getValue() : null;
                        return fieldData.getFormFieldDataProvider().apply(value);
                    };
                } else if (fieldData.getReferencedRecordIdToTemplateRecord() != null) {
                    formField = this.createReferenceField(column, false, fieldData.getTemplate());
                    fieldValueFunction = this.createReferenceFieldValueFunction(column, fieldData);
                } else {
                    formField = this.createFormField(column);
                    fieldValueFunction = this.createFieldValueFunction(column);
                }
            }
            if (title == null) {
                title = RecordVersionsView.createTitleFromCamelCase(column.getName());
            }
            fieldFunctionMap.put(column.getMappingId(), fieldValueFunction);
            fieldMap.put(column.getMappingId(), formField);
            formField.setVisible(false);
            if (formField instanceof TagComboBox) {
                formField.setEditingMode(FieldEditingMode.READONLY);
            }
            if (metaSection) {
                formField.setEditingMode(FieldEditingMode.READONLY);
            }
            formLayout.addLabelAndField(null, title, formField);
        }
        table.onSingleRowSelected.addListener(recordUpdate -> {
            HashSet<AbstractField> fieldSet = new HashSet<AbstractField>();
            for (ResolvedTransactionRecordValue updateValue : recordUpdate.getRecordValues()) {
                int columnId = updateValue.getColumnId();
                Function fieldValueFunction = (Function)fieldFunctionMap.get(columnId);
                if (fieldValueFunction == null) continue;
                AbstractField field = (AbstractField)fieldMap.get(columnId);
                field.setValue(fieldValueFunction.apply(recordUpdate));
                field.setVisible(true);
                fieldSet.add(field);
            }
            fieldMap.values().stream().filter(f -> !fieldSet.contains(f)).forEach(f -> f.setVisible(false));
        });
        this.centerView.setComponent((Component)form);
        ListTable versionTable = new ListTable();
        versionTable.setModel((InfiniteListModel)new ListTableModel(this.recordUpdates));
        versionTable.setRowHeight(30);
        for (FieldIndex column : columns) {
            TableColumn tableCol = null;
            String title = null;
            if (this.isMetaField(column.getName())) {
                tableCol = this.createTableColumn(column);
                title = this.getMetaFieldTitle(column.getName());
            } else {
                RecordVersionViewFieldData fieldData = viewFieldByColumn.get(column);
                title = fieldData.getFieldTitle();
                if (fieldData.isCustomField()) {
                    tableCol = this.createCustomTableColumn(column, fieldData);
                    tableCol = new TableColumn(column.getName(), fieldData.getTableField()).setValueExtractor(recordUpdate -> {
                        ResolvedTransactionRecordValue updateValue = recordUpdate.getValue(column.getMappingId());
                        Object value = updateValue != null ? updateValue.getValue() : null;
                        return fieldData.getTableFieldDataProvider().apply(value);
                    });
                    tableCol.setDefaultWidth(fieldData.getTableColumnWidth());
                } else if (fieldData.getReferencedRecordIdToTemplateRecord() != null) {
                    Function<RecordUpdate, Object> referenceFieldValueFunction = this.createReferenceFieldValueFunction(column, fieldData);
                    tableCol = new TableColumn(column.getName(), this.createReferenceField(column, true, null)).setValueExtractor(referenceFieldValueFunction::apply);
                } else {
                    tableCol = this.createTableColumn(column);
                }
            }
            if (title == null) {
                RecordVersionsView.createTitleFromCamelCase(column.getName());
            }
            tableCol.setTitle(title);
            versionTable.addColumn(tableCol);
        }
        this.rightView.setComponent((Component)versionTable);
    }

    public void showVersionsWindow() {
        this.showVersionsWindow(false);
    }

    public void showVersionsWindow(boolean showTable) {
        this.createUi();
        ApplicationWindow window = new ApplicationWindow(ApplicationIcons.CLOCK_BACK, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.modificationHistory", new Object[0]), this.applicationInstanceData);
        window.setWindowSize(800, 900);
        window.getWindow().setStretchContent(true);
        window.getWindow().setBodyBackgroundColor((Color)(this.applicationInstanceData.getUser().isDarkTheme() ? Color.DARK_GRAY.withAlpha(0.001f) : Color.WHITE.withAlpha(0.001f)));
        window.addOkButton().onClick.addListener(window::close);
        window.addButtonGroup();
        window.setContent(this.responsiveApplication.getUi());
        window.setWindowRelativeSize(0.7f, 0.7f);
        ToolbarButton versionTableButton = window.addButton(ApplicationIcons.TABLE, "Show as edit table");
        ToolbarButton versionFormButton = window.addButton(ApplicationIcons.FORM, "Show as edit form");
        versionFormButton.setVisible(false);
        versionTableButton.onClick.addListener(() -> {
            versionTableButton.setVisible(false);
            versionFormButton.setVisible(true);
            this.leftView.setVisible(false);
            this.centerView.setVisible(false);
            this.rightView.setVisible(true);
        });
        versionFormButton.onClick.addListener(() -> {
            versionTableButton.setVisible(true);
            versionFormButton.setVisible(false);
            this.leftView.setVisible(true);
            this.centerView.setVisible(true);
            this.rightView.setVisible(false);
        });
        if (showTable) {
            versionTableButton.setVisible(false);
            versionFormButton.setVisible(true);
            this.leftView.setVisible(false);
            this.centerView.setVisible(false);
            this.rightView.setVisible(true);
        }
        window.show();
    }

    private TableColumn<RecordUpdate, ? extends Object> createCustomTableColumn(FieldIndex column, RecordVersionViewFieldData fieldData) {
        TableColumn tableColumn = new TableColumn(column.getName(), fieldData.getTableField()).setValueExtractor(recordUpdate -> {
            ResolvedTransactionRecordValue updateValue = recordUpdate.getValue(column.getMappingId());
            Object value = updateValue != null ? updateValue.getValue() : null;
            return fieldData.getTableFieldDataProvider().apply(value);
        });
        tableColumn.setDefaultWidth(fieldData.getTableColumnWidth());
        tableColumn.setTitle(fieldData.getFieldTitle());
        return tableColumn;
    }

    private TableColumn<RecordUpdate, ? extends Object> createTableColumn(FieldIndex fieldIndex) {
        String fieldName = fieldIndex.getName();
        Function<RecordUpdate, Object> fieldValueFunction = this.createFieldValueFunction(fieldIndex);
        ValueExtractor valueExtractor = fieldValueFunction::apply;
        Function<RecordUpdate, Object> valueFunction = recordUpdate -> {
            ResolvedTransactionRecordValue updateValue = recordUpdate.getValue(fieldIndex.getMappingId());
            return updateValue != null ? updateValue.getValue() : null;
        };
        if (this.isMetaUserColumn(fieldIndex)) {
            return new TableColumn(fieldName, this.applicationInstanceData.getComponentFactory().createUserTemplateField()).setDefaultWidth(250).setValueExtractor(recordUpdate -> {
                Object value = valueFunction.apply((RecordUpdate)recordUpdate);
                return value != null ? Integer.valueOf((Integer)value) : null;
            });
        }
        switch (fieldIndex.getFieldType()) {
            case BOOLEAN: {
                return new TableColumn(fieldName, (AbstractField)new CheckBox()).setDefaultWidth(70).setValueExtractor(recordUpdate -> {
                    Object value = valueFunction.apply((RecordUpdate)recordUpdate);
                    return value != null ? (Boolean)value : null;
                });
            }
            case SHORT: 
            case INT: 
            case LONG: {
                return new TableColumn(fieldName, (AbstractField)new NumberField(0)).setDefaultWidth(70).setValueExtractor(recordUpdate -> {
                    Object value = valueFunction.apply((RecordUpdate)recordUpdate);
                    return value != null ? (Number)((Number)value) : (Number)null;
                });
            }
            case FLOAT: 
            case DOUBLE: {
                return new TableColumn(fieldName, (AbstractField)new NumberField(2)).setDefaultWidth(100).setValueExtractor(recordUpdate -> {
                    Object value = valueFunction.apply((RecordUpdate)recordUpdate);
                    return value != null ? (Number)((Number)value) : (Number)null;
                });
            }
            case TEXT: {
                return new TableColumn(fieldName, (AbstractField)new TextField()).setDefaultWidth(200).setValueExtractor(recordUpdate -> {
                    Object value = valueFunction.apply((RecordUpdate)recordUpdate);
                    return value != null ? (String)value : null;
                });
            }
            case TRANSLATABLE_TEXT: {
                return new TableColumn(fieldName, (AbstractField)new TextField()).setDefaultWidth(200).setValueExtractor(recordUpdate -> {
                    Object value = valueFunction.apply((RecordUpdate)recordUpdate);
                    return value != null ? ((TranslatableText)value).getText() : null;
                });
            }
            case FILE: {
                return new TableColumn(fieldName, (AbstractField)new TextField()).setDefaultWidth(200).setValueExtractor(recordUpdate -> {
                    FileValue value = (FileValue)valueFunction.apply((RecordUpdate)recordUpdate);
                    if (value == null) {
                        return null;
                    }
                    String size = FileUtils.byteCountToDisplaySize((long)value.getSize());
                    return value.getFileName() + " (" + size + ")";
                });
            }
            case SINGLE_REFERENCE: {
                return new TableColumn(fieldName, (AbstractField)new TextField()).setDefaultWidth(250).setValueExtractor(recordUpdate -> (String)valueExtractor.extract(recordUpdate));
            }
            case MULTI_REFERENCE: {
                TagComboBox tagComboBox = new TagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
                return new TableColumn(fieldName, (AbstractField)tagComboBox).setDefaultWidth(250).setValueExtractor(recordUpdate -> (List)valueExtractor.extract(recordUpdate));
            }
            case TIMESTAMP: {
                return new TableColumn(fieldName, (AbstractField)new InstantDateTimeField()).setDefaultWidth(200).setValueExtractor(recordUpdate -> {
                    Integer value = (Integer)valueFunction.apply((RecordUpdate)recordUpdate);
                    return value == null ? null : Instant.ofEpochSecond(value.intValue());
                });
            }
            case DATE: {
                return new TableColumn(fieldName, (AbstractField)new LocalDateField()).setDefaultWidth(200).setValueExtractor(recordUpdate -> {
                    Long value = (Long)valueFunction.apply((RecordUpdate)recordUpdate);
                    return value == null ? null : Instant.ofEpochMilli(value).atOffset(ZoneOffset.UTC).toLocalDate();
                });
            }
            case TIME: {
                return new TableColumn(fieldName, (AbstractField)new LocalTimeField()).setDefaultWidth(200).setValueExtractor(recordUpdate -> {
                    Integer value = (Integer)valueFunction.apply((RecordUpdate)recordUpdate);
                    return value == null ? null : Instant.ofEpochSecond(value.intValue()).atOffset(ZoneOffset.UTC).toLocalTime();
                });
            }
            case DATE_TIME: {
                return new TableColumn(fieldName, (AbstractField)new InstantDateTimeField()).setDefaultWidth(200).setValueExtractor(recordUpdate -> {
                    Long value = (Long)valueFunction.apply((RecordUpdate)recordUpdate);
                    return value == null ? null : Instant.ofEpochMilli(value);
                });
            }
            case LOCAL_DATE: {
                return new TableColumn(fieldName, (AbstractField)new LocalDateField()).setDefaultWidth(170).setValueExtractor(recordUpdate -> {
                    Long value = (Long)valueFunction.apply((RecordUpdate)recordUpdate);
                    return value == null ? null : Instant.ofEpochMilli(value).atOffset(ZoneOffset.UTC).toLocalDate();
                });
            }
            case ENUM: {
                return new TableColumn(fieldName, (AbstractField)new TextField()).setDefaultWidth(175).setValueExtractor(recordUpdate -> {
                    Short value = (Short)valueFunction.apply((RecordUpdate)recordUpdate);
                    EnumFieldModel enumFieldModel = (EnumFieldModel)fieldIndex.getFieldModel().getTableModel().getField(fieldIndex.getName());
                    List enumTitles = enumFieldModel.getEnumModel().getEnumTitles();
                    return value == null || value == 0 ? null : (String)enumTitles.get(value - 1);
                });
            }
            case BINARY: {
                return new TableColumn(fieldName, (AbstractField)new TextField()).setDefaultWidth(150).setValueExtractor(recordUpdate -> {
                    byte[] value = (byte[])valueFunction.apply((RecordUpdate)recordUpdate);
                    if (value == null) {
                        return null;
                    }
                    return FileUtils.byteCountToDisplaySize((long)value.length);
                });
            }
        }
        return null;
    }

    private AbstractField createReferenceField(FieldIndex column, boolean table, Template template) {
        if (column.getFieldType() == FieldType.MULTI_REFERENCE) {
            TagComboBox tagComboBox = new TagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
            if (table) {
                tagComboBox.setWrappingMode(TagBoxWrappingMode.SINGLE_LINE);
            } else {
                tagComboBox.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
                tagComboBox.setTemplate((Template)(template != null ? template : BaseTemplate.LIST_ITEM_MEDIUM_ICON_TWO_LINES));
            }
            return tagComboBox;
        }
        ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        return comboBox;
    }

    private AbstractField<?> createFormField(FieldIndex column) {
        if (this.isMetaUserColumn(column)) {
            return this.applicationInstanceData.getComponentFactory().createUserTemplateField();
        }
        switch (column.getFieldType()) {
            case BOOLEAN: {
                return new CheckBox(RecordVersionsView.createTitleFromCamelCase(column.getName()));
            }
            case SHORT: 
            case INT: 
            case LONG: {
                return new NumberField(0);
            }
            case FLOAT: 
            case DOUBLE: {
                return new NumberField(2);
            }
            case TEXT: {
                return new TextField();
            }
            case TRANSLATABLE_TEXT: {
                return new TextField();
            }
            case FILE: {
                return new TextField();
            }
            case SINGLE_REFERENCE: {
                return new TextField();
            }
            case MULTI_REFERENCE: {
                TagComboBox tagComboBox = new TagComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
                tagComboBox.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
                return tagComboBox;
            }
            case TIMESTAMP: {
                return new InstantDateTimeField();
            }
            case DATE: {
                return new LocalDateField();
            }
            case TIME: {
                return new LocalTimeField();
            }
            case DATE_TIME: {
                return new InstantDateTimeField();
            }
            case LOCAL_DATE: {
                return new LocalDateField();
            }
            case ENUM: {
                return new TextField();
            }
            case BINARY: {
                return new TextField();
            }
        }
        return null;
    }

    private Function<RecordUpdate, Object> createReferenceFieldValueFunction(FieldIndex column, RecordVersionViewFieldData fieldData) {
        Function<Integer, BaseTemplateRecord<Integer>> referencedRecordIdToTemplateRecord = fieldData.getReferencedRecordIdToTemplateRecord();
        if (column.getFieldType() == FieldType.MULTI_REFERENCE) {
            return recordUpdate -> {
                ResolvedTransactionRecordValue updateValue = recordUpdate.getValue(column.getMappingId());
                Object value = updateValue != null ? updateValue.getValue() : null;
                ResolvedMultiReferenceUpdate multiReferenceUpdate = (ResolvedMultiReferenceUpdate)value;
                if (multiReferenceUpdate == null) {
                    return null;
                }
                ArrayList<BaseTemplateRecord> records = new ArrayList<BaseTemplateRecord>();
                switch (multiReferenceUpdate.getType()) {
                    case ADD_REMOVE_REFERENCES: {
                        for (Integer referencedId : multiReferenceUpdate.getRemoveReferences()) {
                            records.add((BaseTemplateRecord)referencedRecordIdToTemplateRecord.apply(referencedId * -1));
                        }
                        for (Integer referencedId : multiReferenceUpdate.getAddReferences()) {
                            records.add((BaseTemplateRecord)referencedRecordIdToTemplateRecord.apply(referencedId));
                        }
                        break;
                    }
                    case SET_REFERENCES: {
                        for (Integer referencedId : multiReferenceUpdate.getSetReferences()) {
                            records.add((BaseTemplateRecord)referencedRecordIdToTemplateRecord.apply(referencedId));
                        }
                        break;
                    }
                    case REMOVE_ALL_REFERENCES: {
                        records.add(new BaseTemplateRecord(ApplicationIcons.ERROR, "Remove all", (Object)0));
                    }
                }
                return records;
            };
        }
        if (column.getFieldType() == FieldType.SINGLE_REFERENCE) {
            return recordUpdate -> {
                ResolvedTransactionRecordValue updateValue = recordUpdate.getValue(column.getMappingId());
                Object value = updateValue != null ? updateValue.getValue() : null;
                Integer referencedId = (Integer)value;
                if (referencedId == null) {
                    return null;
                }
                return referencedRecordIdToTemplateRecord.apply(referencedId);
            };
        }
        return null;
    }

    private Function<RecordUpdate, Object> createFieldValueFunction(FieldIndex fieldIndex) {
        Function<RecordUpdate, Object> valueFunction = recordUpdate -> {
            ResolvedTransactionRecordValue updateValue = recordUpdate.getValue(fieldIndex.getMappingId());
            return updateValue != null ? updateValue.getValue() : null;
        };
        if (this.isMetaUserColumn(fieldIndex)) {
            return recordUpdate -> {
                Object value = valueFunction.apply((RecordUpdate)recordUpdate);
                return value != null ? Integer.valueOf((Integer)value) : null;
            };
        }
        switch (fieldIndex.getFieldType()) {
            case BOOLEAN: {
                return recordUpdate -> {
                    Object value = valueFunction.apply((RecordUpdate)recordUpdate);
                    return value != null ? (Boolean)value : null;
                };
            }
            case SHORT: 
            case INT: 
            case LONG: {
                return recordUpdate -> {
                    Object value = valueFunction.apply((RecordUpdate)recordUpdate);
                    return value != null ? (Number)((Number)value) : (Number)null;
                };
            }
            case FLOAT: 
            case DOUBLE: {
                return recordUpdate -> {
                    Object value = valueFunction.apply((RecordUpdate)recordUpdate);
                    return value != null ? (Number)((Number)value) : (Number)null;
                };
            }
            case TEXT: {
                return recordUpdate -> {
                    Object value = valueFunction.apply((RecordUpdate)recordUpdate);
                    return value != null ? (String)value : null;
                };
            }
            case TRANSLATABLE_TEXT: {
                return recordUpdate -> {
                    Object value = valueFunction.apply((RecordUpdate)recordUpdate);
                    return value != null ? ((TranslatableText)value).getText() : null;
                };
            }
            case FILE: {
                return recordUpdate -> {
                    FileValue value = (FileValue)valueFunction.apply((RecordUpdate)recordUpdate);
                    if (value == null) {
                        return null;
                    }
                    String size = FileUtils.byteCountToDisplaySize((long)value.getSize());
                    return value.getFileName() + " (" + size + ")";
                };
            }
            case SINGLE_REFERENCE: {
                return recordUpdate -> {
                    Integer value = (Integer)valueFunction.apply((RecordUpdate)recordUpdate);
                    if (value == null) {
                        return null;
                    }
                    SingleReferenceIndex singleReferenceIndex = (SingleReferenceIndex)fieldIndex;
                    List textIndices = singleReferenceIndex.getReferencedTable().getFieldIndices().stream().filter(c -> c.getFieldType() == FieldType.TEXT || c.getFieldType() == FieldType.TRANSLATABLE_TEXT).limit(5L).collect(Collectors.toList());
                    return textIndices.stream().map(idx -> idx.getStringValue(value.intValue())).filter(s -> !"NULL".equals(s)).filter(Objects::nonNull).collect(Collectors.joining(" "));
                };
            }
            case MULTI_REFERENCE: {
                MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)fieldIndex;
                List textIndices = multiReferenceIndex.getReferencedTable().getFieldIndices().stream().filter(c -> c.getFieldType() == FieldType.TEXT || c.getFieldType() == FieldType.TRANSLATABLE_TEXT).limit(5L).collect(Collectors.toList());
                return recordUpdate -> {
                    ArrayList<BaseTemplateRecord> records = new ArrayList<BaseTemplateRecord>();
                    ResolvedMultiReferenceUpdate multiReferenceUpdate = (ResolvedMultiReferenceUpdate)valueFunction.apply((RecordUpdate)recordUpdate);
                    if (multiReferenceUpdate == null) {
                        return null;
                    }
                    switch (multiReferenceUpdate.getType()) {
                        case ADD_REMOVE_REFERENCES: {
                            String value;
                            for (Integer referencedId : multiReferenceUpdate.getRemoveReferences()) {
                                value = textIndices.stream().map(col -> col.getStringValue(referencedId.intValue())).filter(s -> !"NULL".equals(s)).filter(Objects::nonNull).collect(Collectors.joining(" "));
                                records.add(new BaseTemplateRecord(ApplicationIcons.DELETE, value, (Object)referencedId));
                            }
                            for (Integer referencedId : multiReferenceUpdate.getAddReferences()) {
                                value = textIndices.stream().map(col -> col.getStringValue(referencedId.intValue())).filter(s -> !"NULL".equals(s)).filter(Objects::nonNull).collect(Collectors.joining(" "));
                                records.add(new BaseTemplateRecord(ApplicationIcons.ADD, value, (Object)referencedId));
                            }
                            break;
                        }
                        case SET_REFERENCES: {
                            for (Integer referencedId : multiReferenceUpdate.getSetReferences()) {
                                String value = textIndices.stream().map(col -> col.getStringValue(referencedId.intValue())).filter(s -> !"NULL".equals(s)).filter(Objects::nonNull).collect(Collectors.joining(" "));
                                records.add(new BaseTemplateRecord(ApplicationIcons.CHECK, value, (Object)referencedId));
                            }
                            break;
                        }
                        case REMOVE_ALL_REFERENCES: {
                            records.add(new BaseTemplateRecord(ApplicationIcons.ERROR, "Remove all", (Object)0));
                        }
                    }
                    return records;
                };
            }
            case TIMESTAMP: {
                return recordUpdate -> {
                    Integer value = (Integer)valueFunction.apply((RecordUpdate)recordUpdate);
                    return value == null ? null : Instant.ofEpochSecond(value.intValue());
                };
            }
            case DATE: {
                return recordUpdate -> {
                    Long value = (Long)valueFunction.apply((RecordUpdate)recordUpdate);
                    return value == null ? null : Instant.ofEpochMilli(value).atOffset(ZoneOffset.UTC).toLocalDate();
                };
            }
            case TIME: {
                return recordUpdate -> {
                    Integer value = (Integer)valueFunction.apply((RecordUpdate)recordUpdate);
                    return value == null ? null : Instant.ofEpochSecond(value.intValue()).atOffset(ZoneOffset.UTC).toLocalTime();
                };
            }
            case DATE_TIME: {
                return recordUpdate -> {
                    Long value = (Long)valueFunction.apply((RecordUpdate)recordUpdate);
                    return value == null ? null : Instant.ofEpochMilli(value);
                };
            }
            case LOCAL_DATE: {
                return recordUpdate -> {
                    Long value = (Long)valueFunction.apply((RecordUpdate)recordUpdate);
                    return value == null ? null : Instant.ofEpochMilli(value).atOffset(ZoneOffset.UTC).toLocalDate();
                };
            }
            case ENUM: {
                return recordUpdate -> {
                    Short value = (Short)valueFunction.apply((RecordUpdate)recordUpdate);
                    EnumFieldModel enumFieldModel = (EnumFieldModel)fieldIndex.getFieldModel().getTableModel().getField(fieldIndex.getName());
                    List enumTitles = enumFieldModel.getEnumModel().getEnumTitles();
                    return value == null || value == 0 ? null : enumTitles.get(value - 1);
                };
            }
            case BINARY: {
                return recordUpdate -> {
                    byte[] value = (byte[])valueFunction.apply((RecordUpdate)recordUpdate);
                    if (value == null) {
                        return null;
                    }
                    return FileUtils.byteCountToDisplaySize((long)value.length);
                };
            }
        }
        return null;
    }

    private boolean isMetaUserColumn(FieldIndex<?, ?> FieldIndex2) {
        String fieldName = FieldIndex2.getName();
        return FieldIndex2.getFieldType() == FieldType.INT && this.isMetaField(fieldName) && (fieldName.equals("metaCreatedBy") || fieldName.equals("metaModifiedBy") || fieldName.equals("metaDeletedBy") || fieldName.equals("metaRestoredBy"));
    }

    private String getMetaFieldTitle(String name) {
        return switch (name) {
            case "metaCreatedBy" -> this.applicationInstanceData.getLocalized("org.teamapps.dictionary.createdBy", new Object[0]);
            case "metaCreationDate" -> this.applicationInstanceData.getLocalized("org.teamapps.dictionary.creationDate", new Object[0]);
            case "metaModifiedBy" -> this.applicationInstanceData.getLocalized("org.teamapps.dictionary.modifiedBy", new Object[0]);
            case "metaModificationDate" -> this.applicationInstanceData.getLocalized("org.teamapps.dictionary.modificationDate", new Object[0]);
            case "metaDeletedBy" -> this.applicationInstanceData.getLocalized("org.teamapps.dictionary.deletedBy", new Object[0]);
            case "metaDeletionDate" -> this.applicationInstanceData.getLocalized("org.teamapps.dictionary.deletionDate", new Object[0]);
            case "metaRestoredBy" -> this.applicationInstanceData.getLocalized("org.teamapps.dictionary.restoredBy", new Object[0]);
            case "metaRestoreDate" -> this.applicationInstanceData.getLocalized("org.teamapps.dictionary.restoreDate", new Object[0]);
            default -> name;
        };
    }

    private boolean isMetaField(int columnId) {
        FieldIndex column = this.tableIndex.getFieldIndices().stream().filter(col -> col.getMappingId() == columnId).findFirst().orElse(null);
        return this.isMetaField(column.getName());
    }

    private boolean isMetaField(String fieldName) {
        return Table.isReservedMetaName((String)fieldName);
    }

    private Icon getIcon(ResolvedMultiReferenceUpdate entry) {
        switch (entry.getType()) {
            case ADD_REMOVE_REFERENCES: {
                return ApplicationIcons.ADD;
            }
            case SET_REFERENCES: {
                return ApplicationIcons.CHECK;
            }
            case REMOVE_ALL_REFERENCES: {
                return ApplicationIcons.ERROR;
            }
        }
        return null;
    }

    private Icon getIcon(RecordUpdate update) {
        switch (update.getRecordType()) {
            case CREATE: 
            case CREATE_WITH_ID: {
                return CompositeIcon.of((Icon)ApplicationIcons.DOCUMENT_EMPTY, (Icon)ApplicationIcons.ADD);
            }
            case UPDATE: {
                return ApplicationIcons.EDIT;
            }
            case DELETE: {
                return ApplicationIcons.DELETE;
            }
            case RESTORE: {
                return ApplicationIcons.GARBAGE_MAKE_EMPTY;
            }
            case ADD_CYCLIC_REFERENCE: {
                return CompositeIcon.of((Icon)ApplicationIcons.GRAPH_CONNECTION_DIRECTED, (Icon)ApplicationIcons.ADD);
            }
            case REMOVE_CYCLIC_REFERENCE: {
                return CompositeIcon.of((Icon)ApplicationIcons.GRAPH_CONNECTION_DIRECTED, (Icon)ApplicationIcons.DELETE);
            }
        }
        return null;
    }

    public Template createItemTemplate(int iconSize, int imageSize, VerticalElementAlignment verticalIconAlignment, int maxHeight, int spacing, boolean wrapLines) {
        return new GridTemplate().setAriaLabelProperty("ariaLabel").setTitleProperty("title").setMaxHeight(maxHeight).setPadding(new Spacing(spacing)).addColumn(SizingPolicy.AUTO).addColumn(SizingPolicy.AUTO).addColumn(SizingPolicy.FRACTION).addRow(SizeType.AUTO, 0.0f, 0, 1, 1).addRow(SizeType.AUTO, 0.0f, 0, 1, 1).addRow(SizeType.AUTO, 0.0f, 0, 1, 1).addElement(((IconElement)new IconElement("icon", 0, 2, iconSize).setRowSpan(3)).setVerticalAlignment(verticalIconAlignment).setHorizontalAlignment(HorizontalElementAlignment.RIGHT).setMargin(new Spacing(0, 4, 0, 0))).addElement(new ImageElement("image", 0, 0, imageSize, imageSize).setRowSpan(3).setBorder(new Border(new Line((Color)RgbaColor.GRAY, LineType.SOLID, 0.5f)).setBorderRadius(300.0f)).setShadow(Shadow.withSize((float)0.5f)).setVerticalAlignment(verticalIconAlignment).setMargin(new Spacing(0, 4, 0, 0))).addElement(new TextElement("caption", 0, 1).setWrapLines(wrapLines).setVerticalAlignment(VerticalElementAlignment.BOTTOM).setHorizontalAlignment(HorizontalElementAlignment.LEFT)).addElement(((TextElement)new TextElement("description", 1, 1).setColSpan(1)).setWrapLines(wrapLines).setFontStyle(0.8f, (Color)RgbaColor.GRAY_STANDARD).setVerticalAlignment(VerticalElementAlignment.TOP).setHorizontalAlignment(HorizontalElementAlignment.LEFT)).addElement(new TextElement("badge", 2, 1).setWrapLines(wrapLines).setFontStyle(new FontStyle(1.0f, (Color)RgbaColor.MATERIAL_BLUE_900, null, true, false, false)).setVerticalAlignment(VerticalElementAlignment.BOTTOM).setHorizontalAlignment(HorizontalElementAlignment.LEFT));
    }
}

