/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.window;

import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.ApplicationInstanceDataMethods;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.window.Window;
import org.teamapps.ux.session.SessionContext;

public class ApplicationWindow
implements ApplicationInstanceDataMethods {
    private final Window window;
    private final boolean smallToolbarButtons;
    private final ApplicationInstanceData applicationInstanceData;
    private Toolbar toolbar;
    private ToolbarButtonGroup currentButtonGroup;
    private ToolbarButton saveButton;
    private ToolbarButton okButton;
    private ToolbarButton cancelButton;

    public ApplicationWindow(Icon icon, String title, ApplicationInstanceData applicationInstanceData) {
        this(icon, title, false, applicationInstanceData);
    }

    public ApplicationWindow(Icon icon, String title, boolean smallToolbarButtons, ApplicationInstanceData applicationInstanceData) {
        this.smallToolbarButtons = smallToolbarButtons;
        this.applicationInstanceData = applicationInstanceData;
        this.window = new Window(icon, title, 800, 600, null);
        this.window.setResizable(true);
        this.toolbar = new Toolbar();
        this.window.setToolbar(this.toolbar);
        this.window.setMaximizable(true);
        this.window.setCloseable(true);
        this.window.setCloseOnEscape(true);
        this.window.enableAutoHeight();
        this.currentButtonGroup = this.toolbar.addButtonGroup(new ToolbarButtonGroup());
    }

    public ToolbarButtonGroup addButtonGroup() {
        this.currentButtonGroup = new ToolbarButtonGroup();
        this.toolbar.addButtonGroup(this.currentButtonGroup);
        return this.currentButtonGroup;
    }

    public ToolbarButton addButton(Icon icon, String title) {
        return this.addButton(icon, title, title);
    }

    public ToolbarButton addButton(Icon icon, String title, String description) {
        ToolbarButton button = this.smallToolbarButtons ? ToolbarButton.createSmall((Icon)icon, (String)title) : ToolbarButton.create((Icon)icon, (String)title, (String)description);
        this.currentButtonGroup.addButton(button);
        return button;
    }

    public ToolbarButton addSaveButton() {
        return this.addSaveButton(this.getLocalized("org.teamapps.dictionary.save", new Object[0]), this.getLocalized("org.teamapps.dictionary.saveAndCloseWindow", new Object[0]));
    }

    public ToolbarButton addSaveButton(String title, String description) {
        this.saveButton = this.smallToolbarButtons ? ToolbarButton.createSmall((Icon)ApplicationIcons.FLOPPY_DISK, (String)title) : ToolbarButton.create((Icon)ApplicationIcons.FLOPPY_DISK, (String)title, (String)description);
        this.currentButtonGroup.addButton(this.saveButton);
        return this.saveButton;
    }

    public ToolbarButton addOkButton() {
        return this.addOkButton(this.getLocalized("org.teamapps.dictionary.oK", new Object[0]), this.getLocalized("org.teamapps.dictionary.oK", new Object[0]));
    }

    public ToolbarButton addOkButton(String title, String description) {
        this.okButton = this.smallToolbarButtons ? ToolbarButton.createSmall((Icon)ApplicationIcons.OK, (String)title) : ToolbarButton.create((Icon)ApplicationIcons.OK, (String)title, (String)description);
        this.currentButtonGroup.addButton(this.okButton);
        return this.okButton;
    }

    public ToolbarButton addCancelButton() {
        return this.addCancelButton(this.getLocalized("org.teamapps.dictionary.cancel", new Object[0]), this.getLocalized("org.teamapps.dictionary.cancelAndCloseWindow", new Object[0]));
    }

    public ToolbarButton addCancelButton(String title, String description) {
        this.cancelButton = this.smallToolbarButtons ? ToolbarButton.createSmall((Icon)ApplicationIcons.WINDOW_CLOSE, (String)title) : ToolbarButton.create((Icon)ApplicationIcons.WINDOW_CLOSE, (String)title, (String)description);
        this.currentButtonGroup.addButton(this.cancelButton);
        this.cancelButton.onClick.addListener(() -> this.window.close());
        return this.cancelButton;
    }

    public void setContent(Component content) {
        this.window.setContent(content);
    }

    public void setWindowRelativeSize(float relativeWidth, float relativeHeight) {
        int windowWidth = (int)Math.max(800.0f, Math.min(1600.0f, (float)SessionContext.current().getClientInfo().getViewPortWidth() * relativeWidth));
        int windowHeight = (int)Math.max(600.0f, Math.min(1200.0f, (float)SessionContext.current().getClientInfo().getScreenHeight() * relativeHeight));
        this.window.setSize(windowWidth, windowHeight);
    }

    public void setWindowPreferredSize(int width, int height, float minRelativeMargin) {
        int windowWidth = (int)Math.min((float)width, (float)SessionContext.current().getClientInfo().getViewPortWidth() * (1.0f - minRelativeMargin));
        int windowHeight = (int)Math.min((float)height, (float)SessionContext.current().getClientInfo().getScreenHeight() * (1.0f - minRelativeMargin));
        this.window.setSize(windowWidth, windowHeight);
    }

    public void setWindowSize(int width, int height) {
        this.window.setSize(width, height);
    }

    public void show() {
        this.window.show(300);
    }

    public void close() {
        this.window.close();
    }

    public ToolbarButtonGroup getCurrentButtonGroup() {
        return this.currentButtonGroup;
    }

    public ToolbarButton getSaveButton() {
        return this.saveButton;
    }

    public ToolbarButton getOkButton() {
        return this.okButton;
    }

    public ToolbarButton getCancelButton() {
        return this.cancelButton;
    }

    @Override
    public ApplicationInstanceData getApplicationInstanceData() {
        return this.applicationInstanceData;
    }

    public Window getWindow() {
        return this.window;
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }
}

