/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.privilege;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.icons.Icon;

public abstract class AbstractPrivilegeGroup
implements PrivilegeGroup {
    private final String name;
    private final Icon icon;
    private final String titleKey;
    private final String descriptionKey;
    private final boolean multiFactorAuthenticationRequired;
    private final boolean inheritanceForbidden;
    private final List<Privilege> privileges;
    private Supplier<List<PrivilegeObject>> privilegeObjectsSupplier;
    private String category;

    public AbstractPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey) {
        this.name = name;
        this.icon = icon;
        this.titleKey = titleKey;
        this.descriptionKey = descriptionKey;
        this.privileges = Collections.emptyList();
        this.multiFactorAuthenticationRequired = false;
        this.inheritanceForbidden = false;
    }

    public AbstractPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, boolean multiFactorAuthenticationRequired, boolean inheritanceForbidden) {
        this.name = name;
        this.icon = icon;
        this.titleKey = titleKey;
        this.descriptionKey = descriptionKey;
        this.multiFactorAuthenticationRequired = multiFactorAuthenticationRequired;
        this.inheritanceForbidden = inheritanceForbidden;
        this.privileges = Collections.emptyList();
    }

    public AbstractPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, List<Privilege> privileges) {
        this.name = name;
        this.icon = icon;
        this.titleKey = titleKey;
        this.descriptionKey = descriptionKey;
        this.privileges = privileges;
        this.multiFactorAuthenticationRequired = false;
        this.inheritanceForbidden = false;
    }

    public AbstractPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, Privilege ... privileges) {
        this.name = name;
        this.icon = icon;
        this.titleKey = titleKey;
        this.descriptionKey = descriptionKey;
        this.privileges = Arrays.asList(privileges);
        this.multiFactorAuthenticationRequired = false;
        this.inheritanceForbidden = false;
    }

    public AbstractPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, boolean multiFactorAuthenticationRequired, boolean inheritanceForbidden, Privilege ... privileges) {
        this.name = name;
        this.icon = icon;
        this.titleKey = titleKey;
        this.descriptionKey = descriptionKey;
        this.privileges = Arrays.asList(privileges);
        this.multiFactorAuthenticationRequired = multiFactorAuthenticationRequired;
        this.inheritanceForbidden = inheritanceForbidden;
    }

    public AbstractPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, boolean multiFactorAuthenticationRequired, List<Privilege> privileges) {
        this.name = name;
        this.icon = icon;
        this.titleKey = titleKey;
        this.descriptionKey = descriptionKey;
        this.multiFactorAuthenticationRequired = multiFactorAuthenticationRequired;
        this.privileges = privileges;
        this.inheritanceForbidden = false;
    }

    public AbstractPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, List<Privilege> privileges, Supplier<List<PrivilegeObject>> privilegeObjectsSupplier) {
        this.name = name;
        this.icon = icon;
        this.titleKey = titleKey;
        this.descriptionKey = descriptionKey;
        this.privileges = privileges;
        this.privilegeObjectsSupplier = privilegeObjectsSupplier;
        this.multiFactorAuthenticationRequired = false;
        this.inheritanceForbidden = false;
    }

    public AbstractPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, boolean multiFactorAuthenticationRequired, boolean inheritanceForbidden, List<Privilege> privileges, Supplier<List<PrivilegeObject>> privilegeObjectsSupplier) {
        this.name = name;
        this.icon = icon;
        this.titleKey = titleKey;
        this.descriptionKey = descriptionKey;
        this.multiFactorAuthenticationRequired = multiFactorAuthenticationRequired;
        this.privileges = privileges;
        this.privilegeObjectsSupplier = privilegeObjectsSupplier;
        this.inheritanceForbidden = inheritanceForbidden;
    }

    public void setPrivilegeObjectsSupplier(Supplier<List<PrivilegeObject>> privilegeObjectsSupplier) {
        this.privilegeObjectsSupplier = privilegeObjectsSupplier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getTitleKey() {
        return this.titleKey;
    }

    @Override
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    @Override
    public List<Privilege> getPrivileges() {
        return this.privileges;
    }

    @Override
    public boolean isMultiFactorAuthenticationRequired() {
        return this.multiFactorAuthenticationRequired;
    }

    @Override
    public boolean isInheritanceForbidden() {
        return this.inheritanceForbidden;
    }

    @Override
    public Supplier<List<PrivilegeObject>> getPrivilegeObjectsSupplier() {
        return this.privilegeObjectsSupplier;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegeGroup that = (PrivilegeGroup)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }
}

