/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.user;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.apache.commons.io.FileUtils;

public class LocalizedFormatter {
    private final Locale locale;
    private final ZoneId timezone;
    private final NumberFormat percentFormat;
    private final NumberFormat compactNumberFormat;
    private final NumberFormat decimalFormat;
    private final DateTimeFormatter dateFormatLong;
    private final DateTimeFormatter dateFormat;
    private final DateTimeFormatter dateTimeFormat;
    private final DateTimeFormatter dateTimeFormatLong;
    private final DateTimeFormatter timeFormatter;
    private final DateTimeFormatter durationFormatter;

    public LocalizedFormatter(Locale locale, ZoneId timezone) {
        this.locale = locale;
        this.timezone = timezone;
        this.percentFormat = NumberFormat.getPercentInstance(locale);
        this.percentFormat.setMaximumFractionDigits(2);
        this.compactNumberFormat = NumberFormat.getCompactNumberInstance(locale, NumberFormat.Style.LONG);
        this.decimalFormat = DecimalFormat.getInstance(locale);
        this.decimalFormat.setMaximumFractionDigits(2);
        this.dateTimeFormat = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.SHORT).withLocale(locale);
        this.dateFormatLong = DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL).withLocale(locale);
        this.dateFormat = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(locale);
        this.dateTimeFormatLong = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL, FormatStyle.SHORT).withLocale(locale);
        this.timeFormatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).withLocale(locale);
        this.durationFormatter = DateTimeFormatter.ofPattern("mm:ss");
    }

    public String formatFileSize(long length) {
        return FileUtils.byteCountToDisplaySize((long)length);
    }

    public String formatPercent(double value) {
        return this.percentFormat.format(value);
    }

    public String formatDecimalNumber(double value) {
        return this.decimalFormat.format(value);
    }

    public String formatCompactNumber(long value) {
        return this.compactNumberFormat.format(value);
    }

    public String formatTimestamp(int timestamp) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestamp), this.timezone).format(this.dateTimeFormat);
    }

    public String formatTimestamp(long timestamp) {
        if (timestamp < Integer.MAX_VALUE) {
            return ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestamp), this.timezone).format(this.dateTimeFormat);
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), this.timezone).format(this.dateTimeFormat);
    }

    public String formatTimestampLong(int timestamp) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestamp), this.timezone).format(this.dateTimeFormatLong);
    }

    public String formatTimestampLong(long timestamp) {
        if (timestamp < Integer.MAX_VALUE) {
            return ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestamp), this.timezone).format(this.dateTimeFormatLong);
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), this.timezone).format(this.dateTimeFormatLong);
    }

    public String formatTimeOnly(Instant instant) {
        if (instant == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(instant, this.timezone).format(this.timeFormatter);
    }

    public String formatDateOnlyLong(Instant instant) {
        if (instant == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(instant, this.timezone).format(this.dateFormatLong);
    }

    public String formatDateOnly(Instant instant) {
        if (instant == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(instant, this.timezone).format(this.dateFormat);
    }

    public String formatDateTime(Instant instant) {
        if (instant == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(instant, this.timezone).format(this.dateTimeFormat);
    }

    public String formatDurationInSeconds(int seconds) {
        LocalTime timeOfDay = LocalTime.ofSecondOfDay(Math.abs(seconds));
        return this.durationFormatter.format(timeOfDay);
    }
}

