/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.localize;

import java.util.HashMap;
import java.util.Map;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.localization.Country;
import org.teamapps.application.api.localization.Language;

public class FlagMap {
    private static final Map<String, String> flagMap = new HashMap<String, String>();
    private static final Map<String, String> flagByLanguage = new HashMap<String, String>();

    public static String getFlagByCountryCode(String isoCountryCode) {
        return flagMap.get(isoCountryCode);
    }

    public static String getFlagByCountry(Country country) {
        return country != null ? FlagMap.getFlagByCountryCode(country.getIsoCode()) : null;
    }

    public static String getFlagByLanguageCode(String isoCountryCode) {
        return flagByLanguage.get(isoCountryCode);
    }

    public static String getFlagByLanguage(Language language) {
        return language != null ? FlagMap.getFlagByLanguageCode(language.getIsoCode()) : null;
    }

    public static String getTranslatedLanguageWithFlag(String languageIso, ApplicationInstanceData applicationInstanceData) {
        return FlagMap.getTranslatedLanguageWithFlag(languageIso, false, applicationInstanceData);
    }

    public static String getTranslatedLanguageWithFlag(String languageIso, boolean htmlBold, ApplicationInstanceData applicationInstanceData) {
        Language language = Language.getLanguageByIsoCode(languageIso);
        if (language == null) {
            return null;
        }
        return FlagMap.getTranslatedLanguageWithFlag(language, htmlBold, applicationInstanceData);
    }

    public static String getTranslatedLanguageWithFlag(Language language, ApplicationInstanceData applicationInstanceData) {
        return FlagMap.getTranslatedLanguageWithFlag(language, false, applicationInstanceData);
    }

    public static String getTranslatedLanguageWithFlag(Language language, boolean htmlBold, ApplicationInstanceData applicationInstanceData) {
        String flag = FlagMap.getFlagByLanguageCode(language.getIsoCode());
        String caption = language.getLanguageLocalized(applicationInstanceData);
        Object flagData = flag == null ? "" : flag + " ";
        return (String)flagData + FlagMap.getHtmlBold(caption, htmlBold);
    }

    private static String getHtmlBold(String value, boolean bold) {
        return bold ? "<b>" + value + "</b>" : value;
    }

    static {
        flagMap.put("AC", "\ud83c\udde6\ud83c\udde8");
        flagMap.put("AD", "\ud83c\udde6\ud83c\udde9");
        flagMap.put("AE", "\ud83c\udde6\ud83c\uddea");
        flagMap.put("AF", "\ud83c\udde6\ud83c\uddeb");
        flagMap.put("AG", "\ud83c\udde6\ud83c\uddec");
        flagMap.put("AI", "\ud83c\udde6\ud83c\uddee");
        flagMap.put("AL", "\ud83c\udde6\ud83c\uddf1");
        flagMap.put("AM", "\ud83c\udde6\ud83c\uddf2");
        flagMap.put("AO", "\ud83c\udde6\ud83c\uddf4");
        flagMap.put("AQ", "\ud83c\udde6\ud83c\uddf6");
        flagMap.put("AR", "\ud83c\udde6\ud83c\uddf7");
        flagMap.put("AS", "\ud83c\udde6\ud83c\uddf8");
        flagMap.put("AT", "\ud83c\udde6\ud83c\uddf9");
        flagMap.put("AU", "\ud83c\udde6\ud83c\uddfa");
        flagMap.put("AW", "\ud83c\udde6\ud83c\uddfc");
        flagMap.put("AX", "\ud83c\udde6\ud83c\uddfd");
        flagMap.put("AZ", "\ud83c\udde6\ud83c\uddff");
        flagMap.put("BA", "\ud83c\udde7\ud83c\udde6");
        flagMap.put("BB", "\ud83c\udde7\ud83c\udde7");
        flagMap.put("BD", "\ud83c\udde7\ud83c\udde9");
        flagMap.put("BE", "\ud83c\udde7\ud83c\uddea");
        flagMap.put("BF", "\ud83c\udde7\ud83c\uddeb");
        flagMap.put("BG", "\ud83c\udde7\ud83c\uddec");
        flagMap.put("BH", "\ud83c\udde7\ud83c\udded");
        flagMap.put("BI", "\ud83c\udde7\ud83c\uddee");
        flagMap.put("BJ", "\ud83c\udde7\ud83c\uddef");
        flagMap.put("BL", "\ud83c\udde7\ud83c\uddf1");
        flagMap.put("BM", "\ud83c\udde7\ud83c\uddf2");
        flagMap.put("BN", "\ud83c\udde7\ud83c\uddf3");
        flagMap.put("BO", "\ud83c\udde7\ud83c\uddf4");
        flagMap.put("BQ", "\ud83c\udde7\ud83c\uddf6");
        flagMap.put("BR", "\ud83c\udde7\ud83c\uddf7");
        flagMap.put("BS", "\ud83c\udde7\ud83c\uddf8");
        flagMap.put("BT", "\ud83c\udde7\ud83c\uddf9");
        flagMap.put("BV", "\ud83c\udde7\ud83c\uddfb");
        flagMap.put("BW", "\ud83c\udde7\ud83c\uddfc");
        flagMap.put("BY", "\ud83c\udde7\ud83c\uddfe");
        flagMap.put("BZ", "\ud83c\udde7\ud83c\uddff");
        flagMap.put("CA", "\ud83c\udde8\ud83c\udde6");
        flagMap.put("CC", "\ud83c\udde8\ud83c\udde8");
        flagMap.put("CD", "\ud83c\udde8\ud83c\udde9");
        flagMap.put("CF", "\ud83c\udde8\ud83c\uddeb");
        flagMap.put("CG", "\ud83c\udde8\ud83c\uddec");
        flagMap.put("CH", "\ud83c\udde8\ud83c\udded");
        flagMap.put("CI", "\ud83c\udde8\ud83c\uddee");
        flagMap.put("CK", "\ud83c\udde8\ud83c\uddf0");
        flagMap.put("CL", "\ud83c\udde8\ud83c\uddf1");
        flagMap.put("CM", "\ud83c\udde8\ud83c\uddf2");
        flagMap.put("CN", "\ud83c\udde8\ud83c\uddf3");
        flagMap.put("CO", "\ud83c\udde8\ud83c\uddf4");
        flagMap.put("CP", "\ud83c\udde8\ud83c\uddf5");
        flagMap.put("CR", "\ud83c\udde8\ud83c\uddf7");
        flagMap.put("CU", "\ud83c\udde8\ud83c\uddfa");
        flagMap.put("CV", "\ud83c\udde8\ud83c\uddfb");
        flagMap.put("CW", "\ud83c\udde8\ud83c\uddfc");
        flagMap.put("CX", "\ud83c\udde8\ud83c\uddfd");
        flagMap.put("CY", "\ud83c\udde8\ud83c\uddfe");
        flagMap.put("CZ", "\ud83c\udde8\ud83c\uddff");
        flagMap.put("DE", "\ud83c\udde9\ud83c\uddea");
        flagMap.put("DG", "\ud83c\udde9\ud83c\uddec");
        flagMap.put("DJ", "\ud83c\udde9\ud83c\uddef");
        flagMap.put("DK", "\ud83c\udde9\ud83c\uddf0");
        flagMap.put("DM", "\ud83c\udde9\ud83c\uddf2");
        flagMap.put("DO", "\ud83c\udde9\ud83c\uddf4");
        flagMap.put("DZ", "\ud83c\udde9\ud83c\uddff");
        flagMap.put("EA", "\ud83c\uddea\ud83c\udde6");
        flagMap.put("EC", "\ud83c\uddea\ud83c\udde8");
        flagMap.put("EE", "\ud83c\uddea\ud83c\uddea");
        flagMap.put("EG", "\ud83c\uddea\ud83c\uddec");
        flagMap.put("EH", "\ud83c\uddea\ud83c\udded");
        flagMap.put("ER", "\ud83c\uddea\ud83c\uddf7");
        flagMap.put("ES", "\ud83c\uddea\ud83c\uddf8");
        flagMap.put("ET", "\ud83c\uddea\ud83c\uddf9");
        flagMap.put("EU", "\ud83c\uddea\ud83c\uddfa");
        flagMap.put("FI", "\ud83c\uddeb\ud83c\uddee");
        flagMap.put("FJ", "\ud83c\uddeb\ud83c\uddef");
        flagMap.put("FK", "\ud83c\uddeb\ud83c\uddf0");
        flagMap.put("FM", "\ud83c\uddeb\ud83c\uddf2");
        flagMap.put("FO", "\ud83c\uddeb\ud83c\uddf4");
        flagMap.put("FR", "\ud83c\uddeb\ud83c\uddf7");
        flagMap.put("GA", "\ud83c\uddec\ud83c\udde6");
        flagMap.put("GB", "\ud83c\uddec\ud83c\udde7");
        flagMap.put("GD", "\ud83c\uddec\ud83c\udde9");
        flagMap.put("GE", "\ud83c\uddec\ud83c\uddea");
        flagMap.put("GF", "\ud83c\uddec\ud83c\uddeb");
        flagMap.put("GG", "\ud83c\uddec\ud83c\uddec");
        flagMap.put("GH", "\ud83c\uddec\ud83c\udded");
        flagMap.put("GI", "\ud83c\uddec\ud83c\uddee");
        flagMap.put("GL", "\ud83c\uddec\ud83c\uddf1");
        flagMap.put("GM", "\ud83c\uddec\ud83c\uddf2");
        flagMap.put("GN", "\ud83c\uddec\ud83c\uddf3");
        flagMap.put("GP", "\ud83c\uddec\ud83c\uddf5");
        flagMap.put("GQ", "\ud83c\uddec\ud83c\uddf6");
        flagMap.put("GR", "\ud83c\uddec\ud83c\uddf7");
        flagMap.put("GS", "\ud83c\uddec\ud83c\uddf8");
        flagMap.put("GT", "\ud83c\uddec\ud83c\uddf9");
        flagMap.put("GU", "\ud83c\uddec\ud83c\uddfa");
        flagMap.put("GW", "\ud83c\uddec\ud83c\uddfc");
        flagMap.put("GY", "\ud83c\uddec\ud83c\uddfe");
        flagMap.put("HK", "\ud83c\udded\ud83c\uddf0");
        flagMap.put("HM", "\ud83c\udded\ud83c\uddf2");
        flagMap.put("HN", "\ud83c\udded\ud83c\uddf3");
        flagMap.put("HR", "\ud83c\udded\ud83c\uddf7");
        flagMap.put("HT", "\ud83c\udded\ud83c\uddf9");
        flagMap.put("HU", "\ud83c\udded\ud83c\uddfa");
        flagMap.put("IC", "\ud83c\uddee\ud83c\udde8");
        flagMap.put("ID", "\ud83c\uddee\ud83c\udde9");
        flagMap.put("IE", "\ud83c\uddee\ud83c\uddea");
        flagMap.put("IL", "\ud83c\uddee\ud83c\uddf1");
        flagMap.put("IM", "\ud83c\uddee\ud83c\uddf2");
        flagMap.put("IN", "\ud83c\uddee\ud83c\uddf3");
        flagMap.put("IO", "\ud83c\uddee\ud83c\uddf4");
        flagMap.put("IQ", "\ud83c\uddee\ud83c\uddf6");
        flagMap.put("IR", "\ud83c\uddee\ud83c\uddf7");
        flagMap.put("IS", "\ud83c\uddee\ud83c\uddf8");
        flagMap.put("IT", "\ud83c\uddee\ud83c\uddf9");
        flagMap.put("JE", "\ud83c\uddef\ud83c\uddea");
        flagMap.put("JM", "\ud83c\uddef\ud83c\uddf2");
        flagMap.put("JO", "\ud83c\uddef\ud83c\uddf4");
        flagMap.put("JP", "\ud83c\uddef\ud83c\uddf5");
        flagMap.put("KE", "\ud83c\uddf0\ud83c\uddea");
        flagMap.put("KG", "\ud83c\uddf0\ud83c\uddec");
        flagMap.put("KH", "\ud83c\uddf0\ud83c\udded");
        flagMap.put("KI", "\ud83c\uddf0\ud83c\uddee");
        flagMap.put("KM", "\ud83c\uddf0\ud83c\uddf2");
        flagMap.put("KN", "\ud83c\uddf0\ud83c\uddf3");
        flagMap.put("KP", "\ud83c\uddf0\ud83c\uddf5");
        flagMap.put("KR", "\ud83c\uddf0\ud83c\uddf7");
        flagMap.put("KW", "\ud83c\uddf0\ud83c\uddfc");
        flagMap.put("KY", "\ud83c\uddf0\ud83c\uddfe");
        flagMap.put("KZ", "\ud83c\uddf0\ud83c\uddff");
        flagMap.put("LA", "\ud83c\uddf1\ud83c\udde6");
        flagMap.put("LB", "\ud83c\uddf1\ud83c\udde7");
        flagMap.put("LC", "\ud83c\uddf1\ud83c\udde8");
        flagMap.put("LI", "\ud83c\uddf1\ud83c\uddee");
        flagMap.put("LK", "\ud83c\uddf1\ud83c\uddf0");
        flagMap.put("LR", "\ud83c\uddf1\ud83c\uddf7");
        flagMap.put("LS", "\ud83c\uddf1\ud83c\uddf8");
        flagMap.put("LT", "\ud83c\uddf1\ud83c\uddf9");
        flagMap.put("LU", "\ud83c\uddf1\ud83c\uddfa");
        flagMap.put("LV", "\ud83c\uddf1\ud83c\uddfb");
        flagMap.put("LY", "\ud83c\uddf1\ud83c\uddfe");
        flagMap.put("MA", "\ud83c\uddf2\ud83c\udde6");
        flagMap.put("MC", "\ud83c\uddf2\ud83c\udde8");
        flagMap.put("MD", "\ud83c\uddf2\ud83c\udde9");
        flagMap.put("ME", "\ud83c\uddf2\ud83c\uddea");
        flagMap.put("MF", "\ud83c\uddf2\ud83c\uddeb");
        flagMap.put("MG", "\ud83c\uddf2\ud83c\uddec");
        flagMap.put("MH", "\ud83c\uddf2\ud83c\udded");
        flagMap.put("MK", "\ud83c\uddf2\ud83c\uddf0");
        flagMap.put("ML", "\ud83c\uddf2\ud83c\uddf1");
        flagMap.put("MM", "\ud83c\uddf2\ud83c\uddf2");
        flagMap.put("MN", "\ud83c\uddf2\ud83c\uddf3");
        flagMap.put("MO", "\ud83c\uddf2\ud83c\uddf4");
        flagMap.put("MP", "\ud83c\uddf2\ud83c\uddf5");
        flagMap.put("MQ", "\ud83c\uddf2\ud83c\uddf6");
        flagMap.put("MR", "\ud83c\uddf2\ud83c\uddf7");
        flagMap.put("MS", "\ud83c\uddf2\ud83c\uddf8");
        flagMap.put("MT", "\ud83c\uddf2\ud83c\uddf9");
        flagMap.put("MU", "\ud83c\uddf2\ud83c\uddfa");
        flagMap.put("MV", "\ud83c\uddf2\ud83c\uddfb");
        flagMap.put("MW", "\ud83c\uddf2\ud83c\uddfc");
        flagMap.put("MX", "\ud83c\uddf2\ud83c\uddfd");
        flagMap.put("MY", "\ud83c\uddf2\ud83c\uddfe");
        flagMap.put("MZ", "\ud83c\uddf2\ud83c\uddff");
        flagMap.put("NA", "\ud83c\uddf3\ud83c\udde6");
        flagMap.put("NC", "\ud83c\uddf3\ud83c\udde8");
        flagMap.put("NE", "\ud83c\uddf3\ud83c\uddea");
        flagMap.put("NF", "\ud83c\uddf3\ud83c\uddeb");
        flagMap.put("NG", "\ud83c\uddf3\ud83c\uddec");
        flagMap.put("NI", "\ud83c\uddf3\ud83c\uddee");
        flagMap.put("NL", "\ud83c\uddf3\ud83c\uddf1");
        flagMap.put("NO", "\ud83c\uddf3\ud83c\uddf4");
        flagMap.put("NP", "\ud83c\uddf3\ud83c\uddf5");
        flagMap.put("NR", "\ud83c\uddf3\ud83c\uddf7");
        flagMap.put("NU", "\ud83c\uddf3\ud83c\uddfa");
        flagMap.put("NZ", "\ud83c\uddf3\ud83c\uddff");
        flagMap.put("OM", "\ud83c\uddf4\ud83c\uddf2");
        flagMap.put("PA", "\ud83c\uddf5\ud83c\udde6");
        flagMap.put("PE", "\ud83c\uddf5\ud83c\uddea");
        flagMap.put("PF", "\ud83c\uddf5\ud83c\uddeb");
        flagMap.put("PG", "\ud83c\uddf5\ud83c\uddec");
        flagMap.put("PH", "\ud83c\uddf5\ud83c\udded");
        flagMap.put("PK", "\ud83c\uddf5\ud83c\uddf0");
        flagMap.put("PL", "\ud83c\uddf5\ud83c\uddf1");
        flagMap.put("PM", "\ud83c\uddf5\ud83c\uddf2");
        flagMap.put("PN", "\ud83c\uddf5\ud83c\uddf3");
        flagMap.put("PR", "\ud83c\uddf5\ud83c\uddf7");
        flagMap.put("PS", "\ud83c\uddf5\ud83c\uddf8");
        flagMap.put("PT", "\ud83c\uddf5\ud83c\uddf9");
        flagMap.put("PW", "\ud83c\uddf5\ud83c\uddfc");
        flagMap.put("PY", "\ud83c\uddf5\ud83c\uddfe");
        flagMap.put("QA", "\ud83c\uddf6\ud83c\udde6");
        flagMap.put("RE", "\ud83c\uddf7\ud83c\uddea");
        flagMap.put("RO", "\ud83c\uddf7\ud83c\uddf4");
        flagMap.put("RS", "\ud83c\uddf7\ud83c\uddf8");
        flagMap.put("RU", "\ud83c\uddf7\ud83c\uddfa");
        flagMap.put("RW", "\ud83c\uddf7\ud83c\uddfc");
        flagMap.put("SA", "\ud83c\uddf8\ud83c\udde6");
        flagMap.put("SB", "\ud83c\uddf8\ud83c\udde7");
        flagMap.put("SC", "\ud83c\uddf8\ud83c\udde8");
        flagMap.put("SD", "\ud83c\uddf8\ud83c\udde9");
        flagMap.put("SE", "\ud83c\uddf8\ud83c\uddea");
        flagMap.put("SG", "\ud83c\uddf8\ud83c\uddec");
        flagMap.put("SH", "\ud83c\uddf8\ud83c\udded");
        flagMap.put("SI", "\ud83c\uddf8\ud83c\uddee");
        flagMap.put("SJ", "\ud83c\uddf8\ud83c\uddef");
        flagMap.put("SK", "\ud83c\uddf8\ud83c\uddf0");
        flagMap.put("SL", "\ud83c\uddf8\ud83c\uddf1");
        flagMap.put("SM", "\ud83c\uddf8\ud83c\uddf2");
        flagMap.put("SN", "\ud83c\uddf8\ud83c\uddf3");
        flagMap.put("SO", "\ud83c\uddf8\ud83c\uddf4");
        flagMap.put("SR", "\ud83c\uddf8\ud83c\uddf7");
        flagMap.put("SS", "\ud83c\uddf8\ud83c\uddf8");
        flagMap.put("ST", "\ud83c\uddf8\ud83c\uddf9");
        flagMap.put("SV", "\ud83c\uddf8\ud83c\uddfb");
        flagMap.put("SX", "\ud83c\uddf8\ud83c\uddfd");
        flagMap.put("SY", "\ud83c\uddf8\ud83c\uddfe");
        flagMap.put("SZ", "\ud83c\uddf8\ud83c\uddff");
        flagMap.put("TA", "\ud83c\uddf9\ud83c\udde6");
        flagMap.put("TC", "\ud83c\uddf9\ud83c\udde8");
        flagMap.put("TD", "\ud83c\uddf9\ud83c\udde9");
        flagMap.put("TF", "\ud83c\uddf9\ud83c\uddeb");
        flagMap.put("TG", "\ud83c\uddf9\ud83c\uddec");
        flagMap.put("TH", "\ud83c\uddf9\ud83c\udded");
        flagMap.put("TJ", "\ud83c\uddf9\ud83c\uddef");
        flagMap.put("TK", "\ud83c\uddf9\ud83c\uddf0");
        flagMap.put("TL", "\ud83c\uddf9\ud83c\uddf1");
        flagMap.put("TM", "\ud83c\uddf9\ud83c\uddf2");
        flagMap.put("TN", "\ud83c\uddf9\ud83c\uddf3");
        flagMap.put("TO", "\ud83c\uddf9\ud83c\uddf4");
        flagMap.put("TR", "\ud83c\uddf9\ud83c\uddf7");
        flagMap.put("TT", "\ud83c\uddf9\ud83c\uddf9");
        flagMap.put("TV", "\ud83c\uddf9\ud83c\uddfb");
        flagMap.put("TW", "\ud83c\uddf9\ud83c\uddfc");
        flagMap.put("TZ", "\ud83c\uddf9\ud83c\uddff");
        flagMap.put("UA", "\ud83c\uddfa\ud83c\udde6");
        flagMap.put("UG", "\ud83c\uddfa\ud83c\uddec");
        flagMap.put("UM", "\ud83c\uddfa\ud83c\uddf2");
        flagMap.put("UN", "\ud83c\uddfa\ud83c\uddf3");
        flagMap.put("US", "\ud83c\uddfa\ud83c\uddf8");
        flagMap.put("UY", "\ud83c\uddfa\ud83c\uddfe");
        flagMap.put("UZ", "\ud83c\uddfa\ud83c\uddff");
        flagMap.put("VA", "\ud83c\uddfb\ud83c\udde6");
        flagMap.put("VC", "\ud83c\uddfb\ud83c\udde8");
        flagMap.put("VE", "\ud83c\uddfb\ud83c\uddea");
        flagMap.put("VG", "\ud83c\uddfb\ud83c\uddec");
        flagMap.put("VI", "\ud83c\uddfb\ud83c\uddee");
        flagMap.put("VN", "\ud83c\uddfb\ud83c\uddf3");
        flagMap.put("VU", "\ud83c\uddfb\ud83c\uddfa");
        flagMap.put("WF", "\ud83c\uddfc\ud83c\uddeb");
        flagMap.put("WS", "\ud83c\uddfc\ud83c\uddf8");
        flagMap.put("XK", "\ud83c\uddfd\ud83c\uddf0");
        flagMap.put("YE", "\ud83c\uddfe\ud83c\uddea");
        flagMap.put("YT", "\ud83c\uddfe\ud83c\uddf9");
        flagMap.put("ZA", "\ud83c\uddff\ud83c\udde6");
        flagMap.put("ZM", "\ud83c\uddff\ud83c\uddf2");
        flagMap.put("ZW", "\ud83c\uddff\ud83c\uddfc");
        flagByLanguage.put("aa", "\ud83c\uddea\ud83c\uddf7");
        flagByLanguage.put("af", "\ud83c\uddff\ud83c\udde6");
        flagByLanguage.put("ak", "\ud83c\uddec\ud83c\udded");
        flagByLanguage.put("am", "\ud83c\uddea\ud83c\uddf9");
        flagByLanguage.put("an", "\ud83c\uddea\ud83c\uddf8");
        flagByLanguage.put("ar", "\ud83c\uddea\ud83c\uddec");
        flagByLanguage.put("as", "\ud83c\uddee\ud83c\uddf3");
        flagByLanguage.put("av", "\ud83c\uddf7\ud83c\uddfa");
        flagByLanguage.put("ay", "\ud83c\udde7\ud83c\uddf4");
        flagByLanguage.put("az", "\ud83c\udde6\ud83c\uddff");
        flagByLanguage.put("ba", "\ud83c\uddf7\ud83c\uddfa");
        flagByLanguage.put("be", "\ud83c\udde7\ud83c\uddfe");
        flagByLanguage.put("bg", "\ud83c\udde7\ud83c\uddec");
        flagByLanguage.put("bh", "\ud83c\uddee\ud83c\uddf3");
        flagByLanguage.put("bi", "\ud83c\uddfb\ud83c\uddfa");
        flagByLanguage.put("bm", "\ud83c\uddf2\ud83c\uddf1");
        flagByLanguage.put("bn", "\ud83c\udde7\ud83c\udde9");
        flagByLanguage.put("bo", "\ud83c\udde8\ud83c\uddf3");
        flagByLanguage.put("br", "\ud83c\uddeb\ud83c\uddf7");
        flagByLanguage.put("bs", "\ud83c\udde7\ud83c\udde6");
        flagByLanguage.put("ca", "\ud83c\udde6\ud83c\udde9");
        flagByLanguage.put("ce", "\ud83c\uddf7\ud83c\uddfa");
        flagByLanguage.put("ch", "\ud83c\uddec\ud83c\uddfa");
        flagByLanguage.put("co", "\ud83c\uddeb\ud83c\uddf7");
        flagByLanguage.put("cr", "\ud83c\udde8\ud83c\udde6");
        flagByLanguage.put("cs", "\ud83c\udde8\ud83c\uddff");
        flagByLanguage.put("cv", "\ud83c\uddf7\ud83c\uddfa");
        flagByLanguage.put("cy", "\ud83c\uddec\ud83c\udde7");
        flagByLanguage.put("da", "\ud83c\udde9\ud83c\uddf0");
        flagByLanguage.put("de", "\ud83c\udde9\ud83c\uddea");
        flagByLanguage.put("dv", "\ud83c\uddf2\ud83c\uddfb");
        flagByLanguage.put("dz", "\ud83c\udde7\ud83c\uddf9");
        flagByLanguage.put("ee", "\ud83c\uddec\ud83c\udded");
        flagByLanguage.put("el", "\ud83c\uddec\ud83c\uddf7");
        flagByLanguage.put("en", "\ud83c\uddec\ud83c\udde7");
        flagByLanguage.put("eo", "\ud83c\uddea\ud83c\uddfa");
        flagByLanguage.put("es", "\ud83c\uddea\ud83c\uddf8");
        flagByLanguage.put("et", "\ud83c\uddea\ud83c\uddea");
        flagByLanguage.put("eu", "\ud83c\uddea\ud83c\uddf8");
        flagByLanguage.put("fa", "\ud83c\uddee\ud83c\uddf7");
        flagByLanguage.put("ff", "\ud83c\udde8\ud83c\uddf2");
        flagByLanguage.put("fi", "\ud83c\uddeb\ud83c\uddee");
        flagByLanguage.put("fj", "\ud83c\uddeb\ud83c\uddef");
        flagByLanguage.put("fo", "\ud83c\uddeb\ud83c\uddf4");
        flagByLanguage.put("fr", "\ud83c\uddeb\ud83c\uddf7");
        flagByLanguage.put("ga", "\ud83c\uddee\ud83c\uddea");
        flagByLanguage.put("gd", "\ud83c\uddee\ud83c\uddea");
        flagByLanguage.put("gn", "\ud83c\uddf5\ud83c\uddfe");
        flagByLanguage.put("gu", "\ud83c\uddee\ud83c\uddf3");
        flagByLanguage.put("ha", "\ud83c\uddf3\ud83c\uddea");
        flagByLanguage.put("he", "\ud83c\uddee\ud83c\uddf1");
        flagByLanguage.put("hi", "\ud83c\uddee\ud83c\uddf3");
        flagByLanguage.put("ho", "\ud83c\uddf5\ud83c\uddec");
        flagByLanguage.put("hr", "\ud83c\udded\ud83c\uddf7");
        flagByLanguage.put("ht", "\ud83c\udded\ud83c\uddf9");
        flagByLanguage.put("hu", "\ud83c\udded\ud83c\uddfa");
        flagByLanguage.put("hy", "\ud83c\udde6\ud83c\uddf2");
        flagByLanguage.put("hz", "\ud83c\uddf3\ud83c\udde6");
        flagByLanguage.put("id", "\ud83c\uddee\ud83c\udde9");
        flagByLanguage.put("ig", "\ud83c\uddf3\ud83c\uddec");
        flagByLanguage.put("ii", "\ud83c\udde8\ud83c\uddf3");
        flagByLanguage.put("ik", "\ud83c\uddfa\ud83c\uddf8");
        flagByLanguage.put("is", "\ud83c\uddee\ud83c\uddf8");
        flagByLanguage.put("it", "\ud83c\uddee\ud83c\uddf9");
        flagByLanguage.put("iu", "\ud83c\udde8\ud83c\udde6");
        flagByLanguage.put("ja", "\ud83c\uddef\ud83c\uddf5");
        flagByLanguage.put("jv", "\ud83c\uddee\ud83c\udde9");
        flagByLanguage.put("ka", "\ud83c\uddec\ud83c\uddea");
        flagByLanguage.put("kg", "\ud83c\udde8\ud83c\uddec");
        flagByLanguage.put("ki", "\ud83c\uddf0\ud83c\uddea");
        flagByLanguage.put("kj", "\ud83c\udde6\ud83c\uddf4");
        flagByLanguage.put("kk", "\ud83c\uddf0\ud83c\uddff");
        flagByLanguage.put("kl", "\ud83c\uddec\ud83c\uddf1");
        flagByLanguage.put("km", "\ud83c\uddf0\ud83c\udded");
        flagByLanguage.put("kn", "\ud83c\uddee\ud83c\uddf3");
        flagByLanguage.put("ko", "\ud83c\uddf0\ud83c\uddf7");
        flagByLanguage.put("kr", "\ud83c\uddf3\ud83c\uddec");
        flagByLanguage.put("ks", "\ud83c\uddee\ud83c\uddf3");
        flagByLanguage.put("ku", "\ud83c\uddf9\ud83c\uddf7");
        flagByLanguage.put("kv", "\ud83c\uddf7\ud83c\uddfa");
        flagByLanguage.put("kw", "\ud83c\uddec\ud83c\udde7");
        flagByLanguage.put("ky", "\ud83c\uddf0\ud83c\uddec");
        flagByLanguage.put("lg", "\ud83c\uddfa\ud83c\uddec");
        flagByLanguage.put("ln", "\ud83c\udde8\ud83c\uddec");
        flagByLanguage.put("lo", "\ud83c\uddf1\ud83c\udde6");
        flagByLanguage.put("lt", "\ud83c\uddf1\ud83c\uddf9");
        flagByLanguage.put("lu", "\ud83c\uddf1\ud83c\uddfa");
        flagByLanguage.put("lv", "\ud83c\uddf1\ud83c\uddfb");
        flagByLanguage.put("mg", "\ud83c\uddf2\ud83c\uddec");
        flagByLanguage.put("mh", "\ud83c\uddf2\ud83c\udded");
        flagByLanguage.put("mk", "\ud83c\uddf2\ud83c\uddf0");
        flagByLanguage.put("ml", "\ud83c\uddf2\ud83c\uddf1");
        flagByLanguage.put("mn", "\ud83c\uddf2\ud83c\uddf3");
        flagByLanguage.put("mr", "\ud83c\uddee\ud83c\uddf3");
        flagByLanguage.put("ms", "\ud83c\uddf2\ud83c\uddfe");
        flagByLanguage.put("mt", "\ud83c\uddf2\ud83c\uddf9");
        flagByLanguage.put("my", "\ud83c\uddf2\ud83c\uddf2");
        flagByLanguage.put("na", "\ud83c\uddf3\ud83c\uddf7");
        flagByLanguage.put("nd", "\ud83c\uddff\ud83c\uddfc");
        flagByLanguage.put("ne", "\ud83c\uddf3\ud83c\uddf5");
        flagByLanguage.put("ng", "\ud83c\uddf3\ud83c\udde6");
        flagByLanguage.put("nl", "\ud83c\uddf3\ud83c\uddf1");
        flagByLanguage.put("no", "\ud83c\uddf3\ud83c\uddf4");
        flagByLanguage.put("nr", "\ud83c\uddf3\ud83c\uddf7");
        flagByLanguage.put("nv", "\ud83c\uddfa\ud83c\uddf8");
        flagByLanguage.put("ny", "\ud83c\uddf2\ud83c\uddfc");
        flagByLanguage.put("oj", "\ud83c\udde8\ud83c\udde6");
        flagByLanguage.put("om", "\ud83c\uddea\ud83c\uddf9");
        flagByLanguage.put("or", "\ud83c\uddee\ud83c\uddf3");
        flagByLanguage.put("os", "\ud83c\uddec\ud83c\uddea");
        flagByLanguage.put("pa", "\ud83c\uddf5\ud83c\uddf0");
        flagByLanguage.put("pl", "\ud83c\uddf5\ud83c\uddf1");
        flagByLanguage.put("ps", "\ud83c\udde6\ud83c\uddeb");
        flagByLanguage.put("pt", "\ud83c\uddf5\ud83c\uddf9");
        flagByLanguage.put("qu", "\ud83c\uddf5\ud83c\uddea");
        flagByLanguage.put("rm", "\ud83c\udde8\ud83c\udded");
        flagByLanguage.put("rn", "\ud83c\udde7\ud83c\uddee");
        flagByLanguage.put("ro", "\ud83c\uddf7\ud83c\uddf4");
        flagByLanguage.put("ru", "\ud83c\uddf7\ud83c\uddfa");
        flagByLanguage.put("rw", "\ud83c\uddf7\ud83c\uddfc");
        flagByLanguage.put("sa", "\ud83c\uddee\ud83c\uddf3");
        flagByLanguage.put("sc", "\ud83c\uddee\ud83c\uddf9");
        flagByLanguage.put("sd", "\ud83c\uddf5\ud83c\uddf0");
        flagByLanguage.put("sg", "\ud83c\udde8\ud83c\uddeb");
        flagByLanguage.put("si", "\ud83c\uddf1\ud83c\uddf0");
        flagByLanguage.put("sk", "\ud83c\uddf8\ud83c\uddf0");
        flagByLanguage.put("sl", "\ud83c\uddf8\ud83c\uddee");
        flagByLanguage.put("sm", "\ud83c\udde6\ud83c\uddf8");
        flagByLanguage.put("sn", "\ud83c\uddff\ud83c\uddfc");
        flagByLanguage.put("so", "\ud83c\uddf8\ud83c\uddf4");
        flagByLanguage.put("sq", "\ud83c\udde6\ud83c\uddf1");
        flagByLanguage.put("sr", "\ud83c\uddf7\ud83c\uddf8");
        flagByLanguage.put("ss", "\ud83c\uddf8\ud83c\uddff");
        flagByLanguage.put("st", "\ud83c\udde6\ud83c\uddf1");
        flagByLanguage.put("su", "\ud83c\uddee\ud83c\udde9");
        flagByLanguage.put("sv", "\ud83c\uddf8\ud83c\uddea");
        flagByLanguage.put("sw", "\ud83c\uddf0\ud83c\uddea");
        flagByLanguage.put("ta", "\ud83c\uddee\ud83c\uddf3");
        flagByLanguage.put("te", "\ud83c\uddee\ud83c\uddf3");
        flagByLanguage.put("tg", "\ud83c\uddf9\ud83c\uddef");
        flagByLanguage.put("th", "\ud83c\uddf9\ud83c\udded");
        flagByLanguage.put("ti", "\ud83c\uddea\ud83c\uddf7");
        flagByLanguage.put("tk", "\ud83c\uddf9\ud83c\uddf2");
        flagByLanguage.put("tl", "\ud83c\uddf5\ud83c\udded");
        flagByLanguage.put("tn", "\ud83c\udde7\ud83c\uddfc");
        flagByLanguage.put("to", "\ud83c\uddf9\ud83c\uddf4");
        flagByLanguage.put("tr", "\ud83c\uddf9\ud83c\uddf7");
        flagByLanguage.put("ts", "\ud83c\uddff\ud83c\uddfc");
        flagByLanguage.put("tt", "\ud83c\uddf7\ud83c\uddfa");
        flagByLanguage.put("tw", "\ud83c\uddec\ud83c\udded");
        flagByLanguage.put("ty", "\ud83c\uddf5\ud83c\uddeb");
        flagByLanguage.put("ug", "\ud83c\udde8\ud83c\uddf3");
        flagByLanguage.put("uk", "\ud83c\uddfa\ud83c\udde6");
        flagByLanguage.put("ur", "\ud83c\uddf5\ud83c\uddf0");
        flagByLanguage.put("uz", "\ud83c\uddfa\ud83c\uddff");
        flagByLanguage.put("ve", "\ud83c\uddff\ud83c\udde6");
        flagByLanguage.put("vi", "\ud83c\uddfb\ud83c\uddf3");
        flagByLanguage.put("wa", "\ud83c\udde7\ud83c\uddea");
        flagByLanguage.put("wo", "\ud83c\uddf8\ud83c\uddf3");
        flagByLanguage.put("xh", "\ud83c\uddff\ud83c\udde6");
        flagByLanguage.put("yi", "\ud83c\uddee\ud83c\uddf1");
        flagByLanguage.put("yo", "\ud83c\uddf3\ud83c\uddec");
        flagByLanguage.put("za", "\ud83c\udde8\ud83c\uddf3");
        flagByLanguage.put("zh", "\ud83c\udde8\ud83c\uddf3");
        flagByLanguage.put("zu", "\ud83c\uddff\ud83c\udde6");
        flagByLanguage.put("pap", "\ud83c\udde8\ud83c\uddfc");
    }
}

