/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.application;

import java.io.File;
import java.util.List;
import org.teamapps.application.api.application.ApplicationGroup;
import org.teamapps.application.api.application.ApplicationInitializer;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.ApplicationRoleAssignmentPrivilegeObjectProvider;
import org.teamapps.application.api.application.theme.ApplicationTheme;
import org.teamapps.application.api.config.ApplicationConfig;
import org.teamapps.application.api.localization.LocalizationData;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.application.api.privilege.ApplicationRole;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.versioning.ApplicationVersion;
import org.teamapps.application.server.ApiHandler;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.universaldb.schema.ModelProvider;
import org.teamapps.ux.application.ResponsiveApplication;

public interface BaseApplicationBuilder {
    public ApplicationVersion getApplicationVersion();

    default public String getReleaseNotes() {
        return null;
    }

    public Icon getApplicationIcon();

    public String getApplicationName();

    public String getApplicationTitleKey();

    public String getApplicationDescriptionKey();

    default public ApplicationGroup getPreferredApplicationGroup() {
        return null;
    }

    default public ApplicationTheme getApplicationTheme() {
        return null;
    }

    public List<ApplicationRole> getApplicationRoles();

    public List<PrivilegeGroup> getPrivilegeGroups();

    public LocalizationData getLocalizationData();

    public ModelProvider getDatabaseModel();

    default public boolean useToolbarApplicationMenu() {
        return false;
    }

    public ApplicationConfig getApplicationConfig();

    default public String getApplicationConfigXml(ClassLoader classLoader) {
        return this.getApplicationConfig() != null ? this.getApplicationConfig().getConfigXml(classLoader) : null;
    }

    default public void updateConfig(String xml, ClassLoader classLoader) throws Exception {
        if (this.getApplicationConfig() != null) {
            this.getApplicationConfig().updateConfig(xml, classLoader);
        }
    }

    default public ApplicationRoleAssignmentPrivilegeObjectProvider getRoleAssignmentDelegatedPrivilegeObjectProvider() {
        return null;
    }

    public Event<Void> getOnApplicationInstalled();

    public Event<ApplicationInitializer> getOnApplicationLoaded();

    public Event<Void> getOnApplicationUnloaded();

    public Event<Void> getOnApplicationUninstalled();

    default public ApiHandler getApiHandler() {
        return null;
    }

    public boolean isApplicationAccessible(ApplicationPrivilegeProvider var1);

    public void build(ResponsiveApplication var1, ApplicationInstanceData var2);

    public void createTestData(File var1);

    public void importTestData(File var1);
}

