/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.versioning;

import java.util.Objects;

public class ApplicationVersion
implements Comparable<ApplicationVersion> {
    private final int major;
    private final int minor;
    private final int patch;
    private final String tag;

    public static ApplicationVersion create(int major, int minor) {
        return new ApplicationVersion(major, minor, 0, null);
    }

    public static ApplicationVersion create(int major, int minor, int patch, String tag) {
        return new ApplicationVersion(major, minor, patch, tag);
    }

    public static ApplicationVersion create(int major, int minor, String tag) {
        return new ApplicationVersion(major, minor, 0, tag);
    }

    public static ApplicationVersion create(int major, int minor, int patch) {
        return new ApplicationVersion(major, minor, patch, null);
    }

    public ApplicationVersion(int major, int minor, int patch, String tag) {
        this.tag = tag == null ? "V" : tag;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public String getTag() {
        return this.tag;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getVersion() {
        return this.major + "." + this.minor + "." + this.patch + "-" + this.tag;
    }

    @Override
    public int compareTo(ApplicationVersion version) {
        if (this.major != version.getMajor()) {
            return this.major < version.getMajor() ? -1 : 1;
        }
        if (this.minor != version.getMinor()) {
            return this.minor < version.getMinor() ? -1 : 1;
        }
        if (this.patch != version.getPatch()) {
            return this.patch < version.getPatch() ? -1 : 1;
        }
        if (!this.tag.equals(version.getTag())) {
            return this.tag.compareTo(version.getTag());
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationVersion that = (ApplicationVersion)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && this.tag.equals(that.tag);
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.major, this.minor, this.patch);
    }
}

