/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.localization;

import com.ibm.icu.text.Transliterator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.teamapps.application.api.localization.Country;
import org.teamapps.application.api.localization.Language;

public class DictionaryBuilder {
    private static final String DICTIONARY_PREFIX = "org.teamapps.dictionary.";
    private static Transliterator TRANSLITERATOR = Transliterator.getInstance((String)"Any-Latin; nfd; [:nonspacing mark:] remove; nfc");

    public static void main(String[] args) throws IOException {
        DictionaryBuilder.buildDictionaryData();
    }

    private static void buildDictionaryData() throws IOException {
        List values = DictionaryBuilder.readData().stream().filter(s -> s != null && !s.isBlank()).collect(Collectors.toList());
        ArrayList<CallSite> resourceLines = new ArrayList<CallSite>();
        ArrayList<CallSite> codeLines = new ArrayList<CallSite>();
        for (String value : values) {
            if (value.startsWith("::")) {
                codeLines.add((CallSite)((Object)("//" + value.substring(2))));
                resourceLines.add((CallSite)((Object)("# " + value.substring(2))));
                continue;
            }
            if (value.contains("=")) {
                int pos = value.indexOf(61);
                String k = value.substring(0, pos);
                String v = value.substring(pos + 1);
                String key = DICTIONARY_PREFIX + k;
                resourceLines.add((CallSite)((Object)(key + "=" + v)));
                codeLines.add((CallSite)((Object)("public static final String " + k.toUpperCase().replaceAll("\\.", "_") + " = \"" + key + "\";")));
                continue;
            }
            resourceLines.add((CallSite)((Object)(DictionaryBuilder.createKey(value) + "=" + value)));
            codeLines.add((CallSite)((Object)("public static final String " + DictionaryBuilder.createConstant(value) + " = \"" + DictionaryBuilder.createKey(value) + "\";")));
        }
        resourceLines.forEach(System.out::println);
        System.out.println("------");
        codeLines.forEach(System.out::println);
    }

    private static void createCountryAndLanguageLines() {
        for (Country country : Country.values()) {
            System.out.println("country." + country.name() + "=" + country.getValue());
        }
        for (Enum enum_ : Language.values()) {
            System.out.println("language." + enum_.name() + "=" + ((Language)enum_).getValue());
        }
    }

    private static String cleanValue(String value) {
        value = TRANSLITERATOR.transliterate((String)value);
        value = WordUtils.capitalize((String)value);
        value = ((String)value).replaceAll("\\.\\.\\.", "___");
        value = DictionaryBuilder.removeNonAnsi((String)value);
        value = ((String)value).replaceAll(" ", "");
        value = ((String)value).substring(0, 1).toLowerCase() + ((String)value).substring(1);
        return value;
    }

    private static String createKey(String value) {
        return DICTIONARY_PREFIX + DictionaryBuilder.cleanValue(value);
    }

    private static String createConstant(String value) {
        value = DictionaryBuilder.cleanValue((String)value);
        if (((String)(value = ((String)value).replaceAll("(.)(\\p{Upper})", "$1_$2").toUpperCase())).length() > 36) {
            value = "SENTENCE_" + ((String)value).substring(0, 35) + "__";
        }
        return value;
    }

    public static String removeNonAnsi(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c;
            char code = c = s.charAt(i);
            if (c == '_' || c == ' ') {
                sb.append(c);
                continue;
            }
            if (code > '@' && code < '[') {
                sb.append(c);
                continue;
            }
            if (code > '`' && code < '{') {
                sb.append(c);
                continue;
            }
            if (code <= '/' || code >= ':') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static List<String> readData() throws IOException {
        InputStream resource = DictionaryBuilder.class.getResourceAsStream("dictionary-data.txt");
        return IOUtils.readLines((InputStream)resource, (Charset)StandardCharsets.UTF_8);
    }
}

