/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.server;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.LinkOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.api.server.SessionHandler;
import org.teamapps.application.api.server.SessionManager;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.model.SchemaInfo;
import org.teamapps.model.system.SystemStarts;
import org.teamapps.model.system.Type;
import org.teamapps.server.ServletRegistration;
import org.teamapps.server.undertow.embedded.TeamAppsUndertowEmbeddedServer;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.schema.SchemaInfoProvider;
import org.teamapps.ux.resource.ClassPathResourceProvider;
import org.teamapps.ux.resource.FileResource;
import org.teamapps.ux.resource.ResourceProvider;
import org.teamapps.ux.resource.ResourceProviderServlet;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class ApplicationServer
implements WebController,
SessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final File basePath;
    private final File configPath;
    private TeamAppsConfiguration teamAppsConfiguration;
    private int port;
    private UniversalDB universalDb;
    private List<ServletRegistration> servletRegistrations = new ArrayList<ServletRegistration>();
    private SessionHandler sessionHandler;
    private WeakHashMap<SessionHandler, Long> weakStartDateBySessionHandler = new WeakHashMap();

    public ApplicationServer(File basePath) {
        this(basePath, new File(basePath, "config"), new TeamAppsConfiguration(), 8080);
    }

    public ApplicationServer(File basePath, File configPath, TeamAppsConfiguration teamAppsConfiguration, int port) {
        this.basePath = basePath;
        this.configPath = configPath;
        this.teamAppsConfiguration = teamAppsConfiguration;
        this.port = port;
        configPath.mkdir();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> SystemStarts.create().setTimestamp(Instant.now()).setType(Type.STOP).save()));
    }

    @Override
    public void updateSessionHandler(File jarFile) throws Exception {
        LOGGER.info("Loading new session handler:" + jarFile.getPath());
        URLClassLoader classLoader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()});
        SessionHandler newSessionHandler = this.loadSessionHandler(classLoader);
        newSessionHandler.init(this, this.universalDb, this.configPath);
        this.weakStartDateBySessionHandler.put(newSessionHandler, System.currentTimeMillis());
        this.sessionHandler = newSessionHandler;
        System.gc();
        LOGGER.info("Updated session handler:" + this.sessionHandler);
    }

    @Override
    public void updateSessionHandler(SessionHandler sessionHandler) {
        sessionHandler.init(this, this.universalDb, this.configPath);
        this.weakStartDateBySessionHandler.put(sessionHandler, System.currentTimeMillis());
        this.sessionHandler = sessionHandler;
        LOGGER.info("Updated fixed session handler:" + sessionHandler);
    }

    private SessionHandler loadSessionHandler(URLClassLoader classLoader) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ClassGraph classGraph = new ClassGraph();
        if (classLoader != null) {
            classGraph.overrideClassLoaders(new ClassLoader[]{classLoader});
        }
        ClassInfoList classInfos = classGraph.enableAllInfo().scan().getClassesImplementing(SessionHandler.class.getName()).getStandardClasses();
        Class builder = ((ClassInfo)classInfos.get(0)).loadClass();
        return (SessionHandler)builder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public void onSessionStart(SessionContext context) {
        this.sessionHandler.handleSessionStart(context);
    }

    @Override
    public Collection<Long> getBootstrappedSystems() {
        return this.weakStartDateBySessionHandler.values();
    }

    public void start() throws Exception {
        File dbPath = new File(this.basePath, "db");
        dbPath.mkdir();
        this.universalDb = UniversalDB.createStandalone((File)dbPath, (SchemaInfoProvider)new SchemaInfo());
        this.sessionHandler.init(this, this.universalDb, this.configPath);
        TeamAppsUndertowEmbeddedServer server = new TeamAppsUndertowEmbeddedServer((WebController)this, this.teamAppsConfiguration, this.port);
        File staticResourcesPath = new File(this.basePath, "static");
        staticResourcesPath.mkdir();
        this.addServletRegistration(new ServletRegistration((Servlet)new ResourceProviderServlet((servletPath, relativeResourcePath, httpSessionId) -> {
            try {
                File file = new File(staticResourcesPath, relativeResourcePath);
                if (file.exists() && !file.isDirectory() && file.toPath().toRealPath(new LinkOption[0]).startsWith(staticResourcesPath.getPath())) {
                    return new FileResource(file);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }), "/static/*"));
        for (final ServletRegistration servletRegistration : this.servletRegistrations) {
            for (final String mapping : servletRegistration.getMappings()) {
                LOGGER.info("Registering servlet on url path: " + mapping);
                server.addServletContextListener(new ServletContextListener(){

                    public void contextInitialized(ServletContextEvent sce) {
                        ServletRegistration.Dynamic dynamic = sce.getServletContext().addServlet("teamapps-registered-" + servletRegistration.getServlet().getClass().getSimpleName() + UUID.randomUUID().toString(), servletRegistration.getServlet());
                        dynamic.setAsyncSupported(servletRegistration.isAsyncSupported());
                        dynamic.addMapping(new String[]{mapping});
                    }
                });
            }
        }
        server.start();
        SystemStarts.create().setTimestamp(Instant.now()).setType(Type.START).save();
    }

    public void addClassPathResourceProvider(String basePackage, String prefix) {
        if (!((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        this.addServletRegistration(new ServletRegistration((Servlet)new ResourceProviderServlet((ResourceProvider)new ClassPathResourceProvider(basePackage)), (String)prefix + "*"));
    }

    public void addServletRegistration(ServletRegistration servletRegistration) {
        this.servletRegistrations.add(servletRegistration);
    }
}

