/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.extended.FileConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class ApplicationConfigXml<CONFIG> {
    public CONFIG readConfigFile(String xml) {
        XStream xstream = ApplicationConfigXml.createXStream();
        return (CONFIG)xstream.fromXML(xml);
    }

    public CONFIG readConfigFile(File xml) {
        XStream xstream = ApplicationConfigXml.createXStream();
        return (CONFIG)xstream.fromXML(xml);
    }

    public String getConfigXml(CONFIG config) {
        XStream xStream = ApplicationConfigXml.createXStream();
        return xStream.toXML(config);
    }

    public void writeConfig(CONFIG config, File file) throws IOException {
        String xml = this.getConfigXml(config);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        bos.write(xml.getBytes(StandardCharsets.UTF_8));
        bos.close();
    }

    private static XStream createXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver()){

            protected void setupConverters() {
            }
        };
        xstream.registerConverter((Converter)new ReflectionConverter(xstream.getMapper(), xstream.getReflectionProvider()), -20);
        xstream.registerConverter((SingleValueConverter)new BooleanConverter(), 0);
        xstream.registerConverter((SingleValueConverter)new IntConverter(), 0);
        xstream.registerConverter((SingleValueConverter)new StringConverter(), 0);
        xstream.registerConverter((Converter)new CollectionConverter(xstream.getMapper()), 0);
        xstream.registerConverter((SingleValueConverter)new FileConverter());
        xstream.addPermission(NullPermission.NULL);
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.ignoreUnknownElements();
        return xstream;
    }
}

