/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.privilege;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.icons.Icon;

public class AbstractApplicationPrivileges {
    private static List<PrivilegeGroup> privilegeGroups = new ArrayList<PrivilegeGroup>();
    public static SimplePrivilege LAUNCH_APPLICATION = AbstractApplicationPrivileges.addSimplePrivilege("org.teamapps.privilege.launchApplication", ApplicationIcons.WINDOW, "org.teamapps.dictionary.launchApplication", "org.teamapps.dictionary.allowsAUserToLaunchTheApplication");

    protected static SimplePrivilege addSimplePrivilege(String name, Icon icon, String titleKey, String descriptionKey) {
        SimplePrivilege privilegeGroup = PrivilegeGroup.createSimplePrivilege(name, icon, titleKey, descriptionKey);
        AbstractApplicationPrivileges.addPrivilege(privilegeGroup);
        return privilegeGroup;
    }

    protected static SimpleOrganizationalPrivilege addSimpleOrganizationalPrivilege(String name, Icon icon, String titleKey, String descriptionKey) {
        SimpleOrganizationalPrivilege privilegeGroup = PrivilegeGroup.createSimpleOrganizationalPrivilege(name, icon, titleKey, descriptionKey);
        AbstractApplicationPrivileges.addPrivilege(privilegeGroup);
        return privilegeGroup;
    }

    protected static SimpleCustomObjectPrivilege addSimpleCustomObjectPrivilege(String name, Icon icon, String titleKey, String descriptionKey, Supplier<List<PrivilegeObject>> privilegeObjectsSupplier) {
        SimpleCustomObjectPrivilege privilegeGroup = PrivilegeGroup.createSimpleCustomObjectPrivilege(name, icon, titleKey, descriptionKey, privilegeObjectsSupplier);
        AbstractApplicationPrivileges.addPrivilege(privilegeGroup);
        return privilegeGroup;
    }

    protected static StandardPrivilegeGroup addStandardPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, Privilege ... privileges) {
        StandardPrivilegeGroup privilegeGroup = PrivilegeGroup.createStandardPrivilegeGroup(name, icon, titleKey, descriptionKey, privileges);
        AbstractApplicationPrivileges.addPrivilege(privilegeGroup);
        return privilegeGroup;
    }

    protected static OrganizationalPrivilegeGroup addOrganizationalPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, Privilege ... privileges) {
        OrganizationalPrivilegeGroup privilegeGroup = PrivilegeGroup.createOrganizationalPrivilegeGroup(name, icon, titleKey, descriptionKey, privileges);
        AbstractApplicationPrivileges.addPrivilege(privilegeGroup);
        return privilegeGroup;
    }

    protected static CustomObjectPrivilegeGroup addCustomObjectPrivilegeGroup(String name, Icon icon, String titleKey, String descriptionKey, List<Privilege> privileges, Supplier<List<PrivilegeObject>> privilegeObjectsSupplier) {
        CustomObjectPrivilegeGroup privilegeGroup = PrivilegeGroup.createCustomObjectPrivilegeGroup(name, icon, titleKey, descriptionKey, privileges, privilegeObjectsSupplier);
        AbstractApplicationPrivileges.addPrivilege(privilegeGroup);
        return privilegeGroup;
    }

    protected static PrivilegeGroup addPrivilege(PrivilegeGroup privilegeGroup) {
        privilegeGroups.add(privilegeGroup);
        return privilegeGroup;
    }

    public static List<PrivilegeGroup> getPrivileges() {
        return privilegeGroups;
    }
}

