/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.tools;

import java.time.ZoneId;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.data.value.SortDirection;
import org.teamapps.data.value.Sorting;
import org.teamapps.event.Event;
import org.teamapps.udb.filter.TimeIntervalFilter;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.infiniteitemview.AbstractInfiniteItemViewModel;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemView2;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemViewModel;
import org.teamapps.ux.component.table.AbstractTableModel;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableModel;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.timegraph.LineChartCurveType;
import org.teamapps.ux.component.timegraph.LineChartLine;
import org.teamapps.ux.component.timegraph.LineChartYScaleZoomMode;
import org.teamapps.ux.component.timegraph.ScaleType;
import org.teamapps.ux.component.timegraph.TimeGraph;
import org.teamapps.ux.component.timegraph.TimeGraphModel;
import org.teamapps.ux.component.timegraph.partitioning.StaticPartitioningTimeGraphModel;
import org.teamapps.ux.session.SessionContext;

public abstract class RecordModelBuilder<RECORD> {
    public Event<Void> onDataChanged = new Event();
    public Event<RECORD> onSelectedRecordChanged = new Event();
    private final ApplicationInstanceData applicationInstanceData;
    private TimeIntervalFilter timeIntervalFilter;
    private String fullTextQuery;
    private String sortField;
    private boolean sortAscending;
    private Predicate<RECORD> customFilter;
    private int countRecords;
    private List<RECORD> records;

    public RecordModelBuilder(ApplicationInstanceData applicationInstanceData) {
        this.applicationInstanceData = applicationInstanceData;
        this.onDataChanged.addListener(this::queryRecords);
    }

    public void updateModels() {
        this.onDataChanged.fire();
    }

    public void attachViewCountHandler(View view, Supplier<String> titleSupplier) {
        this.onDataChanged.addListener(() -> view.getPanel().setTitle((String)titleSupplier.get() + " (" + this.countRecords + ")"));
    }

    public void attachSearchField(View view) {
        TextField searchField = this.createSearchField();
        view.getPanel().setRightHeaderField((AbstractField)searchField);
        view.getPanel().setRightHeaderFieldIcon(ApplicationIcons.FUNNEL);
    }

    public TextField createSearchField() {
        TextField searchField = new TextField();
        searchField.setEmptyText(this.applicationInstanceData.getLocalized("org.teamapps.dictionary.search___", new Object[0]));
        searchField.setShowClearButton(true);
        searchField.onTextInput.addListener(this::setFullTextQuery);
        return searchField;
    }

    public TableModel<RECORD> createTableModel() {
        AbstractTableModel model = new AbstractTableModel<RECORD>(){

            public int getCount() {
                return RecordModelBuilder.this.countRecords;
            }

            public List<RECORD> getRecords(int startIndex, int length, Sorting sorting) {
                return RecordModelBuilder.this.records.stream().skip(startIndex).limit(length).collect(Collectors.toList());
            }
        };
        this.onDataChanged.addListener(() -> ((Event)model.onAllDataChanged).fire());
        return model;
    }

    public Table<RECORD> createTable() {
        Table table = new Table();
        table.setModel(this.createTableModel());
        table.onSortingChanged.addListener(event -> this.setSorting(event.getSortField(), event.getSortDirection() == SortDirection.ASC));
        table.onRowSelected.addListener(record -> this.onSelectedRecordChanged.fire(record));
        return table;
    }

    public InfiniteItemViewModel<RECORD> createInfiniteItemViewModel() {
        AbstractInfiniteItemViewModel model = new AbstractInfiniteItemViewModel<RECORD>(){

            public int getCount() {
                return RecordModelBuilder.this.countRecords;
            }

            public List<RECORD> getRecords(int startIndex, int length) {
                return RecordModelBuilder.this.records.stream().skip(startIndex).limit(length).collect(Collectors.toList());
            }
        };
        this.onDataChanged.addListener(() -> RecordModelBuilder.lambda$createInfiniteItemViewModel$3((InfiniteItemViewModel)model));
        return model;
    }

    public InfiniteItemView2<RECORD> createItemView2(Template template, float itemWidth, int itemHeight) {
        InfiniteItemView2 itemView = new InfiniteItemView2(template, itemWidth, itemHeight);
        itemView.setModel(this.createInfiniteItemViewModel());
        itemView.onItemClicked.addListener(record -> this.onSelectedRecordChanged.fire(record.getRecord()));
        return itemView;
    }

    public TimeGraphModel createTimeGraphModel(Function<RECORD, Long> recordTimeFunction, String seriesId) {
        StaticPartitioningTimeGraphModel timeGraphModel = StaticPartitioningTimeGraphModel.create((ZoneId)SessionContext.current().getTimeZone());
        this.onDataChanged.addListener(() -> {
            long[] data = new long[this.records.size()];
            for (int i = 0; i < this.records.size(); ++i) {
                data[i] = (Long)recordTimeFunction.apply(this.records.get(i));
            }
            timeGraphModel.setEventTimestampsForDataSeriesId(seriesId, data);
        });
        return timeGraphModel;
    }

    public TimeGraph createTimeGraph(Function<RECORD, Long> recordTimeFunction, String fieldName) {
        RgbaColor color = Color.MATERIAL_BLUE_700;
        return this.createTimeGraph(recordTimeFunction, fieldName, color);
    }

    public TimeGraph createTimeGraph(Function<RECORD, Long> recordTimeFunction, String fieldName, RgbaColor color) {
        LineChartLine line = new LineChartLine(fieldName, LineChartCurveType.MONOTONE, 0.5f, (Color)color, (Color)color.withAlpha(0.05f));
        line.setAreaColorScaleMin((Color)color.withAlpha(0.05f));
        line.setAreaColorScaleMax((Color)color.withAlpha(0.5f));
        line.setYScaleType(ScaleType.LINEAR);
        line.setYScaleZoomMode(LineChartYScaleZoomMode.DYNAMIC_INCLUDING_ZERO);
        TimeGraphModel timeGraphModel = this.createTimeGraphModel(recordTimeFunction, fieldName);
        TimeGraph timeGraph = new TimeGraph(timeGraphModel);
        timeGraph.onIntervalSelected.addListener(interval -> this.setTimeIntervalFilter(interval != null ? new TimeIntervalFilter(fieldName, interval.getMin(), interval.getMax()) : null));
        return timeGraph;
    }

    public void setFullTextQuery(String query) {
        this.fullTextQuery = query;
        this.onDataChanged.fire();
    }

    public void removeFullTextQuery() {
        if (this.fullTextQuery != null) {
            this.fullTextQuery = null;
            this.onDataChanged.fire();
        }
    }

    public void setSorting(String sortField, boolean sortAscending) {
        this.sortField = sortField;
        this.sortAscending = sortAscending;
        this.onDataChanged.fire();
    }

    public void removeSorting() {
        if (this.sortField != null) {
            this.sortField = null;
            this.onDataChanged.fire();
        }
    }

    public void setTimeIntervalFilter(String fieldName, long start, long end) {
        TimeIntervalFilter timeIntervalFilter = fieldName != null ? new TimeIntervalFilter(fieldName, start, end) : null;
        this.setTimeIntervalFilter(timeIntervalFilter);
    }

    public void setTimeIntervalFilter(TimeIntervalFilter timeIntervalFilter) {
        this.timeIntervalFilter = timeIntervalFilter;
        this.onDataChanged.fire();
    }

    public void removeTimeIntervalFilter() {
        if (this.timeIntervalFilter != null) {
            this.timeIntervalFilter = null;
            this.onDataChanged.fire();
        }
    }

    public void setCustomFilter(Predicate<RECORD> customFilter) {
        this.customFilter = customFilter;
        this.onDataChanged.fire();
    }

    public void removeCustomFilter() {
        this.customFilter = null;
        this.onDataChanged.fire();
    }

    private void queryRecords() {
        List<RECORD> queryResult = this.queryRecords(this.fullTextQuery, this.timeIntervalFilter, this.sortField, this.sortAscending);
        this.records = this.customFilter != null ? queryResult.stream().filter(record -> this.customFilter.test(record)).collect(Collectors.toList()) : queryResult;
        this.countRecords = this.records.size();
    }

    public abstract List<RECORD> queryRecords(String var1, TimeIntervalFilter var2, String var3, boolean var4);

    private static /* synthetic */ void lambda$createInfiniteItemViewModel$3(InfiniteItemViewModel model) {
        model.onAllDataChanged().fire();
    }
}

