/*-
 * ========================LICENSE_START=================================
 * TeamApps Application API
 * ---
 * Copyright (C) 2020 - 2021 TeamApps.org
 * ---
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.teamapps.application.api.theme;

import org.teamapps.application.api.localization.Country;
import org.teamapps.icon.flags.FlagIcon;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

import java.lang.reflect.Method;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ApplicationIcons {

	private static Method iconLoaderMethod;
	private static Map<String, Icon> iconMap = new HashMap<>();

	static {
		try {
			Class<?> aClass = Class.forName("org.teamapps.icon.standard.StandardIcon");
			iconLoaderMethod = aClass.getMethod("valueOf", String.class);
		} catch(Exception e) {
		}
	}

	private static Icon createIcon(String name) {
		if (iconLoaderMethod != null) {
			try {
				Icon icon =  (Icon) iconLoaderMethod.invoke(null, name);
				iconMap.put(name, icon);
				return icon;
			} catch (Exception ignore) { }
		}
		return MaterialIcon.QUESTION_ANSWER;
	}

	public static Map<String, Icon> getIconMap() {
		return iconMap;
	}

	public static ComboBox<Icon> createIconComboBox() {
		return createIconComboBox(BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, true);
	}

	public static ComboBox<Icon> createIconComboBox(Template template, boolean withFlagIcons) {
		ComboBox<Icon> comboBox = new ComboBox<>(template);
		if (template == BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE) {
			comboBox.setDropDownTemplate(BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
		}
		Map<Icon, String> iconNameByIcon = new HashMap<>();
		getIconMap().forEach((key, value) -> iconNameByIcon.put(value, key.replace("_", " ")));
		if (withFlagIcons) {
			FlagIcon.getIcons().forEach(flagIcon -> iconNameByIcon.put(flagIcon, flagIcon.getConstantName().replace("_", " ")));
		}
		comboBox.setRecordToStringFunction(iconNameByIcon::get);
		comboBox.setPropertyExtractor((icon, propertyName) -> switch(propertyName) {
			case BaseTemplate.PROPERTY_ICON -> icon;
			case BaseTemplate.PROPERTY_CAPTION -> iconNameByIcon.get(icon);
			default -> null;
		});
		List<Icon> icons = iconNameByIcon.keySet().stream()
				.sorted(Comparator.comparing(iconNameByIcon::get))
				.collect(Collectors.toList());
		comboBox.setModel(query -> icons.stream()
				.filter(icon -> (query == null || query.isEmpty()) || iconNameByIcon.get(icon).toLowerCase().contains(query.toLowerCase()))
				.limit(150)
				.collect(Collectors.toList()));
		return comboBox;
	}

	public static final Icon _3D_GLASSES = createIcon("_3D_GLASSES");
	public static final Icon ADD = createIcon("ADD");
	public static final Icon ADDRESS_BOOK = createIcon("ADDRESS_BOOK");
	public static final Icon ADHESIVE_TAPE = createIcon("ADHESIVE_TAPE");
	public static final Icon AIR_TUBE_CARRIER = createIcon("AIR_TUBE_CARRIER");
	public static final Icon AIRBRUSH = createIcon("AIRBRUSH");
	public static final Icon AIRPLANE = createIcon("AIRPLANE");
	public static final Icon AIRPLANE_LANDING = createIcon("AIRPLANE_LANDING");
	public static final Icon AIRPLANE_STARTING = createIcon("AIRPLANE_STARTING");
	public static final Icon AIRPLANE_TOP = createIcon("AIRPLANE_TOP");
	public static final Icon AIRSHIP = createIcon("AIRSHIP");
	public static final Icon ALARM = createIcon("ALARM");
	public static final Icon ALARMCLOCK = createIcon("ALARMCLOCK");
	public static final Icon AMBULANCE = createIcon("AMBULANCE");
	public static final Icon AMMUNITION_BOX_CLOSED = createIcon("AMMUNITION_BOX_CLOSED");
	public static final Icon AMMUNITION_BOX_OPEN = createIcon("AMMUNITION_BOX_OPEN");
	public static final Icon ANCHOR = createIcon("ANCHOR");
	public static final Icon ANGEL = createIcon("ANGEL");
	public static final Icon ANTENNA = createIcon("ANTENNA");
	public static final Icon APPLE = createIcon("APPLE");
	public static final Icon APPLE_BITE = createIcon("APPLE_BITE");
	public static final Icon ARMOUR = createIcon("ARMOUR");
	public static final Icon ARMY_KNIFE = createIcon("ARMY_KNIFE");
	public static final Icon ARROW_AROUND = createIcon("ARROW_AROUND");
	public static final Icon ARROW_BARRIER = createIcon("ARROW_BARRIER");
	public static final Icon ARROW_CIRCLE = createIcon("ARROW_CIRCLE");
	public static final Icon ARROW_CURVE_LEFT = createIcon("ARROW_CURVE_LEFT");
	public static final Icon ARROW_DOWN = createIcon("ARROW_DOWN");
	public static final Icon ARROW_DOWN_LEFT = createIcon("ARROW_DOWN_LEFT");
	public static final Icon ARROW_DOWN_RIGHT = createIcon("ARROW_DOWN_RIGHT");
	public static final Icon ARROW_FROM = createIcon("ARROW_FROM");
	public static final Icon ARROW_INTO = createIcon("ARROW_INTO");
	public static final Icon ARROW_LEFT = createIcon("ARROW_LEFT");
	public static final Icon ARROW_LOOP = createIcon("ARROW_LOOP");
	public static final Icon ARROW_OUT = createIcon("ARROW_OUT");
	public static final Icon ARROW_OVAL_CIRCLE = createIcon("ARROW_OVAL_CIRCLE");
	public static final Icon ARROW_OVER = createIcon("ARROW_OVER");
	public static final Icon ARROW_RIGHT = createIcon("ARROW_RIGHT");
	public static final Icon ARROW_SQUIGGLY = createIcon("ARROW_SQUIGGLY");
	public static final Icon ARROW_THROUGH = createIcon("ARROW_THROUGH");
	public static final Icon ARROW_TO = createIcon("ARROW_TO");
	public static final Icon ARROW_TURN_LEFT = createIcon("ARROW_TURN_LEFT");
	public static final Icon ARROW_U_TURN = createIcon("ARROW_U_TURN");
	public static final Icon ARROW_UP = createIcon("ARROW_UP");
	public static final Icon ARROW_UP_LEFT = createIcon("ARROW_UP_LEFT");
	public static final Icon ARROW_UP_RIGHT = createIcon("ARROW_UP_RIGHT");
	public static final Icon ARROWS_CIRCLE = createIcon("ARROWS_CIRCLE");
	public static final Icon ARROWS_CROSS = createIcon("ARROWS_CROSS");
	public static final Icon ARROWS_FORK_THREE = createIcon("ARROWS_FORK_THREE");
	public static final Icon ARROWS_FORK_TWO = createIcon("ARROWS_FORK_TWO");
	public static final Icon ARROWS_JOIN = createIcon("ARROWS_JOIN");
	public static final Icon ARROWS_JOIN_DIAGONAL = createIcon("ARROWS_JOIN_DIAGONAL");
	public static final Icon ARROWS_JUNCTION = createIcon("ARROWS_JUNCTION");
	public static final Icon ARROWS_MERGE = createIcon("ARROWS_MERGE");
	public static final Icon ARROWS_MERGE_INTO = createIcon("ARROWS_MERGE_INTO");
	public static final Icon ARROWS_MIX = createIcon("ARROWS_MIX");
	public static final Icon ARROWS_OVAL_CIRCLE = createIcon("ARROWS_OVAL_CIRCLE");
	public static final Icon ARROWS_SHUFFLE = createIcon("ARROWS_SHUFFLE");
	public static final Icon ARROWS_SPREAD = createIcon("ARROWS_SPREAD");
	public static final Icon ARROWS_SPREAD_DIAGONAL = createIcon("ARROWS_SPREAD_DIAGONAL");
	public static final Icon ASHTRAY_CIGARETTE = createIcon("ASHTRAY_CIGARETTE");
	public static final Icon ASTROLOGER = createIcon("ASTROLOGER");
	public static final Icon ASTRONAUT = createIcon("ASTRONAUT");
	public static final Icon ATHLETE = createIcon("ATHLETE");
	public static final Icon ATM = createIcon("ATM");
	public static final Icon ATOM = createIcon("ATOM");
	public static final Icon ATOM_ALT = createIcon("ATOM_ALT");
	public static final Icon AUCTION_HAMMER = createIcon("AUCTION_HAMMER");
	public static final Icon AUDIO_CASSETTE = createIcon("AUDIO_CASSETTE");
	public static final Icon AXE = createIcon("AXE");
	public static final Icon BABY = createIcon("BABY");
	public static final Icon BACK = createIcon("BACK");
	public static final Icon BACKPACK = createIcon("BACKPACK");
	public static final Icon BACON = createIcon("BACON");
	public static final Icon BACTERIA = createIcon("BACTERIA");
	public static final Icon BADMINTON_RACKET = createIcon("BADMINTON_RACKET");
	public static final Icon BAG = createIcon("BAG");
	public static final Icon BAGS = createIcon("BAGS");
	public static final Icon BALLOON = createIcon("BALLOON");
	public static final Icon BALLOONS = createIcon("BALLOONS");
	public static final Icon BALLPEN = createIcon("BALLPEN");
	public static final Icon BANANA = createIcon("BANANA");
	public static final Icon BAND_AID = createIcon("BAND_AID");
	public static final Icon BANK_BUILDING = createIcon("BANK_BUILDING");
	public static final Icon BARCODE = createIcon("BARCODE");
	public static final Icon BARCODE_SCANNER = createIcon("BARCODE_SCANNER");
	public static final Icon BARREL = createIcon("BARREL");
	public static final Icon BARRELS = createIcon("BARRELS");
	public static final Icon BARRIER_CLOSED = createIcon("BARRIER_CLOSED");
	public static final Icon BARRIER_OPEN = createIcon("BARRIER_OPEN");
	public static final Icon BASEBALL = createIcon("BASEBALL");
	public static final Icon BASEBALL_BAT = createIcon("BASEBALL_BAT");
	public static final Icon BASKETBALL = createIcon("BASKETBALL");
	public static final Icon BASKETBALL_HOOP = createIcon("BASKETBALL_HOOP");
	public static final Icon BATTERY_0_5 = createIcon("BATTERY_0_5");
	public static final Icon BATTERY_1_5 = createIcon("BATTERY_1_5");
	public static final Icon BATTERY_2_5 = createIcon("BATTERY_2_5");
	public static final Icon BATTERY_3_5 = createIcon("BATTERY_3_5");
	public static final Icon BATTERY_4_5 = createIcon("BATTERY_4_5");
	public static final Icon BATTERY_5_5 = createIcon("BATTERY_5_5");
	public static final Icon BATTERY_CHARGE = createIcon("BATTERY_CHARGE");
	public static final Icon BATTERY_PLUS_MINUS = createIcon("BATTERY_PLUS_MINUS");
	public static final Icon BEAR = createIcon("BEAR");
	public static final Icon BED = createIcon("BED");
	public static final Icon BED_PERSON = createIcon("BED_PERSON");
	public static final Icon BEER_BOTTLE = createIcon("BEER_BOTTLE");
	public static final Icon BEER_GARDEN_TABLE = createIcon("BEER_GARDEN_TABLE");
	public static final Icon BEER_GLASS = createIcon("BEER_GLASS");
	public static final Icon BEER_MUG = createIcon("BEER_MUG");
	public static final Icon BELL = createIcon("BELL");
	public static final Icon BELL_CROTAL = createIcon("BELL_CROTAL");
	public static final Icon BEVERAGE_CAN = createIcon("BEVERAGE_CAN");
	public static final Icon BEVERAGE_CAN_EMPTY = createIcon("BEVERAGE_CAN_EMPTY");
	public static final Icon BIBLE = createIcon("BIBLE");
	public static final Icon BICYCLE = createIcon("BICYCLE");
	public static final Icon BICYCLIST = createIcon("BICYCLIST");
	public static final Icon BILLBOARD_EMPTY = createIcon("BILLBOARD_EMPTY");
	public static final Icon BINOCULAR = createIcon("BINOCULAR");
	public static final Icon BIRD = createIcon("BIRD");
	public static final Icon BLACKBOARD = createIcon("BLACKBOARD");
	public static final Icon BLENDER = createIcon("BLENDER");
	public static final Icon BLOOD_BAG = createIcon("BLOOD_BAG");
	public static final Icon BLOT = createIcon("BLOT");
	public static final Icon BODY_SCALE = createIcon("BODY_SCALE");
	public static final Icon BOLT = createIcon("BOLT");
	public static final Icon BOMB = createIcon("BOMB");
	public static final Icon BOMB_FUSE = createIcon("BOMB_FUSE");
	public static final Icon BONE = createIcon("BONE");
	public static final Icon BOOK = createIcon("BOOK");
	public static final Icon BOOK_BOOKMARK = createIcon("BOOK_BOOKMARK");
	public static final Icon BOOK_HEADPHONES = createIcon("BOOK_HEADPHONES");
	public static final Icon BOOK_OPEN = createIcon("BOOK_OPEN");
	public static final Icon BOOK_TELEPHONE = createIcon("BOOK_TELEPHONE");
	public static final Icon BOOKKEEPER = createIcon("BOOKKEEPER");
	public static final Icon BOOKMARK = createIcon("BOOKMARK");
	public static final Icon BOOKMARKS = createIcon("BOOKMARKS");
	public static final Icon BOOKS = createIcon("BOOKS");
	public static final Icon BOOMBOX = createIcon("BOOMBOX");
	public static final Icon BOTTLE = createIcon("BOTTLE");
	public static final Icon BOTTLE_BUBBLES = createIcon("BOTTLE_BUBBLES");
	public static final Icon BOTTLE_CRATE = createIcon("BOTTLE_CRATE");
	public static final Icon BOTTLE_OF_PILLS = createIcon("BOTTLE_OF_PILLS");
	public static final Icon BOW_TIE = createIcon("BOW_TIE");
	public static final Icon BOWL = createIcon("BOWL");
	public static final Icon BOWLING_BALL = createIcon("BOWLING_BALL");
	public static final Icon BOWLING_PIN = createIcon("BOWLING_PIN");
	public static final Icon BOWLING_PINS = createIcon("BOWLING_PINS");
	public static final Icon BOX_CLOSED = createIcon("BOX_CLOSED");
	public static final Icon BOX_INTO = createIcon("BOX_INTO");
	public static final Icon BOX_OPEN = createIcon("BOX_OPEN");
	public static final Icon BOX_OUT = createIcon("BOX_OUT");
	public static final Icon BOX_SOFTWARE = createIcon("BOX_SOFTWARE");
	public static final Icon BOX_SURPRISE = createIcon("BOX_SURPRISE");
	public static final Icon BOX_TALL = createIcon("BOX_TALL");
	public static final Icon BOXING_GLOVE = createIcon("BOXING_GLOVE");
	public static final Icon BOY = createIcon("BOY");
	public static final Icon BRAIN = createIcon("BRAIN");
	public static final Icon BREAKFAST_EGG = createIcon("BREAKFAST_EGG");
	public static final Icon BREAKPOINT = createIcon("BREAKPOINT");
	public static final Icon BREAKPOINT_SELECTION = createIcon("BREAKPOINT_SELECTION");
	public static final Icon BREAKPOINTS = createIcon("BREAKPOINTS");
	public static final Icon BREAKPOINTS_SELECTION = createIcon("BREAKPOINTS_SELECTION");
	public static final Icon BRICK_TROWEL = createIcon("BRICK_TROWEL");
	public static final Icon BRICKWALL = createIcon("BRICKWALL");
	public static final Icon BRIDGE = createIcon("BRIDGE");
	public static final Icon BRIEFCASE = createIcon("BRIEFCASE");
	public static final Icon BRIEFCASE_ALT = createIcon("BRIEFCASE_ALT");
	public static final Icon BRIEFCASE_DOCUMENT = createIcon("BRIEFCASE_DOCUMENT");
	public static final Icon BRIEFCASE_DOCUMENT_ALT = createIcon("BRIEFCASE_DOCUMENT_ALT");
	public static final Icon BRUSH = createIcon("BRUSH");
	public static final Icon BUCKET = createIcon("BUCKET");
	public static final Icon BUG = createIcon("BUG");
	public static final Icon BUG_ROUND = createIcon("BUG_ROUND");
	public static final Icon BUILDING_BLOCK = createIcon("BUILDING_BLOCK");
	public static final Icon BULL = createIcon("BULL");
	public static final Icon BULLDOZER = createIcon("BULLDOZER");
	public static final Icon BULLET_TRAIN = createIcon("BULLET_TRAIN");
	public static final Icon BULLETS = createIcon("BULLETS");
	public static final Icon BUOY = createIcon("BUOY");
	public static final Icon BUS = createIcon("BUS");
	public static final Icon BUS_FRONT = createIcon("BUS_FRONT");
	public static final Icon BUSINESSMEN = createIcon("BUSINESSMEN");
	public static final Icon BUSINESSPEOPLE = createIcon("BUSINESSPEOPLE");
	public static final Icon BUSINESSPEOPLE_ALT = createIcon("BUSINESSPEOPLE_ALT");
	public static final Icon BUSINESSPERSON = createIcon("BUSINESSPERSON");
	public static final Icon BUSINESSPERSON_ALT = createIcon("BUSINESSPERSON_ALT");
	public static final Icon BUSINESSWOMAN = createIcon("BUSINESSWOMAN");
	public static final Icon BUSINESSWOMEN = createIcon("BUSINESSWOMEN");
	public static final Icon BUTTON_OK = createIcon("BUTTON_OK");
	public static final Icon C_CLAMP = createIcon("C_CLAMP");
	public static final Icon CABINET = createIcon("CABINET");
	public static final Icon CABINET_CLOTHES = createIcon("CABINET_CLOTHES");
	public static final Icon CABINET_FLASH = createIcon("CABINET_FLASH");
	public static final Icon CABINET_OPEN = createIcon("CABINET_OPEN");
	public static final Icon CABINET_WARNING = createIcon("CABINET_WARNING");
	public static final Icon CACTUS = createIcon("CACTUS");
	public static final Icon CAESAR = createIcon("CAESAR");
	public static final Icon CAKE = createIcon("CAKE");
	public static final Icon CAKE_CUT = createIcon("CAKE_CUT");
	public static final Icon CAKE_SLICE = createIcon("CAKE_SLICE");
	public static final Icon CALCULATOR = createIcon("CALCULATOR");
	public static final Icon CALENDAR = createIcon("CALENDAR");
	public static final Icon CALENDAR_1 = createIcon("CALENDAR_1");
	public static final Icon CALENDAR_3 = createIcon("CALENDAR_3");
	public static final Icon CALENDAR_31 = createIcon("CALENDAR_31");
	public static final Icon CALENDAR_5 = createIcon("CALENDAR_5");
	public static final Icon CALENDAR_52 = createIcon("CALENDAR_52");
	public static final Icon CALENDAR_7 = createIcon("CALENDAR_7");
	public static final Icon CALENDAR_CLOCK = createIcon("CALENDAR_CLOCK");
	public static final Icon CALIBRATION_MARK = createIcon("CALIBRATION_MARK");
	public static final Icon CALIPER = createIcon("CALIPER");
	public static final Icon CAMERA = createIcon("CAMERA");
	public static final Icon CAN_CLOSED = createIcon("CAN_CLOSED");
	public static final Icon CAN_OPEN = createIcon("CAN_OPEN");
	public static final Icon CANDLE = createIcon("CANDLE");
	public static final Icon CANDLE_HOLDER = createIcon("CANDLE_HOLDER");
	public static final Icon CANNON = createIcon("CANNON");
	public static final Icon CAR_COMPACT = createIcon("CAR_COMPACT");
	public static final Icon CAR_COMPACT_FRONT = createIcon("CAR_COMPACT_FRONT");
	public static final Icon CAR_CONVERTIBLE = createIcon("CAR_CONVERTIBLE");
	public static final Icon CAR_SEDAN = createIcon("CAR_SEDAN");
	public static final Icon CAR_SEDAN_FRONT = createIcon("CAR_SEDAN_FRONT");
	public static final Icon CAR_SPORTS_FRONT = createIcon("CAR_SPORTS_FRONT");
	public static final Icon CARABINER = createIcon("CARABINER");
	public static final Icon CARD_TERMINAL = createIcon("CARD_TERMINAL");
	public static final Icon CARGO_CONTAINER = createIcon("CARGO_CONTAINER");
	public static final Icon CASH_FLOW = createIcon("CASH_FLOW");
	public static final Icon CASH_REGISTER = createIcon("CASH_REGISTER");
	public static final Icon CASHIER = createIcon("CASHIER");
	public static final Icon CASK = createIcon("CASK");
	public static final Icon CASTLE = createIcon("CASTLE");
	public static final Icon CD = createIcon("CD");
	public static final Icon CD_BURN = createIcon("CD_BURN");
	public static final Icon CD_CASE = createIcon("CD_CASE");
	public static final Icon CD_DRIVE = createIcon("CD_DRIVE");
	public static final Icon CD_MUSIC = createIcon("CD_MUSIC");
	public static final Icon CD_PIRATED = createIcon("CD_PIRATED");
	public static final Icon CD_WINDOW = createIcon("CD_WINDOW");
	public static final Icon CENTRAL_BANK = createIcon("CENTRAL_BANK");
	public static final Icon CENTRAL_BANK_DOLLAR = createIcon("CENTRAL_BANK_DOLLAR");
	public static final Icon CENTRAL_BANK_EURO = createIcon("CENTRAL_BANK_EURO");
	public static final Icon CENTRAL_BANK_POUND = createIcon("CENTRAL_BANK_POUND");
	public static final Icon CENTRAL_BANK_YEN = createIcon("CENTRAL_BANK_YEN");
	public static final Icon CENTRAL_BANK_YUAN = createIcon("CENTRAL_BANK_YUAN");
	public static final Icon CHAINSAW = createIcon("CHAINSAW");
	public static final Icon CHALK = createIcon("CHALK");
	public static final Icon CHAMPAGNE_BOTTLE = createIcon("CHAMPAGNE_BOTTLE");
	public static final Icon CHAMPAGNE_GLASS = createIcon("CHAMPAGNE_GLASS");
	public static final Icon CHART_AREA = createIcon("CHART_AREA");
	public static final Icon CHART_BAR = createIcon("CHART_BAR");
	public static final Icon CHART_BUBBLE = createIcon("CHART_BUBBLE");
	public static final Icon CHART_CANDLESTICK = createIcon("CHART_CANDLESTICK");
	public static final Icon CHART_COLUMN = createIcon("CHART_COLUMN");
	public static final Icon CHART_COLUMN_STACKED = createIcon("CHART_COLUMN_STACKED");
	public static final Icon CHART_DONUT = createIcon("CHART_DONUT");
	public static final Icon CHART_DOT = createIcon("CHART_DOT");
	public static final Icon CHART_FUNNEL = createIcon("CHART_FUNNEL");
	public static final Icon CHART_GANTT = createIcon("CHART_GANTT");
	public static final Icon CHART_HI_LO = createIcon("CHART_HI_LO");
	public static final Icon CHART_LINE = createIcon("CHART_LINE");
	public static final Icon CHART_PIE = createIcon("CHART_PIE");
	public static final Icon CHART_PYRAMID = createIcon("CHART_PYRAMID");
	public static final Icon CHART_RADAR = createIcon("CHART_RADAR");
	public static final Icon CHART_RENKO = createIcon("CHART_RENKO");
	public static final Icon CHART_SPLINE = createIcon("CHART_SPLINE");
	public static final Icon CHART_STEP = createIcon("CHART_STEP");
	public static final Icon CHECK = createIcon("CHECK");
	public static final Icon CHECKBOOK = createIcon("CHECKBOOK");
	public static final Icon CHECKBOX = createIcon("CHECKBOX");
	public static final Icon CHECKBOX_SELECTED = createIcon("CHECKBOX_SELECTED");
	public static final Icon CHECKBOX_UNCHECKED = createIcon("CHECKBOX_UNCHECKED");
	public static final Icon CHECKBOX_UNSELECTED = createIcon("CHECKBOX_UNSELECTED");
	public static final Icon CHECKS = createIcon("CHECKS");
	public static final Icon CHESS_PIECE_BISHOP = createIcon("CHESS_PIECE_BISHOP");
	public static final Icon CHESS_PIECE_KING = createIcon("CHESS_PIECE_KING");
	public static final Icon CHESS_PIECE_KNIGHT = createIcon("CHESS_PIECE_KNIGHT");
	public static final Icon CHESS_PIECE_PAWN = createIcon("CHESS_PIECE_PAWN");
	public static final Icon CHESS_PIECE_QUEEN = createIcon("CHESS_PIECE_QUEEN");
	public static final Icon CHESS_PIECE_ROOK = createIcon("CHESS_PIECE_ROOK");
	public static final Icon CHEST = createIcon("CHEST");
	public static final Icon CHEST_INTO = createIcon("CHEST_INTO");
	public static final Icon CHEST_OPEN = createIcon("CHEST_OPEN");
	public static final Icon CHEST_OPEN_FULL = createIcon("CHEST_OPEN_FULL");
	public static final Icon CHEST_OUT = createIcon("CHEST_OUT");
	public static final Icon CHOCOLATE = createIcon("CHOCOLATE");
	public static final Icon CHRISTIAN_CROSS = createIcon("CHRISTIAN_CROSS");
	public static final Icon CHRISTMAS_BALL = createIcon("CHRISTMAS_BALL");
	public static final Icon CHURCH = createIcon("CHURCH");
	public static final Icon CIGARETTE = createIcon("CIGARETTE");
	public static final Icon CIGARETTE_PACKET = createIcon("CIGARETTE_PACKET");
	public static final Icon CIGARETTE_PACKET_EMPTY = createIcon("CIGARETTE_PACKET_EMPTY");
	public static final Icon CIRCUS = createIcon("CIRCUS");
	public static final Icon CLAPPERBOARD = createIcon("CLAPPERBOARD");
	public static final Icon CLAPPERBOARD_CLOSED = createIcon("CLAPPERBOARD_CLOSED");
	public static final Icon CLEAVER = createIcon("CLEAVER");
	public static final Icon CLEF = createIcon("CLEF");
	public static final Icon CLIENT_NETWORK = createIcon("CLIENT_NETWORK");
	public static final Icon CLIENTS = createIcon("CLIENTS");
	public static final Icon CLIPBOARD = createIcon("CLIPBOARD");
	public static final Icon CLIPBOARD_CHECK_EDIT = createIcon("CLIPBOARD_CHECK_EDIT");
	public static final Icon CLIPBOARD_CHECKS = createIcon("CLIPBOARD_CHECKS");
	public static final Icon CLIPBOARD_EMPTY = createIcon("CLIPBOARD_EMPTY");
	public static final Icon CLIPBOARD_PASTE = createIcon("CLIPBOARD_PASTE");
	public static final Icon CLIPBOARD_PASTE_NO_FORMAT = createIcon("CLIPBOARD_PASTE_NO_FORMAT");
	public static final Icon CLOCK = createIcon("CLOCK");
	public static final Icon CLOCK_BACK = createIcon("CLOCK_BACK");
	public static final Icon CLOCK_FORWARD = createIcon("CLOCK_FORWARD");
	public static final Icon CLOSE = createIcon("CLOSE");
	public static final Icon CLOTHES_PIN = createIcon("CLOTHES_PIN");
	public static final Icon CLOUD = createIcon("CLOUD");
	public static final Icon CLOUD_DARK = createIcon("CLOUD_DARK");
	public static final Icon CLOUD_DOWNLOAD = createIcon("CLOUD_DOWNLOAD");
	public static final Icon CLOUD_FLASH = createIcon("CLOUD_FLASH");
	public static final Icon CLOUD_HAIL = createIcon("CLOUD_HAIL");
	public static final Icon CLOUD_MOON = createIcon("CLOUD_MOON");
	public static final Icon CLOUD_NETWORK = createIcon("CLOUD_NETWORK");
	public static final Icon CLOUD_RAIN = createIcon("CLOUD_RAIN");
	public static final Icon CLOUD_REFRESH = createIcon("CLOUD_REFRESH");
	public static final Icon CLOUD_SNOW = createIcon("CLOUD_SNOW");
	public static final Icon CLOUD_SUN = createIcon("CLOUD_SUN");
	public static final Icon CLOUD_UPDOWN = createIcon("CLOUD_UPDOWN");
	public static final Icon CLOUD_UPLOAD = createIcon("CLOUD_UPLOAD");
	public static final Icon CLOWN = createIcon("CLOWN");
	public static final Icon COATHANGER = createIcon("COATHANGER");
	public static final Icon COCKTAIL = createIcon("COCKTAIL");
	public static final Icon COCKTAIL_LEMON = createIcon("COCKTAIL_LEMON");
	public static final Icon CODE = createIcon("CODE");
	public static final Icon CODE_C = createIcon("CODE_C");
	public static final Icon CODE_CPLUSPLUS = createIcon("CODE_CPLUSPLUS");
	public static final Icon CODE_CSHARP = createIcon("CODE_CSHARP");
	public static final Icon CODE_JAVA = createIcon("CODE_JAVA");
	public static final Icon CODE_JAVASCRIPT = createIcon("CODE_JAVASCRIPT");
	public static final Icon CODE_LINE = createIcon("CODE_LINE");
	public static final Icon CODE_PHP = createIcon("CODE_PHP");
	public static final Icon CODE_RUBY = createIcon("CODE_RUBY");
	public static final Icon CODE_VBASIC = createIcon("CODE_VBASIC");
	public static final Icon CODES_OF_LAW = createIcon("CODES_OF_LAW");
	public static final Icon COFFEE_BEAN = createIcon("COFFEE_BEAN");
	public static final Icon COFFEE_BEANS = createIcon("COFFEE_BEANS");
	public static final Icon COFFEE_MACHINE = createIcon("COFFEE_MACHINE");
	public static final Icon COFFIN = createIcon("COFFIN");
	public static final Icon COMB = createIcon("COMB");
	public static final Icon COMPACT_CAMERA = createIcon("COMPACT_CAMERA");
	public static final Icon COMPASS = createIcon("COMPASS");
	public static final Icon COMPASSES = createIcon("COMPASSES");
	public static final Icon COMPRESS = createIcon("COMPRESS");
	public static final Icon COMPRESS_COMPRESSED = createIcon("COMPRESS_COMPRESSED");
	public static final Icon COMPUTER_CHIP = createIcon("COMPUTER_CHIP");
	public static final Icon COMPUTER_CHIP_DIP = createIcon("COMPUTER_CHIP_DIP");
	public static final Icon COMPUTER_CHIP_DIP_FLASH = createIcon("COMPUTER_CHIP_DIP_FLASH");
	public static final Icon CONSOLE = createIcon("CONSOLE");
	public static final Icon CONSOLE_NETWORK = createIcon("CONSOLE_NETWORK");
	public static final Icon CONSTRUCTION_BARRIER = createIcon("CONSTRUCTION_BARRIER");
	public static final Icon CONTAINERSHIP = createIcon("CONTAINERSHIP");
	public static final Icon CONTRACT = createIcon("CONTRACT");
	public static final Icon CONTRAST = createIcon("CONTRAST");
	public static final Icon CONTRAST_LOW = createIcon("CONTRAST_LOW");
	public static final Icon CONTROL_DEVICE = createIcon("CONTROL_DEVICE");
	public static final Icon CONTROL_PANEL = createIcon("CONTROL_PANEL");
	public static final Icon CONTROL_TOWER = createIcon("CONTROL_TOWER");
	public static final Icon COOK = createIcon("COOK");
	public static final Icon COOKIES = createIcon("COOKIES");
	public static final Icon COOLING_TOWER = createIcon("COOLING_TOWER");
	public static final Icon COOLING_TOWER_SMOKE = createIcon("COOLING_TOWER_SMOKE");
	public static final Icon COPY = createIcon("COPY");
	public static final Icon CORKSCREW = createIcon("CORKSCREW");
	public static final Icon CORRECTION_FLUID = createIcon("CORRECTION_FLUID");
	public static final Icon COURTHOUSE = createIcon("COURTHOUSE");
	public static final Icon COW = createIcon("COW");
	public static final Icon CRACK = createIcon("CRACK");
	public static final Icon CRASH_TEST_DUMMY = createIcon("CRASH_TEST_DUMMY");
	public static final Icon CREDIT_CARD = createIcon("CREDIT_CARD");
	public static final Icon CREDIT_CARD_ALT = createIcon("CREDIT_CARD_ALT");
	public static final Icon CREDIT_CARDS = createIcon("CREDIT_CARDS");
	public static final Icon CRIMINAL = createIcon("CRIMINAL");
	public static final Icon CROSSBOW = createIcon("CROSSBOW");
	public static final Icon CROWN = createIcon("CROWN");
	public static final Icon CRUISE_SHIP = createIcon("CRUISE_SHIP");
	public static final Icon CRUTCH = createIcon("CRUTCH");
	public static final Icon CRYSTAL_BALL = createIcon("CRYSTAL_BALL");
	public static final Icon CUBE_MOLECULE = createIcon("CUBE_MOLECULE");
	public static final Icon CUBE_MOLECULE_ISOMETRIC = createIcon("CUBE_MOLECULE_ISOMETRIC");
	public static final Icon CUBES = createIcon("CUBES");
	public static final Icon CUP = createIcon("CUP");
	public static final Icon CURRENCY_DOLLAR = createIcon("CURRENCY_DOLLAR");
	public static final Icon CURRENCY_EURO = createIcon("CURRENCY_EURO");
	public static final Icon CURRENCY_PLAIN = createIcon("CURRENCY_PLAIN");
	public static final Icon CURRENCY_WON = createIcon("CURRENCY_WON");
	public static final Icon CURRENCY_YEN = createIcon("CURRENCY_YEN");
	public static final Icon CURRENCY_YUAN = createIcon("CURRENCY_YUAN");
	public static final Icon CUT = createIcon("CUT");
	public static final Icon DAGGER = createIcon("DAGGER");
	public static final Icon DART = createIcon("DART");
	public static final Icon DATA = createIcon("DATA");
	public static final Icon DATA_CLOUD = createIcon("DATA_CLOUD");
	public static final Icon DATA_COPY = createIcon("DATA_COPY");
	public static final Icon DATA_FLOPPY_DISK = createIcon("DATA_FLOPPY_DISK");
	public static final Icon DATA_NETWORK = createIcon("DATA_NETWORK");
	public static final Icon DATA_SCROLL = createIcon("DATA_SCROLL");
	public static final Icon DATA_SHARED = createIcon("DATA_SHARED");
	public static final Icon DATA_TABLE = createIcon("DATA_TABLE");
	public static final Icon DEBUG = createIcon("DEBUG");
	public static final Icon DECK_CHAIR = createIcon("DECK_CHAIR");
	public static final Icon DELETE = createIcon("DELETE");
	public static final Icon DELIVERY_MAN_PARCEL = createIcon("DELIVERY_MAN_PARCEL");
	public static final Icon DELIVERY_NOTE = createIcon("DELIVERY_NOTE");
	public static final Icon DELIVERY_TRUCK = createIcon("DELIVERY_TRUCK");
	public static final Icon DENTURE = createIcon("DENTURE");
	public static final Icon DESK = createIcon("DESK");
	public static final Icon DESK_LAMP = createIcon("DESK_LAMP");
	public static final Icon DESKTOP = createIcon("DESKTOP");
	public static final Icon DETERGENT = createIcon("DETERGENT");
	public static final Icon DEVIL = createIcon("DEVIL");
	public static final Icon DIAMOND = createIcon("DIAMOND");
	public static final Icon DIAMOND_RING = createIcon("DIAMOND_RING");
	public static final Icon DICE = createIcon("DICE");
	public static final Icon DICTATION_MICROPHONE = createIcon("DICTATION_MICROPHONE");
	public static final Icon DICTIONARY = createIcon("DICTIONARY");
	public static final Icon DIE = createIcon("DIE");
	public static final Icon DISABILITY = createIcon("DISABILITY");
	public static final Icon DISINFECTION = createIcon("DISINFECTION");
	public static final Icon DIVING_MASK = createIcon("DIVING_MASK");
	public static final Icon DNA = createIcon("DNA");
	public static final Icon DOCTOR = createIcon("DOCTOR");
	public static final Icon DOCUMENT_ATTACHMENT = createIcon("DOCUMENT_ATTACHMENT");
	public static final Icon DOCUMENT_CENTER = createIcon("DOCUMENT_CENTER");
	public static final Icon DOCUMENT_CENTER_HORIZONTAL = createIcon("DOCUMENT_CENTER_HORIZONTAL");
	public static final Icon DOCUMENT_CENTER_VERTICAL = createIcon("DOCUMENT_CENTER_VERTICAL");
	public static final Icon DOCUMENT_CHART = createIcon("DOCUMENT_CHART");
	public static final Icon DOCUMENT_CUP = createIcon("DOCUMENT_CUP");
	public static final Icon DOCUMENT_EMPTY = createIcon("DOCUMENT_EMPTY");
	public static final Icon DOCUMENT_EMPTY_LANDSCAPE = createIcon("DOCUMENT_EMPTY_LANDSCAPE");
	public static final Icon DOCUMENT_FOOTER = createIcon("DOCUMENT_FOOTER");
	public static final Icon DOCUMENT_GEAR = createIcon("DOCUMENT_GEAR");
	public static final Icon DOCUMENT_HEADER = createIcon("DOCUMENT_HEADER");
	public static final Icon DOCUMENT_HEART = createIcon("DOCUMENT_HEART");
	public static final Icon DOCUMENT_HEIGHT = createIcon("DOCUMENT_HEIGHT");
	public static final Icon DOCUMENT_INFORMATION = createIcon("DOCUMENT_INFORMATION");
	public static final Icon DOCUMENT_MUSIC = createIcon("DOCUMENT_MUSIC");
	public static final Icon DOCUMENT_NOTEBOOK = createIcon("DOCUMENT_NOTEBOOK");
	public static final Icon DOCUMENT_ORIENTATION_LANDSCAPE = createIcon("DOCUMENT_ORIENTATION_LANDSCAPE");
	public static final Icon DOCUMENT_ORIENTATION_PORTRAIT = createIcon("DOCUMENT_ORIENTATION_PORTRAIT");
	public static final Icon DOCUMENT_PAGE_NUMBER = createIcon("DOCUMENT_PAGE_NUMBER");
	public static final Icon DOCUMENT_PINNED = createIcon("DOCUMENT_PINNED");
	public static final Icon DOCUMENT_PULSE = createIcon("DOCUMENT_PULSE");
	public static final Icon DOCUMENT_SELECTION = createIcon("DOCUMENT_SELECTION");
	public static final Icon DOCUMENT_SIZE = createIcon("DOCUMENT_SIZE");
	public static final Icon DOCUMENT_STOP = createIcon("DOCUMENT_STOP");
	public static final Icon DOCUMENT_TAG = createIcon("DOCUMENT_TAG");
	public static final Icon DOCUMENT_TEXT = createIcon("DOCUMENT_TEXT");
	public static final Icon DOCUMENT_WIDTH = createIcon("DOCUMENT_WIDTH");
	public static final Icon DOCUMENT_ZIP = createIcon("DOCUMENT_ZIP");
	public static final Icon DOCUMENT_ZOOM_IN = createIcon("DOCUMENT_ZOOM_IN");
	public static final Icon DOCUMENT_ZOOM_OUT = createIcon("DOCUMENT_ZOOM_OUT");
	public static final Icon DOCUMENTS_EMPTY = createIcon("DOCUMENTS_EMPTY");
	public static final Icon DOCUMENTS_EXCHANGE = createIcon("DOCUMENTS_EXCHANGE");
	public static final Icon DOG = createIcon("DOG");
	public static final Icon DOME_CAMERA = createIcon("DOME_CAMERA");
	public static final Icon DOOR_CLOSED = createIcon("DOOR_CLOSED");
	public static final Icon DOOR_EXIT = createIcon("DOOR_EXIT");
	public static final Icon DOOR_OPEN = createIcon("DOOR_OPEN");
	public static final Icon DOT_MATRIX = createIcon("DOT_MATRIX");
	public static final Icon DOWNLOAD = createIcon("DOWNLOAD");
	public static final Icon DRAM = createIcon("DRAM");
	public static final Icon DRINK = createIcon("DRINK");
	public static final Icon DROP = createIcon("DROP");
	public static final Icon DROP_DOWN_LIST = createIcon("DROP_DOWN_LIST");
	public static final Icon DRUM = createIcon("DRUM");
	public static final Icon DUDE = createIcon("DUDE");
	public static final Icon DUDE_BANDANA = createIcon("DUDE_BANDANA");
	public static final Icon DUDE_BEANIE = createIcon("DUDE_BEANIE");
	public static final Icon DUDE_CAP = createIcon("DUDE_CAP");
	public static final Icon DUG_WELL = createIcon("DUG_WELL");
	public static final Icon DUMBBELL = createIcon("DUMBBELL");
	public static final Icon DUMP_TRUCK = createIcon("DUMP_TRUCK");
	public static final Icon DYNAMITE = createIcon("DYNAMITE");
	public static final Icon EAR = createIcon("EAR");
	public static final Icon EARTH = createIcon("EARTH");
	public static final Icon EARTH_ALT = createIcon("EARTH_ALT");
	public static final Icon EARTH_LINK = createIcon("EARTH_LINK");
	public static final Icon EARTH_LOCATION = createIcon("EARTH_LOCATION");
	public static final Icon EARTH_MUSIC = createIcon("EARTH_MUSIC");
	public static final Icon EARTH_NETWORK = createIcon("EARTH_NETWORK");
	public static final Icon EASEL = createIcon("EASEL");
	public static final Icon EASEL_EMPTY = createIcon("EASEL_EMPTY");
	public static final Icon EDIT = createIcon("EDIT");
	public static final Icon EIGHTBALL = createIcon("EIGHTBALL");
	public static final Icon ELECTRIC_IRON = createIcon("ELECTRIC_IRON");
	public static final Icon ELEMENT = createIcon("ELEMENT");
	public static final Icon ELEMENT_COPY = createIcon("ELEMENT_COPY");
	public static final Icon ELEMENT_SELECTION = createIcon("ELEMENT_SELECTION");
	public static final Icon ELEMENTS = createIcon("ELEMENTS");
	public static final Icon ELEMENTS_BRANCH = createIcon("ELEMENTS_BRANCH");
	public static final Icon ELEMENTS_BRANCH_HIGHLIGHT = createIcon("ELEMENTS_BRANCH_HIGHLIGHT");
	public static final Icon ELEMENTS_CASCADE = createIcon("ELEMENTS_CASCADE");
	public static final Icon ELEMENTS_FOUR = createIcon("ELEMENTS_FOUR");
	public static final Icon ELEMENTS_HIERARCHY = createIcon("ELEMENTS_HIERARCHY");
	public static final Icon ELEMENTS_SELECTION = createIcon("ELEMENTS_SELECTION");
	public static final Icon ELEMENTS_THREE = createIcon("ELEMENTS_THREE");
	public static final Icon ELEMENTS_TREE = createIcon("ELEMENTS_TREE");
	public static final Icon ELEMENTS_TWO = createIcon("ELEMENTS_TWO");
	public static final Icon EMERGENCY_STOP_BUTTON = createIcon("EMERGENCY_STOP_BUTTON");
	public static final Icon EMOTICON_ANGRY = createIcon("EMOTICON_ANGRY");
	public static final Icon EMOTICON_BLINK = createIcon("EMOTICON_BLINK");
	public static final Icon EMOTICON_CLOWN = createIcon("EMOTICON_CLOWN");
	public static final Icon EMOTICON_CONFUSED = createIcon("EMOTICON_CONFUSED");
	public static final Icon EMOTICON_COOL = createIcon("EMOTICON_COOL");
	public static final Icon EMOTICON_CRY = createIcon("EMOTICON_CRY");
	public static final Icon EMOTICON_FROWN = createIcon("EMOTICON_FROWN");
	public static final Icon EMOTICON_GRIN = createIcon("EMOTICON_GRIN");
	public static final Icon EMOTICON_KISS = createIcon("EMOTICON_KISS");
	public static final Icon EMOTICON_SMILE = createIcon("EMOTICON_SMILE");
	public static final Icon EMOTICON_STRAIGHT_FACE = createIcon("EMOTICON_STRAIGHT_FACE");
	public static final Icon EMOTICON_SURPRISED = createIcon("EMOTICON_SURPRISED");
	public static final Icon EMOTICON_TONGUE = createIcon("EMOTICON_TONGUE");
	public static final Icon ENGINEER = createIcon("ENGINEER");
	public static final Icon ENVELOPE = createIcon("ENVELOPE");
	public static final Icon ENVIRONMENT = createIcon("ENVIRONMENT");
	public static final Icon ENVIRONMENT_NETWORK = createIcon("ENVIRONMENT_NETWORK");
	public static final Icon EQUALIZER = createIcon("EQUALIZER");
	public static final Icon ERASE = createIcon("ERASE");
	public static final Icon ERROR = createIcon("ERROR");
	public static final Icon ESCALATOR = createIcon("ESCALATOR");
	public static final Icon ESCALATOR_DOWN = createIcon("ESCALATOR_DOWN");
	public static final Icon ESCALATOR_UP = createIcon("ESCALATOR_UP");
	public static final Icon EXCAVATOR = createIcon("EXCAVATOR");
	public static final Icon EXPLOSION = createIcon("EXPLOSION");
	public static final Icon EYE = createIcon("EYE");
	public static final Icon EYE_BLIND = createIcon("EYE_BLIND");
	public static final Icon EYE_SCAN = createIcon("EYE_SCAN");
	public static final Icon EYEGLASSES = createIcon("EYEGLASSES");
	public static final Icon FACE_SCAN = createIcon("FACE_SCAN");
	public static final Icon FACTORY = createIcon("FACTORY");
	public static final Icon FAN = createIcon("FAN");
	public static final Icon FANCY_CAKE = createIcon("FANCY_CAKE");
	public static final Icon FAX_MACHINE = createIcon("FAX_MACHINE");
	public static final Icon FEEDING_BOTTLE = createIcon("FEEDING_BOTTLE");
	public static final Icon FENCE = createIcon("FENCE");
	public static final Icon FILM = createIcon("FILM");
	public static final Icon FILM_CARTRIDGE = createIcon("FILM_CARTRIDGE");
	public static final Icon FILTER_AND_SORT = createIcon("FILTER_AND_SORT");
	public static final Icon FIND_AGAIN = createIcon("FIND_AGAIN");
	public static final Icon FIND_TEXT = createIcon("FIND_TEXT");
	public static final Icon FINGERPRINT = createIcon("FINGERPRINT");
	public static final Icon FINGERPRINT_SCAN = createIcon("FINGERPRINT_SCAN");
	public static final Icon FIRE = createIcon("FIRE");
	public static final Icon FIRE_EXTINGUISHER = createIcon("FIRE_EXTINGUISHER");
	public static final Icon FIRE_HYDRANT = createIcon("FIRE_HYDRANT");
	public static final Icon FIRE_TRUCK = createIcon("FIRE_TRUCK");
	public static final Icon FIREFIGHTER = createIcon("FIREFIGHTER");
	public static final Icon FIREWALL = createIcon("FIREWALL");
	public static final Icon FIREWALL_EARTH = createIcon("FIREWALL_EARTH");
	public static final Icon FIRST_AID = createIcon("FIRST_AID");
	public static final Icon FIRST_AID_BOX = createIcon("FIRST_AID_BOX");
	public static final Icon FISH = createIcon("FISH");
	public static final Icon FISH_BOWL = createIcon("FISH_BOWL");
	public static final Icon FIT_TO_HEIGHT = createIcon("FIT_TO_HEIGHT");
	public static final Icon FIT_TO_SIZE = createIcon("FIT_TO_SIZE");
	public static final Icon FIT_TO_WIDTH = createIcon("FIT_TO_WIDTH");
	public static final Icon FLAME = createIcon("FLAME");
	public static final Icon FLASH = createIcon("FLASH");
	public static final Icon FLASHLIGHT = createIcon("FLASHLIGHT");
	public static final Icon FLASK = createIcon("FLASK");
	public static final Icon FLASK_ROUND_BOTTOM = createIcon("FLASK_ROUND_BOTTOM");
	public static final Icon FLATSCREEN_TV = createIcon("FLATSCREEN_TV");
	public static final Icon FLOPPY_DISK = createIcon("FLOPPY_DISK");
	public static final Icon FLOPPY_DISK_WINDOW = createIcon("FLOPPY_DISK_WINDOW");
	public static final Icon FLOPPY_DISKS = createIcon("FLOPPY_DISKS");
	public static final Icon FLOPPY_DRIVE = createIcon("FLOPPY_DRIVE");
	public static final Icon FLOWER = createIcon("FLOWER");
	public static final Icon FOLDER = createIcon("FOLDER");
	public static final Icon FOLDER_CUBES = createIcon("FOLDER_CUBES");
	public static final Icon FOLDER_DOCUMENT = createIcon("FOLDER_DOCUMENT");
	public static final Icon FOLDER_DOCUMENT_VERTICAL = createIcon("FOLDER_DOCUMENT_VERTICAL");
	public static final Icon FOLDER_INTO = createIcon("FOLDER_INTO");
	public static final Icon FOLDER_LEVER_ARCH = createIcon("FOLDER_LEVER_ARCH");
	public static final Icon FOLDER_MAIL = createIcon("FOLDER_MAIL");
	public static final Icon FOLDER_MOVIE = createIcon("FOLDER_MOVIE");
	public static final Icon FOLDER_MOVIE_VERTICAL = createIcon("FOLDER_MOVIE_VERTICAL");
	public static final Icon FOLDER_MUSIC = createIcon("FOLDER_MUSIC");
	public static final Icon FOLDER_MUSIC_VERTICAL = createIcon("FOLDER_MUSIC_VERTICAL");
	public static final Icon FOLDER_NETWORK = createIcon("FOLDER_NETWORK");
	public static final Icon FOLDER_OPEN = createIcon("FOLDER_OPEN");
	public static final Icon FOLDER_OPEN_DOCUMENT = createIcon("FOLDER_OPEN_DOCUMENT");
	public static final Icon FOLDER_OUT = createIcon("FOLDER_OUT");
	public static final Icon FOLDER_SHARED = createIcon("FOLDER_SHARED");
	public static final Icon FOLDER_VERTICAL = createIcon("FOLDER_VERTICAL");
	public static final Icon FOLDER_WINDOW = createIcon("FOLDER_WINDOW");
	public static final Icon FOLDER_ZIP = createIcon("FOLDER_ZIP");
	public static final Icon FOLDERS = createIcon("FOLDERS");
	public static final Icon FOLDERS_LEVER_ARCH = createIcon("FOLDERS_LEVER_ARCH");
	public static final Icon FOLDING_RULE = createIcon("FOLDING_RULE");
	public static final Icon FONT = createIcon("FONT");
	public static final Icon FONT_STYLE_BOLD = createIcon("FONT_STYLE_BOLD");
	public static final Icon FONT_STYLE_ITALICS = createIcon("FONT_STYLE_ITALICS");
	public static final Icon FONT_STYLE_NORMAL = createIcon("FONT_STYLE_NORMAL");
	public static final Icon FONT_STYLE_STRIKETHROUGH = createIcon("FONT_STYLE_STRIKETHROUGH");
	public static final Icon FONT_STYLE_SUBSCRIPT = createIcon("FONT_STYLE_SUBSCRIPT");
	public static final Icon FONT_STYLE_SUPERSCRIPT = createIcon("FONT_STYLE_SUPERSCRIPT");
	public static final Icon FONT_STYLE_UNDERLINE = createIcon("FONT_STYLE_UNDERLINE");
	public static final Icon FOOTBALL = createIcon("FOOTBALL");
	public static final Icon FORKLIFT = createIcon("FORKLIFT");
	public static final Icon FORM = createIcon("FORM");
	public static final Icon FORMULA = createIcon("FORMULA");
	public static final Icon FORTRESS_TOWER = createIcon("FORTRESS_TOWER");
	public static final Icon FOUNTAIN_PEN = createIcon("FOUNTAIN_PEN");
	public static final Icon FRIED_EGG = createIcon("FRIED_EGG");
	public static final Icon FRIED_EGG_BACON = createIcon("FRIED_EGG_BACON");
	public static final Icon FRONT = createIcon("FRONT");
	public static final Icon FUEL_DISPENSER = createIcon("FUEL_DISPENSER");
	public static final Icon FUNNEL = createIcon("FUNNEL");
	public static final Icon GALLOWS = createIcon("GALLOWS");
	public static final Icon GAMBLING_CHIP = createIcon("GAMBLING_CHIP");
	public static final Icon GAMBLING_CHIPS = createIcon("GAMBLING_CHIPS");
	public static final Icon GAMBLING_CHIPS_STACKED = createIcon("GAMBLING_CHIPS_STACKED");
	public static final Icon GAMEPAD = createIcon("GAMEPAD");
	public static final Icon GARBAGE = createIcon("GARBAGE");
	public static final Icon GARBAGE_CAN = createIcon("GARBAGE_CAN");
	public static final Icon GARBAGE_CONTAINER = createIcon("GARBAGE_CONTAINER");
	public static final Icon GARBAGE_EMPTY = createIcon("GARBAGE_EMPTY");
	public static final Icon GARBAGE_FULL = createIcon("GARBAGE_FULL");
	public static final Icon GARBAGE_HALF_FULL = createIcon("GARBAGE_HALF_FULL");
	public static final Icon GARBAGE_MAKE_EMPTY = createIcon("GARBAGE_MAKE_EMPTY");
	public static final Icon GARBAGE_OVERFLOW = createIcon("GARBAGE_OVERFLOW");
	public static final Icon GAS_CYLINDER = createIcon("GAS_CYLINDER");
	public static final Icon GAUGE = createIcon("GAUGE");
	public static final Icon GAUNTLET = createIcon("GAUNTLET");
	public static final Icon GAUZE_BANDAGE = createIcon("GAUZE_BANDAGE");
	public static final Icon GEARWHEEL = createIcon("GEARWHEEL");
	public static final Icon GEARWHEELS = createIcon("GEARWHEELS");
	public static final Icon GEIGER_COUNTER = createIcon("GEIGER_COUNTER");
	public static final Icon GENIUS = createIcon("GENIUS");
	public static final Icon GHOST = createIcon("GHOST");
	public static final Icon GIFT = createIcon("GIFT");
	public static final Icon GIRL = createIcon("GIRL");
	public static final Icon GLASS_CRACKED = createIcon("GLASS_CRACKED");
	public static final Icon GLASS_FORK = createIcon("GLASS_FORK");
	public static final Icon GLOBE = createIcon("GLOBE");
	public static final Icon GOAL = createIcon("GOAL");
	public static final Icon GOAL_BALL = createIcon("GOAL_BALL");
	public static final Icon GOBLET = createIcon("GOBLET");
	public static final Icon GOLD_BAR = createIcon("GOLD_BAR");
	public static final Icon GOLD_BARS = createIcon("GOLD_BARS");
	public static final Icon GOLF_BALL = createIcon("GOLF_BALL");
	public static final Icon GOLF_CLUB_IRON = createIcon("GOLF_CLUB_IRON");
	public static final Icon GOLF_CLUB_PUTTER = createIcon("GOLF_CLUB_PUTTER");
	public static final Icon GOLF_CLUB_WOOD = createIcon("GOLF_CLUB_WOOD");
	public static final Icon GOLF_FLAG = createIcon("GOLF_FLAG");
	public static final Icon GPS = createIcon("GPS");
	public static final Icon GRADUATE = createIcon("GRADUATE");
	public static final Icon GRADUATION_HAT = createIcon("GRADUATION_HAT");
	public static final Icon GRADUATION_HAT_SCROLL = createIcon("GRADUATION_HAT_SCROLL");
	public static final Icon GRAND_PIANO = createIcon("GRAND_PIANO");
	public static final Icon GRAPH = createIcon("GRAPH");
	public static final Icon GRAPH_CLAW = createIcon("GRAPH_CLAW");
	public static final Icon GRAPH_CONNECTION = createIcon("GRAPH_CONNECTION");
	public static final Icon GRAPH_CONNECTION_DIRECTED = createIcon("GRAPH_CONNECTION_DIRECTED");
	public static final Icon GRAPH_FORK = createIcon("GRAPH_FORK");
	public static final Icon GRAPH_FORK_SPREAD = createIcon("GRAPH_FORK_SPREAD");
	public static final Icon GRAPH_FROM = createIcon("GRAPH_FROM");
	public static final Icon GRAPH_NODE = createIcon("GRAPH_NODE");
	public static final Icon GRAPH_SELF_LOOP = createIcon("GRAPH_SELF_LOOP");
	public static final Icon GRAPH_SQUARE = createIcon("GRAPH_SQUARE");
	public static final Icon GRAPH_STAR = createIcon("GRAPH_STAR");
	public static final Icon GRAPH_TO = createIcon("GRAPH_TO");
	public static final Icon GRAPH_TRIANGLE = createIcon("GRAPH_TRIANGLE");
	public static final Icon GRAPHICS_TABLET = createIcon("GRAPHICS_TABLET");
	public static final Icon GRENADE = createIcon("GRENADE");
	public static final Icon GUARD = createIcon("GUARD");
	public static final Icon GUILLOTINE = createIcon("GUILLOTINE");
	public static final Icon GUITAR = createIcon("GUITAR");
	public static final Icon GUN = createIcon("GUN");
	public static final Icon HAIR_DRYER = createIcon("HAIR_DRYER");
	public static final Icon HAMBURGER = createIcon("HAMBURGER");
	public static final Icon HAMMER = createIcon("HAMMER");
	public static final Icon HAMMER_SLEDGE = createIcon("HAMMER_SLEDGE");
	public static final Icon HAND_CARD = createIcon("HAND_CARD");
	public static final Icon HAND_COUNT_FOUR = createIcon("HAND_COUNT_FOUR");
	public static final Icon HAND_COUNT_ONE = createIcon("HAND_COUNT_ONE");
	public static final Icon HAND_COUNT_THREE = createIcon("HAND_COUNT_THREE");
	public static final Icon HAND_COUNT_ZERO = createIcon("HAND_COUNT_ZERO");
	public static final Icon HAND_DRILL = createIcon("HAND_DRILL");
	public static final Icon HAND_FIST = createIcon("HAND_FIST");
	public static final Icon HAND_FOUR = createIcon("HAND_FOUR");
	public static final Icon HAND_GUN = createIcon("HAND_GUN");
	public static final Icon HAND_MONEY = createIcon("HAND_MONEY");
	public static final Icon HAND_OFFER = createIcon("HAND_OFFER");
	public static final Icon HAND_PAPER = createIcon("HAND_PAPER");
	public static final Icon HAND_POINT_LEFT = createIcon("HAND_POINT_LEFT");
	public static final Icon HAND_POINT_LEFT_BACK = createIcon("HAND_POINT_LEFT_BACK");
	public static final Icon HAND_POINT_RIGHT = createIcon("HAND_POINT_RIGHT");
	public static final Icon HAND_POINT_RIGHT_BACK = createIcon("HAND_POINT_RIGHT_BACK");
	public static final Icon HAND_POINT_UP = createIcon("HAND_POINT_UP");
	public static final Icon HAND_POINT_UP_BACK = createIcon("HAND_POINT_UP_BACK");
	public static final Icon HAND_PUMP = createIcon("HAND_PUMP");
	public static final Icon HAND_SPREAD = createIcon("HAND_SPREAD");
	public static final Icon HAND_STOP = createIcon("HAND_STOP");
	public static final Icon HAND_THUMB_DOWN = createIcon("HAND_THUMB_DOWN");
	public static final Icon HAND_THUMB_UP = createIcon("HAND_THUMB_UP");
	public static final Icon HAND_TOUCH = createIcon("HAND_TOUCH");
	public static final Icon HAND_TRUCK = createIcon("HAND_TRUCK");
	public static final Icon HAND_TRUCK_BAG = createIcon("HAND_TRUCK_BAG");
	public static final Icon HAND_TRUCK_BOX = createIcon("HAND_TRUCK_BOX");
	public static final Icon HAND_TRUCK_SUITCASE = createIcon("HAND_TRUCK_SUITCASE");
	public static final Icon HANDBAG = createIcon("HANDBAG");
	public static final Icon HANDCUFFS = createIcon("HANDCUFFS");
	public static final Icon HANDHELD_DEVICE = createIcon("HANDHELD_DEVICE");
	public static final Icon HANDSAW = createIcon("HANDSAW");
	public static final Icon HANDSHAKE = createIcon("HANDSHAKE");
	public static final Icon HARD_DRIVE = createIcon("HARD_DRIVE");
	public static final Icon HARD_DRIVE_NETWORK = createIcon("HARD_DRIVE_NETWORK");
	public static final Icon HARDHAT = createIcon("HARDHAT");
	public static final Icon HAT = createIcon("HAT");
	public static final Icon HAT_ALT = createIcon("HAT_ALT");
	public static final Icon HEADPHONES = createIcon("HEADPHONES");
	public static final Icon HEADSET = createIcon("HEADSET");
	public static final Icon HEADSTONE = createIcon("HEADSTONE");
	public static final Icon HEART = createIcon("HEART");
	public static final Icon HEART_BROKEN = createIcon("HEART_BROKEN");
	public static final Icon HEARTBEAT = createIcon("HEARTBEAT");
	public static final Icon HELICOPTER = createIcon("HELICOPTER");
	public static final Icon HELMET = createIcon("HELMET");
	public static final Icon HELP_EARTH = createIcon("HELP_EARTH");
	public static final Icon HINT = createIcon("HINT");
	public static final Icon HISTORY = createIcon("HISTORY");
	public static final Icon HISTORY_SCROLL = createIcon("HISTORY_SCROLL");
	public static final Icon HOCKEY_PUCK = createIcon("HOCKEY_PUCK");
	public static final Icon HOCKEY_STICK = createIcon("HOCKEY_STICK");
	public static final Icon HOLE_PUNCH = createIcon("HOLE_PUNCH");
	public static final Icon HOLMES = createIcon("HOLMES");
	public static final Icon HOME = createIcon("HOME");
	public static final Icon HOME_FIRE = createIcon("HOME_FIRE");
	public static final Icon HOME_LOCK = createIcon("HOME_LOCK");
	public static final Icon HOME_WATER = createIcon("HOME_WATER");
	public static final Icon HORSE = createIcon("HORSE");
	public static final Icon HOSPITAL = createIcon("HOSPITAL");
	public static final Icon HOT_AIR_BALLOON = createIcon("HOT_AIR_BALLOON");
	public static final Icon HOTEL = createIcon("HOTEL");
	public static final Icon HOURGLASS = createIcon("HOURGLASS");
	public static final Icon HOUSE_FRAMEWORK = createIcon("HOUSE_FRAMEWORK");
	public static final Icon HOUSES = createIcon("HOUSES");
	public static final Icon HTML_TAG = createIcon("HTML_TAG");
	public static final Icon HTML_TAG_CLOSE = createIcon("HTML_TAG_CLOSE");
	public static final Icon I_BEAM = createIcon("I_BEAM");
	public static final Icon I_BEAMS = createIcon("I_BEAMS");
	public static final Icon ICE_CREAM_CONE = createIcon("ICE_CREAM_CONE");
	public static final Icon ICE_POP = createIcon("ICE_POP");
	public static final Icon ICECUBE = createIcon("ICECUBE");
	public static final Icon ID_BADGE = createIcon("ID_BADGE");
	public static final Icon ID_CARD = createIcon("ID_CARD");
	public static final Icon ID_CARDS = createIcon("ID_CARDS");
	public static final Icon IGLOO = createIcon("IGLOO");
	public static final Icon INBOX = createIcon("INBOX");
	public static final Icon INBOX_EMPTY = createIcon("INBOX_EMPTY");
	public static final Icon INBOX_FULL = createIcon("INBOX_FULL");
	public static final Icon INBOX_INTO = createIcon("INBOX_INTO");
	public static final Icon INBOX_OUT = createIcon("INBOX_OUT");
	public static final Icon INDENT_DECREASE = createIcon("INDENT_DECREASE");
	public static final Icon INDENT_INCREASE = createIcon("INDENT_INCREASE");
	public static final Icon INDEX = createIcon("INDEX");
	public static final Icon INDEX_ROTATING = createIcon("INDEX_ROTATING");
	public static final Icon INDUSTRIAL_MACHINE = createIcon("INDUSTRIAL_MACHINE");
	public static final Icon INDUSTRIAL_ROBOT = createIcon("INDUSTRIAL_ROBOT");
	public static final Icon INFORMATION = createIcon("INFORMATION");
	public static final Icon INFUSION_DRIP = createIcon("INFUSION_DRIP");
	public static final Icon INJECTION = createIcon("INJECTION");
	public static final Icon INKPOT = createIcon("INKPOT");
	public static final Icon INSTALL = createIcon("INSTALL");
	public static final Icon INVOICE = createIcon("INVOICE");
	public static final Icon INVOICE_DOLLAR = createIcon("INVOICE_DOLLAR");
	public static final Icon INVOICE_EURO = createIcon("INVOICE_EURO");
	public static final Icon JACKHAMMER = createIcon("JACKHAMMER");
	public static final Icon JAR = createIcon("JAR");
	public static final Icon JAR_COFFEE_BEAN = createIcon("JAR_COFFEE_BEAN");
	public static final Icon JAR_COOKIES = createIcon("JAR_COOKIES");
	public static final Icon JAR_EARTH = createIcon("JAR_EARTH");
	public static final Icon JERRYCAN = createIcon("JERRYCAN");
	public static final Icon JOYSTICK = createIcon("JOYSTICK");
	public static final Icon JUDGE = createIcon("JUDGE");
	public static final Icon KEY = createIcon("KEY");
	public static final Icon KEY_CAR = createIcon("KEY_CAR");
	public static final Icon KEY_MORTICE = createIcon("KEY_MORTICE");
	public static final Icon KEYBOARD = createIcon("KEYBOARD");
	public static final Icon KEYBOARD_KEY_0 = createIcon("KEYBOARD_KEY_0");
	public static final Icon KEYBOARD_KEY_1 = createIcon("KEYBOARD_KEY_1");
	public static final Icon KEYBOARD_KEY_2 = createIcon("KEYBOARD_KEY_2");
	public static final Icon KEYBOARD_KEY_3 = createIcon("KEYBOARD_KEY_3");
	public static final Icon KEYBOARD_KEY_4 = createIcon("KEYBOARD_KEY_4");
	public static final Icon KEYBOARD_KEY_5 = createIcon("KEYBOARD_KEY_5");
	public static final Icon KEYBOARD_KEY_6 = createIcon("KEYBOARD_KEY_6");
	public static final Icon KEYBOARD_KEY_7 = createIcon("KEYBOARD_KEY_7");
	public static final Icon KEYBOARD_KEY_8 = createIcon("KEYBOARD_KEY_8");
	public static final Icon KEYBOARD_KEY_9 = createIcon("KEYBOARD_KEY_9");
	public static final Icon KEYBOARD_KEY_A = createIcon("KEYBOARD_KEY_A");
	public static final Icon KEYBOARD_KEY_B = createIcon("KEYBOARD_KEY_B");
	public static final Icon KEYBOARD_KEY_C = createIcon("KEYBOARD_KEY_C");
	public static final Icon KEYBOARD_KEY_CLOCK = createIcon("KEYBOARD_KEY_CLOCK");
	public static final Icon KEYBOARD_KEY_D = createIcon("KEYBOARD_KEY_D");
	public static final Icon KEYBOARD_KEY_DOWN = createIcon("KEYBOARD_KEY_DOWN");
	public static final Icon KEYBOARD_KEY_E = createIcon("KEYBOARD_KEY_E");
	public static final Icon KEYBOARD_KEY_EMPTY = createIcon("KEYBOARD_KEY_EMPTY");
	public static final Icon KEYBOARD_KEY_ENTER = createIcon("KEYBOARD_KEY_ENTER");
	public static final Icon KEYBOARD_KEY_F = createIcon("KEYBOARD_KEY_F");
	public static final Icon KEYBOARD_KEY_G = createIcon("KEYBOARD_KEY_G");
	public static final Icon KEYBOARD_KEY_H = createIcon("KEYBOARD_KEY_H");
	public static final Icon KEYBOARD_KEY_I = createIcon("KEYBOARD_KEY_I");
	public static final Icon KEYBOARD_KEY_J = createIcon("KEYBOARD_KEY_J");
	public static final Icon KEYBOARD_KEY_K = createIcon("KEYBOARD_KEY_K");
	public static final Icon KEYBOARD_KEY_L = createIcon("KEYBOARD_KEY_L");
	public static final Icon KEYBOARD_KEY_LEFT = createIcon("KEYBOARD_KEY_LEFT");
	public static final Icon KEYBOARD_KEY_M = createIcon("KEYBOARD_KEY_M");
	public static final Icon KEYBOARD_KEY_MINUS = createIcon("KEYBOARD_KEY_MINUS");
	public static final Icon KEYBOARD_KEY_N = createIcon("KEYBOARD_KEY_N");
	public static final Icon KEYBOARD_KEY_O = createIcon("KEYBOARD_KEY_O");
	public static final Icon KEYBOARD_KEY_P = createIcon("KEYBOARD_KEY_P");
	public static final Icon KEYBOARD_KEY_PLUS = createIcon("KEYBOARD_KEY_PLUS");
	public static final Icon KEYBOARD_KEY_Q = createIcon("KEYBOARD_KEY_Q");
	public static final Icon KEYBOARD_KEY_R = createIcon("KEYBOARD_KEY_R");
	public static final Icon KEYBOARD_KEY_RIGHT = createIcon("KEYBOARD_KEY_RIGHT");
	public static final Icon KEYBOARD_KEY_S = createIcon("KEYBOARD_KEY_S");
	public static final Icon KEYBOARD_KEY_SHIFT = createIcon("KEYBOARD_KEY_SHIFT");
	public static final Icon KEYBOARD_KEY_SPEAKER = createIcon("KEYBOARD_KEY_SPEAKER");
	public static final Icon KEYBOARD_KEY_T = createIcon("KEYBOARD_KEY_T");
	public static final Icon KEYBOARD_KEY_U = createIcon("KEYBOARD_KEY_U");
	public static final Icon KEYBOARD_KEY_UP = createIcon("KEYBOARD_KEY_UP");
	public static final Icon KEYBOARD_KEY_V = createIcon("KEYBOARD_KEY_V");
	public static final Icon KEYBOARD_KEY_W = createIcon("KEYBOARD_KEY_W");
	public static final Icon KEYBOARD_KEY_X = createIcon("KEYBOARD_KEY_X");
	public static final Icon KEYBOARD_KEY_Y = createIcon("KEYBOARD_KEY_Y");
	public static final Icon KEYBOARD_KEY_Z = createIcon("KEYBOARD_KEY_Z");
	public static final Icon KEYBOARD_WIRELESS = createIcon("KEYBOARD_WIRELESS");
	public static final Icon KEYHOLE = createIcon("KEYHOLE");
	public static final Icon KEYPAD = createIcon("KEYPAD");
	public static final Icon KEYS = createIcon("KEYS");
	public static final Icon KIDNEY_DISH = createIcon("KIDNEY_DISH");
	public static final Icon KNIFE = createIcon("KNIFE");
	public static final Icon KNIFE_FORK = createIcon("KNIFE_FORK");
	public static final Icon KNIFE_FORK_SPOON = createIcon("KNIFE_FORK_SPOON");
	public static final Icon KNOT = createIcon("KNOT");
	public static final Icon LADDER = createIcon("LADDER");
	public static final Icon LANTERN = createIcon("LANTERN");
	public static final Icon LANTERN_ON = createIcon("LANTERN_ON");
	public static final Icon LAPTOP = createIcon("LAPTOP");
	public static final Icon LASER_POINTER = createIcon("LASER_POINTER");
	public static final Icon LAUNDRY_MACHINE = createIcon("LAUNDRY_MACHINE");
	public static final Icon LAUREL_WREATH = createIcon("LAUREL_WREATH");
	public static final Icon LAYOUT = createIcon("LAYOUT");
	public static final Icon LAYOUT_CENTER = createIcon("LAYOUT_CENTER");
	public static final Icon LAYOUT_EAST = createIcon("LAYOUT_EAST");
	public static final Icon LAYOUT_HORIZONTAL = createIcon("LAYOUT_HORIZONTAL");
	public static final Icon LAYOUT_NORTH = createIcon("LAYOUT_NORTH");
	public static final Icon LAYOUT_NORTHEAST = createIcon("LAYOUT_NORTHEAST");
	public static final Icon LAYOUT_NORTHWEST = createIcon("LAYOUT_NORTHWEST");
	public static final Icon LAYOUT_SOUTH = createIcon("LAYOUT_SOUTH");
	public static final Icon LAYOUT_SOUTHEAST = createIcon("LAYOUT_SOUTHEAST");
	public static final Icon LAYOUT_SOUTHWEST = createIcon("LAYOUT_SOUTHWEST");
	public static final Icon LAYOUT_VERTICAL = createIcon("LAYOUT_VERTICAL");
	public static final Icon LAYOUT_WEST = createIcon("LAYOUT_WEST");
	public static final Icon LEAF = createIcon("LEAF");
	public static final Icon LECTERN = createIcon("LECTERN");
	public static final Icon LECTURE = createIcon("LECTURE");
	public static final Icon LED = createIcon("LED");
	public static final Icon LEMON = createIcon("LEMON");
	public static final Icon LEMONADE_GLASS = createIcon("LEMONADE_GLASS");
	public static final Icon LIFEBELT = createIcon("LIFEBELT");
	public static final Icon LIGHTBULB_OFF = createIcon("LIGHTBULB_OFF");
	public static final Icon LIGHTBULB_ON = createIcon("LIGHTBULB_ON");
	public static final Icon LIGHTHOUSE = createIcon("LIGHTHOUSE");
	public static final Icon LINE_BREAK = createIcon("LINE_BREAK");
	public static final Icon LINE_SPACING_PARAGRAPH = createIcon("LINE_SPACING_PARAGRAPH");
	public static final Icon LINE_SPACING_TEXT = createIcon("LINE_SPACING_TEXT");
	public static final Icon LINK = createIcon("LINK");
	public static final Icon LINK_BROKEN = createIcon("LINK_BROKEN");
	public static final Icon LIPSTICK = createIcon("LIPSTICK");
	public static final Icon LIST_STYLE_BULLETS = createIcon("LIST_STYLE_BULLETS");
	public static final Icon LIST_STYLE_NUMBERED = createIcon("LIST_STYLE_NUMBERED");
	public static final Icon LIST_STYLE_ROMAN = createIcon("LIST_STYLE_ROMAN");
	public static final Icon LOCATION_PIN = createIcon("LOCATION_PIN");
	public static final Icon LOCK = createIcon("LOCK");
	public static final Icon LOCK_COMBINATION = createIcon("LOCK_COMBINATION");
	public static final Icon LOCK_OPEN = createIcon("LOCK_OPEN");
	public static final Icon LOCK_ROUND = createIcon("LOCK_ROUND");
	public static final Icon LOG = createIcon("LOG");
	public static final Icon LOG_IN = createIcon("LOG_IN");
	public static final Icon LOG_OUT = createIcon("LOG_OUT");
	public static final Icon LOGIC_AND = createIcon("LOGIC_AND");
	public static final Icon LOGIC_NOT = createIcon("LOGIC_NOT");
	public static final Icon LOGIC_OR = createIcon("LOGIC_OR");
	public static final Icon LOGIC_XOR = createIcon("LOGIC_XOR");
	public static final Icon LOGS = createIcon("LOGS");
	public static final Icon LOLLIPOP = createIcon("LOLLIPOP");
	public static final Icon LOUDSPEAKER = createIcon("LOUDSPEAKER");
	public static final Icon LOUDSPEAKER_BOX = createIcon("LOUDSPEAKER_BOX");
	public static final Icon LOUDSPEAKER_NETWORK = createIcon("LOUDSPEAKER_NETWORK");
	public static final Icon LOUDSPEAKER_OFF = createIcon("LOUDSPEAKER_OFF");
	public static final Icon LOUDSPEAKER_VOLUME_FOUR = createIcon("LOUDSPEAKER_VOLUME_FOUR");
	public static final Icon LOUDSPEAKER_VOLUME_THREE = createIcon("LOUDSPEAKER_VOLUME_THREE");
	public static final Icon LOUDSPEAKER_VOLUME_TWO = createIcon("LOUDSPEAKER_VOLUME_TWO");
	public static final Icon MAGAZINE_FOLDER = createIcon("MAGAZINE_FOLDER");
	public static final Icon MAGAZINE_FOLDER_EMPTY = createIcon("MAGAZINE_FOLDER_EMPTY");
	public static final Icon MAGIC_WAND = createIcon("MAGIC_WAND");
	public static final Icon MAGICIAN = createIcon("MAGICIAN");
	public static final Icon MAGNET = createIcon("MAGNET");
	public static final Icon MAGNIFYING_GLASS = createIcon("MAGNIFYING_GLASS");
	public static final Icon MAIL = createIcon("MAIL");
	public static final Icon MAIL_ATTACHMENT = createIcon("MAIL_ATTACHMENT");
	public static final Icon MAIL_BUG = createIcon("MAIL_BUG");
	public static final Icon MAIL_CLOUD = createIcon("MAIL_CLOUD");
	public static final Icon MAIL_EARTH = createIcon("MAIL_EARTH");
	public static final Icon MAIL_EXCHANGE = createIcon("MAIL_EXCHANGE");
	public static final Icon MAIL_FILTER = createIcon("MAIL_FILTER");
	public static final Icon MAIL_FORWARD = createIcon("MAIL_FORWARD");
	public static final Icon MAIL_FRONT = createIcon("MAIL_FRONT");
	public static final Icon MAIL_INTO = createIcon("MAIL_INTO");
	public static final Icon MAIL_OPEN = createIcon("MAIL_OPEN");
	public static final Icon MAIL_OPEN_LETTER = createIcon("MAIL_OPEN_LETTER");
	public static final Icon MAIL_OUT = createIcon("MAIL_OUT");
	public static final Icon MAIL_REPLY = createIcon("MAIL_REPLY");
	public static final Icon MAIL_REPLY_ALL = createIcon("MAIL_REPLY_ALL");
	public static final Icon MAIL_SEALED = createIcon("MAIL_SEALED");
	public static final Icon MAIL_VIRUS = createIcon("MAIL_VIRUS");
	public static final Icon MAIL_WRITE = createIcon("MAIL_WRITE");
	public static final Icon MAILBOX_EMPTY = createIcon("MAILBOX_EMPTY");
	public static final Icon MAILBOX_FULL = createIcon("MAILBOX_FULL");
	public static final Icon MAILS = createIcon("MAILS");
	public static final Icon MANEKI_NEKO = createIcon("MANEKI_NEKO");
	public static final Icon MAP = createIcon("MAP");
	public static final Icon MAP_LOCATION = createIcon("MAP_LOCATION");
	public static final Icon MAP_PIN = createIcon("MAP_PIN");
	public static final Icon MAP_ROADS = createIcon("MAP_ROADS");
	public static final Icon MAP_ROUTE = createIcon("MAP_ROUTE");
	public static final Icon MARIONETTE = createIcon("MARIONETTE");
	public static final Icon MARKER = createIcon("MARKER");
	public static final Icon MARKET_STAND = createIcon("MARKET_STAND");
	public static final Icon MASK = createIcon("MASK");
	public static final Icon MASKS = createIcon("MASKS");
	public static final Icon MATRYOSHKA = createIcon("MATRYOSHKA");
	public static final Icon MAXIMIZE = createIcon("MAXIMIZE");
	public static final Icon MDA = createIcon("MDA");
	public static final Icon MEASURING_CUP = createIcon("MEASURING_CUP");
	public static final Icon MEDAL = createIcon("MEDAL");
	public static final Icon MEDAL_STAR = createIcon("MEDAL_STAR");
	public static final Icon MEDIA_BEGINNING = createIcon("MEDIA_BEGINNING");
	public static final Icon MEDIA_EJECT = createIcon("MEDIA_EJECT");
	public static final Icon MEDIA_END = createIcon("MEDIA_END");
	public static final Icon MEDIA_FAST_FORWARD = createIcon("MEDIA_FAST_FORWARD");
	public static final Icon MEDIA_PAUSE = createIcon("MEDIA_PAUSE");
	public static final Icon MEDIA_PLAY = createIcon("MEDIA_PLAY");
	public static final Icon MEDIA_RECORD = createIcon("MEDIA_RECORD");
	public static final Icon MEDIA_REWIND = createIcon("MEDIA_REWIND");
	public static final Icon MEDIA_STEP_BACK = createIcon("MEDIA_STEP_BACK");
	public static final Icon MEDIA_STEP_FORWARD = createIcon("MEDIA_STEP_FORWARD");
	public static final Icon MEDIA_STOP = createIcon("MEDIA_STOP");
	public static final Icon MEDICAL_BAG = createIcon("MEDICAL_BAG");
	public static final Icon MEGAPHONE = createIcon("MEGAPHONE");
	public static final Icon MEMORY = createIcon("MEMORY");
	public static final Icon MEMORY_STICK = createIcon("MEMORY_STICK");
	public static final Icon MENORA = createIcon("MENORA");
	public static final Icon MESSAGE = createIcon("MESSAGE");
	public static final Icon MESSAGES = createIcon("MESSAGES");
	public static final Icon MICROPHONE = createIcon("MICROPHONE");
	public static final Icon MICROSCOPE = createIcon("MICROSCOPE");
	public static final Icon MICROWAVE_OVEN = createIcon("MICROWAVE_OVEN");
	public static final Icon MILK = createIcon("MILK");
	public static final Icon MINIBUS = createIcon("MINIBUS");
	public static final Icon MINIMIZE = createIcon("MINIMIZE");
	public static final Icon MINUS = createIcon("MINUS");
	public static final Icon MIRROR_HORIZONTALLY = createIcon("MIRROR_HORIZONTALLY");
	public static final Icon MIRROR_VERTICALLY = createIcon("MIRROR_VERTICALLY");
	public static final Icon MISSILE = createIcon("MISSILE");
	public static final Icon MISSILE_ALT = createIcon("MISSILE_ALT");
	public static final Icon MOBILE_CRANE = createIcon("MOBILE_CRANE");
	public static final Icon MOBILE_PHONE = createIcon("MOBILE_PHONE");
	public static final Icon MOBILE_PHONE_FOLDING = createIcon("MOBILE_PHONE_FOLDING");
	public static final Icon MOBILE_PHONE_KEYS = createIcon("MOBILE_PHONE_KEYS");
	public static final Icon MODEM = createIcon("MODEM");
	public static final Icon MODEM_EARTH = createIcon("MODEM_EARTH");
	public static final Icon MOLECULE_H2O = createIcon("MOLECULE_H2O");
	public static final Icon MONEY_BILL = createIcon("MONEY_BILL");
	public static final Icon MONEY_BILL_COINS = createIcon("MONEY_BILL_COINS");
	public static final Icon MONEY_BILL_CUT = createIcon("MONEY_BILL_CUT");
	public static final Icon MONEY_BILL_DOLLAR = createIcon("MONEY_BILL_DOLLAR");
	public static final Icon MONEY_BILL_EURO = createIcon("MONEY_BILL_EURO");
	public static final Icon MONEY_BILL_FIRE = createIcon("MONEY_BILL_FIRE");
	public static final Icon MONEY_BILL_REFUND = createIcon("MONEY_BILL_REFUND");
	public static final Icon MONEY_BILLS = createIcon("MONEY_BILLS");
	public static final Icon MONEY_COIN = createIcon("MONEY_COIN");
	public static final Icon MONEY_COINS = createIcon("MONEY_COINS");
	public static final Icon MONEY_COINS_STACKED = createIcon("MONEY_COINS_STACKED");
	public static final Icon MONEY_INTEREST = createIcon("MONEY_INTEREST");
	public static final Icon MONEYBAG = createIcon("MONEYBAG");
	public static final Icon MONEYBAG_COINS = createIcon("MONEYBAG_COINS");
	public static final Icon MONEYBAG_DOLLAR = createIcon("MONEYBAG_DOLLAR");
	public static final Icon MONEYBAG_EURO = createIcon("MONEYBAG_EURO");
	public static final Icon MONITOR = createIcon("MONITOR");
	public static final Icon MONITOR_BRUSH = createIcon("MONITOR_BRUSH");
	public static final Icon MONITOR_HEIGHT = createIcon("MONITOR_HEIGHT");
	public static final Icon MONITOR_SIZE = createIcon("MONITOR_SIZE");
	public static final Icon MONITOR_SLEEP = createIcon("MONITOR_SLEEP");
	public static final Icon MONITOR_TEST_CARD = createIcon("MONITOR_TEST_CARD");
	public static final Icon MONITOR_TOUCH = createIcon("MONITOR_TOUCH");
	public static final Icon MONITOR_VIDEO_CHAT = createIcon("MONITOR_VIDEO_CHAT");
	public static final Icon MONITOR_WIDTH = createIcon("MONITOR_WIDTH");
	public static final Icon MOON = createIcon("MOON");
	public static final Icon MOON_HALF = createIcon("MOON_HALF");
	public static final Icon MOSQUE = createIcon("MOSQUE");
	public static final Icon MOSQUITO = createIcon("MOSQUITO");
	public static final Icon MOTOR_SCOOTER = createIcon("MOTOR_SCOOTER");
	public static final Icon MOTORBIKE = createIcon("MOTORBIKE");
	public static final Icon MOTORCYCLE_HELMET = createIcon("MOTORCYCLE_HELMET");
	public static final Icon MOTORCYCLIST = createIcon("MOTORCYCLIST");
	public static final Icon MOUSE = createIcon("MOUSE");
	public static final Icon MOUSE_ALT = createIcon("MOUSE_ALT");
	public static final Icon MOUSE_LEFT_BUTTON = createIcon("MOUSE_LEFT_BUTTON");
	public static final Icon MOUSE_LEFT_BUTTON_ALT = createIcon("MOUSE_LEFT_BUTTON_ALT");
	public static final Icon MOUSE_POINTER = createIcon("MOUSE_POINTER");
	public static final Icon MOUSE_RIGHT_BUTTON = createIcon("MOUSE_RIGHT_BUTTON");
	public static final Icon MOUSE_RIGHT_BUTTON_ALT = createIcon("MOUSE_RIGHT_BUTTON_ALT");
	public static final Icon MOUSETRAP = createIcon("MOUSETRAP");
	public static final Icon MOVIE = createIcon("MOVIE");
	public static final Icon MOVIE_CAMERA = createIcon("MOVIE_CAMERA");
	public static final Icon MOVIES = createIcon("MOVIES");
	public static final Icon MOVING_TRUCK = createIcon("MOVING_TRUCK");
	public static final Icon MUG = createIcon("MUG");
	public static final Icon MUG_TEA = createIcon("MUG_TEA");
	public static final Icon MULTIMETER = createIcon("MULTIMETER");
	public static final Icon MULTIMETER_ANALOG = createIcon("MULTIMETER_ANALOG");
	public static final Icon MUSHROOM = createIcon("MUSHROOM");
	public static final Icon MUSIC = createIcon("MUSIC");
	public static final Icon NAIL = createIcon("NAIL");
	public static final Icon NAV_DOWN = createIcon("NAV_DOWN");
	public static final Icon NAV_DOWN_LEFT = createIcon("NAV_DOWN_LEFT");
	public static final Icon NAV_DOWN_RIGHT = createIcon("NAV_DOWN_RIGHT");
	public static final Icon NAV_LEFT = createIcon("NAV_LEFT");
	public static final Icon NAV_PLAIN = createIcon("NAV_PLAIN");
	public static final Icon NAV_REDO = createIcon("NAV_REDO");
	public static final Icon NAV_REFRESH = createIcon("NAV_REFRESH");
	public static final Icon NAV_RIGHT = createIcon("NAV_RIGHT");
	public static final Icon NAV_UNDO = createIcon("NAV_UNDO");
	public static final Icon NAV_UP = createIcon("NAV_UP");
	public static final Icon NAV_UP_LEFT = createIcon("NAV_UP_LEFT");
	public static final Icon NAV_UP_RIGHT = createIcon("NAV_UP_RIGHT");
	public static final Icon NAVIGATE_BEGINNING = createIcon("NAVIGATE_BEGINNING");
	public static final Icon NAVIGATE_CHECK = createIcon("NAVIGATE_CHECK");
	public static final Icon NAVIGATE_CLOSE = createIcon("NAVIGATE_CLOSE");
	public static final Icon NAVIGATE_CROSS = createIcon("NAVIGATE_CROSS");
	public static final Icon NAVIGATE_DOWN = createIcon("NAVIGATE_DOWN");
	public static final Icon NAVIGATE_DOWN_TWO = createIcon("NAVIGATE_DOWN_TWO");
	public static final Icon NAVIGATE_END = createIcon("NAVIGATE_END");
	public static final Icon NAVIGATE_LEFT = createIcon("NAVIGATE_LEFT");
	public static final Icon NAVIGATE_LEFT_TWO = createIcon("NAVIGATE_LEFT_TWO");
	public static final Icon NAVIGATE_MINUS = createIcon("NAVIGATE_MINUS");
	public static final Icon NAVIGATE_OPEN = createIcon("NAVIGATE_OPEN");
	public static final Icon NAVIGATE_PLUS = createIcon("NAVIGATE_PLUS");
	public static final Icon NAVIGATE_RIGHT = createIcon("NAVIGATE_RIGHT");
	public static final Icon NAVIGATE_RIGHT_TWO = createIcon("NAVIGATE_RIGHT_TWO");
	public static final Icon NAVIGATE_UP = createIcon("NAVIGATE_UP");
	public static final Icon NAVIGATE_UP_TWO = createIcon("NAVIGATE_UP_TWO");
	public static final Icon NETWORK_NODE = createIcon("NETWORK_NODE");
	public static final Icon NETWORK_NODE_T = createIcon("NETWORK_NODE_T");
	public static final Icon NEWSPAPER = createIcon("NEWSPAPER");
	public static final Icon NEWTONS_CRADLE = createIcon("NEWTONS_CRADLE");
	public static final Icon NONPROFIT = createIcon("NONPROFIT");
	public static final Icon NOSE = createIcon("NOSE");
	public static final Icon NOTE = createIcon("NOTE");
	public static final Icon NOTE_BLOCK = createIcon("NOTE_BLOCK");
	public static final Icon NOTE_PINNED = createIcon("NOTE_PINNED");
	public static final Icon NOTE_TEXT = createIcon("NOTE_TEXT");
	public static final Icon NOTEBOOK = createIcon("NOTEBOOK");
	public static final Icon NOTEBOOK2 = createIcon("NOTEBOOK2");
	public static final Icon NOTEBOOK3 = createIcon("NOTEBOOK3");
	public static final Icon NUMERIC_KEYPAD = createIcon("NUMERIC_KEYPAD");
	public static final Icon OBJECT_ALIGNMENT_BOTTOM = createIcon("OBJECT_ALIGNMENT_BOTTOM");
	public static final Icon OBJECT_ALIGNMENT_CENTER = createIcon("OBJECT_ALIGNMENT_CENTER");
	public static final Icon OBJECT_ALIGNMENT_HORIZONTAL = createIcon("OBJECT_ALIGNMENT_HORIZONTAL");
	public static final Icon OBJECT_ALIGNMENT_LEFT = createIcon("OBJECT_ALIGNMENT_LEFT");
	public static final Icon OBJECT_ALIGNMENT_RIGHT = createIcon("OBJECT_ALIGNMENT_RIGHT");
	public static final Icon OBJECT_ALIGNMENT_TOP = createIcon("OBJECT_ALIGNMENT_TOP");
	public static final Icon OBJECT_ALIGNMENT_VERTICAL = createIcon("OBJECT_ALIGNMENT_VERTICAL");
	public static final Icon OBJECT_BALL = createIcon("OBJECT_BALL");
	public static final Icon OBJECT_CONE = createIcon("OBJECT_CONE");
	public static final Icon OBJECT_CUBE = createIcon("OBJECT_CUBE");
	public static final Icon OBJECT_CYLINDER = createIcon("OBJECT_CYLINDER");
	public static final Icon OBJECTS = createIcon("OBJECTS");
	public static final Icon OBJECTS_CONE_BALL = createIcon("OBJECTS_CONE_BALL");
	public static final Icon OBJECTS_CONE_TO_CUBE = createIcon("OBJECTS_CONE_TO_CUBE");
	public static final Icon OBJECTS_CUBE_BALL = createIcon("OBJECTS_CUBE_BALL");
	public static final Icon OBJECTS_CUBE_CONE = createIcon("OBJECTS_CUBE_CONE");
	public static final Icon OBJECTS_CUBE_TO_CONE = createIcon("OBJECTS_CUBE_TO_CONE");
	public static final Icon OBJECTS_EXCHANGE = createIcon("OBJECTS_EXCHANGE");
	public static final Icon ODOMETER = createIcon("ODOMETER");
	public static final Icon OFFICE_BUILDING = createIcon("OFFICE_BUILDING");
	public static final Icon OFFICE_BUILDINGS = createIcon("OFFICE_BUILDINGS");
	public static final Icon OFFICE_CHAIR = createIcon("OFFICE_CHAIR");
	public static final Icon OIL_PLATFORM = createIcon("OIL_PLATFORM");
	public static final Icon OIL_PUMP = createIcon("OIL_PUMP");
	public static final Icon OK = createIcon("OK");
	public static final Icon ORANGE = createIcon("ORANGE");
	public static final Icon PACEMAKER = createIcon("PACEMAKER");
	public static final Icon PACIFIER = createIcon("PACIFIER");
	public static final Icon PACKAGE = createIcon("PACKAGE");
	public static final Icon PACKAGING_PAPER = createIcon("PACKAGING_PAPER");
	public static final Icon PACKAGING_TAPE = createIcon("PACKAGING_TAPE");
	public static final Icon PAGER = createIcon("PAGER");
	public static final Icon PAGODA = createIcon("PAGODA");
	public static final Icon PAINT_BRUSH = createIcon("PAINT_BRUSH");
	public static final Icon PAINT_BUCKET = createIcon("PAINT_BUCKET");
	public static final Icon PAINT_ROLLER = createIcon("PAINT_ROLLER");
	public static final Icon PAINTERS_PALETTE = createIcon("PAINTERS_PALETTE");
	public static final Icon PAINTERS_PALETTE_ALT = createIcon("PAINTERS_PALETTE_ALT");
	public static final Icon PAINTERS_PALETTE_BRUSH = createIcon("PAINTERS_PALETTE_BRUSH");
	public static final Icon PAINTERS_PALETTE_EMPTY = createIcon("PAINTERS_PALETTE_EMPTY");
	public static final Icon PAINTING_LANDSCAPE = createIcon("PAINTING_LANDSCAPE");
	public static final Icon PAINTING_PORTRAIT = createIcon("PAINTING_PORTRAIT");
	public static final Icon PALM_TREE = createIcon("PALM_TREE");
	public static final Icon PAN_FLUTE = createIcon("PAN_FLUTE");
	public static final Icon PAPER_FAN = createIcon("PAPER_FAN");
	public static final Icon PAPER_JET = createIcon("PAPER_JET");
	public static final Icon PAPER_LANTERN = createIcon("PAPER_LANTERN");
	public static final Icon PAPER_ROLL = createIcon("PAPER_ROLL");
	public static final Icon PAPERCLIP = createIcon("PAPERCLIP");
	public static final Icon PAPERCLIP_OVAL = createIcon("PAPERCLIP_OVAL");
	public static final Icon PARASOL = createIcon("PARASOL");
	public static final Icon PARKING_METER = createIcon("PARKING_METER");
	public static final Icon PASSPORT = createIcon("PASSPORT");
	public static final Icon PASSWORD_FIELD = createIcon("PASSWORD_FIELD");
	public static final Icon PASTOR = createIcon("PASTOR");
	public static final Icon PAWN = createIcon("PAWN");
	public static final Icon PCI_CARD = createIcon("PCI_CARD");
	public static final Icon PCI_CARD_NETWORK = createIcon("PCI_CARD_NETWORK");
	public static final Icon PDA = createIcon("PDA");
	public static final Icon PDA_WRITE = createIcon("PDA_WRITE");
	public static final Icon PENCIL = createIcon("PENCIL");
	public static final Icon PENS = createIcon("PENS");
	public static final Icon PENTAGRAM = createIcon("PENTAGRAM");
	public static final Icon PERFUME = createIcon("PERFUME");
	public static final Icon PERSON = createIcon("PERSON");
	public static final Icon PET_BOTTLE = createIcon("PET_BOTTLE");
	public static final Icon PETRI_DISH = createIcon("PETRI_DISH");
	public static final Icon PHONE_CONFERENCE = createIcon("PHONE_CONFERENCE");
	public static final Icon PHONE_HANG_UP = createIcon("PHONE_HANG_UP");
	public static final Icon PHONE_PICK_UP = createIcon("PHONE_PICK_UP");
	public static final Icon PHONE_RECEIVER = createIcon("PHONE_RECEIVER");
	public static final Icon PHONE_RECEIVER_VERTICAL = createIcon("PHONE_RECEIVER_VERTICAL");
	public static final Icon PHONE_SPEAKER = createIcon("PHONE_SPEAKER");
	public static final Icon PHONE_SPEECH_BUBBLE = createIcon("PHONE_SPEECH_BUBBLE");
	public static final Icon PHOTO_LANDSCAPE = createIcon("PHOTO_LANDSCAPE");
	public static final Icon PHOTO_PORTRAIT = createIcon("PHOTO_PORTRAIT");
	public static final Icon PHOTOGRAPHIC_FILTER = createIcon("PHOTOGRAPHIC_FILTER");
	public static final Icon PHOTOGRAPHIC_FILTERS = createIcon("PHOTOGRAPHIC_FILTERS");
	public static final Icon PHOTOS = createIcon("PHOTOS");
	public static final Icon PIECE = createIcon("PIECE");
	public static final Icon PIECE_ALT = createIcon("PIECE_ALT");
	public static final Icon PIECES = createIcon("PIECES");
	public static final Icon PIG = createIcon("PIG");
	public static final Icon PIGGY_BANK = createIcon("PIGGY_BANK");
	public static final Icon PILL = createIcon("PILL");
	public static final Icon PILL_CAPSULE = createIcon("PILL_CAPSULE");
	public static final Icon PILOT = createIcon("PILOT");
	public static final Icon PIN = createIcon("PIN");
	public static final Icon PIN_ROUND_HEAD = createIcon("PIN_ROUND_HEAD");
	public static final Icon PINEAPPLE = createIcon("PINEAPPLE");
	public static final Icon PIPETTE = createIcon("PIPETTE");
	public static final Icon PIPETTE_TEST = createIcon("PIPETTE_TEST");
	public static final Icon PIRATES_SHIP = createIcon("PIRATES_SHIP");
	public static final Icon PLANE_TOOL = createIcon("PLANE_TOOL");
	public static final Icon PLANET = createIcon("PLANET");
	public static final Icon PLANK = createIcon("PLANK");
	public static final Icon PLANKS = createIcon("PLANKS");
	public static final Icon PLANT = createIcon("PLANT");
	public static final Icon PLATFORM_TRUCK_BOX = createIcon("PLATFORM_TRUCK_BOX");
	public static final Icon PLATFORM_TRUCK_EMPTY = createIcon("PLATFORM_TRUCK_EMPTY");
	public static final Icon PLATFORM_TRUCK_SUITCASE = createIcon("PLATFORM_TRUCK_SUITCASE");
	public static final Icon PLAYING_CARD_CLUBS = createIcon("PLAYING_CARD_CLUBS");
	public static final Icon PLAYING_CARD_DIAMONDS = createIcon("PLAYING_CARD_DIAMONDS");
	public static final Icon PLAYING_CARD_HEARTS = createIcon("PLAYING_CARD_HEARTS");
	public static final Icon PLAYING_CARD_SPADES = createIcon("PLAYING_CARD_SPADES");
	public static final Icon PLAYING_CARDS = createIcon("PLAYING_CARDS");
	public static final Icon PLAYING_CARDS_DECK = createIcon("PLAYING_CARDS_DECK");
	public static final Icon PLIERS = createIcon("PLIERS");
	public static final Icon PLUG = createIcon("PLUG");
	public static final Icon PLUG_CINCH = createIcon("PLUG_CINCH");
	public static final Icon PLUG_CORD = createIcon("PLUG_CORD");
	public static final Icon PLUG_LAN = createIcon("PLUG_LAN");
	public static final Icon PLUG_USB = createIcon("PLUG_USB");
	public static final Icon PLUS = createIcon("PLUS");
	public static final Icon PODIUM = createIcon("PODIUM");
	public static final Icon PODIUM_TROPHY = createIcon("PODIUM_TROPHY");
	public static final Icon POISON = createIcon("POISON");
	public static final Icon POLICE_CAR = createIcon("POLICE_CAR");
	public static final Icon POLICEMAN = createIcon("POLICEMAN");
	public static final Icon POLICEMAN_BOBBY = createIcon("POLICEMAN_BOBBY");
	public static final Icon PONTIFEX = createIcon("PONTIFEX");
	public static final Icon POOL_BALLS = createIcon("POOL_BALLS");
	public static final Icon PORTABLE_BARCODE_SCANNER = createIcon("PORTABLE_BARCODE_SCANNER");
	public static final Icon PORTFOLIO_FOLDER = createIcon("PORTFOLIO_FOLDER");
	public static final Icon POST_HORN = createIcon("POST_HORN");
	public static final Icon POSTAGE_STAMP = createIcon("POSTAGE_STAMP");
	public static final Icon POWER = createIcon("POWER");
	public static final Icon POWER_DRILL = createIcon("POWER_DRILL");
	public static final Icon PRECISION_KNIFE = createIcon("PRECISION_KNIFE");
	public static final Icon PRECISION_SQUARE = createIcon("PRECISION_SQUARE");
	public static final Icon PRESENTATION = createIcon("PRESENTATION");
	public static final Icon PRESENTATION_PIE_CHART = createIcon("PRESENTATION_PIE_CHART");
	public static final Icon PRESS = createIcon("PRESS");
	public static final Icon PRESSURE_SPRAYER = createIcon("PRESSURE_SPRAYER");
	public static final Icon PRETZEL = createIcon("PRETZEL");
	public static final Icon PRICE_STICKER = createIcon("PRICE_STICKER");
	public static final Icon PRINT_CALCULATOR = createIcon("PRINT_CALCULATOR");
	public static final Icon PRINT_LAYOUT_CONTINOUS = createIcon("PRINT_LAYOUT_CONTINOUS");
	public static final Icon PRINT_LAYOUT_SINGLE = createIcon("PRINT_LAYOUT_SINGLE");
	public static final Icon PRINTER = createIcon("PRINTER");
	public static final Icon PRINTER_NETWORK = createIcon("PRINTER_NETWORK");
	public static final Icon PRINTER_PHOTO = createIcon("PRINTER_PHOTO");
	public static final Icon PROGRESS_BAR = createIcon("PROGRESS_BAR");
	public static final Icon PROJECTOR = createIcon("PROJECTOR");
	public static final Icon PUMPKIN = createIcon("PUMPKIN");
	public static final Icon PUMPKIN_HALLOWEEN = createIcon("PUMPKIN_HALLOWEEN");
	public static final Icon PUNCHING_BAG = createIcon("PUNCHING_BAG");
	public static final Icon PURCHASE_ORDER = createIcon("PURCHASE_ORDER");
	public static final Icon PURSE = createIcon("PURSE");
	public static final Icon PYLON = createIcon("PYLON");
	public static final Icon QUAD = createIcon("QUAD");
	public static final Icon QUESTION = createIcon("QUESTION");
	public static final Icon QUESTION_AND_ANSWER = createIcon("QUESTION_AND_ANSWER");
	public static final Icon QUOTATION_MARK_LEFT = createIcon("QUOTATION_MARK_LEFT");
	public static final Icon QUOTATION_MARK_RIGHT = createIcon("QUOTATION_MARK_RIGHT");
	public static final Icon QUOTATION_MARKS = createIcon("QUOTATION_MARKS");
	public static final Icon RACK_SERVER = createIcon("RACK_SERVER");
	public static final Icon RACK_SERVER_NETWORK = createIcon("RACK_SERVER_NETWORK");
	public static final Icon RACK_SERVERS = createIcon("RACK_SERVERS");
	public static final Icon RADAR = createIcon("RADAR");
	public static final Icon RADIATION = createIcon("RADIATION");
	public static final Icon RADIO = createIcon("RADIO");
	public static final Icon RADIO_BUTTON_GROUP = createIcon("RADIO_BUTTON_GROUP");
	public static final Icon RADIO_BUTTON_SELECTED = createIcon("RADIO_BUTTON_SELECTED");
	public static final Icon RADIO_BUTTON_UNSELECTED = createIcon("RADIO_BUTTON_UNSELECTED");
	public static final Icon RAIN_DROPS = createIcon("RAIN_DROPS");
	public static final Icon RAZOR = createIcon("RAZOR");
	public static final Icon REACTOR = createIcon("REACTOR");
	public static final Icon RECEIPT = createIcon("RECEIPT");
	public static final Icon RECEIPT_BOOK = createIcon("RECEIPT_BOOK");
	public static final Icon RECEIPT_PRINTER = createIcon("RECEIPT_PRINTER");
	public static final Icon RECORD = createIcon("RECORD");
	public static final Icon RECORD_PLAYER = createIcon("RECORD_PLAYER");
	public static final Icon RECYCLE = createIcon("RECYCLE");
	public static final Icon REDO = createIcon("REDO");
	public static final Icon REFRESH = createIcon("REFRESH");
	public static final Icon REGISTRY = createIcon("REGISTRY");
	public static final Icon REMOTE_CONTROL = createIcon("REMOTE_CONTROL");
	public static final Icon REMOTE_CONTROL_INFRARED = createIcon("REMOTE_CONTROL_INFRARED");
	public static final Icon REPEAT = createIcon("REPEAT");
	public static final Icon RESIZE = createIcon("RESIZE");
	public static final Icon RETICLE = createIcon("RETICLE");
	public static final Icon RFID_CHIP = createIcon("RFID_CHIP");
	public static final Icon RFQ = createIcon("RFQ");
	public static final Icon ROAD_ROLLER = createIcon("ROAD_ROLLER");
	public static final Icon ROBOT = createIcon("ROBOT");
	public static final Icon ROCKET = createIcon("ROCKET");
	public static final Icon ROCKING_HORSE = createIcon("ROCKING_HORSE");
	public static final Icon ROTATE_LEFT = createIcon("ROTATE_LEFT");
	public static final Icon ROTATE_RIGHT = createIcon("ROTATE_RIGHT");
	public static final Icon ROULETTE_WHEEL = createIcon("ROULETTE_WHEEL");
	public static final Icon ROUTE_SIGN = createIcon("ROUTE_SIGN");
	public static final Icon ROUTER = createIcon("ROUTER");
	public static final Icon RSS = createIcon("RSS");
	public static final Icon RUBBER_STAMP = createIcon("RUBBER_STAMP");
	public static final Icon SAFE = createIcon("SAFE");
	public static final Icon SAFE_INTO = createIcon("SAFE_INTO");
	public static final Icon SAFE_OPEN_EMPTY = createIcon("SAFE_OPEN_EMPTY");
	public static final Icon SAFE_OPEN_FULL = createIcon("SAFE_OPEN_FULL");
	public static final Icon SAFE_OUT = createIcon("SAFE_OUT");
	public static final Icon SAFETY_GLASSES = createIcon("SAFETY_GLASSES");
	public static final Icon SAFETY_PIN = createIcon("SAFETY_PIN");
	public static final Icon SAFETY_PIN_OPEN = createIcon("SAFETY_PIN_OPEN");
	public static final Icon SAILBOAT = createIcon("SAILBOAT");
	public static final Icon SALES_QUOTATION = createIcon("SALES_QUOTATION");
	public static final Icon SATELLITE = createIcon("SATELLITE");
	public static final Icon SATELLITE_DISH = createIcon("SATELLITE_DISH");
	public static final Icon SAUSAGE = createIcon("SAUSAGE");
	public static final Icon SAVE_AS = createIcon("SAVE_AS");
	public static final Icon SCALES = createIcon("SCALES");
	public static final Icon SCALPEL = createIcon("SCALPEL");
	public static final Icon SCANNER = createIcon("SCANNER");
	public static final Icon SCHOOL = createIcon("SCHOOL");
	public static final Icon SCHOOLBOY = createIcon("SCHOOLBOY");
	public static final Icon SCHOOLBUS = createIcon("SCHOOLBUS");
	public static final Icon SCHOOLBUS_FRONT = createIcon("SCHOOLBUS_FRONT");
	public static final Icon SCIENTIST = createIcon("SCIENTIST");
	public static final Icon SCOOTER = createIcon("SCOOTER");
	public static final Icon SCORE_BOARD = createIcon("SCORE_BOARD");
	public static final Icon SCREWDRIVER = createIcon("SCREWDRIVER");
	public static final Icon SCROLL = createIcon("SCROLL");
	public static final Icon SCROLL_BAR_HORIZONTAL = createIcon("SCROLL_BAR_HORIZONTAL");
	public static final Icon SCROLL_BAR_VERTICAL = createIcon("SCROLL_BAR_VERTICAL");
	public static final Icon SCROLL_CLOSED = createIcon("SCROLL_CLOSED");
	public static final Icon SD_CARD = createIcon("SD_CARD");
	public static final Icon SEARCH_REPLACE = createIcon("SEARCH_REPLACE");
	public static final Icon SECURITY_AGENT = createIcon("SECURITY_AGENT");
	public static final Icon SECURITY_BADGE = createIcon("SECURITY_BADGE");
	public static final Icon SELECTION = createIcon("SELECTION");
	public static final Icon SELECTION_DELETE = createIcon("SELECTION_DELETE");
	public static final Icon SELECTION_FIND = createIcon("SELECTION_FIND");
	public static final Icon SELECTION_RECYCLE = createIcon("SELECTION_RECYCLE");
	public static final Icon SELECTION_REFRESH = createIcon("SELECTION_REFRESH");
	public static final Icon SELECTION_VIEW = createIcon("SELECTION_VIEW");
	public static final Icon SENIOR_CITIZEN_FEMALE = createIcon("SENIOR_CITIZEN_FEMALE");
	public static final Icon SENIOR_CITIZEN_MALE = createIcon("SENIOR_CITIZEN_MALE");
	public static final Icon SERVER = createIcon("SERVER");
	public static final Icon SERVER_ALT = createIcon("SERVER_ALT");
	public static final Icon SERVER_CLIENT = createIcon("SERVER_CLIENT");
	public static final Icon SERVER_CLIENT_EXCHANGE = createIcon("SERVER_CLIENT_EXCHANGE");
	public static final Icon SERVER_CLOUD = createIcon("SERVER_CLOUD");
	public static final Icon SERVER_DOCUMENT = createIcon("SERVER_DOCUMENT");
	public static final Icon SERVER_EARTH = createIcon("SERVER_EARTH");
	public static final Icon SERVER_FROM_CLIENT = createIcon("SERVER_FROM_CLIENT");
	public static final Icon SERVER_ID_CARD = createIcon("SERVER_ID_CARD");
	public static final Icon SERVER_INTO = createIcon("SERVER_INTO");
	public static final Icon SERVER_MAIL = createIcon("SERVER_MAIL");
	public static final Icon SERVER_MAIL_DOWNLOAD = createIcon("SERVER_MAIL_DOWNLOAD");
	public static final Icon SERVER_MAIL_UPLOAD = createIcon("SERVER_MAIL_UPLOAD");
	public static final Icon SERVER_NETWORK = createIcon("SERVER_NETWORK");
	public static final Icon SERVER_OUT = createIcon("SERVER_OUT");
	public static final Icon SERVER_TO_CLIENT = createIcon("SERVER_TO_CLIENT");
	public static final Icon SERVICE_BELL = createIcon("SERVICE_BELL");
	public static final Icon SET_SQUARE = createIcon("SET_SQUARE");
	public static final Icon SEWING_MACHINE = createIcon("SEWING_MACHINE");
	public static final Icon SHAPE_CIRCLE = createIcon("SHAPE_CIRCLE");
	public static final Icon SHAPE_ELLIPSE = createIcon("SHAPE_ELLIPSE");
	public static final Icon SHAPE_HEXAGON = createIcon("SHAPE_HEXAGON");
	public static final Icon SHAPE_OCTAGON = createIcon("SHAPE_OCTAGON");
	public static final Icon SHAPE_PENTAGON = createIcon("SHAPE_PENTAGON");
	public static final Icon SHAPE_RECTANGLE = createIcon("SHAPE_RECTANGLE");
	public static final Icon SHAPE_RHOMB = createIcon("SHAPE_RHOMB");
	public static final Icon SHAPE_SQUARE = createIcon("SHAPE_SQUARE");
	public static final Icon SHAPE_TRIANGLE = createIcon("SHAPE_TRIANGLE");
	public static final Icon SHAPES = createIcon("SHAPES");
	public static final Icon SHARE = createIcon("SHARE");
	public static final Icon SHELF_EMPTY = createIcon("SHELF_EMPTY");
	public static final Icon SHELF_FULL = createIcon("SHELF_FULL");
	public static final Icon SHIELD = createIcon("SHIELD");
	public static final Icon SHIP = createIcon("SHIP");
	public static final Icon SHIPS_WHEEL = createIcon("SHIPS_WHEEL");
	public static final Icon SHOPPING_BAG = createIcon("SHOPPING_BAG");
	public static final Icon SHOPPING_BAG_FULL = createIcon("SHOPPING_BAG_FULL");
	public static final Icon SHOPPING_BASKET = createIcon("SHOPPING_BASKET");
	public static final Icon SHOPPING_BASKET_FULL = createIcon("SHOPPING_BASKET_FULL");
	public static final Icon SHOPPING_CART = createIcon("SHOPPING_CART");
	public static final Icon SHOPPING_CART_FULL = createIcon("SHOPPING_CART_FULL");
	public static final Icon SHOWER_GEL = createIcon("SHOWER_GEL");
	public static final Icon SHREDDER = createIcon("SHREDDER");
	public static final Icon SHUTTER = createIcon("SHUTTER");
	public static final Icon SHUTTLECOCK = createIcon("SHUTTLECOCK");
	public static final Icon SICKLE = createIcon("SICKLE");
	public static final Icon SIGN_FORBIDDEN = createIcon("SIGN_FORBIDDEN");
	public static final Icon SIGN_STOP = createIcon("SIGN_STOP");
	public static final Icon SIGN_WARNING = createIcon("SIGN_WARNING");
	public static final Icon SIGN_WARNING_BIOHAZARD = createIcon("SIGN_WARNING_BIOHAZARD");
	public static final Icon SIGN_WARNING_FLAMMABLE = createIcon("SIGN_WARNING_FLAMMABLE");
	public static final Icon SIGN_WARNING_HARMFUL = createIcon("SIGN_WARNING_HARMFUL");
	public static final Icon SIGN_WARNING_RADIATION = createIcon("SIGN_WARNING_RADIATION");
	public static final Icon SIGN_WARNING_TOXIC = createIcon("SIGN_WARNING_TOXIC");
	public static final Icon SIGN_WARNING_VOLTAGE = createIcon("SIGN_WARNING_VOLTAGE");
	public static final Icon SIGN_YIELD = createIcon("SIGN_YIELD");
	public static final Icon SIGNAL_FLAG = createIcon("SIGNAL_FLAG");
	public static final Icon SIGNAL_FLAG_CHECKERED = createIcon("SIGNAL_FLAG_CHECKERED");
	public static final Icon SIGNAL_STRENGTH_0 = createIcon("SIGNAL_STRENGTH_0");
	public static final Icon SIGNAL_STRENGTH_1 = createIcon("SIGNAL_STRENGTH_1");
	public static final Icon SIGNAL_STRENGTH_2 = createIcon("SIGNAL_STRENGTH_2");
	public static final Icon SIGNAL_STRENGTH_3 = createIcon("SIGNAL_STRENGTH_3");
	public static final Icon SIGNAL_STRENGTH_4 = createIcon("SIGNAL_STRENGTH_4");
	public static final Icon SIGNAL_STRENGTH_5 = createIcon("SIGNAL_STRENGTH_5");
	public static final Icon SIGNALING_DISC = createIcon("SIGNALING_DISC");
	public static final Icon SIGNBOARD_CLOSED = createIcon("SIGNBOARD_CLOSED");
	public static final Icon SIGNBOARD_EMPTY = createIcon("SIGNBOARD_EMPTY");
	public static final Icon SIGNBOARD_FOR_RENT = createIcon("SIGNBOARD_FOR_RENT");
	public static final Icon SIGNBOARD_FOR_SALE = createIcon("SIGNBOARD_FOR_SALE");
	public static final Icon SIGNBOARD_OPEN = createIcon("SIGNBOARD_OPEN");
	public static final Icon SIGNBOARD_SOLD = createIcon("SIGNBOARD_SOLD");
	public static final Icon SIGNPOST = createIcon("SIGNPOST");
	public static final Icon SIGNPOST_THREE = createIcon("SIGNPOST_THREE");
	public static final Icon SIGNPOST_TWO = createIcon("SIGNPOST_TWO");
	public static final Icon SIM_CARD = createIcon("SIM_CARD");
	public static final Icon SINGER = createIcon("SINGER");
	public static final Icon SIXPACK_BEER = createIcon("SIXPACK_BEER");
	public static final Icon SIZES = createIcon("SIZES");
	public static final Icon SKATEBOARD = createIcon("SKATEBOARD");
	public static final Icon SKIN_COW = createIcon("SKIN_COW");
	public static final Icon SKIN_TIGER = createIcon("SKIN_TIGER");
	public static final Icon SKULL = createIcon("SKULL");
	public static final Icon SKULL_BONES = createIcon("SKULL_BONES");
	public static final Icon SLEDGE = createIcon("SLEDGE");
	public static final Icon SLIDER = createIcon("SLIDER");
	public static final Icon SLINGSHOT = createIcon("SLINGSHOT");
	public static final Icon SMALL_TRUCK = createIcon("SMALL_TRUCK");
	public static final Icon SMARTCARD = createIcon("SMARTCARD");
	public static final Icon SMARTPHONE = createIcon("SMARTPHONE");
	public static final Icon SMARTPHONE_CLOUD = createIcon("SMARTPHONE_CLOUD");
	public static final Icon SMS = createIcon("SMS");
	public static final Icon SNOWFLAKE = createIcon("SNOWFLAKE");
	public static final Icon SNOWMAN = createIcon("SNOWMAN");
	public static final Icon SOAP_DISPENSER = createIcon("SOAP_DISPENSER");
	public static final Icon SOCCER_BALL = createIcon("SOCCER_BALL");
	public static final Icon SOLAR_PANEL = createIcon("SOLAR_PANEL");
	public static final Icon SORT = createIcon("SORT");
	public static final Icon SORT_19_ASCENDING = createIcon("SORT_19_ASCENDING");
	public static final Icon SORT_19_DESCENDING = createIcon("SORT_19_DESCENDING");
	public static final Icon SORT_ASCENDING = createIcon("SORT_ASCENDING");
	public static final Icon SORT_ASCENDING_UP = createIcon("SORT_ASCENDING_UP");
	public static final Icon SORT_AZ_ASCENDING = createIcon("SORT_AZ_ASCENDING");
	public static final Icon SORT_AZ_ASCENDING_UP = createIcon("SORT_AZ_ASCENDING_UP");
	public static final Icon SORT_AZ_DESCENDING = createIcon("SORT_AZ_DESCENDING");
	public static final Icon SORT_AZ_DESCENDING_UP = createIcon("SORT_AZ_DESCENDING_UP");
	public static final Icon SORT_DESCENDING = createIcon("SORT_DESCENDING");
	public static final Icon SORT_DESCENDING_UP = createIcon("SORT_DESCENDING_UP");
	public static final Icon SORT_DOWN = createIcon("SORT_DOWN");
	public static final Icon SORT_DOWN_MINUS = createIcon("SORT_DOWN_MINUS");
	public static final Icon SORT_DOWN_PLUS = createIcon("SORT_DOWN_PLUS");
	public static final Icon SORT_UP = createIcon("SORT_UP");
	public static final Icon SORT_UP_DOWN = createIcon("SORT_UP_DOWN");
	public static final Icon SORT_UP_DOWN_QUESTION = createIcon("SORT_UP_DOWN_QUESTION");
	public static final Icon SORT_UP_MINUS = createIcon("SORT_UP_MINUS");
	public static final Icon SORT_UP_PLUS = createIcon("SORT_UP_PLUS");
	public static final Icon SPADE = createIcon("SPADE");
	public static final Icon SPAM = createIcon("SPAM");
	public static final Icon SPEECH_BALLOON = createIcon("SPEECH_BALLOON");
	public static final Icon SPEECH_BALLOON_ANSWER = createIcon("SPEECH_BALLOON_ANSWER");
	public static final Icon SPEECH_BALLOON_QUESTION = createIcon("SPEECH_BALLOON_QUESTION");
	public static final Icon SPELL_CHECK = createIcon("SPELL_CHECK");
	public static final Icon SPELL_CHECK_HIGHLIGHT = createIcon("SPELL_CHECK_HIGHLIGHT");
	public static final Icon SPIDER = createIcon("SPIDER");
	public static final Icon SPIRIT_LEVEL = createIcon("SPIRIT_LEVEL");
	public static final Icon SPONGE = createIcon("SPONGE");
	public static final Icon SPRAY_CAN = createIcon("SPRAY_CAN");
	public static final Icon SPREADSHEET = createIcon("SPREADSHEET");
	public static final Icon SPREADSHEET_CELL = createIcon("SPREADSHEET_CELL");
	public static final Icon SPREADSHEET_CHART = createIcon("SPREADSHEET_CHART");
	public static final Icon SPREADSHEET_COLUMN = createIcon("SPREADSHEET_COLUMN");
	public static final Icon SPREADSHEET_DATA = createIcon("SPREADSHEET_DATA");
	public static final Icon SPREADSHEET_ROW = createIcon("SPREADSHEET_ROW");
	public static final Icon SPREADSHEET_SORT_ASCENDING = createIcon("SPREADSHEET_SORT_ASCENDING");
	public static final Icon SPREADSHEET_SORT_DESCENDING = createIcon("SPREADSHEET_SORT_DESCENDING");
	public static final Icon SPREADSHEET_SUM = createIcon("SPREADSHEET_SUM");
	public static final Icon SPY = createIcon("SPY");
	public static final Icon SSD_DRIVE = createIcon("SSD_DRIVE");
	public static final Icon STAIRS_DOWN = createIcon("STAIRS_DOWN");
	public static final Icon STAIRS_UP = createIcon("STAIRS_UP");
	public static final Icon STANDBY = createIcon("STANDBY");
	public static final Icon STAPLER = createIcon("STAPLER");
	public static final Icon STAR = createIcon("STAR");
	public static final Icon STAR_ALT = createIcon("STAR_ALT");
	public static final Icon STAR_AND_CRESCENT = createIcon("STAR_AND_CRESCENT");
	public static final Icon STAR_OF_DAVID = createIcon("STAR_OF_DAVID");
	public static final Icon STEERING_WHEEL = createIcon("STEERING_WHEEL");
	public static final Icon STEP = createIcon("STEP");
	public static final Icon STETHOSCOPE = createIcon("STETHOSCOPE");
	public static final Icon STICKY_NOTE = createIcon("STICKY_NOTE");
	public static final Icon STICKY_NOTE_TEXT = createIcon("STICKY_NOTE_TEXT");
	public static final Icon STOCK_TICKER = createIcon("STOCK_TICKER");
	public static final Icon STOCKBROKER = createIcon("STOCKBROKER");
	public static final Icon STOCKBROKER_BOWLER = createIcon("STOCKBROKER_BOWLER");
	public static final Icon STOPWATCH = createIcon("STOPWATCH");
	public static final Icon STOPWATCH_ELAPSED = createIcon("STOPWATCH_ELAPSED");
	public static final Icon STORE = createIcon("STORE");
	public static final Icon STROLLER = createIcon("STROLLER");
	public static final Icon SUBMARINE = createIcon("SUBMARINE");
	public static final Icon SUITCASE = createIcon("SUITCASE");
	public static final Icon SUITCASE_ALT = createIcon("SUITCASE_ALT");
	public static final Icon SUN = createIcon("SUN");
	public static final Icon SUN_DIMMED = createIcon("SUN_DIMMED");
	public static final Icon SUN_HALF = createIcon("SUN_HALF");
	public static final Icon SUNGLASSES = createIcon("SUNGLASSES");
	public static final Icon SURGEON = createIcon("SURGEON");
	public static final Icon SURVEILLANCE_CAMERA = createIcon("SURVEILLANCE_CAMERA");
	public static final Icon SURVEILLANCE_CAMERA_ALT = createIcon("SURVEILLANCE_CAMERA_ALT");
	public static final Icon SWITCH_OFF = createIcon("SWITCH_OFF");
	public static final Icon SWITCH_ON = createIcon("SWITCH_ON");
	public static final Icon SWITCH_ROCKER_OFF = createIcon("SWITCH_ROCKER_OFF");
	public static final Icon SWITCH_ROCKER_ON = createIcon("SWITCH_ROCKER_ON");
	public static final Icon SWITCH_SLIDER_OFF = createIcon("SWITCH_SLIDER_OFF");
	public static final Icon SWITCH_SLIDER_ON = createIcon("SWITCH_SLIDER_ON");
	public static final Icon SWORD = createIcon("SWORD");
	public static final Icon SYMBOL_AT = createIcon("SYMBOL_AT");
	public static final Icon SYMBOL_COPYRIGHT = createIcon("SYMBOL_COPYRIGHT");
	public static final Icon SYMBOL_DOLLAR = createIcon("SYMBOL_DOLLAR");
	public static final Icon SYMBOL_DOLLAR_EURO = createIcon("SYMBOL_DOLLAR_EURO");
	public static final Icon SYMBOL_EURO = createIcon("SYMBOL_EURO");
	public static final Icon SYMBOL_FEMALE = createIcon("SYMBOL_FEMALE");
	public static final Icon SYMBOL_HASH = createIcon("SYMBOL_HASH");
	public static final Icon SYMBOL_MALE = createIcon("SYMBOL_MALE");
	public static final Icon SYMBOL_PARAGRAPH = createIcon("SYMBOL_PARAGRAPH");
	public static final Icon SYMBOL_PERCENT = createIcon("SYMBOL_PERCENT");
	public static final Icon SYMBOL_POUND = createIcon("SYMBOL_POUND");
	public static final Icon SYMBOL_Q = createIcon("SYMBOL_Q");
	public static final Icon SYMBOL_QUESTIONMARK = createIcon("SYMBOL_QUESTIONMARK");
	public static final Icon SYMBOL_SUM = createIcon("SYMBOL_SUM");
	public static final Icon SYMBOL_YEN = createIcon("SYMBOL_YEN");
	public static final Icon SYMBOL_YUAN = createIcon("SYMBOL_YUAN");
	public static final Icon SYNAGOGUE = createIcon("SYNAGOGUE");
	public static final Icon SYSTEM = createIcon("SYSTEM");
	public static final Icon TAB_PANE = createIcon("TAB_PANE");
	public static final Icon TABLE = createIcon("TABLE");
	public static final Icon TABLE_SELECTION_ALL = createIcon("TABLE_SELECTION_ALL");
	public static final Icon TABLE_SELECTION_BLOCK = createIcon("TABLE_SELECTION_BLOCK");
	public static final Icon TABLE_SELECTION_CELL = createIcon("TABLE_SELECTION_CELL");
	public static final Icon TABLE_SELECTION_COLUMN = createIcon("TABLE_SELECTION_COLUMN");
	public static final Icon TABLE_SELECTION_RANGE = createIcon("TABLE_SELECTION_RANGE");
	public static final Icon TABLE_SELECTION_ROW = createIcon("TABLE_SELECTION_ROW");
	public static final Icon TABLE_TENNIS_RACKET = createIcon("TABLE_TENNIS_RACKET");
	public static final Icon TABLES = createIcon("TABLES");
	public static final Icon TABLET_COMPUTER = createIcon("TABLET_COMPUTER");
	public static final Icon TABLET_COMPUTER_TOUCH = createIcon("TABLET_COMPUTER_TOUCH");
	public static final Icon TAG = createIcon("TAG");
	public static final Icon TAGS = createIcon("TAGS");
	public static final Icon TANK = createIcon("TANK");
	public static final Icon TANK_TRUCK = createIcon("TANK_TRUCK");
	public static final Icon TAPE_MEASURE = createIcon("TAPE_MEASURE");
	public static final Icon TAPE_MEASURE_ROLL = createIcon("TAPE_MEASURE_ROLL");
	public static final Icon TARGET = createIcon("TARGET");
	public static final Icon TAXI = createIcon("TAXI");
	public static final Icon TEA_BAG = createIcon("TEA_BAG");
	public static final Icon TEACHER = createIcon("TEACHER");
	public static final Icon TEDDY_BEAR = createIcon("TEDDY_BEAR");
	public static final Icon TELEPHONE = createIcon("TELEPHONE");
	public static final Icon TELEPHONE_BOX = createIcon("TELEPHONE_BOX");
	public static final Icon TELEPHONE_RETRO = createIcon("TELEPHONE_RETRO");
	public static final Icon TELESCOPE = createIcon("TELESCOPE");
	public static final Icon TEMPLE = createIcon("TEMPLE");
	public static final Icon TENNIS_BALL = createIcon("TENNIS_BALL");
	public static final Icon TENNIS_RACKET = createIcon("TENNIS_RACKET");
	public static final Icon TENT = createIcon("TENT");
	public static final Icon TERRORIST = createIcon("TERRORIST");
	public static final Icon TEST_CARD = createIcon("TEST_CARD");
	public static final Icon TEXT = createIcon("TEXT");
	public static final Icon TEXT_ALIGN_CENTER = createIcon("TEXT_ALIGN_CENTER");
	public static final Icon TEXT_ALIGN_JUSTIFIED = createIcon("TEXT_ALIGN_JUSTIFIED");
	public static final Icon TEXT_ALIGN_LEFT = createIcon("TEXT_ALIGN_LEFT");
	public static final Icon TEXT_ALIGN_RIGHT = createIcon("TEXT_ALIGN_RIGHT");
	public static final Icon TEXT_BINARY = createIcon("TEXT_BINARY");
	public static final Icon TEXT_BRAILLE = createIcon("TEXT_BRAILLE");
	public static final Icon TEXT_FIELD = createIcon("TEXT_FIELD");
	public static final Icon TEXT_SPEAKER = createIcon("TEXT_SPEAKER");
	public static final Icon TEXT_TREE = createIcon("TEXT_TREE");
	public static final Icon THERMOMETER = createIcon("THERMOMETER");
	public static final Icon THERMOMETER_BODY = createIcon("THERMOMETER_BODY");
	public static final Icon THOUGHT = createIcon("THOUGHT");
	public static final Icon THREAD = createIcon("THREAD");
	public static final Icon TICKET = createIcon("TICKET");
	public static final Icon TIMER = createIcon("TIMER");
	public static final Icon TOASTER = createIcon("TOASTER");
	public static final Icon TOBACCO_PIPE = createIcon("TOBACCO_PIPE");
	public static final Icon TOILET = createIcon("TOILET");
	public static final Icon TOILET_PAPER = createIcon("TOILET_PAPER");
	public static final Icon TOOL_TIP = createIcon("TOOL_TIP");
	public static final Icon TOOLBOX = createIcon("TOOLBOX");
	public static final Icon TOOLS = createIcon("TOOLS");
	public static final Icon TOOTH = createIcon("TOOTH");
	public static final Icon TOOTH_CARIOUS = createIcon("TOOTH_CARIOUS");
	public static final Icon TORII = createIcon("TORII");
	public static final Icon TORPEDO = createIcon("TORPEDO");
	public static final Icon TOUCH = createIcon("TOUCH");
	public static final Icon TOWER_CRANE = createIcon("TOWER_CRANE");
	public static final Icon TRACTOR = createIcon("TRACTOR");
	public static final Icon TRAFFICLIGHT_GREEN = createIcon("TRAFFICLIGHT_GREEN");
	public static final Icon TRAFFICLIGHT_OFF = createIcon("TRAFFICLIGHT_OFF");
	public static final Icon TRAFFICLIGHT_ON = createIcon("TRAFFICLIGHT_ON");
	public static final Icon TRAFFICLIGHT_RED = createIcon("TRAFFICLIGHT_RED");
	public static final Icon TRAFFICLIGHT_RED_YELLOW = createIcon("TRAFFICLIGHT_RED_YELLOW");
	public static final Icon TRAFFICLIGHT_YELLOW = createIcon("TRAFFICLIGHT_YELLOW");
	public static final Icon TRAM = createIcon("TRAM");
	public static final Icon TREE = createIcon("TREE");
	public static final Icon TROJAN_HORSE = createIcon("TROJAN_HORSE");
	public static final Icon TROPHY = createIcon("TROPHY");
	public static final Icon TRUCK = createIcon("TRUCK");
	public static final Icon TRUCK_CONTAINER = createIcon("TRUCK_CONTAINER");
	public static final Icon TRUCK_FRONT = createIcon("TRUCK_FRONT");
	public static final Icon TRUCK_TRAILER = createIcon("TRUCK_TRAILER");
	public static final Icon TUGBOAT = createIcon("TUGBOAT");
	public static final Icon TV = createIcon("TV");
	public static final Icon TWEEZERS = createIcon("TWEEZERS");
	public static final Icon TYPEWRITER = createIcon("TYPEWRITER");
	public static final Icon UFO = createIcon("UFO");
	public static final Icon UMBRELLA_CLOSED = createIcon("UMBRELLA_CLOSED");
	public static final Icon UMBRELLA_OPEN = createIcon("UMBRELLA_OPEN");
	public static final Icon UNDO = createIcon("UNDO");
	public static final Icon UNINSTALL = createIcon("UNINSTALL");
	public static final Icon UNIVERSITY = createIcon("UNIVERSITY");
	public static final Icon UPLOAD = createIcon("UPLOAD");
	public static final Icon USER = createIcon("USER");
	public static final Icon USER_EARTH = createIcon("USER_EARTH");
	public static final Icon USER_GLASSES = createIcon("USER_GLASSES");
	public static final Icon USER_HEADPHONES = createIcon("USER_HEADPHONES");
	public static final Icon USER_HEADSET = createIcon("USER_HEADSET");
	public static final Icon USER_MESSAGE = createIcon("USER_MESSAGE");
	public static final Icon USER_MOBILE_PHONE = createIcon("USER_MOBILE_PHONE");
	public static final Icon USER_MONITOR = createIcon("USER_MONITOR");
	public static final Icon USER_SMARTPHONE = createIcon("USER_SMARTPHONE");
	public static final Icon USER_TELEPHONE = createIcon("USER_TELEPHONE");
	public static final Icon USERS = createIcon("USERS");
	public static final Icon USERS_ALT = createIcon("USERS_ALT");
	public static final Icon USERS_CROWD = createIcon("USERS_CROWD");
	public static final Icon USERS_FIVE = createIcon("USERS_FIVE");
	public static final Icon USERS_FOUR = createIcon("USERS_FOUR");
	public static final Icon USERS_MEETING = createIcon("USERS_MEETING");
	public static final Icon USERS_RELATION = createIcon("USERS_RELATION");
	public static final Icon USERS_THREE = createIcon("USERS_THREE");
	public static final Icon USERS_THREE_RELATION = createIcon("USERS_THREE_RELATION");
	public static final Icon USERS_FAMILY = createIcon("USERS_FAMILY");
	public static final Icon UTILITY_KNIFE = createIcon("UTILITY_KNIFE");
	public static final Icon VACUUM_CLEANER = createIcon("VACUUM_CLEANER");
	public static final Icon VAN = createIcon("VAN");
	public static final Icon VECTOR_CIRCLE = createIcon("VECTOR_CIRCLE");
	public static final Icon VECTOR_CURVE_CUBIC = createIcon("VECTOR_CURVE_CUBIC");
	public static final Icon VECTOR_CURVE_QUADRATIC = createIcon("VECTOR_CURVE_QUADRATIC");
	public static final Icon VECTOR_ELLIPSE = createIcon("VECTOR_ELLIPSE");
	public static final Icon VECTOR_LINE = createIcon("VECTOR_LINE");
	public static final Icon VECTOR_SQUARE = createIcon("VECTOR_SQUARE");
	public static final Icon VECTOR_TRIANGLE = createIcon("VECTOR_TRIANGLE");
	public static final Icon VENDING_MACHINE = createIcon("VENDING_MACHINE");
	public static final Icon VIDEO_CAMERA = createIcon("VIDEO_CAMERA");
	public static final Icon VIDEO_CHAT = createIcon("VIDEO_CHAT");
	public static final Icon VIDEOTAPE = createIcon("VIDEOTAPE");
	public static final Icon VIEW_1_1 = createIcon("VIEW_1_1");
	public static final Icon VIOLIN = createIcon("VIOLIN");
	public static final Icon VIRUS = createIcon("VIRUS");
	public static final Icon VOICE_RECORDER = createIcon("VOICE_RECORDER");
	public static final Icon VOODOO_DOLL = createIcon("VOODOO_DOLL");
	public static final Icon WALKIE_TALKIE = createIcon("WALKIE_TALKIE");
	public static final Icon WALL_BARBED_WIRE = createIcon("WALL_BARBED_WIRE");
	public static final Icon WALLET = createIcon("WALLET");
	public static final Icon WALLET_EMPTY = createIcon("WALLET_EMPTY");
	public static final Icon WAREHOUSE = createIcon("WAREHOUSE");
	public static final Icon WASHING_POWDER = createIcon("WASHING_POWDER");
	public static final Icon WATER = createIcon("WATER");
	public static final Icon WATER_FISH = createIcon("WATER_FISH");
	public static final Icon WATER_TAP = createIcon("WATER_TAP");
	public static final Icon WATERING_CAN = createIcon("WATERING_CAN");
	public static final Icon WATERING_CAN_HALF = createIcon("WATERING_CAN_HALF");
	public static final Icon WAX_SEAL = createIcon("WAX_SEAL");
	public static final Icon WAX_SEAL_BROKEN = createIcon("WAX_SEAL_BROKEN");
	public static final Icon WEB = createIcon("WEB");
	public static final Icon WEBCAM = createIcon("WEBCAM");
	public static final Icon WEDDING_RINGS = createIcon("WEDDING_RINGS");
	public static final Icon WEIGHT = createIcon("WEIGHT");
	public static final Icon WEIGHT_RING = createIcon("WEIGHT_RING");
	public static final Icon WHEAT = createIcon("WHEAT");
	public static final Icon WHEEL = createIcon("WHEEL");
	public static final Icon WHEEL_LOADER = createIcon("WHEEL_LOADER");
	public static final Icon WHEELBARROW = createIcon("WHEELBARROW");
	public static final Icon WHEELBARROW_FULL = createIcon("WHEELBARROW_FULL");
	public static final Icon WHEELCHAIR = createIcon("WHEELCHAIR");
	public static final Icon WHISTLE = createIcon("WHISTLE");
	public static final Icon WHISTLE_NOISE = createIcon("WHISTLE_NOISE");
	public static final Icon WIND_ENGINE = createIcon("WIND_ENGINE");
	public static final Icon WIND_ENGINE_OFFSHORE = createIcon("WIND_ENGINE_OFFSHORE");
	public static final Icon WIND_ENGINES = createIcon("WIND_ENGINES");
	public static final Icon WINDMILL = createIcon("WINDMILL");
	public static final Icon WINDOW = createIcon("WINDOW");
	public static final Icon WINDOW_CD = createIcon("WINDOW_CD");
	public static final Icon WINDOW_CLOSE = createIcon("WINDOW_CLOSE");
	public static final Icon WINDOW_DIALOG = createIcon("WINDOW_DIALOG");
	public static final Icon WINDOW_EARTH = createIcon("WINDOW_EARTH");
	public static final Icon WINDOW_ENVIRONMENT = createIcon("WINDOW_ENVIRONMENT");
	public static final Icon WINDOW_EQUALIZER = createIcon("WINDOW_EQUALIZER");
	public static final Icon WINDOW_EXPLORER = createIcon("WINDOW_EXPLORER");
	public static final Icon WINDOW_FONT = createIcon("WINDOW_FONT");
	public static final Icon WINDOW_GEAR = createIcon("WINDOW_GEAR");
	public static final Icon WINDOW_HEIGHT = createIcon("WINDOW_HEIGHT");
	public static final Icon WINDOW_INFORMATION = createIcon("WINDOW_INFORMATION");
	public static final Icon WINDOW_KEY = createIcon("WINDOW_KEY");
	public static final Icon WINDOW_LOGON = createIcon("WINDOW_LOGON");
	public static final Icon WINDOW_NETWORK = createIcon("WINDOW_NETWORK");
	public static final Icon WINDOW_OSCILLOGRAPH = createIcon("WINDOW_OSCILLOGRAPH");
	public static final Icon WINDOW_SIDEBAR = createIcon("WINDOW_SIDEBAR");
	public static final Icon WINDOW_SIZE = createIcon("WINDOW_SIZE");
	public static final Icon WINDOW_SPLIT_HOR = createIcon("WINDOW_SPLIT_HOR");
	public static final Icon WINDOW_SPLIT_VER = createIcon("WINDOW_SPLIT_VER");
	public static final Icon WINDOW_STAR = createIcon("WINDOW_STAR");
	public static final Icon WINDOW_TEST_CARD = createIcon("WINDOW_TEST_CARD");
	public static final Icon WINDOW_TIME = createIcon("WINDOW_TIME");
	public static final Icon WINDOW_TOUCH = createIcon("WINDOW_TOUCH");
	public static final Icon WINDOW_WARNING = createIcon("WINDOW_WARNING");
	public static final Icon WINDOW_WIDTH = createIcon("WINDOW_WIDTH");
	public static final Icon WINDOWS = createIcon("WINDOWS");
	public static final Icon WINDOWS_CLOSE = createIcon("WINDOWS_CLOSE");
	public static final Icon WINDSOCK = createIcon("WINDSOCK");
	public static final Icon WINDUP_KEY = createIcon("WINDUP_KEY");
	public static final Icon WINE = createIcon("WINE");
	public static final Icon WINE_BOTTLE = createIcon("WINE_BOTTLE");
	public static final Icon WINE_GLASS = createIcon("WINE_GLASS");
	public static final Icon WLAN_ANTENNA = createIcon("WLAN_ANTENNA");
	public static final Icon WLAN_ROUTER = createIcon("WLAN_ROUTER");
	public static final Icon WOMAN = createIcon("WOMAN");
	public static final Icon WOMAN_ALT = createIcon("WOMAN_ALT");
	public static final Icon WOMAN_ALT2 = createIcon("WOMAN_ALT2");
	public static final Icon WOODEN_PALLET = createIcon("WOODEN_PALLET");
	public static final Icon WOODEN_PALLET_BOX = createIcon("WOODEN_PALLET_BOX");
	public static final Icon WORKER = createIcon("WORKER");
	public static final Icon WORKER_BIB = createIcon("WORKER_BIB");
	public static final Icon WORKPLACE = createIcon("WORKPLACE");
	public static final Icon WORKSTATION = createIcon("WORKSTATION");
	public static final Icon WORKSTATION_NETWORK = createIcon("WORKSTATION_NETWORK");
	public static final Icon WORM = createIcon("WORM");
	public static final Icon WRENCH = createIcon("WRENCH");
	public static final Icon WRISTWATCH = createIcon("WRISTWATCH");
	public static final Icon X_RAY = createIcon("X_RAY");
	public static final Icon YINYANG = createIcon("YINYANG");
	public static final Icon ZOOM_IN = createIcon("ZOOM_IN");
	public static final Icon ZOOM_OUT = createIcon("ZOOM_OUT");


}
