/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.application;

import java.util.List;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.ApplicationPerspective;
import org.teamapps.application.api.organization.OrgUnit;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.databinding.MutableValue;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.component.Component;

public abstract class AbstractApplicationPerspective
implements ApplicationPerspective {
    private final ApplicationInstanceData applicationInstanceData;
    private final MutableValue<String> perspectiveInfoBadgeValue;
    private Component perspectiveMenuPanel;
    private Perspective perspective;

    public AbstractApplicationPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        this.applicationInstanceData = applicationInstanceData;
        this.perspectiveInfoBadgeValue = perspectiveInfoBadgeValue;
        this.perspective = Perspective.createPerspective();
    }

    public void setPerspectiveMenuPanel(Component perspectiveMenuPanel) {
        this.perspectiveMenuPanel = perspectiveMenuPanel;
    }

    public void setPerspective(Perspective perspective) {
        this.perspective = perspective;
    }

    @Override
    public Component getPerspectiveMenuPanel() {
        return this.perspectiveMenuPanel;
    }

    @Override
    public Perspective getPerspective() {
        return this.perspective;
    }

    public void showPerspective(Perspective perspective) {
        this.applicationInstanceData.showPerspective(perspective);
    }

    public void writeActivityLog(String title, String data) {
        this.getApplicationInstanceData().writeActivityLog(title, data);
    }

    public void writeExceptionLog(String title, Throwable throwable) {
        this.getApplicationInstanceData().writeExceptionLog(title, throwable);
    }

    public ApplicationInstanceData getApplicationInstanceData() {
        return this.applicationInstanceData;
    }

    public MutableValue<String> getPerspectiveInfoBadgeValue() {
        return this.perspectiveInfoBadgeValue;
    }

    public String getLocalized(String key) {
        return this.getLocalized(key, new Object[]{null});
    }

    public String getLocalized(TranslatableText translatableText) {
        return this.applicationInstanceData.getLocalized(translatableText);
    }

    public String getLocalized(String key, Object ... parameters) {
        return this.applicationInstanceData.getLocalized(key, parameters);
    }

    public boolean isAllowed(SimplePrivilege simplePrivilege) {
        return this.applicationInstanceData.isAllowed(simplePrivilege);
    }

    public boolean isAllowed(SimpleOrganizationalPrivilege group, OrgUnit orgUnit) {
        return this.applicationInstanceData.isAllowed(group, orgUnit);
    }

    public boolean isAllowed(SimpleCustomObjectPrivilege group, PrivilegeObject privilegeObject) {
        return this.applicationInstanceData.isAllowed(group, privilegeObject);
    }

    public boolean isAllowed(StandardPrivilegeGroup group, Privilege privilege) {
        return this.applicationInstanceData.isAllowed(group, privilege);
    }

    public boolean isAllowed(OrganizationalPrivilegeGroup group, Privilege privilege, OrgUnit orgUnit) {
        return this.applicationInstanceData.isAllowed(group, privilege, orgUnit);
    }

    public boolean isAllowed(CustomObjectPrivilegeGroup group, Privilege privilege, PrivilegeObject privilegeObject) {
        return this.applicationInstanceData.isAllowed(group, privilege, privilegeObject);
    }

    public List<OrgUnit> getAllowedUnits(SimpleOrganizationalPrivilege simplePrivilege) {
        return this.applicationInstanceData.getAllowedUnits(simplePrivilege);
    }

    public List<OrgUnit> getAllowedUnits(OrganizationalPrivilegeGroup group, Privilege privilege) {
        return this.applicationInstanceData.getAllowedUnits(group, privilege);
    }

    public List<PrivilegeObject> getAllowedPrivilegeObjects(SimpleCustomObjectPrivilege simplePrivilege) {
        return this.applicationInstanceData.getAllowedPrivilegeObjects(simplePrivilege);
    }

    public List<PrivilegeObject> getAllowedPrivilegeObjects(CustomObjectPrivilegeGroup group, Privilege privilege) {
        return this.applicationInstanceData.getAllowedPrivilegeObjects(group, privilege);
    }
}

