/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.application.api.application.ApplicationBuilder;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.desktop.ApplicationDesktop;
import org.teamapps.application.api.localization.LocalizationData;
import org.teamapps.application.api.organization.OrgField;
import org.teamapps.application.api.organization.OrgUnit;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.user.SessionUser;
import org.teamapps.icons.Icon;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.component.progress.MultiProgressDisplay;

public class DevApplicationData
implements ApplicationInstanceData {
    private final ApplicationBuilder applicationBuilder;
    private final List<OrgUnit> orgUnits;
    private final DocumentConverter documentConverter;
    private final ResponsiveApplication responsiveApplication;
    private final Map<String, Map<String, String>> localizationMap;
    private final Map<String, Map<String, String>> dictionaryMap;

    public DevApplicationData(ApplicationBuilder applicationBuilder, List<OrgUnit> orgUnits, DocumentConverter documentConverter, ResponsiveApplication responsiveApplication) {
        this.applicationBuilder = applicationBuilder;
        this.localizationMap = applicationBuilder.getLocalizationData() != null ? applicationBuilder.getLocalizationData().createLocalizationMapByLanguage() : new HashMap();
        this.orgUnits = orgUnits;
        this.documentConverter = documentConverter;
        this.responsiveApplication = responsiveApplication;
        this.dictionaryMap = LocalizationData.createDictionaryData(this.getClass().getClassLoader()).createLocalizationMapByLanguage();
    }

    @Override
    public SessionUser getUser() {
        return null;
    }

    @Override
    public OrgField getOrganizationField() {
        return null;
    }

    @Override
    public int getManagedApplicationId() {
        return 0;
    }

    @Override
    public DocumentConverter getDocumentConverter() {
        return this.documentConverter;
    }

    @Override
    public MultiProgressDisplay getMultiProgressDisplay() {
        return this.responsiveApplication.getMultiProgressDisplay();
    }

    @Override
    public void showPerspective(Perspective perspective) {
        this.responsiveApplication.showPerspective(perspective);
    }

    @Override
    public ApplicationDesktop createApplicationDesktop(Icon icon, String title, boolean select, boolean closable) {
        return null;
    }

    @Override
    public void writeActivityLog(String eventTitle, String eventData) {
        System.out.println("User activity: " + eventTitle + ", " + eventData);
    }

    @Override
    public void writeExceptionLog(String title, Throwable throwable) {
        System.out.println("Exception: " + title + ", " + throwable.getMessage());
    }

    @Override
    public String getLocalized(String key, Object ... parameters) {
        for (Map<String, String> map : this.localizationMap.values()) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        for (Map<String, String> map : this.dictionaryMap.values()) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return key;
    }

    @Override
    public String getLocalized(TranslatableText translatableText) {
        if (translatableText == null) {
            return null;
        }
        return translatableText.getText();
    }

    @Override
    public boolean isAllowed(SimplePrivilege simplePrivilege) {
        return true;
    }

    @Override
    public boolean isAllowed(SimpleOrganizationalPrivilege group, OrgUnit orgUnit) {
        return true;
    }

    @Override
    public boolean isAllowed(SimpleCustomObjectPrivilege group, PrivilegeObject privilegeObject) {
        return true;
    }

    @Override
    public boolean isAllowed(StandardPrivilegeGroup group, Privilege privilege) {
        return true;
    }

    @Override
    public boolean isAllowed(OrganizationalPrivilegeGroup group, Privilege privilege, OrgUnit orgUnit) {
        return true;
    }

    @Override
    public boolean isAllowed(CustomObjectPrivilegeGroup group, Privilege privilege, PrivilegeObject privilegeObject) {
        return true;
    }

    @Override
    public List<OrgUnit> getAllowedUnits(SimpleOrganizationalPrivilege simplePrivilege) {
        return this.orgUnits;
    }

    @Override
    public List<OrgUnit> getAllowedUnits(OrganizationalPrivilegeGroup group, Privilege privilege) {
        return this.orgUnits;
    }

    @Override
    public List<PrivilegeObject> getAllowedPrivilegeObjects(SimpleCustomObjectPrivilege simplePrivilege) {
        return simplePrivilege.getPrivilegeObjectsSupplier().get();
    }

    @Override
    public List<PrivilegeObject> getAllowedPrivilegeObjects(CustomObjectPrivilegeGroup group, Privilege privilege) {
        return group.getPrivilegeObjectsSupplier().get();
    }
}

