package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface OrganizationFieldMock extends Entity<OrganizationFieldMock> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_TITLE = "title";
	final static String FIELD_ICON = "icon";

    static OrganizationFieldMock create() {
        return new UdbOrganizationFieldMock();
    }

    static OrganizationFieldMock create(int id) {
        return new UdbOrganizationFieldMock(id, true);
    }

    static OrganizationFieldMock getById(int id) {
        return new UdbOrganizationFieldMock(id, false);
    }

    static EntityBuilder<OrganizationFieldMock> getBuilder() {
        return new UdbOrganizationFieldMock(0, false);
    }

    Instant getMetaCreationDate();

    OrganizationFieldMock setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    OrganizationFieldMock setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    OrganizationFieldMock setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    OrganizationFieldMock setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    OrganizationFieldMock setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    OrganizationFieldMock setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    OrganizationFieldMock setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    OrganizationFieldMock setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    OrganizationFieldMock setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    OrganizationFieldMock setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    OrganizationFieldMock setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    OrganizationFieldMock setMetaDeletedBy(int value);

    TranslatableText getTitle();

    OrganizationFieldMock setTitle(TranslatableText value);

    String getIcon();

    OrganizationFieldMock setIcon(String value);


    static List<OrganizationFieldMock> getAll() {
        return UdbOrganizationFieldMock.getAll();
    }

    static List<OrganizationFieldMock> sort(List<OrganizationFieldMock> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbOrganizationFieldMock.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbOrganizationFieldMock.getCount();
    }

    static OrganizationFieldMockQuery filter() {
        return new UdbOrganizationFieldMockQuery();
    }
}

