package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface OrganizationUnitMock extends Entity<OrganizationUnitMock> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_NAME = "name";
	final static String FIELD_PARENT = "parent";
	final static String FIELD_CHILDREN = "children";
	final static String FIELD_TYPE = "type";
	final static String FIELD_ICON = "icon";
	final static String FIELD_ADDRESS = "address";

    static OrganizationUnitMock create() {
        return new UdbOrganizationUnitMock();
    }

    static OrganizationUnitMock create(int id) {
        return new UdbOrganizationUnitMock(id, true);
    }

    static OrganizationUnitMock getById(int id) {
        return new UdbOrganizationUnitMock(id, false);
    }

    static EntityBuilder<OrganizationUnitMock> getBuilder() {
        return new UdbOrganizationUnitMock(0, false);
    }

    Instant getMetaCreationDate();

    OrganizationUnitMock setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    OrganizationUnitMock setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    OrganizationUnitMock setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    OrganizationUnitMock setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    OrganizationUnitMock setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    OrganizationUnitMock setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    OrganizationUnitMock setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    OrganizationUnitMock setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    OrganizationUnitMock setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    OrganizationUnitMock setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    OrganizationUnitMock setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    OrganizationUnitMock setMetaDeletedBy(int value);

    TranslatableText getName();

    OrganizationUnitMock setName(TranslatableText value);

    OrganizationUnitMock getParent();

    OrganizationUnitMock setParent(OrganizationUnitMock value);

    List<OrganizationUnitMock> getChildren();

    OrganizationUnitMock setChildren(List<OrganizationUnitMock> value);

    int getChildrenCount();

    OrganizationUnitMock setChildren(OrganizationUnitMock ... value);

    BitSet getChildrenAsBitSet();

    OrganizationUnitMock addChildren(List<OrganizationUnitMock> value);

    OrganizationUnitMock addChildren(OrganizationUnitMock ... value);

    OrganizationUnitMock removeChildren(List<OrganizationUnitMock> value);

    OrganizationUnitMock removeChildren(OrganizationUnitMock ... value);

    OrganizationUnitMock removeAllChildren();

    OrganizationUnitTypeMock getType();

    OrganizationUnitMock setType(OrganizationUnitTypeMock value);

    String getIcon();

    OrganizationUnitMock setIcon(String value);

    AddressMock getAddress();

    OrganizationUnitMock setAddress(AddressMock value);


    static List<OrganizationUnitMock> getAll() {
        return UdbOrganizationUnitMock.getAll();
    }

    static List<OrganizationUnitMock> sort(List<OrganizationUnitMock> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbOrganizationUnitMock.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbOrganizationUnitMock.getCount();
    }

    static OrganizationUnitMockQuery filter() {
        return new UdbOrganizationUnitMockQuery();
    }
}

