package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface OrganizationUnitMockQuery extends Query<OrganizationUnitMock> {

    static OrganizationUnitMockQuery create() {
        return new UdbOrganizationUnitMockQuery();
    }

    OrganizationUnitMockQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    OrganizationUnitMockQuery parseFullTextFilter(String query, String... fieldNames);

	OrganizationUnitMockQuery metaCreationDate(NumericFilter filter);

	OrganizationUnitMockQuery orMetaCreationDate(NumericFilter filter);

	OrganizationUnitMockQuery metaCreatedBy(NumericFilter filter);

	OrganizationUnitMockQuery orMetaCreatedBy(NumericFilter filter);

	OrganizationUnitMockQuery metaModificationDate(NumericFilter filter);

	OrganizationUnitMockQuery orMetaModificationDate(NumericFilter filter);

	OrganizationUnitMockQuery metaModifiedBy(NumericFilter filter);

	OrganizationUnitMockQuery orMetaModifiedBy(NumericFilter filter);

	OrganizationUnitMockQuery metaDeletionDate(NumericFilter filter);

	OrganizationUnitMockQuery orMetaDeletionDate(NumericFilter filter);

	OrganizationUnitMockQuery metaDeletedBy(NumericFilter filter);

	OrganizationUnitMockQuery orMetaDeletedBy(NumericFilter filter);

	OrganizationUnitMockQuery name(TranslatableTextFilter filter);

	OrganizationUnitMockQuery orName(TranslatableTextFilter filter);

	OrganizationUnitMockQuery filterParent(OrganizationUnitMockQuery query);

	OrganizationUnitMockQuery parent(NumericFilter filter);

	OrganizationUnitMockQuery orParent(NumericFilter filter);

	OrganizationUnitMockQuery filterChildren(OrganizationUnitMockQuery query);

	OrganizationUnitMockQuery children(MultiReferenceFilterType type, OrganizationUnitMock ... value);

	OrganizationUnitMockQuery childrenCount(MultiReferenceFilterType type, int count);

	OrganizationUnitMockQuery children(MultiReferenceFilter filter);

	OrganizationUnitMockQuery orChildren(MultiReferenceFilter filter);

	OrganizationUnitMockQuery filterType(OrganizationUnitTypeMockQuery query);

	OrganizationUnitMockQuery type(NumericFilter filter);

	OrganizationUnitMockQuery orType(NumericFilter filter);

	OrganizationUnitMockQuery icon(TextFilter filter);

	OrganizationUnitMockQuery orIcon(TextFilter filter);

	OrganizationUnitMockQuery filterAddress(AddressMockQuery query);

	OrganizationUnitMockQuery address(NumericFilter filter);

	OrganizationUnitMockQuery orAddress(NumericFilter filter);


    OrganizationUnitMockQuery andOr(OrganizationUnitMockQuery... queries);

    OrganizationUnitMockQuery customFilter(Function<OrganizationUnitMock, Boolean> customFilter);

    List<OrganizationUnitMock> execute();

    OrganizationUnitMock executeExpectSingleton();

    BitSet executeToBitSet();

    List<OrganizationUnitMock> execute(String sortFieldName, boolean ascending, String ... path);

    List<OrganizationUnitMock> execute(int startIndex, int length, Sorting sorting);

}

