package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbAddressMockQuery extends AbstractUdbQuery<AddressMock> implements AddressMockQuery {

    public UdbAddressMockQuery() {
        super(UdbAddressMock.table, AddressMock.getBuilder());
    }

	@Override
	public AddressMockQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbAddressMock.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public AddressMockQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbAddressMock.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public AddressMockQuery metaCreationDate(NumericFilter filter) {
		and(UdbAddressMock.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbAddressMock.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery metaCreatedBy(NumericFilter filter) {
		and(UdbAddressMock.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbAddressMock.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery metaModificationDate(NumericFilter filter) {
		and(UdbAddressMock.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbAddressMock.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery metaModifiedBy(NumericFilter filter) {
		and(UdbAddressMock.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbAddressMock.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery metaDeletionDate(NumericFilter filter) {
		and(UdbAddressMock.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbAddressMock.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery metaDeletedBy(NumericFilter filter) {
		and(UdbAddressMock.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbAddressMock.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery name(TextFilter filter) {
		and(UdbAddressMock.name.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orName(TextFilter filter) {
		or(UdbAddressMock.name.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery organisation(TextFilter filter) {
		and(UdbAddressMock.organisation.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orOrganisation(TextFilter filter) {
		or(UdbAddressMock.organisation.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery street(TextFilter filter) {
		and(UdbAddressMock.street.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orStreet(TextFilter filter) {
		or(UdbAddressMock.street.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery city(TextFilter filter) {
		and(UdbAddressMock.city.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orCity(TextFilter filter) {
		or(UdbAddressMock.city.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery dependentLocality(TextFilter filter) {
		and(UdbAddressMock.dependentLocality.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orDependentLocality(TextFilter filter) {
		or(UdbAddressMock.dependentLocality.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery state(TextFilter filter) {
		and(UdbAddressMock.state.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orState(TextFilter filter) {
		or(UdbAddressMock.state.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery postalCode(TextFilter filter) {
		and(UdbAddressMock.postalCode.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orPostalCode(TextFilter filter) {
		or(UdbAddressMock.postalCode.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery country(TextFilter filter) {
		and(UdbAddressMock.country.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orCountry(TextFilter filter) {
		or(UdbAddressMock.country.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery latitude(NumericFilter filter) {
		and(UdbAddressMock.latitude.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orLatitude(NumericFilter filter) {
		or(UdbAddressMock.latitude.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery longitude(NumericFilter filter) {
		and(UdbAddressMock.longitude.createFilter(filter));
		return this;
	}

	@Override
	public AddressMockQuery orLongitude(NumericFilter filter) {
		or(UdbAddressMock.longitude.createFilter(filter));
		return this;
	}


	@Override
	public UdbAddressMockQuery andOr(AddressMockQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public AddressMockQuery customFilter(Function<AddressMock, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(AddressMock.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



