package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbOrganizationUnitMock extends AbstractUdbEntity<OrganizationUnitMock> implements OrganizationUnitMock {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static TranslatableTextIndex name;
	protected static SingleReferenceIndex parent;
	protected static MultiReferenceIndex children;
	protected static SingleReferenceIndex type;
	protected static TextIndex icon;
	protected static SingleReferenceIndex address;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		name = (TranslatableTextIndex) tableIndex.getColumnIndex(FIELD_NAME);
		parent = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_PARENT);
		children = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_CHILDREN);
		type = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_TYPE);
		icon = (TextIndex) tableIndex.getColumnIndex(FIELD_ICON);
		address = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ADDRESS);
    }

    public static List<OrganizationUnitMock> getAll() {
        return new EntityBitSetList<>(OrganizationUnitMock.getBuilder(), table.getRecordBitSet());
    }

    public static List<OrganizationUnitMock> sort(List<OrganizationUnitMock> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<OrganizationUnitMock> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, OrganizationUnitMock.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbOrganizationUnitMock() {
        super(table);
    }

    public UdbOrganizationUnitMock(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public OrganizationUnitMock build() {
        return new UdbOrganizationUnitMock();
    }

    @Override
    public OrganizationUnitMock build(int id) {
        return new UdbOrganizationUnitMock(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public OrganizationUnitMock setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public OrganizationUnitMock setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public OrganizationUnitMock setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public OrganizationUnitMock setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public OrganizationUnitMock setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public OrganizationUnitMock setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public OrganizationUnitMock setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public OrganizationUnitMock setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public OrganizationUnitMock setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public OrganizationUnitMock setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public OrganizationUnitMock setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public OrganizationUnitMock setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public TranslatableText getName() {
	    return getTranslatableTextValue(this.name);
	}

	@Override
	public OrganizationUnitMock setName(TranslatableText value) {
    	setTranslatableTextValue(value, this.name);
		return this;
	}

	@Override
	public OrganizationUnitMock getParent() {
		if (isChanged(parent)) {
			return (OrganizationUnitMock) getReferenceChangeValue(parent);
		} else {
			int id = parent.getValue(getId());
			if (id > 0) {
				return OrganizationUnitMock.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public OrganizationUnitMock setParent(OrganizationUnitMock value) {
		setSingleReferenceValue(parent, value, table);
		return this;
	}

	@Override
	public List<OrganizationUnitMock> getChildren() {
	    return getMultiReferenceValue(children, OrganizationUnitMock.getBuilder());
	}

	@Override
	public OrganizationUnitMock setChildren(List<OrganizationUnitMock> value) {
		setMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public int getChildrenCount() {
	    return getMultiReferenceValueCount(children, OrganizationUnitMock.getBuilder());
	}

	@Override
	public OrganizationUnitMock setChildren(OrganizationUnitMock ... value) {
		setMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public BitSet getChildrenAsBitSet() {
	    return getMultiReferenceValueAsBitSet(children, OrganizationUnitMock.getBuilder());
	}

	@Override
	public OrganizationUnitMock addChildren(List<OrganizationUnitMock> value) {
		addMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public OrganizationUnitMock addChildren(OrganizationUnitMock ... value) {
		addMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public OrganizationUnitMock removeChildren(List<OrganizationUnitMock> value) {
		removeMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public OrganizationUnitMock removeChildren(OrganizationUnitMock ... value) {
		removeMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public OrganizationUnitMock removeAllChildren() {
		removeAllMultiReferenceValue(children);
		return this;
	}

	@Override
	public OrganizationUnitTypeMock getType() {
		if (isChanged(type)) {
			return (OrganizationUnitTypeMock) getReferenceChangeValue(type);
		} else {
			int id = type.getValue(getId());
			if (id > 0) {
				return OrganizationUnitTypeMock.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public OrganizationUnitMock setType(OrganizationUnitTypeMock value) {
		setSingleReferenceValue(type, value, table);
		return this;
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public OrganizationUnitMock setIcon(String value) {
	    setTextValue(value, this.icon);
		return this;
	}

	@Override
	public AddressMock getAddress() {
		if (isChanged(address)) {
			return (AddressMock) getReferenceChangeValue(address);
		} else {
			int id = address.getValue(getId());
			if (id > 0) {
				return AddressMock.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public OrganizationUnitMock setAddress(AddressMock value) {
		setSingleReferenceValue(address, value, table);
		return this;
	}


    @Override
    public UdbOrganizationUnitMock save(Transaction transaction, boolean strictChangeVerification) {
        save(transaction, table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbOrganizationUnitMock saveTransactional(boolean strictChangeVerification) {
        save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbOrganizationUnitMock save() {
        save(table);
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        delete(transaction, table);
    }

    @Override
    public void delete() {
        delete(table);
    }

	@Override
	public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(table.getName()).append(": ").append(getId()).append("\n");
		for (ColumnIndex column : table.getColumnIndices()) {
			sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(getId()));
			if (isChanged(column)) {
				TransactionRecordValue changeValue = getChangeValue(column);
				sb.append(" -> ").append(changeValue.getValue());
			}
			sb.append("\n");
		}
		return sb.toString();
	}
}



