package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbOrganizationUnitMockQuery extends AbstractUdbQuery<OrganizationUnitMock> implements OrganizationUnitMockQuery {

    public UdbOrganizationUnitMockQuery() {
        super(UdbOrganizationUnitMock.table, OrganizationUnitMock.getBuilder());
    }

	@Override
	public OrganizationUnitMockQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbOrganizationUnitMock.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbOrganizationUnitMock.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery metaCreationDate(NumericFilter filter) {
		and(UdbOrganizationUnitMock.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbOrganizationUnitMock.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery metaCreatedBy(NumericFilter filter) {
		and(UdbOrganizationUnitMock.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbOrganizationUnitMock.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery metaModificationDate(NumericFilter filter) {
		and(UdbOrganizationUnitMock.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbOrganizationUnitMock.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery metaModifiedBy(NumericFilter filter) {
		and(UdbOrganizationUnitMock.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbOrganizationUnitMock.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery metaDeletionDate(NumericFilter filter) {
		and(UdbOrganizationUnitMock.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbOrganizationUnitMock.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery metaDeletedBy(NumericFilter filter) {
		and(UdbOrganizationUnitMock.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbOrganizationUnitMock.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery name(TranslatableTextFilter filter) {
		and(UdbOrganizationUnitMock.name.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery orName(TranslatableTextFilter filter) {
		or(UdbOrganizationUnitMock.name.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery filterParent(OrganizationUnitMockQuery query) {
		UdbOrganizationUnitMockQuery udbQuery = (UdbOrganizationUnitMockQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnitMock.parent, UdbOrganizationUnitMock.children);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitMockQuery parent(NumericFilter filter) {
		and(UdbOrganizationUnitMock.parent.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery orParent(NumericFilter filter) {
		or(UdbOrganizationUnitMock.parent.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery filterChildren(OrganizationUnitMockQuery query) {
		UdbOrganizationUnitMockQuery udbQuery = (UdbOrganizationUnitMockQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnitMock.children, UdbOrganizationUnitMock.parent);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitMockQuery children(MultiReferenceFilterType type, OrganizationUnitMock ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (OrganizationUnitMock value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbOrganizationUnitMock.children.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery childrenCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbOrganizationUnitMock.children.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery children(MultiReferenceFilter filter) {
		and(UdbOrganizationUnitMock.children.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery orChildren(MultiReferenceFilter filter) {
		or(UdbOrganizationUnitMock.children.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery filterType(OrganizationUnitTypeMockQuery query) {
		UdbOrganizationUnitTypeMockQuery udbQuery = (UdbOrganizationUnitTypeMockQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnitMock.type);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitMockQuery type(NumericFilter filter) {
		and(UdbOrganizationUnitMock.type.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery orType(NumericFilter filter) {
		or(UdbOrganizationUnitMock.type.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery icon(TextFilter filter) {
		and(UdbOrganizationUnitMock.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery orIcon(TextFilter filter) {
		or(UdbOrganizationUnitMock.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery filterAddress(AddressMockQuery query) {
		UdbAddressMockQuery udbQuery = (UdbAddressMockQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnitMock.address);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitMockQuery address(NumericFilter filter) {
		and(UdbOrganizationUnitMock.address.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitMockQuery orAddress(NumericFilter filter) {
		or(UdbOrganizationUnitMock.address.createFilter(filter));
		return this;
	}


	@Override
	public UdbOrganizationUnitMockQuery andOr(OrganizationUnitMockQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public OrganizationUnitMockQuery customFilter(Function<OrganizationUnitMock, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(OrganizationUnitMock.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



