package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface AddressMock extends Entity<AddressMock> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_NAME = "name";
	final static String FIELD_ORGANISATION = "organisation";
	final static String FIELD_STREET = "street";
	final static String FIELD_CITY = "city";
	final static String FIELD_DEPENDENT_LOCALITY = "dependentLocality";
	final static String FIELD_STATE = "state";
	final static String FIELD_POSTAL_CODE = "postalCode";
	final static String FIELD_COUNTRY = "country";
	final static String FIELD_LATITUDE = "latitude";
	final static String FIELD_LONGITUDE = "longitude";

    static AddressMock create() {
        return new UdbAddressMock();
    }

    static AddressMock create(int id) {
        return new UdbAddressMock(id, true);
    }

    static AddressMock getById(int id) {
        return new UdbAddressMock(id, false);
    }

    static EntityBuilder<AddressMock> getBuilder() {
        return new UdbAddressMock(0, false);
    }

    Instant getMetaCreationDate();

    AddressMock setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    AddressMock setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    AddressMock setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    AddressMock setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    AddressMock setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    AddressMock setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    AddressMock setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    AddressMock setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    AddressMock setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    AddressMock setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    AddressMock setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    AddressMock setMetaDeletedBy(int value);

    String getName();

    AddressMock setName(String value);

    String getOrganisation();

    AddressMock setOrganisation(String value);

    String getStreet();

    AddressMock setStreet(String value);

    String getCity();

    AddressMock setCity(String value);

    String getDependentLocality();

    AddressMock setDependentLocality(String value);

    String getState();

    AddressMock setState(String value);

    String getPostalCode();

    AddressMock setPostalCode(String value);

    String getCountry();

    AddressMock setCountry(String value);

    float getLatitude();

    AddressMock setLatitude(float value);

    float getLongitude();

    AddressMock setLongitude(float value);


    static List<AddressMock> getAll() {
        return UdbAddressMock.getAll();
    }

    static List<AddressMock> sort(List<AddressMock> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbAddressMock.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbAddressMock.getCount();
    }

    static AddressMockQuery filter() {
        return new UdbAddressMockQuery();
    }
}

