package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;


import java.util.*;
import java.util.function.Function;


public interface AddressMockQuery extends Query<AddressMock> {

    static AddressMockQuery create() {
        return new UdbAddressMockQuery();
    }

    AddressMockQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    AddressMockQuery parseFullTextFilter(String query, String... fieldNames);

	AddressMockQuery metaCreationDate(NumericFilter filter);

	AddressMockQuery orMetaCreationDate(NumericFilter filter);

	AddressMockQuery metaCreatedBy(NumericFilter filter);

	AddressMockQuery orMetaCreatedBy(NumericFilter filter);

	AddressMockQuery metaModificationDate(NumericFilter filter);

	AddressMockQuery orMetaModificationDate(NumericFilter filter);

	AddressMockQuery metaModifiedBy(NumericFilter filter);

	AddressMockQuery orMetaModifiedBy(NumericFilter filter);

	AddressMockQuery metaDeletionDate(NumericFilter filter);

	AddressMockQuery orMetaDeletionDate(NumericFilter filter);

	AddressMockQuery metaDeletedBy(NumericFilter filter);

	AddressMockQuery orMetaDeletedBy(NumericFilter filter);

	AddressMockQuery name(TextFilter filter);

	AddressMockQuery orName(TextFilter filter);

	AddressMockQuery organisation(TextFilter filter);

	AddressMockQuery orOrganisation(TextFilter filter);

	AddressMockQuery street(TextFilter filter);

	AddressMockQuery orStreet(TextFilter filter);

	AddressMockQuery city(TextFilter filter);

	AddressMockQuery orCity(TextFilter filter);

	AddressMockQuery dependentLocality(TextFilter filter);

	AddressMockQuery orDependentLocality(TextFilter filter);

	AddressMockQuery state(TextFilter filter);

	AddressMockQuery orState(TextFilter filter);

	AddressMockQuery postalCode(TextFilter filter);

	AddressMockQuery orPostalCode(TextFilter filter);

	AddressMockQuery country(TextFilter filter);

	AddressMockQuery orCountry(TextFilter filter);

	AddressMockQuery latitude(NumericFilter filter);

	AddressMockQuery orLatitude(NumericFilter filter);

	AddressMockQuery longitude(NumericFilter filter);

	AddressMockQuery orLongitude(NumericFilter filter);


    AddressMockQuery andOr(AddressMockQuery... queries);

    AddressMockQuery customFilter(Function<AddressMock, Boolean> customFilter);

    List<AddressMock> execute();

    AddressMock executeExpectSingleton();

    BitSet executeToBitSet();

    List<AddressMock> execute(String sortFieldName, boolean ascending, String ... path);

    List<AddressMock> execute(int startIndex, int length, Sorting sorting);

}

