package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface OrganizationUnitTypeMock extends Entity<OrganizationUnitTypeMock> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_NAME = "name";
	final static String FIELD_ABBREVIATION = "abbreviation";
	final static String FIELD_ICON = "icon";
	final static String FIELD_TRANSLATE_ORGANIZATION_UNITS = "translateOrganizationUnits";
	final static String FIELD_ALLOW_USER_CONTAINER = "allowUserContainer";
	final static String FIELD_DEFAULT_CHILD_TYPE = "defaultChildType";
	final static String FIELD_POSSIBLE_CHILDREN_TYPES = "possibleChildrenTypes";
	final static String FIELD_GEO_LOCATION_TYPE = "geoLocationType";

    static OrganizationUnitTypeMock create() {
        return new UdbOrganizationUnitTypeMock();
    }

    static OrganizationUnitTypeMock create(int id) {
        return new UdbOrganizationUnitTypeMock(id, true);
    }

    static OrganizationUnitTypeMock getById(int id) {
        return new UdbOrganizationUnitTypeMock(id, false);
    }

    static EntityBuilder<OrganizationUnitTypeMock> getBuilder() {
        return new UdbOrganizationUnitTypeMock(0, false);
    }

    Instant getMetaCreationDate();

    OrganizationUnitTypeMock setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    OrganizationUnitTypeMock setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    OrganizationUnitTypeMock setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    OrganizationUnitTypeMock setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    OrganizationUnitTypeMock setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    OrganizationUnitTypeMock setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    OrganizationUnitTypeMock setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    OrganizationUnitTypeMock setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    OrganizationUnitTypeMock setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    OrganizationUnitTypeMock setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    OrganizationUnitTypeMock setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    OrganizationUnitTypeMock setMetaDeletedBy(int value);

    TranslatableText getName();

    OrganizationUnitTypeMock setName(TranslatableText value);

    TranslatableText getAbbreviation();

    OrganizationUnitTypeMock setAbbreviation(TranslatableText value);

    String getIcon();

    OrganizationUnitTypeMock setIcon(String value);

    boolean getTranslateOrganizationUnits();

    OrganizationUnitTypeMock setTranslateOrganizationUnits(boolean value);

    boolean getAllowUserContainer();

    OrganizationUnitTypeMock setAllowUserContainer(boolean value);

    OrganizationUnitTypeMock getDefaultChildType();

    OrganizationUnitTypeMock setDefaultChildType(OrganizationUnitTypeMock value);

    List<OrganizationUnitTypeMock> getPossibleChildrenTypes();

    OrganizationUnitTypeMock setPossibleChildrenTypes(List<OrganizationUnitTypeMock> value);

    int getPossibleChildrenTypesCount();

    OrganizationUnitTypeMock setPossibleChildrenTypes(OrganizationUnitTypeMock ... value);

    BitSet getPossibleChildrenTypesAsBitSet();

    OrganizationUnitTypeMock addPossibleChildrenTypes(List<OrganizationUnitTypeMock> value);

    OrganizationUnitTypeMock addPossibleChildrenTypes(OrganizationUnitTypeMock ... value);

    OrganizationUnitTypeMock removePossibleChildrenTypes(List<OrganizationUnitTypeMock> value);

    OrganizationUnitTypeMock removePossibleChildrenTypes(OrganizationUnitTypeMock ... value);

    OrganizationUnitTypeMock removeAllPossibleChildrenTypes();

    GeoLocationType getGeoLocationType();

    OrganizationUnitTypeMock setGeoLocationType(GeoLocationType value);


    static List<OrganizationUnitTypeMock> getAll() {
        return UdbOrganizationUnitTypeMock.getAll();
    }

    static List<OrganizationUnitTypeMock> sort(List<OrganizationUnitTypeMock> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbOrganizationUnitTypeMock.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbOrganizationUnitTypeMock.getCount();
    }

    static OrganizationUnitTypeMockQuery filter() {
        return new UdbOrganizationUnitTypeMockQuery();
    }
}

