package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface OrganizationUnitTypeView extends Entity<OrganizationUnitTypeView> {

	final static String FIELD_NAME = "name";
	final static String FIELD_ABBREVIATION = "abbreviation";
	final static String FIELD_ICON = "icon";
	final static String FIELD_TRANSLATE_ORGANIZATION_UNITS = "translateOrganizationUnits";
	final static String FIELD_ALLOW_USER_CONTAINER = "allowUserContainer";
	final static String FIELD_DEFAULT_CHILD_TYPE = "defaultChildType";
	final static String FIELD_POSSIBLE_CHILDREN_TYPES = "possibleChildrenTypes";
	final static String FIELD_GEO_LOCATION_TYPE = "geoLocationType";

    static OrganizationUnitTypeView getById(int id) {
        return new UdbOrganizationUnitTypeView(id, false);
    }

    static EntityBuilder<OrganizationUnitTypeView> getBuilder() {
        return new UdbOrganizationUnitTypeView(0, false);
    }

    TranslatableText getName();

    TranslatableText getAbbreviation();

    String getIcon();

    boolean getTranslateOrganizationUnits();

    boolean getAllowUserContainer();

    OrganizationUnitTypeView getDefaultChildType();

    List<OrganizationUnitTypeView> getPossibleChildrenTypes();

    int getPossibleChildrenTypesCount();

    BitSet getPossibleChildrenTypesAsBitSet();

    GeoLocationType getGeoLocationType();


    static List<OrganizationUnitTypeView> getAll() {
        return UdbOrganizationUnitTypeView.getAll();
    }

    static List<OrganizationUnitTypeView> sort(List<OrganizationUnitTypeView> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbOrganizationUnitTypeView.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbOrganizationUnitTypeView.getCount();
    }

    static OrganizationUnitTypeViewQuery filter() {
        return new UdbOrganizationUnitTypeViewQuery();
    }
}

