package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbOrganizationUnitTypeMock extends AbstractUdbEntity<OrganizationUnitTypeMock> implements OrganizationUnitTypeMock {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static TranslatableTextIndex name;
	protected static TranslatableTextIndex abbreviation;
	protected static TextIndex icon;
	protected static BooleanIndex translateOrganizationUnits;
	protected static BooleanIndex allowUserContainer;
	protected static SingleReferenceIndex defaultChildType;
	protected static MultiReferenceIndex possibleChildrenTypes;
	protected static ShortIndex geoLocationType;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		name = (TranslatableTextIndex) tableIndex.getColumnIndex(FIELD_NAME);
		abbreviation = (TranslatableTextIndex) tableIndex.getColumnIndex(FIELD_ABBREVIATION);
		icon = (TextIndex) tableIndex.getColumnIndex(FIELD_ICON);
		translateOrganizationUnits = (BooleanIndex) tableIndex.getColumnIndex(FIELD_TRANSLATE_ORGANIZATION_UNITS);
		allowUserContainer = (BooleanIndex) tableIndex.getColumnIndex(FIELD_ALLOW_USER_CONTAINER);
		defaultChildType = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_DEFAULT_CHILD_TYPE);
		possibleChildrenTypes = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_POSSIBLE_CHILDREN_TYPES);
		geoLocationType = (ShortIndex) tableIndex.getColumnIndex(FIELD_GEO_LOCATION_TYPE);
    }

    public static List<OrganizationUnitTypeMock> getAll() {
        return new EntityBitSetList<>(OrganizationUnitTypeMock.getBuilder(), table.getRecordBitSet());
    }

    public static List<OrganizationUnitTypeMock> sort(List<OrganizationUnitTypeMock> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<OrganizationUnitTypeMock> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, OrganizationUnitTypeMock.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbOrganizationUnitTypeMock() {
        super(table);
    }

    public UdbOrganizationUnitTypeMock(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public OrganizationUnitTypeMock build() {
        return new UdbOrganizationUnitTypeMock();
    }

    @Override
    public OrganizationUnitTypeMock build(int id) {
        return new UdbOrganizationUnitTypeMock(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public OrganizationUnitTypeMock setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public OrganizationUnitTypeMock setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public OrganizationUnitTypeMock setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public OrganizationUnitTypeMock setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public OrganizationUnitTypeMock setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public OrganizationUnitTypeMock setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public OrganizationUnitTypeMock setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public OrganizationUnitTypeMock setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public OrganizationUnitTypeMock setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public OrganizationUnitTypeMock setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public OrganizationUnitTypeMock setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public OrganizationUnitTypeMock setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public TranslatableText getName() {
	    return getTranslatableTextValue(this.name);
	}

	@Override
	public OrganizationUnitTypeMock setName(TranslatableText value) {
    	setTranslatableTextValue(value, this.name);
		return this;
	}

	@Override
	public TranslatableText getAbbreviation() {
	    return getTranslatableTextValue(this.abbreviation);
	}

	@Override
	public OrganizationUnitTypeMock setAbbreviation(TranslatableText value) {
    	setTranslatableTextValue(value, this.abbreviation);
		return this;
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public OrganizationUnitTypeMock setIcon(String value) {
	    setTextValue(value, this.icon);
		return this;
	}

	@Override
	public boolean getTranslateOrganizationUnits() {
	    return getBooleanValue(translateOrganizationUnits);
	}

	@Override
	public OrganizationUnitTypeMock setTranslateOrganizationUnits(boolean value) {
	    setBooleanValue(value, this.translateOrganizationUnits);
		return this;
	}

	@Override
	public boolean getAllowUserContainer() {
	    return getBooleanValue(allowUserContainer);
	}

	@Override
	public OrganizationUnitTypeMock setAllowUserContainer(boolean value) {
	    setBooleanValue(value, this.allowUserContainer);
		return this;
	}

	@Override
	public OrganizationUnitTypeMock getDefaultChildType() {
		if (isChanged(defaultChildType)) {
			return (OrganizationUnitTypeMock) getReferenceChangeValue(defaultChildType);
		} else {
			int id = defaultChildType.getValue(getId());
			if (id > 0) {
				return OrganizationUnitTypeMock.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public OrganizationUnitTypeMock setDefaultChildType(OrganizationUnitTypeMock value) {
		setSingleReferenceValue(defaultChildType, value, table);
		return this;
	}

	@Override
	public List<OrganizationUnitTypeMock> getPossibleChildrenTypes() {
	    return getMultiReferenceValue(possibleChildrenTypes, OrganizationUnitTypeMock.getBuilder());
	}

	@Override
	public OrganizationUnitTypeMock setPossibleChildrenTypes(List<OrganizationUnitTypeMock> value) {
		setMultiReferenceValue(value, possibleChildrenTypes);
		return this;
	}

	@Override
	public int getPossibleChildrenTypesCount() {
	    return getMultiReferenceValueCount(possibleChildrenTypes, OrganizationUnitTypeMock.getBuilder());
	}

	@Override
	public OrganizationUnitTypeMock setPossibleChildrenTypes(OrganizationUnitTypeMock ... value) {
		setMultiReferenceValue(Arrays.asList(value), possibleChildrenTypes);
		return this;
	}

	@Override
	public BitSet getPossibleChildrenTypesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(possibleChildrenTypes, OrganizationUnitTypeMock.getBuilder());
	}

	@Override
	public OrganizationUnitTypeMock addPossibleChildrenTypes(List<OrganizationUnitTypeMock> value) {
		addMultiReferenceValue(value, possibleChildrenTypes);
		return this;
	}

	@Override
	public OrganizationUnitTypeMock addPossibleChildrenTypes(OrganizationUnitTypeMock ... value) {
		addMultiReferenceValue(Arrays.asList(value), possibleChildrenTypes);
		return this;
	}

	@Override
	public OrganizationUnitTypeMock removePossibleChildrenTypes(List<OrganizationUnitTypeMock> value) {
		removeMultiReferenceValue(value, possibleChildrenTypes);
		return this;
	}

	@Override
	public OrganizationUnitTypeMock removePossibleChildrenTypes(OrganizationUnitTypeMock ... value) {
		removeMultiReferenceValue(Arrays.asList(value), possibleChildrenTypes);
		return this;
	}

	@Override
	public OrganizationUnitTypeMock removeAllPossibleChildrenTypes() {
		removeAllMultiReferenceValue(possibleChildrenTypes);
		return this;
	}

	@Override
	public GeoLocationType getGeoLocationType() {
	    return getEnumValue(geoLocationType, GeoLocationType.values());
	}

	@Override
	public OrganizationUnitTypeMock setGeoLocationType(GeoLocationType value) {
    	setEnumValue(this.geoLocationType, value);
		return this;
	}


    @Override
    public UdbOrganizationUnitTypeMock save(Transaction transaction, boolean strictChangeVerification) {
        save(transaction, table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbOrganizationUnitTypeMock saveTransactional(boolean strictChangeVerification) {
        save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbOrganizationUnitTypeMock save() {
        save(table);
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        delete(transaction, table);
    }

    @Override
    public void delete() {
        delete(table);
    }

	@Override
	public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(table.getName()).append(": ").append(getId()).append("\n");
		for (ColumnIndex column : table.getColumnIndices()) {
			sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(getId()));
			if (isChanged(column)) {
				TransactionRecordValue changeValue = getChangeValue(column);
				sb.append(" -> ").append(changeValue.getValue());
			}
			sb.append("\n");
		}
		return sb.toString();
	}
}



