/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.teamapps.application.api.application.ApplicationPerspectiveBuilder;
import org.teamapps.application.server.DevApplication;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.server.undertow.embedded.TeamAppsUndertowEmbeddedServer;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.schema.SchemaInfoProvider;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class DevServer {
    private final ApplicationPerspectiveBuilder applicationBuilder;
    private int port = 8080;
    private File path = new File("./dev-database");
    private List<OrganizationUnitView> OrganizationUnitViews = Collections.emptyList();
    private DocumentConverter documentConverter;

    public static DevServer create(ApplicationPerspectiveBuilder applicationBuilder) {
        return new DevServer(applicationBuilder);
    }

    protected DevServer(ApplicationPerspectiveBuilder applicationBuilder) {
        this.applicationBuilder = applicationBuilder;
    }

    public DevServer withDbPath(File path) {
        this.path = path;
        return this;
    }

    public DevServer withPort(int port) {
        this.port = port;
        return this;
    }

    public DevServer withOrganizationUnitViews(List<OrganizationUnitView> OrganizationUnitViews) {
        this.OrganizationUnitViews = OrganizationUnitViews;
        return this;
    }

    public DevServer withDocumentConverter(DocumentConverter documentConverter) {
        this.documentConverter = documentConverter;
        return this;
    }

    public void start() {
        try {
            this.path.mkdir();
            SchemaInfoProvider databaseModel = this.applicationBuilder.getDatabaseModel();
            if (databaseModel != null) {
                UniversalDB.createStandalone((File)this.path, (SchemaInfoProvider)databaseModel);
            }
            WebController webController = sessionContext -> {
                SessionContext context = SessionContext.current();
                RootPanel rootPanel = context.addRootPanel();
                rootPanel.setContent(new DevApplication(this.applicationBuilder, this.OrganizationUnitViews, this.documentConverter).getComponent());
                String defaultBackground = "/resources/backgrounds/default-bl.jpg";
                context.registerBackgroundImage("default", defaultBackground, defaultBackground);
                context.setBackgroundImage("default", 0);
            };
            File webAppDirectory = Files.createTempDirectory("teamapps", new FileAttribute[0]).toRealPath(new LinkOption[0]).toFile();
            TeamAppsUndertowEmbeddedServer server = new TeamAppsUndertowEmbeddedServer(webController, webAppDirectory, this.port);
            server.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

