package org.teamapps.model;

import org.teamapps.universaldb.schema.*;

public class ApiSchema implements SchemaInfoProvider {

	public static Schema create() {
		return new ApiSchema().getSchema();
	}

	public Schema getSchema() {
		return Schema.parse(getSchemaDefinition());
	}

    public String getSchemaDefinition() {
        return "org.teamapps.model as SCHEMA\n" + 
				"controlCenter as DATABASE\n" + 
				"	organizationUnitMock as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		name as TRANSLATABLE_TEXT\n" + 
				"		parent as SINGLE_REFERENCE controlCenter.organizationUnitMock BACKREF children\n" + 
				"		children as MULTI_REFERENCE controlCenter.organizationUnitMock BACKREF parent\n" + 
				"		type as SINGLE_REFERENCE controlCenter.organizationUnitTypeMock BACKREF NONE\n" + 
				"		icon as TEXT\n" + 
				"		address as SINGLE_REFERENCE controlCenter.addressMock BACKREF NONE\n" + 
				"	organizationUnitTypeMock as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		name as TRANSLATABLE_TEXT\n" + 
				"		abbreviation as TRANSLATABLE_TEXT\n" + 
				"		icon as TEXT\n" + 
				"		translateOrganizationUnits as BOOLEAN\n" + 
				"		allowUserContainer as BOOLEAN\n" + 
				"		defaultChildType as SINGLE_REFERENCE controlCenter.organizationUnitTypeMock BACKREF NONE\n" + 
				"		possibleChildrenTypes as MULTI_REFERENCE controlCenter.organizationUnitTypeMock BACKREF NONE\n" + 
				"		geoLocationType as ENUM VALUES (country, state, city, place, none)\n" + 
				"	organizationFieldMock as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		title as TRANSLATABLE_TEXT\n" + 
				"		icon as TEXT\n" + 
				"	addressMock as TABLE (TRACK_CREATION, TRACK_MODIFICATION, KEEP_DELETED)\n" + 
				"		metaCreationDate as TIMESTAMP\n" + 
				"		metaCreatedBy as INT\n" + 
				"		metaModificationDate as TIMESTAMP\n" + 
				"		metaModifiedBy as INT\n" + 
				"		metaDeletionDate as TIMESTAMP\n" + 
				"		metaDeletedBy as INT\n" + 
				"		name as TEXT\n" + 
				"		organisation as TEXT\n" + 
				"		street as TEXT\n" + 
				"		city as TEXT\n" + 
				"		dependentLocality as TEXT\n" + 
				"		state as TEXT\n" + 
				"		postalCode as TEXT\n" + 
				"		country as TEXT\n" + 
				"		latitude as FLOAT\n" + 
				"		longitude as FLOAT\n" + 
				"	organizationUnitView as VIEW REFERENCING controlCenter.organizationUnitMock\n" + 
				"		name as TRANSLATABLE_TEXT\n" + 
				"		parent as SINGLE_REFERENCE controlCenter.organizationUnitView BACKREF children\n" + 
				"		children as MULTI_REFERENCE controlCenter.organizationUnitView BACKREF parent\n" + 
				"		type as SINGLE_REFERENCE controlCenter.organizationUnitTypeView BACKREF NONE\n" + 
				"		icon as TEXT\n" + 
				"		address as SINGLE_REFERENCE controlCenter.addressView BACKREF NONE\n" + 
				"	organizationUnitTypeView as VIEW REFERENCING controlCenter.organizationUnitTypeMock\n" + 
				"		name as TRANSLATABLE_TEXT\n" + 
				"		abbreviation as TRANSLATABLE_TEXT\n" + 
				"		icon as TEXT\n" + 
				"		translateOrganizationUnits as BOOLEAN\n" + 
				"		allowUserContainer as BOOLEAN\n" + 
				"		defaultChildType as SINGLE_REFERENCE controlCenter.organizationUnitTypeView BACKREF NONE\n" + 
				"		possibleChildrenTypes as MULTI_REFERENCE controlCenter.organizationUnitTypeView BACKREF NONE\n" + 
				"		geoLocationType as ENUM VALUES (country, state, city, place, none)\n" + 
				"	organizationFieldView as VIEW REFERENCING controlCenter.organizationFieldMock\n" + 
				"		title as TRANSLATABLE_TEXT\n" + 
				"		icon as TEXT\n" + 
				"	addressView as VIEW REFERENCING controlCenter.addressMock\n" + 
				"		name as TEXT\n" + 
				"		organisation as TEXT\n" + 
				"		street as TEXT\n" + 
				"		city as TEXT\n" + 
				"		dependentLocality as TEXT\n" + 
				"		state as TEXT\n" + 
				"		postalCode as TEXT\n" + 
				"		country as TEXT\n" + 
				"		latitude as FLOAT\n" + 
				"		longitude as FLOAT\n";

    }

}
