package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbAddressMock extends AbstractUdbEntity<AddressMock> implements AddressMock {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static TextIndex name;
	protected static TextIndex organisation;
	protected static TextIndex street;
	protected static TextIndex city;
	protected static TextIndex dependentLocality;
	protected static TextIndex state;
	protected static TextIndex postalCode;
	protected static TextIndex country;
	protected static FloatIndex latitude;
	protected static FloatIndex longitude;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		name = (TextIndex) tableIndex.getColumnIndex(FIELD_NAME);
		organisation = (TextIndex) tableIndex.getColumnIndex(FIELD_ORGANISATION);
		street = (TextIndex) tableIndex.getColumnIndex(FIELD_STREET);
		city = (TextIndex) tableIndex.getColumnIndex(FIELD_CITY);
		dependentLocality = (TextIndex) tableIndex.getColumnIndex(FIELD_DEPENDENT_LOCALITY);
		state = (TextIndex) tableIndex.getColumnIndex(FIELD_STATE);
		postalCode = (TextIndex) tableIndex.getColumnIndex(FIELD_POSTAL_CODE);
		country = (TextIndex) tableIndex.getColumnIndex(FIELD_COUNTRY);
		latitude = (FloatIndex) tableIndex.getColumnIndex(FIELD_LATITUDE);
		longitude = (FloatIndex) tableIndex.getColumnIndex(FIELD_LONGITUDE);
    }

    public static List<AddressMock> getAll() {
        return new EntityBitSetList<>(AddressMock.getBuilder(), table.getRecordBitSet());
    }

    public static List<AddressMock> sort(List<AddressMock> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<AddressMock> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, AddressMock.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbAddressMock() {
        super(table);
    }

    public UdbAddressMock(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public AddressMock build() {
        return new UdbAddressMock();
    }

    @Override
    public AddressMock build(int id) {
        return new UdbAddressMock(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public AddressMock setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public AddressMock setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public AddressMock setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public AddressMock setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public AddressMock setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public AddressMock setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public AddressMock setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public AddressMock setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public AddressMock setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public AddressMock setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public AddressMock setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public AddressMock setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public String getName() {
        return getTextValue(name);
	}

	@Override
	public AddressMock setName(String value) {
	    setTextValue(value, this.name);
		return this;
	}

	@Override
	public String getOrganisation() {
        return getTextValue(organisation);
	}

	@Override
	public AddressMock setOrganisation(String value) {
	    setTextValue(value, this.organisation);
		return this;
	}

	@Override
	public String getStreet() {
        return getTextValue(street);
	}

	@Override
	public AddressMock setStreet(String value) {
	    setTextValue(value, this.street);
		return this;
	}

	@Override
	public String getCity() {
        return getTextValue(city);
	}

	@Override
	public AddressMock setCity(String value) {
	    setTextValue(value, this.city);
		return this;
	}

	@Override
	public String getDependentLocality() {
        return getTextValue(dependentLocality);
	}

	@Override
	public AddressMock setDependentLocality(String value) {
	    setTextValue(value, this.dependentLocality);
		return this;
	}

	@Override
	public String getState() {
        return getTextValue(state);
	}

	@Override
	public AddressMock setState(String value) {
	    setTextValue(value, this.state);
		return this;
	}

	@Override
	public String getPostalCode() {
        return getTextValue(postalCode);
	}

	@Override
	public AddressMock setPostalCode(String value) {
	    setTextValue(value, this.postalCode);
		return this;
	}

	@Override
	public String getCountry() {
        return getTextValue(country);
	}

	@Override
	public AddressMock setCountry(String value) {
	    setTextValue(value, this.country);
		return this;
	}

	@Override
	public float getLatitude() {
	    return getFloatValue(latitude);
	}

	@Override
	public AddressMock setLatitude(float value) {
	    setFloatValue(value, this.latitude);
		return this;
	}

	@Override
	public float getLongitude() {
	    return getFloatValue(longitude);
	}

	@Override
	public AddressMock setLongitude(float value) {
	    setFloatValue(value, this.longitude);
		return this;
	}


    @Override
    public UdbAddressMock save(Transaction transaction, boolean strictChangeVerification) {
        save(transaction, table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbAddressMock saveTransactional(boolean strictChangeVerification) {
        save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbAddressMock save() {
        save(table);
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        delete(transaction, table);
    }

    @Override
    public void delete() {
        delete(table);
    }

	@Override
	public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(table.getName()).append(": ").append(getId()).append("\n");
		for (ColumnIndex column : table.getColumnIndices()) {
			sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(getId()));
			if (isChanged(column)) {
				TransactionRecordValue changeValue = getChangeValue(column);
				sb.append(" -> ").append(changeValue.getValue());
			}
			sb.append("\n");
		}
		return sb.toString();
	}
}



