package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbOrganizationFieldMockQuery extends AbstractUdbQuery<OrganizationFieldMock> implements OrganizationFieldMockQuery {

    public UdbOrganizationFieldMockQuery() {
        super(UdbOrganizationFieldMock.table, OrganizationFieldMock.getBuilder());
    }

	@Override
	public OrganizationFieldMockQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbOrganizationFieldMock.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbOrganizationFieldMock.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery metaCreationDate(NumericFilter filter) {
		and(UdbOrganizationFieldMock.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbOrganizationFieldMock.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery metaCreatedBy(NumericFilter filter) {
		and(UdbOrganizationFieldMock.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbOrganizationFieldMock.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery metaModificationDate(NumericFilter filter) {
		and(UdbOrganizationFieldMock.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbOrganizationFieldMock.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery metaModifiedBy(NumericFilter filter) {
		and(UdbOrganizationFieldMock.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbOrganizationFieldMock.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery metaDeletionDate(NumericFilter filter) {
		and(UdbOrganizationFieldMock.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbOrganizationFieldMock.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery metaDeletedBy(NumericFilter filter) {
		and(UdbOrganizationFieldMock.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbOrganizationFieldMock.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery title(TranslatableTextFilter filter) {
		and(UdbOrganizationFieldMock.title.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery orTitle(TranslatableTextFilter filter) {
		or(UdbOrganizationFieldMock.title.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery icon(TextFilter filter) {
		and(UdbOrganizationFieldMock.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationFieldMockQuery orIcon(TextFilter filter) {
		or(UdbOrganizationFieldMock.icon.createFilter(filter));
		return this;
	}


	@Override
	public UdbOrganizationFieldMockQuery andOr(OrganizationFieldMockQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public OrganizationFieldMockQuery customFilter(Function<OrganizationFieldMock, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(OrganizationFieldMock.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



