package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbOrganizationUnitTypeMockQuery extends AbstractUdbQuery<OrganizationUnitTypeMock> implements OrganizationUnitTypeMockQuery {

    public UdbOrganizationUnitTypeMockQuery() {
        super(UdbOrganizationUnitTypeMock.table, OrganizationUnitTypeMock.getBuilder());
    }

	@Override
	public OrganizationUnitTypeMockQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbOrganizationUnitTypeMock.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbOrganizationUnitTypeMock.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery metaCreationDate(NumericFilter filter) {
		and(UdbOrganizationUnitTypeMock.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbOrganizationUnitTypeMock.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery metaCreatedBy(NumericFilter filter) {
		and(UdbOrganizationUnitTypeMock.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbOrganizationUnitTypeMock.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery metaModificationDate(NumericFilter filter) {
		and(UdbOrganizationUnitTypeMock.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbOrganizationUnitTypeMock.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery metaModifiedBy(NumericFilter filter) {
		and(UdbOrganizationUnitTypeMock.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbOrganizationUnitTypeMock.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery metaDeletionDate(NumericFilter filter) {
		and(UdbOrganizationUnitTypeMock.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbOrganizationUnitTypeMock.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery metaDeletedBy(NumericFilter filter) {
		and(UdbOrganizationUnitTypeMock.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbOrganizationUnitTypeMock.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery name(TranslatableTextFilter filter) {
		and(UdbOrganizationUnitTypeMock.name.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery orName(TranslatableTextFilter filter) {
		or(UdbOrganizationUnitTypeMock.name.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery abbreviation(TranslatableTextFilter filter) {
		and(UdbOrganizationUnitTypeMock.abbreviation.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery orAbbreviation(TranslatableTextFilter filter) {
		or(UdbOrganizationUnitTypeMock.abbreviation.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery icon(TextFilter filter) {
		and(UdbOrganizationUnitTypeMock.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery orIcon(TextFilter filter) {
		or(UdbOrganizationUnitTypeMock.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery translateOrganizationUnits(BooleanFilter filter) {
		and(UdbOrganizationUnitTypeMock.translateOrganizationUnits.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery orTranslateOrganizationUnits(BooleanFilter filter) {
		or(UdbOrganizationUnitTypeMock.translateOrganizationUnits.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery allowUserContainer(BooleanFilter filter) {
		and(UdbOrganizationUnitTypeMock.allowUserContainer.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery orAllowUserContainer(BooleanFilter filter) {
		or(UdbOrganizationUnitTypeMock.allowUserContainer.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery filterDefaultChildType(OrganizationUnitTypeMockQuery query) {
		UdbOrganizationUnitTypeMockQuery udbQuery = (UdbOrganizationUnitTypeMockQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnitTypeMock.defaultChildType);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery defaultChildType(NumericFilter filter) {
		and(UdbOrganizationUnitTypeMock.defaultChildType.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery orDefaultChildType(NumericFilter filter) {
		or(UdbOrganizationUnitTypeMock.defaultChildType.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery filterPossibleChildrenTypes(OrganizationUnitTypeMockQuery query) {
		UdbOrganizationUnitTypeMockQuery udbQuery = (UdbOrganizationUnitTypeMockQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnitTypeMock.possibleChildrenTypes);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery possibleChildrenTypes(MultiReferenceFilterType type, OrganizationUnitTypeMock ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (OrganizationUnitTypeMock value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbOrganizationUnitTypeMock.possibleChildrenTypes.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery possibleChildrenTypesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbOrganizationUnitTypeMock.possibleChildrenTypes.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery possibleChildrenTypes(MultiReferenceFilter filter) {
		and(UdbOrganizationUnitTypeMock.possibleChildrenTypes.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery orPossibleChildrenTypes(MultiReferenceFilter filter) {
		or(UdbOrganizationUnitTypeMock.possibleChildrenTypes.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery geoLocationType(EnumFilterType filterType, GeoLocationType... enums) {
		and(UdbOrganizationUnitTypeMock.geoLocationType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public OrganizationUnitTypeMockQuery orGeoLocationType(EnumFilterType filterType, GeoLocationType... enums) {
		or(UdbOrganizationUnitTypeMock.geoLocationType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}


	@Override
	public UdbOrganizationUnitTypeMockQuery andOr(OrganizationUnitTypeMockQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public OrganizationUnitTypeMockQuery customFilter(Function<OrganizationUnitTypeMock, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(OrganizationUnitTypeMock.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



