/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.application;

import java.util.List;
import org.teamapps.application.api.application.Application;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.ux.application.ResponsiveApplication;

public abstract class AbstractApplication
implements Application {
    private final ResponsiveApplication responsiveApplication;
    private final ApplicationInstanceData applicationInstanceData;

    public AbstractApplication(ResponsiveApplication responsiveApplication, ApplicationInstanceData applicationInstanceData) {
        this.responsiveApplication = responsiveApplication;
        this.applicationInstanceData = applicationInstanceData;
    }

    public ResponsiveApplication getResponsiveApplication() {
        return this.responsiveApplication;
    }

    public ApplicationInstanceData getApplicationInstanceData() {
        return this.applicationInstanceData;
    }

    public void writeActivityLog(String title, String data) {
        this.getApplicationInstanceData().writeActivityLog(title, data);
    }

    public void writeExceptionLog(String title, Throwable throwable) {
        this.getApplicationInstanceData().writeExceptionLog(title, throwable);
    }

    public String getLocalized(String key, Object ... parameters) {
        return this.applicationInstanceData.getLocalized(key, parameters);
    }

    public boolean isAllowed(SimplePrivilege simplePrivilege) {
        return this.applicationInstanceData.isAllowed(simplePrivilege);
    }

    public boolean isAllowed(SimpleOrganizationalPrivilege group, OrganizationUnitView OrganizationUnitView2) {
        return this.applicationInstanceData.isAllowed(group, OrganizationUnitView2);
    }

    public boolean isAllowed(SimpleCustomObjectPrivilege group, PrivilegeObject privilegeObject) {
        return this.applicationInstanceData.isAllowed(group, privilegeObject);
    }

    public boolean isAllowed(StandardPrivilegeGroup group, Privilege privilege) {
        return this.applicationInstanceData.isAllowed(group, privilege);
    }

    public boolean isAllowed(OrganizationalPrivilegeGroup group, Privilege privilege, OrganizationUnitView OrganizationUnitView2) {
        return this.applicationInstanceData.isAllowed(group, privilege, OrganizationUnitView2);
    }

    public boolean isAllowed(CustomObjectPrivilegeGroup group, Privilege privilege, PrivilegeObject privilegeObject) {
        return this.applicationInstanceData.isAllowed(group, privilege, privilegeObject);
    }

    public List<OrganizationUnitView> getAllowedUnits(SimpleOrganizationalPrivilege simplePrivilege) {
        return this.applicationInstanceData.getAllowedUnits(simplePrivilege);
    }

    public List<OrganizationUnitView> getAllowedUnits(OrganizationalPrivilegeGroup group, Privilege privilege) {
        return this.applicationInstanceData.getAllowedUnits(group, privilege);
    }

    public List<PrivilegeObject> getAllowedPrivilegeObjects(SimpleCustomObjectPrivilege simplePrivilege) {
        return this.applicationInstanceData.getAllowedPrivilegeObjects(simplePrivilege);
    }

    public List<PrivilegeObject> getAllowedPrivilegeObjects(CustomObjectPrivilegeGroup group, Privilege privilege) {
        return this.applicationInstanceData.getAllowedPrivilegeObjects(group, privilege);
    }
}

